//! Autogenerated by GenerateDef from src/aro/Builtins/s390x.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    __builtin_non_tx_store,
    __builtin_s390_bdepg,
    __builtin_s390_bextg,
    __builtin_s390_lcbb,
    __builtin_s390_vaccb,
    __builtin_s390_vacccq,
    __builtin_s390_vaccf,
    __builtin_s390_vaccg,
    __builtin_s390_vacch,
    __builtin_s390_vaccq,
    __builtin_s390_vacq,
    __builtin_s390_vaq,
    __builtin_s390_vavgb,
    __builtin_s390_vavgf,
    __builtin_s390_vavgg,
    __builtin_s390_vavgh,
    __builtin_s390_vavglb,
    __builtin_s390_vavglf,
    __builtin_s390_vavglg,
    __builtin_s390_vavglh,
    __builtin_s390_vavglq,
    __builtin_s390_vavgq,
    __builtin_s390_vbperm,
    __builtin_s390_vceqbs,
    __builtin_s390_vceqfs,
    __builtin_s390_vceqgs,
    __builtin_s390_vceqhs,
    __builtin_s390_vceqqs,
    __builtin_s390_vcfn,
    __builtin_s390_vchbs,
    __builtin_s390_vchfs,
    __builtin_s390_vchgs,
    __builtin_s390_vchhs,
    __builtin_s390_vchlbs,
    __builtin_s390_vchlfs,
    __builtin_s390_vchlgs,
    __builtin_s390_vchlhs,
    __builtin_s390_vchlqs,
    __builtin_s390_vchqs,
    __builtin_s390_vcksm,
    __builtin_s390_vclfnhs,
    __builtin_s390_vclfnls,
    __builtin_s390_vclzb,
    __builtin_s390_vclzf,
    __builtin_s390_vclzg,
    __builtin_s390_vclzh,
    __builtin_s390_vclzq,
    __builtin_s390_vcnf,
    __builtin_s390_vcrnfs,
    __builtin_s390_vctzb,
    __builtin_s390_vctzf,
    __builtin_s390_vctzg,
    __builtin_s390_vctzh,
    __builtin_s390_vctzq,
    __builtin_s390_verimb,
    __builtin_s390_verimf,
    __builtin_s390_verimg,
    __builtin_s390_verimh,
    __builtin_s390_verllb,
    __builtin_s390_verllf,
    __builtin_s390_verllg,
    __builtin_s390_verllh,
    __builtin_s390_verllvb,
    __builtin_s390_verllvf,
    __builtin_s390_verllvg,
    __builtin_s390_verllvh,
    __builtin_s390_veval,
    __builtin_s390_vfaeb,
    __builtin_s390_vfaebs,
    __builtin_s390_vfaef,
    __builtin_s390_vfaefs,
    __builtin_s390_vfaeh,
    __builtin_s390_vfaehs,
    __builtin_s390_vfaezb,
    __builtin_s390_vfaezbs,
    __builtin_s390_vfaezf,
    __builtin_s390_vfaezfs,
    __builtin_s390_vfaezh,
    __builtin_s390_vfaezhs,
    __builtin_s390_vfcedbs,
    __builtin_s390_vfcesbs,
    __builtin_s390_vfchdbs,
    __builtin_s390_vfchedbs,
    __builtin_s390_vfchesbs,
    __builtin_s390_vfchsbs,
    __builtin_s390_vfeeb,
    __builtin_s390_vfeebs,
    __builtin_s390_vfeef,
    __builtin_s390_vfeefs,
    __builtin_s390_vfeeh,
    __builtin_s390_vfeehs,
    __builtin_s390_vfeezb,
    __builtin_s390_vfeezbs,
    __builtin_s390_vfeezf,
    __builtin_s390_vfeezfs,
    __builtin_s390_vfeezh,
    __builtin_s390_vfeezhs,
    __builtin_s390_vfeneb,
    __builtin_s390_vfenebs,
    __builtin_s390_vfenef,
    __builtin_s390_vfenefs,
    __builtin_s390_vfeneh,
    __builtin_s390_vfenehs,
    __builtin_s390_vfenezb,
    __builtin_s390_vfenezbs,
    __builtin_s390_vfenezf,
    __builtin_s390_vfenezfs,
    __builtin_s390_vfenezh,
    __builtin_s390_vfenezhs,
    __builtin_s390_vfidb,
    __builtin_s390_vfisb,
    __builtin_s390_vflndb,
    __builtin_s390_vflnsb,
    __builtin_s390_vflpdb,
    __builtin_s390_vflpsb,
    __builtin_s390_vfmadb,
    __builtin_s390_vfmasb,
    __builtin_s390_vfmaxdb,
    __builtin_s390_vfmaxsb,
    __builtin_s390_vfmindb,
    __builtin_s390_vfminsb,
    __builtin_s390_vfmsdb,
    __builtin_s390_vfmssb,
    __builtin_s390_vfnmadb,
    __builtin_s390_vfnmasb,
    __builtin_s390_vfnmsdb,
    __builtin_s390_vfnmssb,
    __builtin_s390_vfsqdb,
    __builtin_s390_vfsqsb,
    __builtin_s390_vftcidb,
    __builtin_s390_vftcisb,
    __builtin_s390_vgemb,
    __builtin_s390_vgemf,
    __builtin_s390_vgemg,
    __builtin_s390_vgemh,
    __builtin_s390_vgemq,
    __builtin_s390_vgfmab,
    __builtin_s390_vgfmaf,
    __builtin_s390_vgfmag,
    __builtin_s390_vgfmah,
    __builtin_s390_vgfmb,
    __builtin_s390_vgfmf,
    __builtin_s390_vgfmg,
    __builtin_s390_vgfmh,
    __builtin_s390_vistrb,
    __builtin_s390_vistrbs,
    __builtin_s390_vistrf,
    __builtin_s390_vistrfs,
    __builtin_s390_vistrh,
    __builtin_s390_vistrhs,
    __builtin_s390_vlbb,
    __builtin_s390_vlbrf,
    __builtin_s390_vlbrg,
    __builtin_s390_vlbrh,
    __builtin_s390_vlbrq,
    __builtin_s390_vll,
    __builtin_s390_vlrlr,
    __builtin_s390_vmaeb,
    __builtin_s390_vmaef,
    __builtin_s390_vmaeg,
    __builtin_s390_vmaeh,
    __builtin_s390_vmahb,
    __builtin_s390_vmahf,
    __builtin_s390_vmahg,
    __builtin_s390_vmahh,
    __builtin_s390_vmahq,
    __builtin_s390_vmaleb,
    __builtin_s390_vmalef,
    __builtin_s390_vmaleg,
    __builtin_s390_vmaleh,
    __builtin_s390_vmalhb,
    __builtin_s390_vmalhf,
    __builtin_s390_vmalhg,
    __builtin_s390_vmalhh,
    __builtin_s390_vmalhq,
    __builtin_s390_vmalob,
    __builtin_s390_vmalof,
    __builtin_s390_vmalog,
    __builtin_s390_vmaloh,
    __builtin_s390_vmaob,
    __builtin_s390_vmaof,
    __builtin_s390_vmaog,
    __builtin_s390_vmaoh,
    __builtin_s390_vmeb,
    __builtin_s390_vmef,
    __builtin_s390_vmeg,
    __builtin_s390_vmeh,
    __builtin_s390_vmhb,
    __builtin_s390_vmhf,
    __builtin_s390_vmhg,
    __builtin_s390_vmhh,
    __builtin_s390_vmhq,
    __builtin_s390_vmleb,
    __builtin_s390_vmlef,
    __builtin_s390_vmleg,
    __builtin_s390_vmleh,
    __builtin_s390_vmlhb,
    __builtin_s390_vmlhf,
    __builtin_s390_vmlhg,
    __builtin_s390_vmlhh,
    __builtin_s390_vmlhq,
    __builtin_s390_vmlob,
    __builtin_s390_vmlof,
    __builtin_s390_vmlog,
    __builtin_s390_vmloh,
    __builtin_s390_vmob,
    __builtin_s390_vmof,
    __builtin_s390_vmog,
    __builtin_s390_vmoh,
    __builtin_s390_vmslg,
    __builtin_s390_vpdi,
    __builtin_s390_vperm,
    __builtin_s390_vpklsf,
    __builtin_s390_vpklsfs,
    __builtin_s390_vpklsg,
    __builtin_s390_vpklsgs,
    __builtin_s390_vpklsh,
    __builtin_s390_vpklshs,
    __builtin_s390_vpksf,
    __builtin_s390_vpksfs,
    __builtin_s390_vpksg,
    __builtin_s390_vpksgs,
    __builtin_s390_vpksh,
    __builtin_s390_vpkshs,
    __builtin_s390_vsbcbiq,
    __builtin_s390_vsbiq,
    __builtin_s390_vscbib,
    __builtin_s390_vscbif,
    __builtin_s390_vscbig,
    __builtin_s390_vscbih,
    __builtin_s390_vscbiq,
    __builtin_s390_vsl,
    __builtin_s390_vslb,
    __builtin_s390_vsld,
    __builtin_s390_vsldb,
    __builtin_s390_vsq,
    __builtin_s390_vsra,
    __builtin_s390_vsrab,
    __builtin_s390_vsrd,
    __builtin_s390_vsrl,
    __builtin_s390_vsrlb,
    __builtin_s390_vstl,
    __builtin_s390_vstrcb,
    __builtin_s390_vstrcbs,
    __builtin_s390_vstrcf,
    __builtin_s390_vstrcfs,
    __builtin_s390_vstrch,
    __builtin_s390_vstrchs,
    __builtin_s390_vstrczb,
    __builtin_s390_vstrczbs,
    __builtin_s390_vstrczf,
    __builtin_s390_vstrczfs,
    __builtin_s390_vstrczh,
    __builtin_s390_vstrczhs,
    __builtin_s390_vstrlr,
    __builtin_s390_vstrsb,
    __builtin_s390_vstrsf,
    __builtin_s390_vstrsh,
    __builtin_s390_vstrszb,
    __builtin_s390_vstrszf,
    __builtin_s390_vstrszh,
    __builtin_s390_vsumb,
    __builtin_s390_vsumgf,
    __builtin_s390_vsumgh,
    __builtin_s390_vsumh,
    __builtin_s390_vsumqf,
    __builtin_s390_vsumqg,
    __builtin_s390_vtm,
    __builtin_s390_vuphb,
    __builtin_s390_vuphf,
    __builtin_s390_vuphg,
    __builtin_s390_vuphh,
    __builtin_s390_vuplb,
    __builtin_s390_vuplf,
    __builtin_s390_vuplg,
    __builtin_s390_vuplhb,
    __builtin_s390_vuplhf,
    __builtin_s390_vuplhg,
    __builtin_s390_vuplhh,
    __builtin_s390_vuplhw,
    __builtin_s390_vupllb,
    __builtin_s390_vupllf,
    __builtin_s390_vupllg,
    __builtin_s390_vupllh,
    __builtin_tabort,
    __builtin_tbegin,
    __builtin_tbegin_nofloat,
    __builtin_tbeginc,
    __builtin_tend,
    __builtin_tx_assist,
    __builtin_tx_nesting_depth,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 14;
pub const longest_name = 26;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(582);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 2 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 3 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 4 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 5 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 6 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 7 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 8 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 9 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 10 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 291, .child_index = 11 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 14 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 283, .child_index = 15 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 16 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 20 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 283, .child_index = 21 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 22 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 23 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 24 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 25 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 26 },
    .{ .char = '9', .end_of_word = false, .end_of_list = true, .number = 283, .child_index = 27 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 28 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 29 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 31 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 33 },
    .{ .char = '0', .end_of_word = false, .end_of_list = true, .number = 283, .child_index = 34 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 35 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 36 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 37 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 38 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 39 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 283, .child_index = 40 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 43 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 44 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 45 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 46 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 47 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 48 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 50 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 280, .child_index = 51 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 64 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 67 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 69 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 70 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 71 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 72 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 75 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 31, .child_index = 76 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 84 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 64, .child_index = 86 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 95 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 97 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 98 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 53, .child_index = 101 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 107 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 43, .child_index = 110 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 117 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 118 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 119 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 121 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 123 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 124 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 125 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 126 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 128 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 129 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 130 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 131 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 132 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 138 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 139 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 141 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 142 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 143 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 144 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 146 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 147 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 148 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 24, .child_index = 150 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 152 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 154 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 156 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 159 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 160 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 161 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 162 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 163 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 164 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 165 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 168 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 176 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 181 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 184 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 185 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 186 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 187 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 189 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 191 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 4, .child_index = 192 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 194 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 20, .child_index = 197 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 199 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 200 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 202 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 43 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 203 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 204 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 205 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 205 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 206 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 212 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 218 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 218 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 117 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 224 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 176 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 225 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 176 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 226 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 227 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 228 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 229 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 233 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 235 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 229 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 147 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 125 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 125 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 152 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 238 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 241 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 242 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 244 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 176 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 245 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 250 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 251 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 255 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 176 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 181 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 172 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 176 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 172 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 205 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 117 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 256 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 257 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 260 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 261 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 262 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 263 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 263 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 263 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 19, .child_index = 264 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 267 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 271 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 276 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 278 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 261 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 176 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 279 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 172 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 281 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 287 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 290 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 290 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 290 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 233 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 290 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 125 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 125 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 152 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 152 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 172 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 287 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 257 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 286 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 291 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 176 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 229 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 255 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 292 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 296 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 298 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 300 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 172 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 305 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 307 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 172 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 286 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 286 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 261 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 308 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 312 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 314 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 43 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 315 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 316 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 317 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
};
pub const data = blk: {
    @setEvalBranchQuota(2619);
    break :blk [_]Properties{
        .{ .param_str = "vULi*ULi", .features = "transactional_execution" },
        .{ .param_str = "ULiULiULi", .attributes = .{ .@"const" = true }, .features = "miscellaneous_extensions_4" },
        .{ .param_str = "ULiULiULi", .attributes = .{ .@"const" = true }, .features = "miscellaneous_extensions_4" },
        .{ .param_str = "UivC*Ii", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiSLLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV16ScV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "SLLLiSLLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V2ULLiV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V16ScV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2ULLiV2ULLii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiULLLiULLLii*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "nnp_assist" },
        .{ .param_str = "V16ScV16ScV16Sci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4SiV4Sii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2SLLiV2SLLii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV8SsV8Ssi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2ULLiV2ULLii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiULLLiULLLii*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "SLLLiSLLLiSLLLii*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV8UsIi", .attributes = .{ .@"const" = true }, .features = "nnp_assist" },
        .{ .param_str = "V4fV8UsIi", .attributes = .{ .@"const" = true }, .features = "nnp_assist" },
        .{ .param_str = "V16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "nnp_assist" },
        .{ .param_str = "V8UsV4fV4fIi", .attributes = .{ .@"const" = true }, .features = "nnp_assist" },
        .{ .param_str = "V16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4UiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLiV2ULLiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcUc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiUc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiUc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsUc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2dV2di*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4fV4fi*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2SLLiV2dV2di*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2dV2di*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4fV4fi*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V4SiV4fV4fi*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2dV2dIiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4fIiIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2d", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2d", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dV2d", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4fV4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V4fV4fV4fIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V4fV4fV4fIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dV2d", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4fV4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dV2d", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V4fV4fV4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2dV2dV2d", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V4fV4fV4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2dV2d", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4fV4f", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2SLLiV2dIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4fIii*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V16UcV8Us", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV16Uc", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V2ULLiV16Uc", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16Uc", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "ULLLiV16Uc", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16UcV16UcV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4UiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV8UsV8UsV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScvC*Ii", .features = "vector" },
        .{ .param_str = "V4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScUivC*", .features = "vector" },
        .{ .param_str = "V16ScUivC*", .features = "vector_enhancements_1" },
        .{ .param_str = "V8SsV16ScV16ScV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4SiV4SiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLiV2SLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4SiV8SsV8SsV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV16ScV16ScV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4SiV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2SLLiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8SsV8SsV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiSLLLiSLLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16UcV16UcV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4UiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8UsV8UsV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16UcV16UcV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4UiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8UsV8UsV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV16ScV16ScV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4SiV4SiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLiV2SLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4SiV8SsV8SsV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV16ScV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4SiV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV16ScV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8SsV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiSLLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV16ScV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4SiV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLiULLLiIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_1" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV4UiV4Uii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV2ULLiV2ULLii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV8UsV8Usi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV4SiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV4SiV4Sii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV2SLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV2SLLiV2SLLii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV8SsV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16ScV8SsV8Ssi*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiULLLiULLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiSLLLiSLLLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "vV16ScUiv*", .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4UiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4UiIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsV8UsIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V16UcV16UcV16UcV16UcIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4UiIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV4UiV4UiV4UiIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsV8UsIi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV8UsV8UsV8UsIii*", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "vV16ScUiv*", .features = "vector_enhancements_1" },
        .{ .param_str = "V16UcV16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV4UiV4UiV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV8UsV8UsV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV16UcV16UcV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV4UiV4UiV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V16UcV8UsV8UsV16Uci*", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_2" },
        .{ .param_str = "V4UiV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4UiV8UsV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV4UiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "iV16UcV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4SiV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8SsV16Sc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2SLLiV4Si", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "SLLLiV2SLLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V8UsV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V4SiV8Ss", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V8UsV16Uc", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "V2ULLiV4Ui", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "ULLLiV2ULLi", .attributes = .{ .@"const" = true }, .features = "vector_enhancements_3" },
        .{ .param_str = "V4UiV8Us", .attributes = .{ .@"const" = true }, .features = "vector" },
        .{ .param_str = "vi", .attributes = .{ .@"noreturn" = true }, .features = "transactional_execution" },
        .{ .param_str = "iv*", .attributes = .{ .returns_twice = true }, .features = "transactional_execution" },
        .{ .param_str = "iv*", .attributes = .{ .returns_twice = true }, .features = "transactional_execution" },
        .{ .param_str = "v", .attributes = .{ .returns_twice = true }, .features = "transactional_execution" },
        .{ .param_str = "i", .features = "transactional_execution" },
        .{ .param_str = "vi", .features = "transactional_execution" },
        .{ .param_str = "i", .attributes = .{ .@"const" = true }, .features = "transactional_execution" },
    };
};
};
}
