const compiler_rt = @import("../compiler_rt.zig");
const symbol = compiler_rt.symbol;
const floatFromInt = @import("./float_from_int.zig").floatFromInt;

comptime {
    if (compiler_rt.want_aeabi) {
        symbol(&__aeabi_i2d, "__aeabi_i2d");
    } else {
        symbol(&__floatsidf, "__floatsidf");
    }
}

pub fn __floatsidf(a: i32) callconv(.c) f64 {
    return floatFromInt(f64, a);
}

fn __aeabi_i2d(a: i32) callconv(.{ .arm_aapcs = .{} }) f64 {
    return floatFromInt(f64, a);
}
