/*-
 * Copyright (c) 2014 Andrew Turner
 * Copyright (c) 2015-2018 Ruslan Bukin <br@bsdpad.com>
 * All rights reserved.
 *
 * Portions of this software were developed by SRI International and the
 * University of Cambridge Computer Laboratory under DARPA/AFRL contract
 * FA8750-10-C-0237 ("CTSRD"), as part of the DARPA CRASH research programme.
 *
 * Portions of this software were developed by the University of Cambridge
 * Computer Laboratory as part of the CTSRD Project, with support from the
 * UK Higher Education Innovation Fund (HEIF).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _MACHINE_PTE_H_
#define	_MACHINE_PTE_H_

#ifndef LOCORE
typedef	uint64_t	pd_entry_t;		/* page directory entry */
typedef	uint64_t	pt_entry_t;		/* page table entry */
typedef	uint64_t	pn_t;			/* page number */
#endif

/* Level 0 table, 512GiB per entry, SV48 only */
#define	L0_SHIFT	39
#define	L0_SIZE		(1UL << L0_SHIFT)
#define	L0_OFFSET	(L0_SIZE - 1)

/* Level 1 table, 1GiB per entry */
#define	L1_SHIFT	30
#define	L1_SIZE 	(1UL << L1_SHIFT)
#define	L1_OFFSET 	(L1_SIZE - 1)

/* Level 2 table, 2MiB per entry */
#define	L2_SHIFT	21
#define	L2_SIZE 	(1UL << L2_SHIFT)
#define	L2_OFFSET 	(L2_SIZE - 1)

/* Level 3 table, 4KiB per entry */
#define	L3_SHIFT	12
#define	L3_SIZE 	(1UL << L3_SHIFT)
#define	L3_OFFSET 	(L3_SIZE - 1)

#define	Ln_ENTRIES_SHIFT 9
#define	Ln_ENTRIES	(1 << Ln_ENTRIES_SHIFT)
#define	Ln_ADDR_MASK	(Ln_ENTRIES - 1)

/* Bits 9:8 are reserved for software */
#define	PTE_SW_MANAGED	(1 << 9)
#define	PTE_SW_WIRED	(1 << 8)
#define	PTE_D		(1 << 7) /* Dirty */
#define	PTE_A		(1 << 6) /* Accessed */
#define	PTE_G		(1 << 5) /* Global */
#define	PTE_U		(1 << 4) /* User */
#define	PTE_X		(1 << 3) /* Execute */
#define	PTE_W		(1 << 2) /* Write */
#define	PTE_R		(1 << 1) /* Read */
#define	PTE_V		(1 << 0) /* Valid */
#define	PTE_RWX		(PTE_R | PTE_W | PTE_X)
#define	PTE_RX		(PTE_R | PTE_X)
#define	PTE_KERN	(PTE_V | PTE_R | PTE_W | PTE_A | PTE_D)
#define	PTE_PROMOTE	(PTE_V | PTE_RWX | PTE_D | PTE_G | PTE_U | \
			 PTE_SW_MANAGED | PTE_SW_WIRED)

/*
 * Svpbmt Memory Attribute (MA) bits [62:61].
 *
 * +------+-------+------------------------------------------------------------+
 * | Mode | Value | Requested Memory Attributes                                |
 * +------+-------+------------------------------------------------------------+
 * | PMA  | 00    | None, inherited from Physical Memory Attributes (firmware) |
 * | NC   | 01    | Non-cacheable, idempotent, weakly-ordered (RVWMO),         |
 * |      |       | main memory                                                |
 * | IO   | 10    | Non-cacheable, non-idempotent, strongly-ordered, I/O       |
 * | --   | 11    | Reserved                                                   |
 * +------+-------+------------------------------------------------------------+
 */
#define	PTE_MA_SHIFT		61
#define	PTE_MA_MASK		(0x3ul << PTE_MA_SHIFT)
#define	PTE_MA_NONE		(0ul)
#define	PTE_MA_NC		(1ul << PTE_MA_SHIFT)
#define	PTE_MA_IO		(2ul << PTE_MA_SHIFT)

/*
 * T-HEAD Custom Memory Attribute (MA) bits [63:59].
 *
 * bit 59: Trustable (relating to TEE)
 * bit 60: Shareable (among CPUs, not configurable)
 * bit 61: Bufferable (writes to device memory)
 * bit 62: Cacheable
 * bit 63: Memory Ordering (1 = strongly ordered (device), 0 = default)
 *
 * +------+-------+------------------------------------------------------------+
 * | Mode | Value | Requested Memory Attributes                                |
 * +------+-------+------------------------------------------------------------+
 * | NC   | 00110 | Weakly-ordered, non-cacheable, bufferable, shareable,      |
 * |      |       | non-trustable                                              |
 * | PMA  | 01110 | Weakly-ordered, cacheable, bufferable, shareable,          |
 * |      |       | non-trustable                                              |
 * | IO   | 10010 | Strongly-ordered, non-cacheable, non-bufferable,           |
 * |      |       | shareable, non-trustable                                   |
 * +------+-------+------------------------------------------------------------+
 */
#define	PTE_THEAD_MA_SHIFT	59
#define	PTE_THEAD_MA_MASK	(0x1ful << PTE_THEAD_MA_SHIFT)
#define	PTE_THEAD_MA_NC		(0x6ul  << PTE_THEAD_MA_SHIFT)
#define	PTE_THEAD_MA_NONE	(0xeul  << PTE_THEAD_MA_SHIFT)
#define	PTE_THEAD_MA_IO		(0x12ul << PTE_THEAD_MA_SHIFT)

/* Bits 63 - 54 are reserved for future use. */
#define PTE_HI_MASK	0xFFC0000000000000ULL

#define	PTE_PPN0_S	10
#define	PTE_PPN1_S	19
#define	PTE_PPN2_S	28
#define	PTE_PPN3_S	37
#define	PTE_SIZE	8

#endif /* !_MACHINE_PTE_H_ */