//! Autogenerated by GenerateDef from src/aro/Builtins/riscv.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    __builtin_riscv_aes32dsi,
    __builtin_riscv_aes32dsmi,
    __builtin_riscv_aes32esi,
    __builtin_riscv_aes32esmi,
    __builtin_riscv_aes64ds,
    __builtin_riscv_aes64dsm,
    __builtin_riscv_aes64es,
    __builtin_riscv_aes64esm,
    __builtin_riscv_aes64im,
    __builtin_riscv_aes64ks1i,
    __builtin_riscv_aes64ks2,
    __builtin_riscv_brev8_32,
    __builtin_riscv_brev8_64,
    __builtin_riscv_clmul_32,
    __builtin_riscv_clmul_64,
    __builtin_riscv_clmulh_32,
    __builtin_riscv_clmulh_64,
    __builtin_riscv_clmulr_32,
    __builtin_riscv_clmulr_64,
    __builtin_riscv_clz_32,
    __builtin_riscv_clz_64,
    __builtin_riscv_ctz_32,
    __builtin_riscv_ctz_64,
    __builtin_riscv_cv_alu_addN,
    __builtin_riscv_cv_alu_addRN,
    __builtin_riscv_cv_alu_adduN,
    __builtin_riscv_cv_alu_adduRN,
    __builtin_riscv_cv_alu_clip,
    __builtin_riscv_cv_alu_clipu,
    __builtin_riscv_cv_alu_extbs,
    __builtin_riscv_cv_alu_extbz,
    __builtin_riscv_cv_alu_exths,
    __builtin_riscv_cv_alu_exthz,
    __builtin_riscv_cv_alu_sle,
    __builtin_riscv_cv_alu_sleu,
    __builtin_riscv_cv_alu_subN,
    __builtin_riscv_cv_alu_subRN,
    __builtin_riscv_cv_alu_subuN,
    __builtin_riscv_cv_alu_subuRN,
    __builtin_riscv_ntl_load,
    __builtin_riscv_ntl_store,
    __builtin_riscv_orc_b_32,
    __builtin_riscv_orc_b_64,
    __builtin_riscv_pause,
    __builtin_riscv_sha256sig0,
    __builtin_riscv_sha256sig1,
    __builtin_riscv_sha256sum0,
    __builtin_riscv_sha256sum1,
    __builtin_riscv_sha512sig0,
    __builtin_riscv_sha512sig0h,
    __builtin_riscv_sha512sig0l,
    __builtin_riscv_sha512sig1,
    __builtin_riscv_sha512sig1h,
    __builtin_riscv_sha512sig1l,
    __builtin_riscv_sha512sum0,
    __builtin_riscv_sha512sum0r,
    __builtin_riscv_sha512sum1,
    __builtin_riscv_sha512sum1r,
    __builtin_riscv_sm3p0,
    __builtin_riscv_sm3p1,
    __builtin_riscv_sm4ed,
    __builtin_riscv_sm4ks,
    __builtin_riscv_unzip_32,
    __builtin_riscv_xperm4_32,
    __builtin_riscv_xperm4_64,
    __builtin_riscv_xperm8_32,
    __builtin_riscv_xperm8_64,
    __builtin_riscv_zip_32,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 21;
pub const longest_name = 29;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(136);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 2 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 3 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 4 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 5 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 6 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 7 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 8 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 9 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 10 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 11 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 12 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 13 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 14 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 15 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 16 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 17 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 11, .child_index = 27 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 28 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 29 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 32 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 33 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 34 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 35 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 37 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 38 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 39 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 40 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 41 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 42 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 44 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 45 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 46 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 47 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 48 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 49 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 50 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 52 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 53 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 54 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 11, .child_index = 55 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 57 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 58 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 60 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 61 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 62 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 63 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 64 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 66 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 67 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 39 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 69 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 70 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 71 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 72 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 73 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 74 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 75 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 77 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 78 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 80 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 81 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 82 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 83 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 84 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 86 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 87 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 88 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 89 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 90 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 92 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 96 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 99 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 100 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 101 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 102 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 103 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 104 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 105 },
    .{ .char = '0', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 106 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 108 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 108 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 109 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 109 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 111 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 75 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 59 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 112 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 113 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 114 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 115 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 116 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 59 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 59 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 117 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 119 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 120 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 122 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 86 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 126 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 127 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 129 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 131 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 131 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 132 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 133 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 134 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 135 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 81 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 137 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 138 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 139 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 140 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 141 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 142 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 143 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 144 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 145 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 84 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 84 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 146 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 148 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 150 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 153 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 154 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 156 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 150 },
    .{ .char = '0', .end_of_word = true, .end_of_list = false, .number = 3, .child_index = 157 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 157 },
    .{ .char = '0', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 159 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 159 },
    .{ .char = 'N', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 160 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 161 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 156 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 163 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 163 },
    .{ .char = 'u', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'N', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'N', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 160 },
    .{ .char = 's', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
};
pub const data = blk: {
    @setEvalBranchQuota(612);
    break :blk [_]Properties{
        .{ .param_str = "UiUiUiIUi", .features = "zknd,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiIUi", .features = "zknd,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiIUi", .features = "zkne,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiIUi", .features = "zkne,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zknd,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zknd,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zkne,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zkne,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zknd,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiIUi", .features = "zknd|zkne,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zknd|zkne,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zbkb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zbkb,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zbc|zbkc", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zbc|zbkc,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zbc|zbkc,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zbc|zbkc,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zbc,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zbc,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zbb|xtheadbb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUWi", .features = "zbb|xtheadbb,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zbb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUWi", .features = "zbb,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .features = "xcvalu", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v.", .features = "zihintntl", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "v.", .features = "zihintntl", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "UiUi", .features = "zbb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zbb,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v", .features = "zihintpause" },
        .{ .param_str = "UiUi", .features = "zknh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zknh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zknh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zknh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zknh,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zknh,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zknh,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWi", .features = "zknh,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zknh,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zksh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zksh", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiIUi", .features = "zksed", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiIUi", .features = "zksed", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zbkb,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zbkx,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zbkx,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .features = "zbkx,32bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UWiUWiUWi", .features = "zbkx,64bit", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .features = "zbkb,32bit", .attributes = .{ .@"const" = true } },
    };
};
};
}
