//! Autogenerated by GenerateDef from src/aro/Builtins/amdgcn.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    __builtin_amdgcn_alignbit,
    __builtin_amdgcn_alignbyte,
    __builtin_amdgcn_ashr_pk_i8_i32,
    __builtin_amdgcn_ashr_pk_u8_i32,
    __builtin_amdgcn_atomic_dec32,
    __builtin_amdgcn_atomic_dec64,
    __builtin_amdgcn_atomic_inc32,
    __builtin_amdgcn_atomic_inc64,
    __builtin_amdgcn_ballot_w32,
    __builtin_amdgcn_ballot_w64,
    __builtin_amdgcn_bitop3_b16,
    __builtin_amdgcn_bitop3_b32,
    __builtin_amdgcn_buffer_wbinvl1,
    __builtin_amdgcn_buffer_wbinvl1_vol,
    __builtin_amdgcn_class,
    __builtin_amdgcn_classf,
    __builtin_amdgcn_classh,
    __builtin_amdgcn_cosf,
    __builtin_amdgcn_cosh,
    __builtin_amdgcn_cubeid,
    __builtin_amdgcn_cubema,
    __builtin_amdgcn_cubesc,
    __builtin_amdgcn_cubetc,
    __builtin_amdgcn_cvt_f16_bf8,
    __builtin_amdgcn_cvt_f16_fp8,
    __builtin_amdgcn_cvt_f32_bf8,
    __builtin_amdgcn_cvt_f32_fp8,
    __builtin_amdgcn_cvt_f32_fp8_e5m3,
    __builtin_amdgcn_cvt_off_f32_i4,
    __builtin_amdgcn_cvt_pk_bf8_f32,
    __builtin_amdgcn_cvt_pk_f16_bf8,
    __builtin_amdgcn_cvt_pk_f16_fp8,
    __builtin_amdgcn_cvt_pk_f32_bf8,
    __builtin_amdgcn_cvt_pk_f32_fp8,
    __builtin_amdgcn_cvt_pk_fp8_f32,
    __builtin_amdgcn_cvt_pk_i16,
    __builtin_amdgcn_cvt_pk_u16,
    __builtin_amdgcn_cvt_pk_u8_f32,
    __builtin_amdgcn_cvt_pknorm_i16,
    __builtin_amdgcn_cvt_pknorm_u16,
    __builtin_amdgcn_cvt_pkrtz,
    __builtin_amdgcn_cvt_scalef32_2xpk16_bf6_f32,
    __builtin_amdgcn_cvt_scalef32_2xpk16_fp6_f32,
    __builtin_amdgcn_cvt_scalef32_f16_bf8,
    __builtin_amdgcn_cvt_scalef32_f16_fp8,
    __builtin_amdgcn_cvt_scalef32_f32_bf8,
    __builtin_amdgcn_cvt_scalef32_f32_fp8,
    __builtin_amdgcn_cvt_scalef32_pk32_bf16_bf6,
    __builtin_amdgcn_cvt_scalef32_pk32_bf16_fp6,
    __builtin_amdgcn_cvt_scalef32_pk32_bf6_bf16,
    __builtin_amdgcn_cvt_scalef32_pk32_bf6_f16,
    __builtin_amdgcn_cvt_scalef32_pk32_f16_bf6,
    __builtin_amdgcn_cvt_scalef32_pk32_f16_fp6,
    __builtin_amdgcn_cvt_scalef32_pk32_f32_bf6,
    __builtin_amdgcn_cvt_scalef32_pk32_f32_fp6,
    __builtin_amdgcn_cvt_scalef32_pk32_fp6_bf16,
    __builtin_amdgcn_cvt_scalef32_pk32_fp6_f16,
    __builtin_amdgcn_cvt_scalef32_pk_bf16_bf8,
    __builtin_amdgcn_cvt_scalef32_pk_bf16_fp4,
    __builtin_amdgcn_cvt_scalef32_pk_bf16_fp8,
    __builtin_amdgcn_cvt_scalef32_pk_bf8_bf16,
    __builtin_amdgcn_cvt_scalef32_pk_bf8_f16,
    __builtin_amdgcn_cvt_scalef32_pk_bf8_f32,
    __builtin_amdgcn_cvt_scalef32_pk_f16_bf8,
    __builtin_amdgcn_cvt_scalef32_pk_f16_fp4,
    __builtin_amdgcn_cvt_scalef32_pk_f16_fp8,
    __builtin_amdgcn_cvt_scalef32_pk_f32_bf8,
    __builtin_amdgcn_cvt_scalef32_pk_f32_fp4,
    __builtin_amdgcn_cvt_scalef32_pk_f32_fp8,
    __builtin_amdgcn_cvt_scalef32_pk_fp4_bf16,
    __builtin_amdgcn_cvt_scalef32_pk_fp4_f16,
    __builtin_amdgcn_cvt_scalef32_pk_fp4_f32,
    __builtin_amdgcn_cvt_scalef32_pk_fp8_bf16,
    __builtin_amdgcn_cvt_scalef32_pk_fp8_f16,
    __builtin_amdgcn_cvt_scalef32_pk_fp8_f32,
    __builtin_amdgcn_cvt_scalef32_sr_bf8_bf16,
    __builtin_amdgcn_cvt_scalef32_sr_bf8_f16,
    __builtin_amdgcn_cvt_scalef32_sr_bf8_f32,
    __builtin_amdgcn_cvt_scalef32_sr_fp8_bf16,
    __builtin_amdgcn_cvt_scalef32_sr_fp8_f16,
    __builtin_amdgcn_cvt_scalef32_sr_fp8_f32,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_bf16,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_f16,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_f32,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_bf16,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_f16,
    __builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_f32,
    __builtin_amdgcn_cvt_scalef32_sr_pk_fp4_bf16,
    __builtin_amdgcn_cvt_scalef32_sr_pk_fp4_f16,
    __builtin_amdgcn_cvt_scalef32_sr_pk_fp4_f32,
    __builtin_amdgcn_cvt_sr_bf16_f32,
    __builtin_amdgcn_cvt_sr_bf8_f32,
    __builtin_amdgcn_cvt_sr_f16_f32,
    __builtin_amdgcn_cvt_sr_fp8_f32,
    __builtin_amdgcn_dispatch_ptr,
    __builtin_amdgcn_div_fixup,
    __builtin_amdgcn_div_fixupf,
    __builtin_amdgcn_div_fixuph,
    __builtin_amdgcn_div_fmas,
    __builtin_amdgcn_div_fmasf,
    __builtin_amdgcn_div_scale,
    __builtin_amdgcn_div_scalef,
    __builtin_amdgcn_dot4_f32_bf8_bf8,
    __builtin_amdgcn_dot4_f32_bf8_fp8,
    __builtin_amdgcn_dot4_f32_fp8_bf8,
    __builtin_amdgcn_dot4_f32_fp8_fp8,
    __builtin_amdgcn_ds_append,
    __builtin_amdgcn_ds_atomic_async_barrier_arrive_b64,
    __builtin_amdgcn_ds_atomic_barrier_arrive_rtn_b64,
    __builtin_amdgcn_ds_atomic_fadd_f32,
    __builtin_amdgcn_ds_atomic_fadd_f64,
    __builtin_amdgcn_ds_atomic_fadd_v2bf16,
    __builtin_amdgcn_ds_atomic_fadd_v2f16,
    __builtin_amdgcn_ds_bpermute,
    __builtin_amdgcn_ds_bpermute_fi_b32,
    __builtin_amdgcn_ds_bvh_stack_push4_pop1_rtn,
    __builtin_amdgcn_ds_bvh_stack_push8_pop1_rtn,
    __builtin_amdgcn_ds_bvh_stack_push8_pop2_rtn,
    __builtin_amdgcn_ds_bvh_stack_rtn,
    __builtin_amdgcn_ds_consume,
    __builtin_amdgcn_ds_faddf,
    __builtin_amdgcn_ds_fmaxf,
    __builtin_amdgcn_ds_fminf,
    __builtin_amdgcn_ds_gws_barrier,
    __builtin_amdgcn_ds_gws_init,
    __builtin_amdgcn_ds_gws_sema_br,
    __builtin_amdgcn_ds_gws_sema_p,
    __builtin_amdgcn_ds_gws_sema_release_all,
    __builtin_amdgcn_ds_gws_sema_v,
    __builtin_amdgcn_ds_load_tr16_b128_v8bf16,
    __builtin_amdgcn_ds_load_tr16_b128_v8f16,
    __builtin_amdgcn_ds_load_tr16_b128_v8i16,
    __builtin_amdgcn_ds_load_tr4_b64_v2i32,
    __builtin_amdgcn_ds_load_tr6_b96_v3i32,
    __builtin_amdgcn_ds_load_tr8_b64_v2i32,
    __builtin_amdgcn_ds_permute,
    __builtin_amdgcn_ds_read_tr16_b64_v4bf16,
    __builtin_amdgcn_ds_read_tr16_b64_v4f16,
    __builtin_amdgcn_ds_read_tr16_b64_v4i16,
    __builtin_amdgcn_ds_read_tr4_b64_v2i32,
    __builtin_amdgcn_ds_read_tr6_b96_v3i32,
    __builtin_amdgcn_ds_read_tr8_b64_v2i32,
    __builtin_amdgcn_ds_swizzle,
    __builtin_amdgcn_endpgm,
    __builtin_amdgcn_exp2f,
    __builtin_amdgcn_fcmp,
    __builtin_amdgcn_fcmpf,
    __builtin_amdgcn_fdot2,
    __builtin_amdgcn_fdot2_bf16_bf16,
    __builtin_amdgcn_fdot2_f16_f16,
    __builtin_amdgcn_fdot2_f32_bf16,
    __builtin_amdgcn_fdot2c_f32_bf16,
    __builtin_amdgcn_fence,
    __builtin_amdgcn_flat_atomic_fadd_f32,
    __builtin_amdgcn_flat_atomic_fadd_f64,
    __builtin_amdgcn_flat_atomic_fadd_v2bf16,
    __builtin_amdgcn_flat_atomic_fadd_v2f16,
    __builtin_amdgcn_flat_atomic_fmax_f64,
    __builtin_amdgcn_flat_atomic_fmin_f64,
    __builtin_amdgcn_fmed3f,
    __builtin_amdgcn_fmed3h,
    __builtin_amdgcn_fract,
    __builtin_amdgcn_fractf,
    __builtin_amdgcn_fracth,
    __builtin_amdgcn_frexp_exp,
    __builtin_amdgcn_frexp_expf,
    __builtin_amdgcn_frexp_exph,
    __builtin_amdgcn_frexp_mant,
    __builtin_amdgcn_frexp_mantf,
    __builtin_amdgcn_frexp_manth,
    __builtin_amdgcn_get_fpenv,
    __builtin_amdgcn_global_atomic_fadd_f32,
    __builtin_amdgcn_global_atomic_fadd_f64,
    __builtin_amdgcn_global_atomic_fadd_v2bf16,
    __builtin_amdgcn_global_atomic_fadd_v2f16,
    __builtin_amdgcn_global_atomic_fmax_f64,
    __builtin_amdgcn_global_atomic_fmin_f64,
    __builtin_amdgcn_global_load_lds,
    __builtin_amdgcn_global_load_tr16_b128_v8bf16,
    __builtin_amdgcn_global_load_tr16_b128_v8f16,
    __builtin_amdgcn_global_load_tr16_b128_v8i16,
    __builtin_amdgcn_global_load_tr4_b64_v2i32,
    __builtin_amdgcn_global_load_tr6_b96_v3i32,
    __builtin_amdgcn_global_load_tr8_b64_v2i32,
    __builtin_amdgcn_global_load_tr_b128_v4bf16,
    __builtin_amdgcn_global_load_tr_b128_v4f16,
    __builtin_amdgcn_global_load_tr_b128_v4i16,
    __builtin_amdgcn_global_load_tr_b128_v8bf16,
    __builtin_amdgcn_global_load_tr_b128_v8f16,
    __builtin_amdgcn_global_load_tr_b128_v8i16,
    __builtin_amdgcn_global_load_tr_b64_i32,
    __builtin_amdgcn_global_load_tr_b64_v2i32,
    __builtin_amdgcn_grid_size_x,
    __builtin_amdgcn_grid_size_y,
    __builtin_amdgcn_grid_size_z,
    __builtin_amdgcn_groupstaticsize,
    __builtin_amdgcn_iglp_opt,
    __builtin_amdgcn_image_bvh8_intersect_ray,
    __builtin_amdgcn_image_bvh_dual_intersect_ray,
    __builtin_amdgcn_image_bvh_intersect_ray,
    __builtin_amdgcn_image_bvh_intersect_ray_h,
    __builtin_amdgcn_image_bvh_intersect_ray_l,
    __builtin_amdgcn_image_bvh_intersect_ray_lh,
    __builtin_amdgcn_implicitarg_ptr,
    __builtin_amdgcn_interp_mov,
    __builtin_amdgcn_interp_p1,
    __builtin_amdgcn_interp_p1_f16,
    __builtin_amdgcn_interp_p2,
    __builtin_amdgcn_interp_p2_f16,
    __builtin_amdgcn_is_private,
    __builtin_amdgcn_is_shared,
    __builtin_amdgcn_kernarg_segment_ptr,
    __builtin_amdgcn_ldexp,
    __builtin_amdgcn_ldexpf,
    __builtin_amdgcn_ldexph,
    __builtin_amdgcn_lerp,
    __builtin_amdgcn_load_to_lds,
    __builtin_amdgcn_log_clampf,
    __builtin_amdgcn_logf,
    __builtin_amdgcn_make_buffer_rsrc,
    __builtin_amdgcn_mbcnt_hi,
    __builtin_amdgcn_mbcnt_lo,
    __builtin_amdgcn_mfma_f32_16x16x16bf16_1k,
    __builtin_amdgcn_mfma_f32_16x16x16f16,
    __builtin_amdgcn_mfma_f32_16x16x1f32,
    __builtin_amdgcn_mfma_f32_16x16x2bf16,
    __builtin_amdgcn_mfma_f32_16x16x32_bf16,
    __builtin_amdgcn_mfma_f32_16x16x32_bf8_bf8,
    __builtin_amdgcn_mfma_f32_16x16x32_bf8_fp8,
    __builtin_amdgcn_mfma_f32_16x16x32_f16,
    __builtin_amdgcn_mfma_f32_16x16x32_fp8_bf8,
    __builtin_amdgcn_mfma_f32_16x16x32_fp8_fp8,
    __builtin_amdgcn_mfma_f32_16x16x4bf16_1k,
    __builtin_amdgcn_mfma_f32_16x16x4f16,
    __builtin_amdgcn_mfma_f32_16x16x4f32,
    __builtin_amdgcn_mfma_f32_16x16x8_xf32,
    __builtin_amdgcn_mfma_f32_16x16x8bf16,
    __builtin_amdgcn_mfma_f32_32x32x16_bf16,
    __builtin_amdgcn_mfma_f32_32x32x16_bf8_bf8,
    __builtin_amdgcn_mfma_f32_32x32x16_bf8_fp8,
    __builtin_amdgcn_mfma_f32_32x32x16_f16,
    __builtin_amdgcn_mfma_f32_32x32x16_fp8_bf8,
    __builtin_amdgcn_mfma_f32_32x32x16_fp8_fp8,
    __builtin_amdgcn_mfma_f32_32x32x1f32,
    __builtin_amdgcn_mfma_f32_32x32x2bf16,
    __builtin_amdgcn_mfma_f32_32x32x2f32,
    __builtin_amdgcn_mfma_f32_32x32x4_xf32,
    __builtin_amdgcn_mfma_f32_32x32x4bf16,
    __builtin_amdgcn_mfma_f32_32x32x4bf16_1k,
    __builtin_amdgcn_mfma_f32_32x32x4f16,
    __builtin_amdgcn_mfma_f32_32x32x8bf16_1k,
    __builtin_amdgcn_mfma_f32_32x32x8f16,
    __builtin_amdgcn_mfma_f32_4x4x1f32,
    __builtin_amdgcn_mfma_f32_4x4x2bf16,
    __builtin_amdgcn_mfma_f32_4x4x4bf16_1k,
    __builtin_amdgcn_mfma_f32_4x4x4f16,
    __builtin_amdgcn_mfma_f64_16x16x4f64,
    __builtin_amdgcn_mfma_f64_4x4x4f64,
    __builtin_amdgcn_mfma_i32_16x16x16i8,
    __builtin_amdgcn_mfma_i32_16x16x32_i8,
    __builtin_amdgcn_mfma_i32_16x16x4i8,
    __builtin_amdgcn_mfma_i32_16x16x64_i8,
    __builtin_amdgcn_mfma_i32_32x32x16_i8,
    __builtin_amdgcn_mfma_i32_32x32x32_i8,
    __builtin_amdgcn_mfma_i32_32x32x4i8,
    __builtin_amdgcn_mfma_i32_32x32x8i8,
    __builtin_amdgcn_mfma_i32_4x4x4i8,
    __builtin_amdgcn_mfma_scale_f32_16x16x128_f8f6f4,
    __builtin_amdgcn_mfma_scale_f32_32x32x64_f8f6f4,
    __builtin_amdgcn_mov_dpp,
    __builtin_amdgcn_mov_dpp8,
    __builtin_amdgcn_mqsad_pk_u16_u8,
    __builtin_amdgcn_mqsad_u32_u8,
    __builtin_amdgcn_msad_u8,
    __builtin_amdgcn_perm,
    __builtin_amdgcn_permlane16,
    __builtin_amdgcn_permlane16_swap,
    __builtin_amdgcn_permlane16_var,
    __builtin_amdgcn_permlane32_swap,
    __builtin_amdgcn_permlane64,
    __builtin_amdgcn_permlanex16,
    __builtin_amdgcn_permlanex16_var,
    __builtin_amdgcn_prng_b32,
    __builtin_amdgcn_qsad_pk_u16_u8,
    __builtin_amdgcn_queue_ptr,
    __builtin_amdgcn_raw_buffer_load_b128,
    __builtin_amdgcn_raw_buffer_load_b16,
    __builtin_amdgcn_raw_buffer_load_b32,
    __builtin_amdgcn_raw_buffer_load_b64,
    __builtin_amdgcn_raw_buffer_load_b8,
    __builtin_amdgcn_raw_buffer_load_b96,
    __builtin_amdgcn_raw_buffer_store_b128,
    __builtin_amdgcn_raw_buffer_store_b16,
    __builtin_amdgcn_raw_buffer_store_b32,
    __builtin_amdgcn_raw_buffer_store_b64,
    __builtin_amdgcn_raw_buffer_store_b8,
    __builtin_amdgcn_raw_buffer_store_b96,
    __builtin_amdgcn_raw_ptr_buffer_load_lds,
    __builtin_amdgcn_rcp,
    __builtin_amdgcn_rcpf,
    __builtin_amdgcn_rcph,
    __builtin_amdgcn_read_exec,
    __builtin_amdgcn_read_exec_hi,
    __builtin_amdgcn_read_exec_lo,
    __builtin_amdgcn_readfirstlane,
    __builtin_amdgcn_readlane,
    __builtin_amdgcn_rsq,
    __builtin_amdgcn_rsq_clamp,
    __builtin_amdgcn_rsq_clampf,
    __builtin_amdgcn_rsqf,
    __builtin_amdgcn_rsqh,
    __builtin_amdgcn_s_barrier,
    __builtin_amdgcn_s_barrier_signal,
    __builtin_amdgcn_s_barrier_signal_isfirst,
    __builtin_amdgcn_s_barrier_signal_var,
    __builtin_amdgcn_s_barrier_wait,
    __builtin_amdgcn_s_buffer_prefetch_data,
    __builtin_amdgcn_s_dcache_inv,
    __builtin_amdgcn_s_dcache_inv_vol,
    __builtin_amdgcn_s_dcache_wb,
    __builtin_amdgcn_s_decperflevel,
    __builtin_amdgcn_s_get_barrier_state,
    __builtin_amdgcn_s_get_named_barrier_state,
    __builtin_amdgcn_s_getpc,
    __builtin_amdgcn_s_getreg,
    __builtin_amdgcn_s_incperflevel,
    __builtin_amdgcn_s_memrealtime,
    __builtin_amdgcn_s_memtime,
    __builtin_amdgcn_s_monitor_sleep,
    __builtin_amdgcn_s_prefetch_data,
    __builtin_amdgcn_s_sendmsg,
    __builtin_amdgcn_s_sendmsg_rtn,
    __builtin_amdgcn_s_sendmsg_rtnl,
    __builtin_amdgcn_s_sendmsghalt,
    __builtin_amdgcn_s_setprio,
    __builtin_amdgcn_s_setprio_inc_wg,
    __builtin_amdgcn_s_setreg,
    __builtin_amdgcn_s_sleep,
    __builtin_amdgcn_s_sleep_var,
    __builtin_amdgcn_s_ttracedata,
    __builtin_amdgcn_s_ttracedata_imm,
    __builtin_amdgcn_s_wait_asynccnt,
    __builtin_amdgcn_s_wait_event_export_ready,
    __builtin_amdgcn_s_wait_tensorcnt,
    __builtin_amdgcn_s_waitcnt,
    __builtin_amdgcn_sad_hi_u8,
    __builtin_amdgcn_sad_u16,
    __builtin_amdgcn_sad_u8,
    __builtin_amdgcn_sbfe,
    __builtin_amdgcn_sched_barrier,
    __builtin_amdgcn_sched_group_barrier,
    __builtin_amdgcn_sdot2,
    __builtin_amdgcn_sdot4,
    __builtin_amdgcn_sdot8,
    __builtin_amdgcn_set_fpenv,
    __builtin_amdgcn_sicmp,
    __builtin_amdgcn_sicmpl,
    __builtin_amdgcn_sinf,
    __builtin_amdgcn_sinh,
    __builtin_amdgcn_smfmac_f32_16x16x128_bf8_bf8,
    __builtin_amdgcn_smfmac_f32_16x16x128_bf8_fp8,
    __builtin_amdgcn_smfmac_f32_16x16x128_fp8_bf8,
    __builtin_amdgcn_smfmac_f32_16x16x128_fp8_fp8,
    __builtin_amdgcn_smfmac_f32_16x16x32_bf16,
    __builtin_amdgcn_smfmac_f32_16x16x32_f16,
    __builtin_amdgcn_smfmac_f32_16x16x64_bf16,
    __builtin_amdgcn_smfmac_f32_16x16x64_bf8_bf8,
    __builtin_amdgcn_smfmac_f32_16x16x64_bf8_fp8,
    __builtin_amdgcn_smfmac_f32_16x16x64_f16,
    __builtin_amdgcn_smfmac_f32_16x16x64_fp8_bf8,
    __builtin_amdgcn_smfmac_f32_16x16x64_fp8_fp8,
    __builtin_amdgcn_smfmac_f32_32x32x16_bf16,
    __builtin_amdgcn_smfmac_f32_32x32x16_f16,
    __builtin_amdgcn_smfmac_f32_32x32x32_bf16,
    __builtin_amdgcn_smfmac_f32_32x32x32_bf8_bf8,
    __builtin_amdgcn_smfmac_f32_32x32x32_bf8_fp8,
    __builtin_amdgcn_smfmac_f32_32x32x32_f16,
    __builtin_amdgcn_smfmac_f32_32x32x32_fp8_bf8,
    __builtin_amdgcn_smfmac_f32_32x32x32_fp8_fp8,
    __builtin_amdgcn_smfmac_f32_32x32x64_bf8_bf8,
    __builtin_amdgcn_smfmac_f32_32x32x64_bf8_fp8,
    __builtin_amdgcn_smfmac_f32_32x32x64_fp8_bf8,
    __builtin_amdgcn_smfmac_f32_32x32x64_fp8_fp8,
    __builtin_amdgcn_smfmac_i32_16x16x128_i8,
    __builtin_amdgcn_smfmac_i32_16x16x64_i8,
    __builtin_amdgcn_smfmac_i32_32x32x32_i8,
    __builtin_amdgcn_smfmac_i32_32x32x64_i8,
    __builtin_amdgcn_sqrt,
    __builtin_amdgcn_sqrtf,
    __builtin_amdgcn_sqrth,
    __builtin_amdgcn_sudot4,
    __builtin_amdgcn_sudot8,
    __builtin_amdgcn_swmmac_bf16_16x16x32_bf16_w32,
    __builtin_amdgcn_swmmac_bf16_16x16x32_bf16_w64,
    __builtin_amdgcn_swmmac_f16_16x16x32_f16_w32,
    __builtin_amdgcn_swmmac_f16_16x16x32_f16_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf16_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf16_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf8_bf8_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf8_bf8_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf8_fp8_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_bf8_fp8_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_f16_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_f16_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_fp8_bf8_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_fp8_bf8_w64,
    __builtin_amdgcn_swmmac_f32_16x16x32_fp8_fp8_w32,
    __builtin_amdgcn_swmmac_f32_16x16x32_fp8_fp8_w64,
    __builtin_amdgcn_swmmac_i32_16x16x32_iu4_w32,
    __builtin_amdgcn_swmmac_i32_16x16x32_iu4_w64,
    __builtin_amdgcn_swmmac_i32_16x16x32_iu8_w32,
    __builtin_amdgcn_swmmac_i32_16x16x32_iu8_w64,
    __builtin_amdgcn_swmmac_i32_16x16x64_iu4_w32,
    __builtin_amdgcn_swmmac_i32_16x16x64_iu4_w64,
    __builtin_amdgcn_tanh_bf16,
    __builtin_amdgcn_tensor_load_to_lds,
    __builtin_amdgcn_tensor_load_to_lds_d2,
    __builtin_amdgcn_tensor_store_from_lds,
    __builtin_amdgcn_tensor_store_from_lds_d2,
    __builtin_amdgcn_trig_preop,
    __builtin_amdgcn_trig_preopf,
    __builtin_amdgcn_ubfe,
    __builtin_amdgcn_udot2,
    __builtin_amdgcn_udot4,
    __builtin_amdgcn_udot8,
    __builtin_amdgcn_uicmp,
    __builtin_amdgcn_uicmpl,
    __builtin_amdgcn_update_dpp,
    __builtin_amdgcn_wave_barrier,
    __builtin_amdgcn_wavefrontsize,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_tied_w32,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_tied_w64,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_w32,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_w32_gfx12,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_w64,
    __builtin_amdgcn_wmma_bf16_16x16x16_bf16_w64_gfx12,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_tied_w32,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_tied_w64,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_w32,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_w32_gfx12,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_w64,
    __builtin_amdgcn_wmma_f16_16x16x16_f16_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf16_w32,
    __builtin_amdgcn_wmma_f32_16x16x16_bf16_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf16_w64,
    __builtin_amdgcn_wmma_f32_16x16x16_bf16_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf8_bf8_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf8_bf8_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf8_fp8_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_bf8_fp8_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_f16_w32,
    __builtin_amdgcn_wmma_f32_16x16x16_f16_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_f16_w64,
    __builtin_amdgcn_wmma_f32_16x16x16_f16_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_fp8_bf8_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_fp8_bf8_w64_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_fp8_fp8_w32_gfx12,
    __builtin_amdgcn_wmma_f32_16x16x16_fp8_fp8_w64_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x16_iu4_w32,
    __builtin_amdgcn_wmma_i32_16x16x16_iu4_w32_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x16_iu4_w64,
    __builtin_amdgcn_wmma_i32_16x16x16_iu4_w64_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x16_iu8_w32,
    __builtin_amdgcn_wmma_i32_16x16x16_iu8_w32_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x16_iu8_w64,
    __builtin_amdgcn_wmma_i32_16x16x16_iu8_w64_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x32_iu4_w32_gfx12,
    __builtin_amdgcn_wmma_i32_16x16x32_iu4_w64_gfx12,
    __builtin_amdgcn_workgroup_id_x,
    __builtin_amdgcn_workgroup_id_y,
    __builtin_amdgcn_workgroup_id_z,
    __builtin_amdgcn_workgroup_size_x,
    __builtin_amdgcn_workgroup_size_y,
    __builtin_amdgcn_workgroup_size_z,
    __builtin_amdgcn_workitem_id_x,
    __builtin_amdgcn_workitem_id_y,
    __builtin_amdgcn_workitem_id_z,
    __builtin_r600_implicitarg_ptr,
    __builtin_r600_read_tgid_x,
    __builtin_r600_read_tgid_y,
    __builtin_r600_read_tgid_z,
    __builtin_r600_read_tidig_x,
    __builtin_r600_read_tidig_y,
    __builtin_r600_read_tidig_z,
    __builtin_r600_recipsqrt_ieee,
    __builtin_r600_recipsqrt_ieeef,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 20;
pub const longest_name = 52;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(972);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 2 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 3 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 4 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 5 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 6 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 7 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 8 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 9 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 10 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 486, .child_index = 11 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 477, .child_index = 13 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 14 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 15 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 16 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 17 },
    .{ .char = '0', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 18 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 19 },
    .{ .char = '0', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 20 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 21 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 22 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 24 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 25 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 26 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 477, .child_index = 27 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 45 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 46 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 48 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 51 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 80, .child_index = 54 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 49, .child_index = 58 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 61 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 25, .child_index = 63 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 69 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 15, .child_index = 72 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 76 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 77 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 55, .child_index = 80 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 86 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 88 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 26, .child_index = 90 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 103, .child_index = 94 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 105 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 108 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 112 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 115 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 116 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 117 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 118 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 119 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 120 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 121 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 122 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 123 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 124 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 125 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 126 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 71, .child_index = 127 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 128 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 130 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 131 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 132 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 134 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 135 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 136 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 137 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 138 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 139 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 141 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 21, .child_index = 142 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 143 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 145 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 146 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 148 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 149 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 151 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 152 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 155 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 156 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 47, .child_index = 157 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 158 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 159 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 160 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 161 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 162 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 163 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 164 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 165 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 166 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 167 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 168 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 34, .child_index = 169 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 178 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 179 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 180 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 181 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 141 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 182 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 28, .child_index = 184 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 185 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 186 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 187 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 188 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 189 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 190 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 179 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 181 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 191 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 192 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 193 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 38, .child_index = 194 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 195 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 196 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 197 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 198 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 199 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 200 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 201 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 202 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 203 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 204 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 205 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 206 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 208 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 71, .child_index = 209 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 210 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 211 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 212 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 37, .child_index = 213 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 224 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 225 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 226 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 227 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 228 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 229 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 230 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 21, .child_index = 232 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 233 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 234 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 235 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 236 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 115 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 237 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 238 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 240 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 241 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 243 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 244 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 246 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 247 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 47, .child_index = 248 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 249 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 250 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 251 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 252 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 254 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 255 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 256 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 257 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 259 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 260 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 263 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 265 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 267 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 268 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 269 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 271 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 272 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 274 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 275 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 276 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 278 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 279 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 280 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 206 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 281 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 282 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 283 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 284 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 285 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 286 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 287 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 280 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 288 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 289 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 38, .child_index = 290 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 291 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 292 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 293 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 294 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 295 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 296 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 297 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 298 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 299 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 300 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 301 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 302 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 71, .child_index = 306 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 310 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 311 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 313 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 314 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 316 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 318 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 319 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 321 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 322 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 323 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 324 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 326 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 328 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 329 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 330 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 331 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 282 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 332 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 333 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 21, .child_index = 334 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 335 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 337 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 338 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 339 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 340 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 342 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 166 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 343 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 344 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 346 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 47, .child_index = 347 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 348 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 349 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 8, .child_index = 351 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 352 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 353 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 354 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 355 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 357 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 360 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 361 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 362 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 363 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 364 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 365 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 364 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 366 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 367 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 368 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 369 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 371 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 372 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 373 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 374 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 376 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 377 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 380 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 381 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 257 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 382 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 383 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 385 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 386 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 387 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 388 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 38, .child_index = 390 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 391 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 393 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 394 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 396 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 397 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 398 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 399 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 400 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 401 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 402 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 257 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 403 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 404 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 405 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 406 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 408 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 409 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 53, .child_index = 410 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 412 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 413 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 415 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 416 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 417 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 418 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 419 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 420 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 422 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 423 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 425 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 426 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 427 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 428 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 429 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 431 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 433 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 206 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 434 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 21, .child_index = 436 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 437 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 438 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 440 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 441 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 442 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 443 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 445 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 446 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 447 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 448 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 47, .child_index = 449 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 452 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 453 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 454 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 455 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 456 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 457 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 459 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 460 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 461 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 462 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 463 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 464 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 465 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 466 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 467 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 468 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 469 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 472 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 476 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 477 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 479 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 480 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 481 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 482 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 483 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 485 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 486 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 487 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 488 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 490 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 491 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 492 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 493 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 494 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 495 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 38, .child_index = 497 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 500 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 501 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 502 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 503 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 504 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 505 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 508 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 509 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 511 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 512 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 513 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 514 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 515 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 516 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 49, .child_index = 519 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 520 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 521 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 522 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 523 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 524 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 525 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 526 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 527 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 528 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 529 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 530 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 531 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 532 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 533 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 534 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 535 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 536 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 537 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 538 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 539 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 541 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 542 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 543 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 545 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 21, .child_index = 546 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 547 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 548 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 549 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 550 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 551 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 552 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 553 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 555 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 556 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 557 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 558 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 36, .child_index = 560 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 562 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 563 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 564 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 565 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 568 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 570 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 571 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 572 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 573 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 574 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 575 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 576 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 577 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 578 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 579 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 580 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 581 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 582 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 405 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 584 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 585 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 587 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 588 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 589 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 590 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 584 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 591 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 592 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 593 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 595 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 596 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 598 },
    .{ .char = '4', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 599 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 601 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 602 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 603 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 604 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 606 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 22, .child_index = 607 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 609 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 610 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 611 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 612 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 613 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 614 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 615 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 616 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 617 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 618 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 619 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 621 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 622 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 623 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 624 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 625 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 626 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 627 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 631 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 632 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 633 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 634 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 636 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 637 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 638 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 639 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 640 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 641 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 642 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 643 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 644 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 645 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 646 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 649 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 650 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 651 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 652 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 653 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 654 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 656 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 657 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 241 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 658 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 659 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 21, .child_index = 660 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 662 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 663 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 664 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 665 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 667 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 668 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 669 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 670 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 671 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 672 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 673 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 674 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 34, .child_index = 675 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 676 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 677 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 678 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 679 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 570 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 680 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 681 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 683 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 684 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 685 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 686 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 687 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 688 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 134 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 689 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 690 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 691 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 692 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 693 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 694 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 695 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 696 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 697 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 698 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 699 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 700 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 701 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 702 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 703 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 704 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 707 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 604 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 708 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 709 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 22, .child_index = 711 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 715 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 717 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 718 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 719 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 720 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 721 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 722 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 723 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 724 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 725 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 726 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 727 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 728 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 729 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 730 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 731 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 733 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 734 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 735 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 737 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 739 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 740 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 742 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 744 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 745 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 746 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 714 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 749 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 751 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 752 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 753 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 754 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 755 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 166 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 328 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 757 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 758 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 759 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 760 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 761 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 697 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 604 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 762 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 763 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 764 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 617 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 765 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 766 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 767 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 768 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 769 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 770 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 771 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 772 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 773 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 542 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 774 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 775 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 776 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 777 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 778 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 779 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 617 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 781 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 782 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 783 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 784 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 34, .child_index = 785 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 786 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 787 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 788 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 789 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 790 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 794 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 795 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 796 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 797 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 798 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 799 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 800 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 801 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 802 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 803 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 804 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 805 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 806 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 807 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 808 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 809 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 810 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 811 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 812 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 813 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 814 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 815 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 816 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 24, .child_index = 817 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 818 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 819 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 820 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 822 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 823 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 824 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 825 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 826 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 827 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 828 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 829 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 830 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 831 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 832 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 833 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 834 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 835 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 836 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 728 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 839 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 840 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 840 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 841 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 841 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 682 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 842 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 595 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 843 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 844 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 845 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 844 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 846 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 847 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 848 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 513 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 849 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 848 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 595 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 851 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 852 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 853 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 855 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 848 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 328 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 856 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 858 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 859 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 860 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 861 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 862 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 863 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 864 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 865 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 866 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 769 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 867 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 282 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 868 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 728 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 869 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 870 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 773 },
    .{ .char = '1', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 872 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 872 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 873 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 874 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 875 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 34, .child_index = 876 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 879 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 881 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 884 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 885 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 886 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 842 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 887 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 888 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 889 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 890 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 891 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 892 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 893 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 894 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 895 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 897 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 898 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 899 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 900 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 901 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 902 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 903 },
    .{ .char = 'o', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 905 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 906 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 907 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 908 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 909 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 910 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 911 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 24, .child_index = 912 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 913 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 914 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 915 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 916 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 917 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 918 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 919 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 224 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 920 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 921 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 922 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 923 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 924 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 925 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 926 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 503 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 927 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 928 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 735 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 929 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 930 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 931 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 624 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 932 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 933 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 934 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 855 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 850 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 935 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 936 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 937 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 940 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 941 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 942 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 943 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 947 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 951 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 952 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 953 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 954 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 955 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 957 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 958 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 959 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 15, .child_index = 960 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 15, .child_index = 961 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 962 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 963 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 964 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 965 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 966 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 967 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 968 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 969 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 970 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 971 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 972 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 973 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 974 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 558 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 463 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 975 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 271 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 977 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 978 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 979 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 980 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 981 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 982 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 983 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 984 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 985 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 986 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 795 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 987 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 988 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 989 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 990 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 991 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 24, .child_index = 992 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 993 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 994 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 995 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 996 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 997 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 998 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 999 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1000 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1001 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1002 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1003 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1004 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1005 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1006 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1008 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1009 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1010 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1011 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1012 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1013 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 1015 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1016 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1016 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1017 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1018 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1019 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1020 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1021 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1022 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1023 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1024 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1025 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1024 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1026 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1024 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1025 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1024 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1027 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1028 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 921 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1029 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1030 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1031 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1032 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1033 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1034 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1035 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1036 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1037 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1038 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1039 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1040 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1041 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1042 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1043 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1045 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 702 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1046 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1048 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1049 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1050 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1051 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1052 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1053 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1054 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1055 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1056 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1057 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1058 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1059 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1060 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1061 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1062 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1063 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1064 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 24, .child_index = 1065 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1067 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1069 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1070 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1071 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1072 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1073 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1074 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 795 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1075 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1076 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1077 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1078 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1079 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 613 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 547 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 757 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1080 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1081 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1082 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 714 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 1083 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 624 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1084 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1085 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1086 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1087 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1088 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1089 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1093 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1094 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1095 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1096 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1097 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1098 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1100 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1101 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1102 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1103 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1104 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1105 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1106 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1107 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1108 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1109 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1110 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1111 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1112 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1113 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1114 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 906 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1114 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1115 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1116 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1117 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1118 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 861 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1120 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1121 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1122 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1123 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1124 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1125 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1126 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1127 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1128 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1129 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1130 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 495 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 1131 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1132 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1133 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1134 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1135 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1136 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1137 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1138 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1139 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1140 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1141 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1142 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1143 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1144 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1145 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1146 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 842 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 49, .child_index = 1147 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1151 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1152 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1153 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1154 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1155 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 795 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1157 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1158 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1159 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1160 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1161 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1162 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 874 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1164 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1165 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1166 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1167 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1168 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1169 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1170 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1171 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1172 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1175 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1176 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1177 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1178 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1179 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1180 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1181 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1182 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1183 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1184 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1185 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1186 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1187 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1188 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 693 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1189 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1190 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 486 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1191 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1192 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 707 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1193 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1128 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1194 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1195 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1196 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1197 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1198 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1199 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1200 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1201 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1202 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1203 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1204 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1205 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1206 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1207 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1119 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1208 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1209 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1210 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 28, .child_index = 1212 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1213 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1214 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1215 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1216 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 352 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1217 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1218 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1219 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1220 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1221 },
    .{ .char = '9', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1222 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1223 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1086 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1224 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 1226 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1231 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 954 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1232 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1233 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1234 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1235 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1236 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 932 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 491 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1237 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1109 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1239 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1240 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1241 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1242 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1243 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1244 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1245 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1246 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1247 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1248 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1249 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 404 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1250 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1251 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1252 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1253 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1254 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1255 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1256 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1257 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1258 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1259 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1260 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1261 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1262 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1263 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1264 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1265 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1266 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1267 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1268 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 513 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 849 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 28, .child_index = 1269 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1271 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1272 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1273 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1274 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1276 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1277 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1278 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1279 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1280 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1281 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1282 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1283 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1284 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1023 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1024 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1025 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1024 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1285 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1286 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1287 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1288 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1293 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1297 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1298 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1299 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1303 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1307 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1309 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1310 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1311 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1312 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1187 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1313 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 695 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1314 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1315 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1316 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1317 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1318 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1319 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1320 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1321 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1322 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1323 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1324 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1325 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1326 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1327 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1328 },
    .{ .char = '3', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1330 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 1331 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 1332 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 15, .child_index = 1334 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1337 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1338 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 735 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1339 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1340 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1341 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1342 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1343 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1344 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1345 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1346 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1346 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1347 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1349 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1350 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1351 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 491 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1353 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1354 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1356 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 1358 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1360 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1362 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1237 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1365 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 842 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1366 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1367 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1242 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1368 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1369 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1367 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1242 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1242 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1370 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1371 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1372 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1309 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1373 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 1374 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 667 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1375 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1376 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1377 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1378 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1379 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1380 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1381 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1382 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1383 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1384 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1385 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1386 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1387 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1388 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 1389 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1390 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1391 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1392 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1393 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1394 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1397 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1398 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 1399 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1400 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1401 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1402 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1404 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1406 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1407 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1408 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1409 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1410 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1239 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1411 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1412 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1413 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1414 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1237 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1415 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1297 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 737 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1416 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1415 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 600 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1416 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1417 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1418 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1242 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1419 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1419 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1419 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1420 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1421 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1422 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1427 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1428 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1430 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1431 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1434 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1437 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1439 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1441 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1442 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1443 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1444 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1446 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1261 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1447 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1448 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1449 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1450 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1451 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1452 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 1453 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1455 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1457 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1458 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1459 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1461 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1461 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 9, .child_index = 1462 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1464 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1465 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 600 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1466 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1467 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1468 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1469 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1009 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1009 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1470 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1471 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1472 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1473 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1474 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1475 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 932 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1477 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1478 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1242 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1479 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1480 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1481 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 682 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 842 },
    .{ .char = '8', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = '9', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1483 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1484 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 906 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1485 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1486 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1487 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1488 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1489 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1353 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1490 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1491 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1368 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1367 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1368 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1492 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1493 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1494 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1495 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1496 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1497 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1498 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1499 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 1500 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1502 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1503 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1504 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1505 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1506 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1457 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1509 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1510 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1510 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1509 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1509 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1509 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1511 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1512 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1513 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1514 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1515 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1516 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1517 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1518 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1519 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1522 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1523 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1525 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1526 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1527 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1528 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1530 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1531 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1532 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1533 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 567 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 670 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1534 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1535 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1536 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1537 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1415 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1537 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 758 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1538 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1539 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1540 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1541 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1542 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1543 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1544 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1545 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1546 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 1547 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1548 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1550 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1551 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1552 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1554 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1556 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1557 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1489 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1558 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1560 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1562 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1563 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1564 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1565 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1566 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1567 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1568 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1519 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 600 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 714 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 714 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1569 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 569 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1408 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1570 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1571 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1572 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 595 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1016 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1574 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1575 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1576 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1577 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1578 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1579 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 758 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1402 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1419 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1580 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1581 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 1582 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1584 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1585 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1499 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1586 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1587 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1589 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1590 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 1591 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1593 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1594 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1595 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1556 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1537 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1596 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1596 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 600 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 737 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 844 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1597 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1598 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1600 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1601 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1602 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1603 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1604 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1605 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1606 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1608 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1609 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 595 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 624 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1531 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1610 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1611 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1612 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1613 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1614 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1615 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 1616 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1617 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1619 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1620 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1621 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1589 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1622 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1623 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1622 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 1623 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1623 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1624 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 855 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 855 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1625 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 488 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1627 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1628 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1509 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1629 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1630 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1631 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1632 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1187 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 1519 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1519 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1634 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1635 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1636 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1637 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1638 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1639 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1581 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1640 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1641 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1640 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1643 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1644 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1646 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 1647 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1649 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1651 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1652 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1653 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1654 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1655 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1655 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1656 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1657 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1658 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1658 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1658 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1659 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 1660 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1661 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1662 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1663 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1640 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1664 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1664 },
    .{ .char = '4', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 510 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1665 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1666 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1668 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1669 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1666 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1670 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1509 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1672 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1673 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1674 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 1675 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1662 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1677 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1659 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 1678 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1680 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1681 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1682 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1683 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1683 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 1684 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1685 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1686 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1687 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1218 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1688 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1689 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 1690 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1691 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1692 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1693 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 1693 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1624 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1694 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1694 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1695 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1696 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1697 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1698 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 1698 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1699 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1699 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1700 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1701 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1702 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1703 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1704 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1705 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1706 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1707 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1708 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1709 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 842 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1710 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1705 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 1298 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
};
pub const data = blk: {
    @setEvalBranchQuota(4374);
    break :blk [_]Properties{
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UsUiUiUi", .attributes = .{ .@"const" = true }, .features = "ashr_pk_insts" },
        .{ .param_str = "UsUiUiUi", .attributes = .{ .@"const" = true }, .features = "ashr_pk_insts" },
        .{ .param_str = "UZiUZiD*UZiUicC*" },
        .{ .param_str = "UWiUWiD*UWiUicC*" },
        .{ .param_str = "UZiUZiD*UZiUicC*" },
        .{ .param_str = "UWiUWiD*UWiUicC*" },
        .{ .param_str = "ZUib", .attributes = .{ .@"const" = true }, .features = "wavefrontsize32" },
        .{ .param_str = "WUib", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ssssIUi", .attributes = .{ .@"const" = true }, .features = "bitop3_insts" },
        .{ .param_str = "iiiiIUi", .attributes = .{ .@"const" = true }, .features = "bitop3_insts" },
        .{ .param_str = "v" },
        .{ .param_str = "v", .features = "ci_insts" },
        .{ .param_str = "bdi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bfi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bhi", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hiIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "hiIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "fiIi", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "fiIi", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "fiIi", .attributes = .{ .@"const" = true }, .features = "fp8e5m3_insts" },
        .{ .param_str = "fi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iffiIb", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "V2hs", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "V2hs", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "V2fiIb", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "V2fiIb", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "iffiIb", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "E2sii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "E2UsUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UifUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "E2sff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "E2Usff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "E2hff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V6UiV16fV16ff", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V6UiV16fV16ff", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V2hV2hifIiIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2hV2hifIiIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "fifIi", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "fifIi", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V32yV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V32yV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32yf", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32hf", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V32hV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V32hV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V32fV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V32fV6Uif", .attributes = .{ .@"const" = true }, .features = "fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32yf", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32hf", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V2yUifIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2yUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "V2yUifIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V2sV2sV2yfIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2sV2sV2hfIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2sV2sfffIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2hUifIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2hUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "V2hUifIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V2fUifIb", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "V2fUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "V2fUifIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "UiUiV2yfIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "UiUiV2hfIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "UiUifffIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "V2sV2sV2yfIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V2sV2sV2hfIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V2sV2sfffIb", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "iiyUifIi", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "iihUifIi", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "iifUifIi", .attributes = .{ .@"const" = true }, .features = "bf8_cvt_scale_insts" },
        .{ .param_str = "iiyUifIi", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "iihUifIi", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "iifUifIi", .attributes = .{ .@"const" = true }, .features = "fp8_cvt_scale_insts" },
        .{ .param_str = "V6UiV32yUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32hUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32fUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32yUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32hUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "V6UiV32fUif", .attributes = .{ .@"const" = true }, .features = "f16bf16_to_fp6bf6_cvt_scale_insts" },
        .{ .param_str = "UiUiV2yUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "UiUiV2hUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "UiUiV2fUifIi", .attributes = .{ .@"const" = true }, .features = "fp4_cvt_scale_insts" },
        .{ .param_str = "V2yV2yfUiIb", .attributes = .{ .@"const" = true }, .features = "f32_to_f16bf16_cvt_sr_insts" },
        .{ .param_str = "ifiiIi", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "V2hV2hfUiIb", .attributes = .{ .@"const" = true }, .features = "f32_to_f16bf16_cvt_sr_insts" },
        .{ .param_str = "ifiiIi", .attributes = .{ .@"const" = true }, .features = "fp8_conversion_insts" },
        .{ .param_str = "v*4", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dddd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hhhh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "ddddb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffffb", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dddbb*" },
        .{ .param_str = "fffbb*" },
        .{ .param_str = "fUiUif", .attributes = .{ .@"const" = true }, .features = "dot11_insts" },
        .{ .param_str = "fUiUif", .attributes = .{ .@"const" = true }, .features = "dot11_insts" },
        .{ .param_str = "fUiUif", .attributes = .{ .@"const" = true }, .features = "dot11_insts" },
        .{ .param_str = "fUiUif", .attributes = .{ .@"const" = true }, .features = "dot11_insts" },
        .{ .param_str = "ii*3" },
        .{ .param_str = "vLi*3", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "LiLi*3Li", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "ff*3f", .attributes = .{ .custom_typecheck = true }, .features = "gfx8_insts" },
        .{ .param_str = "dd*3d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "V2sV2s*3V2s", .attributes = .{ .custom_typecheck = true }, .features = "atomic_ds_pk_add_16_insts" },
        .{ .param_str = "V2hV2h*3V2h", .attributes = .{ .custom_typecheck = true }, .features = "atomic_ds_pk_add_16_insts" },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "V2UiUiUiV4UiIi", .features = "gfx11_insts" },
        .{ .param_str = "V2UiUiUiV8UiIi", .features = "gfx12_insts" },
        .{ .param_str = "V2WUiUiUiV8UiIi", .features = "gfx12_insts" },
        .{ .param_str = "V2UiUiUiV4UiIi", .features = "gfx11_insts" },
        .{ .param_str = "ii*3" },
        .{ .param_str = "ff*3fIiIiIb" },
        .{ .param_str = "ff*3fIiIiIb" },
        .{ .param_str = "ff*3fIiIiIb" },
        .{ .param_str = "vUiUi", .features = "gws" },
        .{ .param_str = "vUiUi", .features = "gws" },
        .{ .param_str = "vUiUi", .features = "gws" },
        .{ .param_str = "vUi", .features = "gws" },
        .{ .param_str = "vUi", .features = "ci_insts" },
        .{ .param_str = "vUi", .features = "gws" },
        .{ .param_str = "V8yV8y*3", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V8hV8h*3", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V8sV8s*3", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V2iV2i*3", .attributes = .{ .@"const" = true }, .features = "transpose_load_f4f6_insts,wavefrontsize32" },
        .{ .param_str = "V3iV3i*3", .attributes = .{ .@"const" = true }, .features = "transpose_load_f4f6_insts,wavefrontsize32" },
        .{ .param_str = "V2iV2i*3", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4yV4y*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4hV4h*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4sV4s*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V2iV2i*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V3iV3i*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V2iV2i*3", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "iiIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v", .attributes = .{ .@"noreturn" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiddIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiffIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "fV2hV2hfIb", .attributes = .{ .@"const" = true }, .features = "dot10_insts" },
        .{ .param_str = "sV2sV2ss", .attributes = .{ .@"const" = true }, .features = "dot9_insts" },
        .{ .param_str = "hV2hV2hh", .attributes = .{ .@"const" = true }, .features = "dot9_insts" },
        .{ .param_str = "fV2sV2sfIb", .attributes = .{ .@"const" = true }, .features = "dot12_insts" },
        .{ .param_str = "fV2yV2yfIb", .attributes = .{ .@"const" = true }, .features = "dot13_insts" },
        .{ .param_str = "vUicC*." },
        .{ .param_str = "ff*0f", .attributes = .{ .custom_typecheck = true }, .features = "gfx940_insts" },
        .{ .param_str = "dd*0d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "V2sV2s*0V2s", .attributes = .{ .custom_typecheck = true }, .features = "atomic_flat_pk_add_16_insts" },
        .{ .param_str = "V2hV2h*0V2h", .attributes = .{ .custom_typecheck = true }, .features = "atomic_flat_pk_add_16_insts" },
        .{ .param_str = "dd*0d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "dd*0d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "ffff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hhhh", .attributes = .{ .@"const" = true }, .features = "gfx9_insts" },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "id", .attributes = .{ .@"const" = true } },
        .{ .param_str = "if", .attributes = .{ .@"const" = true } },
        .{ .param_str = "sh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "WUi" },
        .{ .param_str = "ff*1f", .attributes = .{ .custom_typecheck = true }, .features = "atomic_fadd_rtn_insts" },
        .{ .param_str = "dd*1d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "V2sV2s*1V2s", .attributes = .{ .custom_typecheck = true }, .features = "atomic_global_pk_add_bf16_inst" },
        .{ .param_str = "V2hV2h*1V2h", .attributes = .{ .custom_typecheck = true }, .features = "atomic_buffer_global_pk_add_f16_insts" },
        .{ .param_str = "dd*1d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "dd*1d", .attributes = .{ .custom_typecheck = true }, .features = "gfx90a_insts" },
        .{ .param_str = "vv*1v*3IUiIiIUi", .attributes = .{ .custom_typecheck = true }, .features = "vmem_to_lds_load_insts" },
        .{ .param_str = "V8yV8y*1", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V8hV8h*1", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V8sV8s*1", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V2iV2i*1", .attributes = .{ .@"const" = true }, .features = "transpose_load_f4f6_insts,wavefrontsize32" },
        .{ .param_str = "V3iV3i*1", .attributes = .{ .@"const" = true }, .features = "transpose_load_f4f6_insts,wavefrontsize32" },
        .{ .param_str = "V2iV2i*1", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts,wavefrontsize32" },
        .{ .param_str = "V4yV4y*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V4hV4h*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V4sV4s*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8yV8y*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V8hV8h*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V8sV8s*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "ii*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V2iV2i*1", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui" },
        .{ .param_str = "vIi" },
        .{ .param_str = "V10UiWUifUcV3fV3fUiV4UiV3f*V3f*", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "V10UiWUifUcV3fV3fV2UiV4UiV3f*V3f*", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "V4UiUifV4fV4fV4fV4Ui", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "V4UiUifV4fV4hV4hV4Ui", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "V4UiWUifV4fV4fV4fV4Ui", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "V4UiWUifV4fV4hV4hV4Ui", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "v*4", .attributes = .{ .@"const" = true } },
        .{ .param_str = "fUiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffUiUibUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "fffUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hffUiUibUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*0", .attributes = .{ .@"const" = true } },
        .{ .param_str = "bvC*0", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v*4", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ddi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hhi", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vv*v*3IUiIiIUi", .features = "vmem_to_lds_load_insts" },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Qbv*sii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4fV4sV4sV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV4hV4hV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fffV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV2sV2sV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV8yV8yV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fWiWiV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fWiWiV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fV8hV8hV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fWiWiV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fWiWiV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV4sV4sV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV4hV4hV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fffV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV2fV2fV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV2sV2sV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV8yV8yV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fWiWiV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fWiWiV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV8hV8hV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fWiWiV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fWiWiV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V32fffV32fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V32fV2sV2sV32fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fffV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV2fV2fV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV2sV2sV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V32fV4sV4sV32fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V32fV4hV4hV32fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV4sV4sV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV4hV4hV16fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fffV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV2sV2sV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV4sV4sV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV4hV4hV4fIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4dddV4dIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "ddddIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4iiiV4iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4iWiWiV4iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16iiiV16iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4iV4iV4iV4iIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16iWiWiV16iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16iV4iV4iV16iIiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V32iiiV32iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16iiiV16iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4iiiV4iIiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV8ZiV8ZiV4fIiIiIiiIii", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV8ZiV8ZiV16fIiIiIiiIii", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "iiIiIiIiIb", .attributes = .{ .@"const" = true, .custom_typecheck = true }, .features = "dpp" },
        .{ .param_str = "UiUiIUi", .attributes = .{ .@"const" = true, .custom_typecheck = true }, .features = "gfx10_insts" },
        .{ .param_str = "WUiWUiUiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4UiWUiUiV4Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true }, .features = "gfx8_insts" },
        .{ .param_str = "UiUiUiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "V2UiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "permlane16_swap" },
        .{ .param_str = "UiUiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "V2UiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "permlane32_swap" },
        .{ .param_str = "UiUi", .attributes = .{ .@"const" = true }, .features = "gfx11_insts" },
        .{ .param_str = "UiUiUiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "gfx10_insts" },
        .{ .param_str = "UiUiUiUiIbIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "UiUi", .attributes = .{ .@"const" = true }, .features = "prng_inst" },
        .{ .param_str = "WUiWUiUiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v*4", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4UiQbiiIi" },
        .{ .param_str = "UsQbiiIi" },
        .{ .param_str = "UiQbiiIi" },
        .{ .param_str = "V2UiQbiiIi" },
        .{ .param_str = "UcQbiiIi" },
        .{ .param_str = "V3UiQbiiIi" },
        .{ .param_str = "vV4UiQbiiIi" },
        .{ .param_str = "vUsQbiiIi" },
        .{ .param_str = "vUiQbiiIi" },
        .{ .param_str = "vV2UiQbiiIi" },
        .{ .param_str = "vUcQbiiIi" },
        .{ .param_str = "vV3UiQbiiIi" },
        .{ .param_str = "vQbv*3IUiiiIiIi", .attributes = .{ .custom_typecheck = true }, .features = "vmem_to_lds_load_insts" },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "WUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "v" },
        .{ .param_str = "vIi", .features = "gfx12_insts" },
        .{ .param_str = "bIi", .features = "gfx12_insts" },
        .{ .param_str = "vv*i", .features = "gfx12_insts" },
        .{ .param_str = "vIs", .features = "gfx12_insts" },
        .{ .param_str = "vQbIiUi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "v" },
        .{ .param_str = "v", .features = "ci_insts" },
        .{ .param_str = "v", .features = "gfx8_insts" },
        .{ .param_str = "vIi" },
        .{ .param_str = "Uii", .features = "gfx12_insts" },
        .{ .param_str = "Uiv*", .features = "gfx12_insts" },
        .{ .param_str = "WUi" },
        .{ .param_str = "UiIi" },
        .{ .param_str = "vIi" },
        .{ .param_str = "WUi", .features = "s_memrealtime" },
        .{ .param_str = "WUi", .features = "s_memtime_inst" },
        .{ .param_str = "vIs", .features = "gfx1250_insts" },
        .{ .param_str = "vvC*Ui", .attributes = .{ .@"const" = true }, .features = "gfx12_insts" },
        .{ .param_str = "vIiUi" },
        .{ .param_str = "UiUIi", .features = "gfx11_insts" },
        .{ .param_str = "UWiUIi", .features = "gfx11_insts" },
        .{ .param_str = "vIiUi" },
        .{ .param_str = "vIs" },
        .{ .param_str = "vIs", .features = "setprio_inc_wg_inst" },
        .{ .param_str = "vIiUi" },
        .{ .param_str = "vIi" },
        .{ .param_str = "vUi", .features = "gfx12_insts" },
        .{ .param_str = "vi" },
        .{ .param_str = "vIs", .features = "gfx10_insts" },
        .{ .param_str = "vIUs", .features = "gfx1250_insts" },
        .{ .param_str = "v", .features = "gfx11_insts" },
        .{ .param_str = "vIUs", .features = "gfx1250_insts" },
        .{ .param_str = "vIi" },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vIi" },
        .{ .param_str = "vIiIiIi" },
        .{ .param_str = "SiV2SsV2SsSiIb", .attributes = .{ .@"const" = true }, .features = "dot2_insts" },
        .{ .param_str = "SiSiSiSiIb", .attributes = .{ .@"const" = true }, .features = "dot1_insts" },
        .{ .param_str = "SiSiSiSiIb", .attributes = .{ .@"const" = true }, .features = "dot1_insts" },
        .{ .param_str = "vWUi" },
        .{ .param_str = "WUiiiIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiWiWiIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "V4fV4iV8iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV4iV8iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV4iV8iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV4iV8iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV4sV8sV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV4hV8hV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V4fV8yV16yV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV2iV4iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fV2iV4iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fV8hV16hV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4fV2iV4iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V4fV2iV4iV4fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV4sV8sV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV4hV8hV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16fV8yV16yV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV2iV4iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV2iV4iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV8hV16hV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV2iV4iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV2iV4iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "fp8_insts" },
        .{ .param_str = "V16fV4iV8iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV4iV8iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV4iV8iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V16fV4iV8iV16fiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4iV4iV8iV4iiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "V4iV2iV4iV4iiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16iV2iV4iV16iiIiIi", .attributes = .{ .@"const" = true }, .features = "mai_insts" },
        .{ .param_str = "V16iV4iV8iV16iiIiIi", .attributes = .{ .@"const" = true }, .features = "gfx950_insts" },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
        .{ .param_str = "hh", .attributes = .{ .@"const" = true }, .features = "16_bit_insts" },
        .{ .param_str = "iIbiIbiiIb", .attributes = .{ .@"const" = true }, .features = "dot8_insts" },
        .{ .param_str = "iIbiIbiiIb", .attributes = .{ .@"const" = true }, .features = "dot8_insts" },
        .{ .param_str = "V8sV8sV16sV8si", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4sV4sV8sV4si", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8hV8hV16hV8hi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4hV4hV8hV4hi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV8sV16sV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fV4sV8sV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV4iV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiV2iV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV4iV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiV2iV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV8hV16hV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fV4hV8hV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV4iV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiV2iV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV4iV8fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiV2iV4fi", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbiIbV2iV8iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbiIbiV4iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbV2iIbV4iV8iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbiIbV2iV4iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbV2iIbV4iV8iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbiIbV2iV4iiIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "yy", .attributes = .{ .@"const" = true }, .features = "bf16_trans_insts" },
        .{ .param_str = "vV4iV8iV4iV4iIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "vV4iV8iIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "vV4iV8iV4iV4iIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "vV4iV8iIi", .attributes = .{ .@"const" = true }, .features = "gfx1250_insts" },
        .{ .param_str = "ddi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiV2UsV2UsUiIb", .attributes = .{ .@"const" = true }, .features = "dot2_insts" },
        .{ .param_str = "UiUiUiUiIb", .attributes = .{ .@"const" = true }, .features = "dot7_insts" },
        .{ .param_str = "UiUiUiUiIb", .attributes = .{ .@"const" = true }, .features = "dot7_insts" },
        .{ .param_str = "WUiUiUiIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiWUiWUiIi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiiIiIiIiIb", .attributes = .{ .@"const" = true, .custom_typecheck = true }, .features = "dpp" },
        .{ .param_str = "v" },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V16sV16sV16sV16sIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8sV16sV16sV8sIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V16sV16sV16sV16sIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8sV8sV8sV8s", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V8sV16sV16sV8sIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4sV4sV4sV4s", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V16hV16hV16hV16hIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8hV16hV16hV8hIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V16hV16hV16hV16hIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8hV8hV8hV8h", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V8hV16hV16hV8hIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4hV4hV4hV4h", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV16sV16sV8f", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8fV8sV8sV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fV16sV16sV4f", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4fV4sV4sV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV2iV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiiV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV2iV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiiV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV16hV16hV8f", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8fV8hV8hV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fV16hV16hV4f", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4fV4hV4hV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV2iV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiiV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8fV2iV2iV8f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4fiiV4f", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbV2iIbV2iV8iIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8iIbiIbiV8iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbV2iIbV2iV4iIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4iIbiIbiV4iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbV4iIbV4iV8iIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize32" },
        .{ .param_str = "V8iIbV2iIbV2iV8iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbV4iIbV4iV4iIb", .attributes = .{ .@"const" = true }, .features = "gfx11_insts,wavefrontsize64" },
        .{ .param_str = "V4iIbiIbiV4iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "V8iIbV2iIbV2iV8iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize32" },
        .{ .param_str = "V4iIbiIbiV4iIb", .attributes = .{ .@"const" = true }, .features = "gfx12_insts,wavefrontsize64" },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Us", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Us", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Us", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Uc*7", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dd", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ff", .attributes = .{ .@"const" = true } },
    };
};
};
}
