//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"16bit_mode",
    @"32bit_mode",
    @"3dnow",
    @"3dnowa",
    @"64bit",
    adx,
    aes,
    allow_light_256_bit,
    amx_avx512,
    amx_bf16,
    amx_complex,
    amx_fp16,
    amx_fp8,
    amx_int8,
    amx_movrs,
    amx_tf32,
    amx_tile,
    amx_transpose,
    avx,
    avx10_1,
    avx10_2,
    avx2,
    avx512bf16,
    avx512bitalg,
    avx512bw,
    avx512cd,
    avx512dq,
    avx512er,
    avx512f,
    avx512fp16,
    avx512ifma,
    avx512pf,
    avx512vbmi,
    avx512vbmi2,
    avx512vl,
    avx512vnni,
    avx512vp2intersect,
    avx512vpopcntdq,
    avxifma,
    avxneconvert,
    avxvnni,
    avxvnniint16,
    avxvnniint8,
    bmi,
    bmi2,
    branch_hint,
    branchfusion,
    bsf_bsr_0_clobbers_result,
    ccmp,
    cf,
    cldemote,
    clflushopt,
    clwb,
    clzero,
    cmov,
    cmpccxadd,
    crc32,
    cx16,
    cx8,
    egpr,
    enqcmd,
    ermsb,
    evex512,
    f16c,
    false_deps_getmant,
    false_deps_lzcnt_tzcnt,
    false_deps_mulc,
    false_deps_mullq,
    false_deps_perm,
    false_deps_popcnt,
    false_deps_range,
    fast_11bytenop,
    fast_15bytenop,
    fast_7bytenop,
    fast_bextr,
    fast_dpwssd,
    fast_gather,
    fast_hops,
    fast_imm16,
    fast_lzcnt,
    fast_movbe,
    fast_scalar_fsqrt,
    fast_scalar_shift_masks,
    fast_shld_rotate,
    fast_variable_crosslane_shuffle,
    fast_variable_perlane_shuffle,
    fast_vector_fsqrt,
    fast_vector_shift_masks,
    faster_shift_than_shuffle,
    fma,
    fma4,
    fsgsbase,
    fsrm,
    fxsr,
    gfni,
    harden_sls_ijmp,
    harden_sls_ret,
    hreset,
    idivl_to_divb,
    idivq_to_divl,
    inline_asm_use_gpr32,
    invpcid,
    kl,
    lea_sp,
    lea_uses_ag,
    lvi_cfi,
    lvi_load_hardening,
    lwp,
    lzcnt,
    macrofusion,
    mmx,
    movbe,
    movdir64b,
    movdiri,
    movrs,
    mwaitx,
    ndd,
    nf,
    no_bypass_delay,
    no_bypass_delay_blend,
    no_bypass_delay_mov,
    no_bypass_delay_shuffle,
    nopl,
    pad_short_functions,
    pclmul,
    pconfig,
    pku,
    popcnt,
    ppx,
    prefer_128_bit,
    prefer_256_bit,
    prefer_mask_registers,
    prefer_movmsk_over_vtest,
    prefer_no_gather,
    prefer_no_scatter,
    prefetchi,
    prefetchwt1,
    prfchw,
    ptwrite,
    push2pop2,
    raoint,
    rdpid,
    rdpru,
    rdrnd,
    rdseed,
    retpoline,
    retpoline_external_thunk,
    retpoline_indirect_branches,
    retpoline_indirect_calls,
    rtm,
    sahf,
    sbb_dep_breaking,
    serialize,
    seses,
    sgx,
    sha,
    sha512,
    shstk,
    slow_3ops_lea,
    slow_incdec,
    slow_lea,
    slow_pmaddwd,
    slow_pmulld,
    slow_shld,
    slow_two_mem_ops,
    slow_unaligned_mem_16,
    slow_unaligned_mem_32,
    sm3,
    sm4,
    smap,
    smep,
    soft_float,
    sse,
    sse2,
    sse3,
    sse4_1,
    sse4_2,
    sse4a,
    sse_unaligned_mem,
    ssse3,
    tagged_globals,
    tbm,
    tsxldtrk,
    tuning_fast_imm_vector_shift,
    uintr,
    use_glm_div_sqrt_costs,
    use_slm_arith_costs,
    usermsr,
    vaes,
    vpclmulqdq,
    vzeroupper,
    waitpkg,
    wbnoinvd,
    widekl,
    x87,
    xop,
    xsave,
    xsavec,
    xsaveopt,
    xsaves,
    zu,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.@"16bit_mode")] = .{
        .llvm_name = "16bit-mode",
        .description = "16-bit mode (i8086)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"32bit_mode")] = .{
        .llvm_name = "32bit-mode",
        .description = "32-bit mode (80386)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.@"3dnow")] = .{
        .llvm_name = null,
        .description = "Enable 3DNow! instructions",
        .dependencies = featureSet(&[_]Feature{
            .mmx,
        }),
    };
    result[@intFromEnum(Feature.@"3dnowa")] = .{
        .llvm_name = null,
        .description = "Enable 3DNow! Athlon instructions",
        .dependencies = featureSet(&[_]Feature{
            .@"3dnow",
        }),
    };
    result[@intFromEnum(Feature.@"64bit")] = .{
        .llvm_name = "64bit",
        .description = "Support 64-bit instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.adx)] = .{
        .llvm_name = "adx",
        .description = "Support ADX instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.aes)] = .{
        .llvm_name = "aes",
        .description = "Enable AES instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.allow_light_256_bit)] = .{
        .llvm_name = "allow-light-256-bit",
        .description = "Enable generation of 256-bit load/stores even if we prefer 128-bit",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.amx_avx512)] = .{
        .llvm_name = "amx-avx512",
        .description = "Support AMX-AVX512 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_bf16)] = .{
        .llvm_name = "amx-bf16",
        .description = "Support AMX-BF16 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_complex)] = .{
        .llvm_name = "amx-complex",
        .description = "Support AMX-COMPLEX instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_fp16)] = .{
        .llvm_name = "amx-fp16",
        .description = "Support AMX amx-fp16 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_fp8)] = .{
        .llvm_name = "amx-fp8",
        .description = "Support AMX-FP8 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_int8)] = .{
        .llvm_name = "amx-int8",
        .description = "Support AMX-INT8 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_movrs)] = .{
        .llvm_name = "amx-movrs",
        .description = "Support AMX-MOVRS instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_tf32)] = .{
        .llvm_name = "amx-tf32",
        .description = "Support AMX-TF32 instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.amx_tile)] = .{
        .llvm_name = "amx-tile",
        .description = "Support AMX-TILE instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.amx_transpose)] = .{
        .llvm_name = "amx-transpose",
        .description = "Support AMX amx-transpose instructions",
        .dependencies = featureSet(&[_]Feature{
            .amx_tile,
        }),
    };
    result[@intFromEnum(Feature.avx)] = .{
        .llvm_name = "avx",
        .description = "Enable AVX instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse4_2,
        }),
    };
    result[@intFromEnum(Feature.avx10_1)] = .{
        .llvm_name = "avx10.1-512",
        .description = "Support AVX10.1 up to 512-bit instruction",
        .dependencies = featureSet(&[_]Feature{
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512fp16,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
        }),
    };
    result[@intFromEnum(Feature.avx10_2)] = .{
        .llvm_name = "avx10.2-512",
        .description = "Support AVX10.2 up to 512-bit instruction",
        .dependencies = featureSet(&[_]Feature{
            .avx10_1,
        }),
    };
    result[@intFromEnum(Feature.avx2)] = .{
        .llvm_name = "avx2",
        .description = "Enable AVX2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx,
        }),
    };
    result[@intFromEnum(Feature.avx512bf16)] = .{
        .llvm_name = "avx512bf16",
        .description = "Support bfloat16 floating point",
        .dependencies = featureSet(&[_]Feature{
            .avx512bw,
        }),
    };
    result[@intFromEnum(Feature.avx512bitalg)] = .{
        .llvm_name = "avx512bitalg",
        .description = "Enable AVX-512 Bit Algorithms",
        .dependencies = featureSet(&[_]Feature{
            .avx512bw,
        }),
    };
    result[@intFromEnum(Feature.avx512bw)] = .{
        .llvm_name = "avx512bw",
        .description = "Enable AVX-512 Byte and Word Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512cd)] = .{
        .llvm_name = "avx512cd",
        .description = "Enable AVX-512 Conflict Detection Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512dq)] = .{
        .llvm_name = "avx512dq",
        .description = "Enable AVX-512 Doubleword and Quadword Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512er)] = .{
        .llvm_name = null,
        .description = "Enable AVX-512 Exponential and Reciprocal Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512f)] = .{
        .llvm_name = "avx512f",
        .description = "Enable AVX-512 instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
            .evex512,
            .f16c,
            .fma,
        }),
    };
    result[@intFromEnum(Feature.avx512fp16)] = .{
        .llvm_name = "avx512fp16",
        .description = "Support 16-bit floating point",
        .dependencies = featureSet(&[_]Feature{
            .avx512bw,
        }),
    };
    result[@intFromEnum(Feature.avx512ifma)] = .{
        .llvm_name = "avx512ifma",
        .description = "Enable AVX-512 Integer Fused Multiple-Add",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512pf)] = .{
        .llvm_name = null,
        .description = "Enable AVX-512 PreFetch Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512vbmi)] = .{
        .llvm_name = "avx512vbmi",
        .description = "Enable AVX-512 Vector Byte Manipulation Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512bw,
        }),
    };
    result[@intFromEnum(Feature.avx512vbmi2)] = .{
        .llvm_name = "avx512vbmi2",
        .description = "Enable AVX-512 further Vector Byte Manipulation Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512bw,
        }),
    };
    result[@intFromEnum(Feature.avx512vl)] = .{
        .llvm_name = "avx512vl",
        .description = "Enable AVX-512 Vector Length eXtensions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512vnni)] = .{
        .llvm_name = "avx512vnni",
        .description = "Enable AVX-512 Vector Neural Network Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512vp2intersect)] = .{
        .llvm_name = "avx512vp2intersect",
        .description = "Enable AVX-512 vp2intersect",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avx512vpopcntdq)] = .{
        .llvm_name = "avx512vpopcntdq",
        .description = "Enable AVX-512 Population Count Instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx512f,
        }),
    };
    result[@intFromEnum(Feature.avxifma)] = .{
        .llvm_name = "avxifma",
        .description = "Enable AVX-IFMA",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.avxneconvert)] = .{
        .llvm_name = "avxneconvert",
        .description = "Support AVX-NE-CONVERT instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.avxvnni)] = .{
        .llvm_name = "avxvnni",
        .description = "Support AVX_VNNI encoding",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.avxvnniint16)] = .{
        .llvm_name = "avxvnniint16",
        .description = "Enable AVX-VNNI-INT16",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.avxvnniint8)] = .{
        .llvm_name = "avxvnniint8",
        .description = "Enable AVX-VNNI-INT8",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.bmi)] = .{
        .llvm_name = "bmi",
        .description = "Support BMI instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.bmi2)] = .{
        .llvm_name = "bmi2",
        .description = "Support BMI2 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.branch_hint)] = .{
        .llvm_name = "branch-hint",
        .description = "Target has branch hint feature",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.branchfusion)] = .{
        .llvm_name = "branchfusion",
        .description = "CMP/TEST can be fused with conditional branches",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.bsf_bsr_0_clobbers_result)] = .{
        .llvm_name = null,
        .description = "BSF/BSR may clobber the lower 32-bits of the result register when the source is zero",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ccmp)] = .{
        .llvm_name = "ccmp",
        .description = "Support conditional cmp & test instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cf)] = .{
        .llvm_name = "cf",
        .description = "Support conditional faulting",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cldemote)] = .{
        .llvm_name = "cldemote",
        .description = "Enable Cache Line Demote",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.clflushopt)] = .{
        .llvm_name = "clflushopt",
        .description = "Flush A Cache Line Optimized",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.clwb)] = .{
        .llvm_name = "clwb",
        .description = "Cache Line Write Back",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.clzero)] = .{
        .llvm_name = "clzero",
        .description = "Enable Cache Line Zero",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cmov)] = .{
        .llvm_name = "cmov",
        .description = "Enable conditional move instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cmpccxadd)] = .{
        .llvm_name = "cmpccxadd",
        .description = "Support CMPCCXADD instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.crc32)] = .{
        .llvm_name = "crc32",
        .description = "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.cx16)] = .{
        .llvm_name = "cx16",
        .description = "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)",
        .dependencies = featureSet(&[_]Feature{
            .cx8,
        }),
    };
    result[@intFromEnum(Feature.cx8)] = .{
        .llvm_name = "cx8",
        .description = "Support CMPXCHG8B instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.egpr)] = .{
        .llvm_name = "egpr",
        .description = "Support extended general purpose register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.enqcmd)] = .{
        .llvm_name = "enqcmd",
        .description = "Has ENQCMD instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ermsb)] = .{
        .llvm_name = "ermsb",
        .description = "REP MOVS/STOS are fast",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.evex512)] = .{
        .llvm_name = "evex512",
        .description = "Support ZMM and 64-bit mask instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.f16c)] = .{
        .llvm_name = "f16c",
        .description = "Support 16-bit floating point conversion instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx,
        }),
    };
    result[@intFromEnum(Feature.false_deps_getmant)] = .{
        .llvm_name = "false-deps-getmant",
        .description = "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_lzcnt_tzcnt)] = .{
        .llvm_name = "false-deps-lzcnt-tzcnt",
        .description = "LZCNT/TZCNT have a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_mulc)] = .{
        .llvm_name = "false-deps-mulc",
        .description = "VF[C]MULCPH/SH has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_mullq)] = .{
        .llvm_name = "false-deps-mullq",
        .description = "VPMULLQ has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_perm)] = .{
        .llvm_name = "false-deps-perm",
        .description = "VPERMD/Q/PS/PD has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_popcnt)] = .{
        .llvm_name = "false-deps-popcnt",
        .description = "POPCNT has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.false_deps_range)] = .{
        .llvm_name = "false-deps-range",
        .description = "VRANGEPD/PS/SD/SS has a false dependency on dest register",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_11bytenop)] = .{
        .llvm_name = "fast-11bytenop",
        .description = "Target can quickly decode up to 11 byte NOPs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_15bytenop)] = .{
        .llvm_name = "fast-15bytenop",
        .description = "Target can quickly decode up to 15 byte NOPs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_7bytenop)] = .{
        .llvm_name = "fast-7bytenop",
        .description = "Target can quickly decode up to 7 byte NOPs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_bextr)] = .{
        .llvm_name = "fast-bextr",
        .description = "Indicates that the BEXTR instruction is implemented as a single uop with good throughput",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_dpwssd)] = .{
        .llvm_name = "fast-dpwssd",
        .description = "Prefer vpdpwssd instruction over vpmaddwd+vpaddd instruction sequence",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_gather)] = .{
        .llvm_name = "fast-gather",
        .description = "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_hops)] = .{
        .llvm_name = "fast-hops",
        .description = "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_imm16)] = .{
        .llvm_name = "fast-imm16",
        .description = "Prefer a i16 instruction with i16 immediate over extension to i32",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_lzcnt)] = .{
        .llvm_name = "fast-lzcnt",
        .description = "LZCNT instructions are as fast as most simple integer ops",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_movbe)] = .{
        .llvm_name = "fast-movbe",
        .description = "Prefer a movbe over a single-use load + bswap / single-use bswap + store",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_scalar_fsqrt)] = .{
        .llvm_name = "fast-scalar-fsqrt",
        .description = "Scalar SQRT is fast (disable Newton-Raphson)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_scalar_shift_masks)] = .{
        .llvm_name = "fast-scalar-shift-masks",
        .description = "Prefer a left/right scalar logical shift pair over a shift+and pair",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_shld_rotate)] = .{
        .llvm_name = "fast-shld-rotate",
        .description = "SHLD can be used as a faster rotate",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_variable_crosslane_shuffle)] = .{
        .llvm_name = "fast-variable-crosslane-shuffle",
        .description = "Cross-lane shuffles with variable masks are fast",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_variable_perlane_shuffle)] = .{
        .llvm_name = "fast-variable-perlane-shuffle",
        .description = "Per-lane shuffles with variable masks are fast",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_vector_fsqrt)] = .{
        .llvm_name = "fast-vector-fsqrt",
        .description = "Vector SQRT is fast (disable Newton-Raphson)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fast_vector_shift_masks)] = .{
        .llvm_name = "fast-vector-shift-masks",
        .description = "Prefer a left/right vector logical shift pair over a shift+and pair",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.faster_shift_than_shuffle)] = .{
        .llvm_name = "faster-shift-than-shuffle",
        .description = "Shifts are faster (or as fast) as shuffle",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fma)] = .{
        .llvm_name = "fma",
        .description = "Enable three-operand fused multiple-add",
        .dependencies = featureSet(&[_]Feature{
            .avx,
        }),
    };
    result[@intFromEnum(Feature.fma4)] = .{
        .llvm_name = "fma4",
        .description = "Enable four-operand fused multiple-add",
        .dependencies = featureSet(&[_]Feature{
            .avx,
            .sse4a,
        }),
    };
    result[@intFromEnum(Feature.fsgsbase)] = .{
        .llvm_name = "fsgsbase",
        .description = "Support FS/GS Base instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fsrm)] = .{
        .llvm_name = "fsrm",
        .description = "REP MOVSB of short lengths is faster",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fxsr)] = .{
        .llvm_name = "fxsr",
        .description = "Support fxsave/fxrestore instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.gfni)] = .{
        .llvm_name = "gfni",
        .description = "Enable Galois Field Arithmetic Instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.harden_sls_ijmp)] = .{
        .llvm_name = "harden-sls-ijmp",
        .description = "Harden against straight line speculation across indirect JMP instructions.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.harden_sls_ret)] = .{
        .llvm_name = "harden-sls-ret",
        .description = "Harden against straight line speculation across RET instructions.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.hreset)] = .{
        .llvm_name = "hreset",
        .description = "Has hreset instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.idivl_to_divb)] = .{
        .llvm_name = "idivl-to-divb",
        .description = "Use 8-bit divide for positive values less than 256",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.idivq_to_divl)] = .{
        .llvm_name = "idivq-to-divl",
        .description = "Use 32-bit divide for positive values less than 2^32",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.inline_asm_use_gpr32)] = .{
        .llvm_name = "inline-asm-use-gpr32",
        .description = "Enable use of GPR32 in inline assembly for APX",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.invpcid)] = .{
        .llvm_name = "invpcid",
        .description = "Invalidate Process-Context Identifier",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.kl)] = .{
        .llvm_name = "kl",
        .description = "Support Key Locker kl Instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.lea_sp)] = .{
        .llvm_name = "lea-sp",
        .description = "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lea_uses_ag)] = .{
        .llvm_name = "lea-uses-ag",
        .description = "LEA instruction needs inputs at AG stage",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lvi_cfi)] = .{
        .llvm_name = "lvi-cfi",
        .description = "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lvi_load_hardening)] = .{
        .llvm_name = "lvi-load-hardening",
        .description = "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lwp)] = .{
        .llvm_name = "lwp",
        .description = "Enable LWP instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.lzcnt)] = .{
        .llvm_name = "lzcnt",
        .description = "Support LZCNT instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.macrofusion)] = .{
        .llvm_name = "macrofusion",
        .description = "Various instructions can be fused with conditional branches",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.mmx)] = .{
        .llvm_name = "mmx",
        .description = "Enable MMX instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.movbe)] = .{
        .llvm_name = "movbe",
        .description = "Support MOVBE instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.movdir64b)] = .{
        .llvm_name = "movdir64b",
        .description = "Support movdir64b instruction (direct store 64 bytes)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.movdiri)] = .{
        .llvm_name = "movdiri",
        .description = "Support movdiri instruction (direct store integer)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.movrs)] = .{
        .llvm_name = "movrs",
        .description = "Enable MOVRS",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.mwaitx)] = .{
        .llvm_name = "mwaitx",
        .description = "Enable MONITORX/MWAITX timer functionality",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ndd)] = .{
        .llvm_name = "ndd",
        .description = "Support non-destructive destination",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.nf)] = .{
        .llvm_name = "nf",
        .description = "Support status flags update suppression",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_bypass_delay)] = .{
        .llvm_name = "no-bypass-delay",
        .description = "Has no bypass delay when using the 'wrong' domain",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_bypass_delay_blend)] = .{
        .llvm_name = "no-bypass-delay-blend",
        .description = "Has no bypass delay when using the 'wrong' blend type",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_bypass_delay_mov)] = .{
        .llvm_name = "no-bypass-delay-mov",
        .description = "Has no bypass delay when using the 'wrong' mov type",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.no_bypass_delay_shuffle)] = .{
        .llvm_name = "no-bypass-delay-shuffle",
        .description = "Has no bypass delay when using the 'wrong' shuffle type",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.nopl)] = .{
        .llvm_name = "nopl",
        .description = "Enable NOPL instruction (generally pentium pro+)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.pad_short_functions)] = .{
        .llvm_name = "pad-short-functions",
        .description = "Pad short functions (to prevent a stall when returning too early)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.pclmul)] = .{
        .llvm_name = "pclmul",
        .description = "Enable packed carry-less multiplication instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.pconfig)] = .{
        .llvm_name = "pconfig",
        .description = "platform configuration instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.pku)] = .{
        .llvm_name = "pku",
        .description = "Enable protection keys",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.popcnt)] = .{
        .llvm_name = "popcnt",
        .description = "Support POPCNT instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ppx)] = .{
        .llvm_name = "ppx",
        .description = "Support Push-Pop Acceleration",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_128_bit)] = .{
        .llvm_name = "prefer-128-bit",
        .description = "Prefer 128-bit AVX instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_256_bit)] = .{
        .llvm_name = "prefer-256-bit",
        .description = "Prefer 256-bit AVX instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_mask_registers)] = .{
        .llvm_name = "prefer-mask-registers",
        .description = "Prefer AVX512 mask registers over PTEST/MOVMSK",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_movmsk_over_vtest)] = .{
        .llvm_name = "prefer-movmsk-over-vtest",
        .description = "Prefer movmsk over vtest instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_no_gather)] = .{
        .llvm_name = "prefer-no-gather",
        .description = "Prefer no gather instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefer_no_scatter)] = .{
        .llvm_name = "prefer-no-scatter",
        .description = "Prefer no scatter instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefetchi)] = .{
        .llvm_name = "prefetchi",
        .description = "Prefetch instruction with T0 or T1 Hint",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prefetchwt1)] = .{
        .llvm_name = null,
        .description = "Prefetch with Intent to Write and T1 Hint",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.prfchw)] = .{
        .llvm_name = "prfchw",
        .description = "Support PRFCHW instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ptwrite)] = .{
        .llvm_name = "ptwrite",
        .description = "Support ptwrite instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.push2pop2)] = .{
        .llvm_name = "push2pop2",
        .description = "Support PUSH2/POP2 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.raoint)] = .{
        .llvm_name = "raoint",
        .description = "Support RAO-INT instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rdpid)] = .{
        .llvm_name = "rdpid",
        .description = "Support RDPID instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rdpru)] = .{
        .llvm_name = "rdpru",
        .description = "Support RDPRU instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rdrnd)] = .{
        .llvm_name = "rdrnd",
        .description = "Support RDRAND instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rdseed)] = .{
        .llvm_name = "rdseed",
        .description = "Support RDSEED instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.retpoline)] = .{
        .llvm_name = "retpoline",
        .description = "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct",
        .dependencies = featureSet(&[_]Feature{
            .retpoline_indirect_branches,
            .retpoline_indirect_calls,
        }),
    };
    result[@intFromEnum(Feature.retpoline_external_thunk)] = .{
        .llvm_name = "retpoline-external-thunk",
        .description = "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature",
        .dependencies = featureSet(&[_]Feature{
            .retpoline_indirect_calls,
        }),
    };
    result[@intFromEnum(Feature.retpoline_indirect_branches)] = .{
        .llvm_name = "retpoline-indirect-branches",
        .description = "Remove speculation of indirect branches from the generated code",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.retpoline_indirect_calls)] = .{
        .llvm_name = "retpoline-indirect-calls",
        .description = "Remove speculation of indirect calls from the generated code",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.rtm)] = .{
        .llvm_name = "rtm",
        .description = "Support RTM instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sahf)] = .{
        .llvm_name = "sahf",
        .description = "Support LAHF and SAHF instructions in 64-bit mode",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sbb_dep_breaking)] = .{
        .llvm_name = "sbb-dep-breaking",
        .description = "SBB with same register has no source dependency",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.serialize)] = .{
        .llvm_name = "serialize",
        .description = "Has serialize instruction",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.seses)] = .{
        .llvm_name = "seses",
        .description = "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.",
        .dependencies = featureSet(&[_]Feature{
            .lvi_cfi,
        }),
    };
    result[@intFromEnum(Feature.sgx)] = .{
        .llvm_name = "sgx",
        .description = "Enable Software Guard Extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sha)] = .{
        .llvm_name = "sha",
        .description = "Enable SHA instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.sha512)] = .{
        .llvm_name = "sha512",
        .description = "Support SHA512 instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.shstk)] = .{
        .llvm_name = "shstk",
        .description = "Support CET Shadow-Stack instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_3ops_lea)] = .{
        .llvm_name = "slow-3ops-lea",
        .description = "LEA instruction with 3 ops or certain registers is slow",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_incdec)] = .{
        .llvm_name = "slow-incdec",
        .description = "INC and DEC instructions are slower than ADD and SUB",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_lea)] = .{
        .llvm_name = "slow-lea",
        .description = "LEA instruction with certain arguments is slow",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_pmaddwd)] = .{
        .llvm_name = "slow-pmaddwd",
        .description = "PMADDWD is slower than PMULLD",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_pmulld)] = .{
        .llvm_name = "slow-pmulld",
        .description = "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_shld)] = .{
        .llvm_name = "slow-shld",
        .description = "SHLD instruction is slow",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_two_mem_ops)] = .{
        .llvm_name = "slow-two-mem-ops",
        .description = "Two memory operand instructions are slow",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_unaligned_mem_16)] = .{
        .llvm_name = "slow-unaligned-mem-16",
        .description = "Slow unaligned 16-byte memory access",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.slow_unaligned_mem_32)] = .{
        .llvm_name = "slow-unaligned-mem-32",
        .description = "Slow unaligned 32-byte memory access",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sm3)] = .{
        .llvm_name = "sm3",
        .description = "Support SM3 instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx,
        }),
    };
    result[@intFromEnum(Feature.sm4)] = .{
        .llvm_name = "sm4",
        .description = "Support SM4 instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.smap)] = .{
        .llvm_name = null,
        .description = "Enable Supervisor Mode Access Prevention",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.smep)] = .{
        .llvm_name = null,
        .description = "Enable Supervisor Mode Execution Prevention",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.soft_float)] = .{
        .llvm_name = "soft-float",
        .description = "Use software floating point features",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sse)] = .{
        .llvm_name = "sse",
        .description = "Enable SSE instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sse2)] = .{
        .llvm_name = "sse2",
        .description = "Enable SSE2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse,
        }),
    };
    result[@intFromEnum(Feature.sse3)] = .{
        .llvm_name = "sse3",
        .description = "Enable SSE3 instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse2,
        }),
    };
    result[@intFromEnum(Feature.sse4_1)] = .{
        .llvm_name = "sse4.1",
        .description = "Enable SSE 4.1 instructions",
        .dependencies = featureSet(&[_]Feature{
            .ssse3,
        }),
    };
    result[@intFromEnum(Feature.sse4_2)] = .{
        .llvm_name = "sse4.2",
        .description = "Enable SSE 4.2 instructions",
        .dependencies = featureSet(&[_]Feature{
            .crc32,
            .sse4_1,
        }),
    };
    result[@intFromEnum(Feature.sse4a)] = .{
        .llvm_name = "sse4a",
        .description = "Support SSE 4a instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse3,
        }),
    };
    result[@intFromEnum(Feature.sse_unaligned_mem)] = .{
        .llvm_name = "sse-unaligned-mem",
        .description = "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.ssse3)] = .{
        .llvm_name = "ssse3",
        .description = "Enable SSSE3 instructions",
        .dependencies = featureSet(&[_]Feature{
            .sse3,
        }),
    };
    result[@intFromEnum(Feature.tagged_globals)] = .{
        .llvm_name = "tagged-globals",
        .description = "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.tbm)] = .{
        .llvm_name = "tbm",
        .description = "Enable TBM instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.tsxldtrk)] = .{
        .llvm_name = "tsxldtrk",
        .description = "Support TSXLDTRK instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.tuning_fast_imm_vector_shift)] = .{
        .llvm_name = "tuning-fast-imm-vector-shift",
        .description = "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.uintr)] = .{
        .llvm_name = "uintr",
        .description = "Has UINTR Instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.use_glm_div_sqrt_costs)] = .{
        .llvm_name = "use-glm-div-sqrt-costs",
        .description = "Use Goldmont specific floating point div/sqrt costs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.use_slm_arith_costs)] = .{
        .llvm_name = "use-slm-arith-costs",
        .description = "Use Silvermont specific arithmetic costs",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.usermsr)] = .{
        .llvm_name = "usermsr",
        .description = "Support USERMSR instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.vaes)] = .{
        .llvm_name = "vaes",
        .description = "Promote selected AES instructions to AVX512/AVX registers",
        .dependencies = featureSet(&[_]Feature{
            .aes,
            .avx2,
        }),
    };
    result[@intFromEnum(Feature.vpclmulqdq)] = .{
        .llvm_name = "vpclmulqdq",
        .description = "Enable vpclmulqdq instructions",
        .dependencies = featureSet(&[_]Feature{
            .avx,
            .pclmul,
        }),
    };
    result[@intFromEnum(Feature.vzeroupper)] = .{
        .llvm_name = "vzeroupper",
        .description = "Should insert vzeroupper instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.waitpkg)] = .{
        .llvm_name = "waitpkg",
        .description = "Wait and pause enhancements",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.wbnoinvd)] = .{
        .llvm_name = "wbnoinvd",
        .description = "Write Back No Invalidate",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.widekl)] = .{
        .llvm_name = "widekl",
        .description = "Support Key Locker wide Instructions",
        .dependencies = featureSet(&[_]Feature{
            .kl,
        }),
    };
    result[@intFromEnum(Feature.x87)] = .{
        .llvm_name = "x87",
        .description = "Enable X87 float instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xop)] = .{
        .llvm_name = "xop",
        .description = "Enable XOP instructions",
        .dependencies = featureSet(&[_]Feature{
            .fma4,
        }),
    };
    result[@intFromEnum(Feature.xsave)] = .{
        .llvm_name = "xsave",
        .description = "Support xsave instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.xsavec)] = .{
        .llvm_name = "xsavec",
        .description = "Support xsavec instructions",
        .dependencies = featureSet(&[_]Feature{
            .xsave,
        }),
    };
    result[@intFromEnum(Feature.xsaveopt)] = .{
        .llvm_name = "xsaveopt",
        .description = "Support xsaveopt instructions",
        .dependencies = featureSet(&[_]Feature{
            .xsave,
        }),
    };
    result[@intFromEnum(Feature.xsaves)] = .{
        .llvm_name = "xsaves",
        .description = "Support xsaves instructions",
        .dependencies = featureSet(&[_]Feature{
            .xsave,
        }),
    };
    result[@intFromEnum(Feature.zu)] = .{
        .llvm_name = "zu",
        .description = "Support zero-upper SETcc/IMUL",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const alderlake: CpuModel = .{
        .name = "alderlake",
        .llvm_name = "alderlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxvnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const amdfam10: CpuModel = .{
        .name = "amdfam10",
        .llvm_name = "amdfam10",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx16,
            .fast_scalar_shift_masks,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .nopl,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .sse4a,
            .vzeroupper,
            .x87,
        }),
    };
    pub const arrowlake: CpuModel = .{
        .name = "arrowlake",
        .llvm_name = "arrowlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const arrowlake_s: CpuModel = .{
        .name = "arrowlake_s",
        .llvm_name = "arrowlake-s",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint16,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .sha512,
            .shstk,
            .slow_3ops_lea,
            .sm3,
            .sm4,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const athlon: CpuModel = .{
        .name = "athlon",
        .llvm_name = "athlon",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cmov,
            .cx8,
            .nopl,
            .prfchw,
            .slow_shld,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon64: CpuModel = .{
        .name = "athlon64",
        .llvm_name = "athlon64",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx8,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon64_sse3: CpuModel = .{
        .name = "athlon64_sse3",
        .llvm_name = "athlon64-sse3",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx16,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon_4: CpuModel = .{
        .name = "athlon_4",
        .llvm_name = "athlon-4",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cmov,
            .cx8,
            .fxsr,
            .nopl,
            .prfchw,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon_fx: CpuModel = .{
        .name = "athlon_fx",
        .llvm_name = "athlon-fx",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx8,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon_mp: CpuModel = .{
        .name = "athlon_mp",
        .llvm_name = "athlon-mp",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cmov,
            .cx8,
            .fxsr,
            .nopl,
            .prfchw,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon_tbird: CpuModel = .{
        .name = "athlon_tbird",
        .llvm_name = "athlon-tbird",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cmov,
            .cx8,
            .nopl,
            .prfchw,
            .slow_shld,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const athlon_xp: CpuModel = .{
        .name = "athlon_xp",
        .llvm_name = "athlon-xp",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cmov,
            .cx8,
            .fxsr,
            .nopl,
            .prfchw,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const atom: CpuModel = .{
        .name = "atom",
        .llvm_name = "atom",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fast_imm16,
            .fxsr,
            .idivl_to_divb,
            .idivq_to_divl,
            .lea_sp,
            .lea_uses_ag,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pad_short_functions,
            .sahf,
            .slow_two_mem_ops,
            .slow_unaligned_mem_16,
            .ssse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const atom_sse4_2_movbe: CpuModel = .{
        .name = "atom_sse4_2_movbe",
        .llvm_name = "atom_sse4_2_movbe",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .clflushopt,
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_7bytenop,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .slow_incdec,
            .slow_lea,
            .slow_pmulld,
            .slow_two_mem_ops,
            .sse4_2,
            .use_slm_arith_costs,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const barcelona: CpuModel = .{
        .name = "barcelona",
        .llvm_name = "barcelona",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx16,
            .fast_scalar_shift_masks,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .nopl,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .smap,
            .smep,
            .sse4a,
            .vzeroupper,
            .x87,
        }),
    };
    pub const bdver1: CpuModel = .{
        .name = "bdver1",
        .llvm_name = "bdver1",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .branchfusion,
            .cmov,
            .cx16,
            .fast_11bytenop,
            .fast_scalar_shift_masks,
            .fxsr,
            .idivq_to_divl,
            .lwp,
            .lzcnt,
            .mmx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .vzeroupper,
            .x87,
            .xop,
            .xsave,
        }),
    };
    pub const bdver2: CpuModel = .{
        .name = "bdver2",
        .llvm_name = "bdver2",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .bmi,
            .branchfusion,
            .cmov,
            .cx16,
            .f16c,
            .fast_11bytenop,
            .fast_bextr,
            .fast_movbe,
            .fast_scalar_shift_masks,
            .fma,
            .fxsr,
            .idivq_to_divl,
            .lwp,
            .lzcnt,
            .mmx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .tbm,
            .vzeroupper,
            .x87,
            .xop,
            .xsave,
        }),
    };
    pub const bdver3: CpuModel = .{
        .name = "bdver3",
        .llvm_name = "bdver3",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .bmi,
            .branchfusion,
            .cmov,
            .cx16,
            .f16c,
            .fast_11bytenop,
            .fast_bextr,
            .fast_movbe,
            .fast_scalar_shift_masks,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lwp,
            .lzcnt,
            .mmx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .tbm,
            .vzeroupper,
            .x87,
            .xop,
            .xsaveopt,
        }),
    };
    pub const bdver4: CpuModel = .{
        .name = "bdver4",
        .llvm_name = "bdver4",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .avx2,
            .bmi,
            .bmi2,
            .branchfusion,
            .cmov,
            .cx16,
            .f16c,
            .fast_11bytenop,
            .fast_bextr,
            .fast_movbe,
            .fast_scalar_shift_masks,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lwp,
            .lzcnt,
            .mmx,
            .movbe,
            .mwaitx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .tbm,
            .vzeroupper,
            .x87,
            .xop,
            .xsaveopt,
        }),
    };
    pub const bonnell: CpuModel = .{
        .name = "bonnell",
        .llvm_name = "bonnell",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fast_imm16,
            .fxsr,
            .idivl_to_divb,
            .idivq_to_divl,
            .lea_sp,
            .lea_uses_ag,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pad_short_functions,
            .sahf,
            .slow_two_mem_ops,
            .slow_unaligned_mem_16,
            .ssse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const broadwell: CpuModel = .{
        .name = "broadwell",
        .llvm_name = "broadwell",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .ermsb,
            .f16c,
            .false_deps_lzcnt_tzcnt,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .smap,
            .smep,
            .vzeroupper,
            .x87,
            .xsaveopt,
        }),
    };
    pub const btver1: CpuModel = .{
        .name = "btver1",
        .llvm_name = "btver1",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fast_15bytenop,
            .fast_imm16,
            .fast_scalar_shift_masks,
            .fast_vector_shift_masks,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .nopl,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .sse4a,
            .ssse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const btver2: CpuModel = .{
        .name = "btver2",
        .llvm_name = "btver2",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .bmi,
            .cmov,
            .cx16,
            .f16c,
            .fast_15bytenop,
            .fast_bextr,
            .fast_hops,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_shift_masks,
            .fast_vector_shift_masks,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .movbe,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .sahf,
            .sbb_dep_breaking,
            .slow_shld,
            .sse4a,
            .x87,
            .xsaveopt,
        }),
    };
    pub const c3: CpuModel = .{
        .name = "c3",
        .llvm_name = "c3",
        .features = featureSet(&[_]Feature{
            .@"3dnow",
            .prfchw,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const c3_2: CpuModel = .{
        .name = "c3_2",
        .llvm_name = "c3-2",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const cannonlake: CpuModel = .{
        .name = "cannonlake",
        .llvm_name = "cannonlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vl,
            .bmi,
            .bmi2,
            .clflushopt,
            .cmov,
            .cx16,
            .ermsb,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const cascadelake: CpuModel = .{
        .name = "cascadelake",
        .llvm_name = "cascadelake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx512bw,
            .avx512cd,
            .avx512dq,
            .avx512vl,
            .avx512vnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .faster_shift_than_shuffle,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const clearwaterforest: CpuModel = .{
        .name = "clearwaterforest",
        .llvm_name = "clearwaterforest",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint16,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prefetchi,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .sha512,
            .shstk,
            .slow_3ops_lea,
            .sm3,
            .sm4,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .usermsr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const cooperlake: CpuModel = .{
        .name = "cooperlake",
        .llvm_name = "cooperlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx512bf16,
            .avx512cd,
            .avx512dq,
            .avx512vl,
            .avx512vnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .faster_shift_than_shuffle,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .tuning_fast_imm_vector_shift,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const core2: CpuModel = .{
        .name = "core2",
        .llvm_name = "core2",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .macrofusion,
            .mmx,
            .nopl,
            .sahf,
            .slow_unaligned_mem_16,
            .ssse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const corei7: CpuModel = .{
        .name = "corei7",
        .llvm_name = "corei7",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .no_bypass_delay_mov,
            .nopl,
            .popcnt,
            .sahf,
            .sse4_2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const diamondrapids: CpuModel = .{
        .name = "diamondrapids",
        .llvm_name = "diamondrapids",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .amx_avx512,
            .amx_bf16,
            .amx_complex,
            .amx_fp16,
            .amx_fp8,
            .amx_int8,
            .amx_movrs,
            .amx_tf32,
            .amx_transpose,
            .avx10_2,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint16,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .branch_hint,
            .ccmp,
            .cf,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .egpr,
            .enqcmd,
            .ermsb,
            .false_deps_getmant,
            .false_deps_mulc,
            .false_deps_mullq,
            .false_deps_perm,
            .false_deps_range,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .movrs,
            .ndd,
            .nf,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .ppx,
            .prefer_256_bit,
            .prefetchi,
            .prfchw,
            .ptwrite,
            .push2pop2,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .sha512,
            .shstk,
            .sm3,
            .sm4,
            .tsxldtrk,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .usermsr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
            .zu,
        }),
    };
    pub const emeraldrapids: CpuModel = .{
        .name = "emeraldrapids",
        .llvm_name = "emeraldrapids",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .amx_bf16,
            .amx_int8,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512fp16,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .avxvnni,
            .bmi,
            .bmi2,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .enqcmd,
            .ermsb,
            .false_deps_getmant,
            .false_deps_mulc,
            .false_deps_mullq,
            .false_deps_perm,
            .false_deps_range,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .smap,
            .smep,
            .tsxldtrk,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const generic: CpuModel = .{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cx8,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .idivq_to_divl,
            .macrofusion,
            .slow_3ops_lea,
            .vzeroupper,
            .x87,
        }),
    };
    pub const geode: CpuModel = .{
        .name = "geode",
        .llvm_name = "geode",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .cx8,
            .prfchw,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const goldmont: CpuModel = .{
        .name = "goldmont",
        .llvm_name = "goldmont",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .clflushopt,
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .slow_incdec,
            .slow_lea,
            .slow_two_mem_ops,
            .smap,
            .smep,
            .sse4_2,
            .use_glm_div_sqrt_costs,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const goldmont_plus: CpuModel = .{
        .name = "goldmont_plus",
        .llvm_name = "goldmont-plus",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .clflushopt,
            .cmov,
            .cx16,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .slow_incdec,
            .slow_lea,
            .slow_two_mem_ops,
            .sse4_2,
            .use_glm_div_sqrt_costs,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const gracemont: CpuModel = .{
        .name = "gracemont",
        .llvm_name = "gracemont",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .avxvnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .f16c,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const grandridge: CpuModel = .{
        .name = "grandridge",
        .llvm_name = "grandridge",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const graniterapids: CpuModel = .{
        .name = "graniterapids",
        .llvm_name = "graniterapids",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .amx_bf16,
            .amx_fp16,
            .amx_int8,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512fp16,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .avxvnni,
            .bmi,
            .bmi2,
            .branch_hint,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .enqcmd,
            .ermsb,
            .false_deps_getmant,
            .false_deps_mulc,
            .false_deps_mullq,
            .false_deps_perm,
            .false_deps_range,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prefetchi,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .tsxldtrk,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const graniterapids_d: CpuModel = .{
        .name = "graniterapids_d",
        .llvm_name = "graniterapids-d",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .amx_bf16,
            .amx_complex,
            .amx_fp16,
            .amx_int8,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512fp16,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .avxvnni,
            .bmi,
            .bmi2,
            .branch_hint,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .enqcmd,
            .ermsb,
            .false_deps_getmant,
            .false_deps_mulc,
            .false_deps_mullq,
            .false_deps_perm,
            .false_deps_range,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prefetchi,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .tsxldtrk,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const haswell: CpuModel = .{
        .name = "haswell",
        .llvm_name = "haswell",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .ermsb,
            .f16c,
            .false_deps_lzcnt_tzcnt,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .popcnt,
            .rdrnd,
            .sahf,
            .slow_3ops_lea,
            .smep,
            .vzeroupper,
            .x87,
            .xsaveopt,
        }),
    };
    pub const @"i86": CpuModel = .{
        .name = "i86",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"16bit_mode",
        }),
    };
    pub const @"i386": CpuModel = .{
        .name = "i386",
        .llvm_name = "i386",
        .features = featureSet(&[_]Feature{
            .bsf_bsr_0_clobbers_result,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const @"i486": CpuModel = .{
        .name = "i486",
        .llvm_name = "i486",
        .features = featureSet(&[_]Feature{
            .bsf_bsr_0_clobbers_result,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const @"i586": CpuModel = .{
        .name = "i586",
        .llvm_name = "i586",
        .features = featureSet(&[_]Feature{
            .cx8,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const @"i686": CpuModel = .{
        .name = "i686",
        .llvm_name = "i686",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const icelake_client: CpuModel = .{
        .name = "icelake_client",
        .llvm_name = "icelake-client",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .clflushopt,
            .cmov,
            .cx16,
            .ermsb,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const icelake_server: CpuModel = .{
        .name = "icelake_server",
        .llvm_name = "icelake-server",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const ivybridge: CpuModel = .{
        .name = "ivybridge",
        .llvm_name = "ivybridge",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .f16c,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .no_bypass_delay_mov,
            .nopl,
            .pclmul,
            .popcnt,
            .rdrnd,
            .sahf,
            .slow_3ops_lea,
            .slow_unaligned_mem_32,
            .smep,
            .vzeroupper,
            .x87,
            .xsaveopt,
        }),
    };
    pub const k6: CpuModel = .{
        .name = "k6",
        .llvm_name = "k6",
        .features = featureSet(&[_]Feature{
            .cx8,
            .mmx,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const k6_2: CpuModel = .{
        .name = "k6_2",
        .llvm_name = "k6-2",
        .features = featureSet(&[_]Feature{
            .@"3dnow",
            .cx8,
            .prfchw,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const k6_3: CpuModel = .{
        .name = "k6_3",
        .llvm_name = "k6-3",
        .features = featureSet(&[_]Feature{
            .@"3dnow",
            .cx8,
            .prfchw,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const k8: CpuModel = .{
        .name = "k8",
        .llvm_name = "k8",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx8,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const k8_sse3: CpuModel = .{
        .name = "k8_sse3",
        .llvm_name = "k8-sse3",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx16,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const knl: CpuModel = .{
        .name = "knl",
        .llvm_name = "knl",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .avx512cd,
            .avx512er,
            .avx512pf,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .fast_gather,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .movbe,
            .nopl,
            .pclmul,
            .popcnt,
            .prefer_mask_registers,
            .prefetchwt1,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .slow_incdec,
            .slow_pmaddwd,
            .slow_two_mem_ops,
            .x87,
            .xsaveopt,
        }),
    };
    pub const knm: CpuModel = .{
        .name = "knm",
        .llvm_name = "knm",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .avx512cd,
            .avx512er,
            .avx512pf,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .fast_gather,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .movbe,
            .nopl,
            .pclmul,
            .popcnt,
            .prefer_mask_registers,
            .prefetchwt1,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .slow_incdec,
            .slow_pmaddwd,
            .slow_two_mem_ops,
            .x87,
            .xsaveopt,
        }),
    };
    pub const lakemont: CpuModel = .{
        .name = "lakemont",
        .llvm_name = "lakemont",
        .features = featureSet(&[_]Feature{
            .cx8,
            .slow_unaligned_mem_16,
            .soft_float,
            .vzeroupper,
        }),
    };
    pub const lunarlake: CpuModel = .{
        .name = "lunarlake",
        .llvm_name = "lunarlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint16,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .sha512,
            .shstk,
            .slow_3ops_lea,
            .sm3,
            .sm4,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const meteorlake: CpuModel = .{
        .name = "meteorlake",
        .llvm_name = "meteorlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxvnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const nehalem: CpuModel = .{
        .name = "nehalem",
        .llvm_name = "nehalem",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .no_bypass_delay_mov,
            .nopl,
            .popcnt,
            .sahf,
            .sse4_2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const nocona: CpuModel = .{
        .name = "nocona",
        .llvm_name = "nocona",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const opteron: CpuModel = .{
        .name = "opteron",
        .llvm_name = "opteron",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx8,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const opteron_sse3: CpuModel = .{
        .name = "opteron_sse3",
        .llvm_name = "opteron-sse3",
        .features = featureSet(&[_]Feature{
            .@"3dnowa",
            .@"64bit",
            .cmov,
            .cx16,
            .fast_scalar_shift_masks,
            .fxsr,
            .nopl,
            .prfchw,
            .sbb_dep_breaking,
            .slow_shld,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pantherlake: CpuModel = .{
        .name = "pantherlake",
        .llvm_name = "pantherlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint16,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prefetchi,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .sha512,
            .shstk,
            .slow_3ops_lea,
            .sm3,
            .sm4,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const penryn: CpuModel = .{
        .name = "penryn",
        .llvm_name = "penryn",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .macrofusion,
            .mmx,
            .nopl,
            .sahf,
            .slow_unaligned_mem_16,
            .sse4_1,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium: CpuModel = .{
        .name = "pentium",
        .llvm_name = "pentium",
        .features = featureSet(&[_]Feature{
            .cx8,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium2: CpuModel = .{
        .name = "pentium2",
        .llvm_name = "pentium2",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium3: CpuModel = .{
        .name = "pentium3",
        .llvm_name = "pentium3",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium3m: CpuModel = .{
        .name = "pentium3m",
        .llvm_name = "pentium3m",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium4: CpuModel = .{
        .name = "pentium4",
        .llvm_name = "pentium4",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium_m: CpuModel = .{
        .name = "pentium_m",
        .llvm_name = "pentium-m",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentium_mmx: CpuModel = .{
        .name = "pentium_mmx",
        .llvm_name = "pentium-mmx",
        .features = featureSet(&[_]Feature{
            .cx8,
            .mmx,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const pentiumpro: CpuModel = .{
        .name = "pentiumpro",
        .llvm_name = "pentiumpro",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .nopl,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const prescott: CpuModel = .{
        .name = "prescott",
        .llvm_name = "prescott",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const raptorlake: CpuModel = .{
        .name = "raptorlake",
        .llvm_name = "raptorlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avxvnni,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .f16c,
            .false_deps_perm,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_movmsk_over_vtest,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const rocketlake: CpuModel = .{
        .name = "rocketlake",
        .llvm_name = "rocketlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .clflushopt,
            .cmov,
            .cx16,
            .ermsb,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const sandybridge: CpuModel = .{
        .name = "sandybridge",
        .llvm_name = "sandybridge",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .avx,
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .no_bypass_delay_mov,
            .nopl,
            .pclmul,
            .popcnt,
            .sahf,
            .slow_3ops_lea,
            .slow_unaligned_mem_32,
            .vzeroupper,
            .x87,
            .xsaveopt,
        }),
    };
    pub const sapphirerapids: CpuModel = .{
        .name = "sapphirerapids",
        .llvm_name = "sapphirerapids",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .amx_bf16,
            .amx_int8,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512fp16,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .avxvnni,
            .bmi,
            .bmi2,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .enqcmd,
            .ermsb,
            .false_deps_getmant,
            .false_deps_mulc,
            .false_deps_mullq,
            .false_deps_perm,
            .false_deps_range,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .smap,
            .smep,
            .tsxldtrk,
            .tuning_fast_imm_vector_shift,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const sierraforest: CpuModel = .{
        .name = "sierraforest",
        .llvm_name = "sierraforest",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .avxifma,
            .avxneconvert,
            .avxvnni,
            .avxvnniint8,
            .bmi,
            .bmi2,
            .cldemote,
            .clflushopt,
            .clwb,
            .cmov,
            .cmpccxadd,
            .cx16,
            .enqcmd,
            .f16c,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .gfni,
            .hreset,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .nopl,
            .pconfig,
            .pku,
            .popcnt,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .serialize,
            .sha,
            .shstk,
            .slow_3ops_lea,
            .uintr,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .waitpkg,
            .widekl,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const silvermont: CpuModel = .{
        .name = "silvermont",
        .llvm_name = "silvermont",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_7bytenop,
            .fast_imm16,
            .fast_movbe,
            .fxsr,
            .idivq_to_divl,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .sahf,
            .slow_incdec,
            .slow_lea,
            .slow_pmulld,
            .slow_two_mem_ops,
            .smep,
            .sse4_2,
            .use_slm_arith_costs,
            .vzeroupper,
            .x87,
        }),
    };
    pub const skx: CpuModel = .{
        .name = "skx",
        .llvm_name = "skx",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx512bw,
            .avx512cd,
            .avx512dq,
            .avx512vl,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .faster_shift_than_shuffle,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const skylake: CpuModel = .{
        .name = "skylake",
        .llvm_name = "skylake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .clflushopt,
            .cmov,
            .cx16,
            .ermsb,
            .f16c,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .smap,
            .smep,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const skylake_avx512: CpuModel = .{
        .name = "skylake_avx512",
        .llvm_name = "skylake-avx512",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx512bw,
            .avx512cd,
            .avx512dq,
            .avx512vl,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .faster_shift_than_shuffle,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pclmul,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .slow_3ops_lea,
            .tuning_fast_imm_vector_shift,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const slm: CpuModel = .{
        .name = "slm",
        .llvm_name = "slm",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_7bytenop,
            .fast_imm16,
            .fast_movbe,
            .fxsr,
            .idivq_to_divl,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .sahf,
            .slow_incdec,
            .slow_lea,
            .slow_pmulld,
            .slow_two_mem_ops,
            .sse4_2,
            .use_slm_arith_costs,
            .vzeroupper,
            .x87,
        }),
    };
    pub const tigerlake: CpuModel = .{
        .name = "tigerlake",
        .llvm_name = "tigerlake",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vp2intersect,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .ermsb,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .no_bypass_delay_blend,
            .no_bypass_delay_mov,
            .no_bypass_delay_shuffle,
            .nopl,
            .pku,
            .popcnt,
            .prefer_256_bit,
            .prfchw,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .shstk,
            .smap,
            .smep,
            .tuning_fast_imm_vector_shift,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const tremont: CpuModel = .{
        .name = "tremont",
        .llvm_name = "tremont",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .aes,
            .clflushopt,
            .clwb,
            .cmov,
            .cx16,
            .fast_imm16,
            .fast_movbe,
            .fsgsbase,
            .fxsr,
            .gfni,
            .mmx,
            .movbe,
            .no_bypass_delay,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .ptwrite,
            .rdpid,
            .rdrnd,
            .rdseed,
            .sahf,
            .sha,
            .slow_incdec,
            .slow_lea,
            .slow_two_mem_ops,
            .sse4_2,
            .use_glm_div_sqrt_costs,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const westmere: CpuModel = .{
        .name = "westmere",
        .llvm_name = "westmere",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .no_bypass_delay_mov,
            .nopl,
            .pclmul,
            .popcnt,
            .sahf,
            .sse4_2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const winchip2: CpuModel = .{
        .name = "winchip2",
        .llvm_name = "winchip2",
        .features = featureSet(&[_]Feature{
            .@"3dnow",
            .prfchw,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const winchip_c6: CpuModel = .{
        .name = "winchip_c6",
        .llvm_name = "winchip-c6",
        .features = featureSet(&[_]Feature{
            .mmx,
            .slow_unaligned_mem_16,
            .vzeroupper,
            .x87,
        }),
    };
    pub const x86_64: CpuModel = .{
        .name = "x86_64",
        .llvm_name = "x86-64",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx8,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .nopl,
            .slow_3ops_lea,
            .slow_incdec,
            .sse2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const x86_64_v2: CpuModel = .{
        .name = "x86_64_v2",
        .llvm_name = "x86-64-v2",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fxsr,
            .idivq_to_divl,
            .macrofusion,
            .mmx,
            .nopl,
            .popcnt,
            .sahf,
            .slow_3ops_lea,
            .slow_unaligned_mem_32,
            .sse4_2,
            .vzeroupper,
            .x87,
        }),
    };
    pub const x86_64_v3: CpuModel = .{
        .name = "x86_64_v3",
        .llvm_name = "x86-64-v3",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .f16c,
            .false_deps_lzcnt_tzcnt,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fma,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .nopl,
            .popcnt,
            .sahf,
            .slow_3ops_lea,
            .vzeroupper,
            .x87,
            .xsave,
        }),
    };
    pub const x86_64_v4: CpuModel = .{
        .name = "x86_64_v4",
        .llvm_name = "x86-64-v4",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .allow_light_256_bit,
            .avx512bw,
            .avx512cd,
            .avx512dq,
            .avx512vl,
            .bmi,
            .bmi2,
            .cmov,
            .cx16,
            .false_deps_popcnt,
            .fast_15bytenop,
            .fast_gather,
            .fast_scalar_fsqrt,
            .fast_shld_rotate,
            .fast_variable_crosslane_shuffle,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .nopl,
            .popcnt,
            .prefer_256_bit,
            .sahf,
            .slow_3ops_lea,
            .vzeroupper,
            .x87,
            .xsave,
        }),
    };
    pub const yonah: CpuModel = .{
        .name = "yonah",
        .llvm_name = "yonah",
        .features = featureSet(&[_]Feature{
            .cmov,
            .cx8,
            .fxsr,
            .mmx,
            .nopl,
            .slow_unaligned_mem_16,
            .sse3,
            .vzeroupper,
            .x87,
        }),
    };
    pub const znver1: CpuModel = .{
        .name = "znver1",
        .llvm_name = "znver1",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .branchfusion,
            .clflushopt,
            .clzero,
            .cmov,
            .cx16,
            .f16c,
            .fast_15bytenop,
            .fast_bextr,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_fsqrt,
            .fast_scalar_shift_masks,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .movbe,
            .mwaitx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdrnd,
            .rdseed,
            .sahf,
            .sbb_dep_breaking,
            .sha,
            .slow_shld,
            .smap,
            .smep,
            .sse4a,
            .vzeroupper,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const znver2: CpuModel = .{
        .name = "znver2",
        .llvm_name = "znver2",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .aes,
            .allow_light_256_bit,
            .avx2,
            .bmi,
            .bmi2,
            .branchfusion,
            .clflushopt,
            .clwb,
            .clzero,
            .cmov,
            .cx16,
            .f16c,
            .fast_15bytenop,
            .fast_bextr,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_fsqrt,
            .fast_scalar_shift_masks,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fxsr,
            .idivq_to_divl,
            .lzcnt,
            .mmx,
            .movbe,
            .mwaitx,
            .nopl,
            .pclmul,
            .popcnt,
            .prfchw,
            .rdpid,
            .rdpru,
            .rdrnd,
            .rdseed,
            .sahf,
            .sbb_dep_breaking,
            .sha,
            .slow_shld,
            .smap,
            .smep,
            .sse4a,
            .vzeroupper,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const znver3: CpuModel = .{
        .name = "znver3",
        .llvm_name = "znver3",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .bmi,
            .bmi2,
            .branchfusion,
            .clflushopt,
            .clwb,
            .clzero,
            .cmov,
            .cx16,
            .f16c,
            .fast_15bytenop,
            .fast_bextr,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_fsqrt,
            .fast_scalar_shift_masks,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fma,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .mwaitx,
            .nopl,
            .pku,
            .popcnt,
            .prfchw,
            .rdpid,
            .rdpru,
            .rdrnd,
            .rdseed,
            .sahf,
            .sbb_dep_breaking,
            .sha,
            .smap,
            .smep,
            .sse4a,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const znver4: CpuModel = .{
        .name = "znver4",
        .llvm_name = "znver4",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vpopcntdq,
            .bmi,
            .bmi2,
            .branchfusion,
            .clflushopt,
            .clwb,
            .clzero,
            .cmov,
            .cx16,
            .fast_15bytenop,
            .fast_bextr,
            .fast_dpwssd,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_fsqrt,
            .fast_scalar_shift_masks,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .mwaitx,
            .nopl,
            .pku,
            .popcnt,
            .prfchw,
            .rdpid,
            .rdpru,
            .rdrnd,
            .rdseed,
            .sahf,
            .sbb_dep_breaking,
            .sha,
            .shstk,
            .smap,
            .smep,
            .sse4a,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
    pub const znver5: CpuModel = .{
        .name = "znver5",
        .llvm_name = "znver5",
        .features = featureSet(&[_]Feature{
            .@"64bit",
            .adx,
            .allow_light_256_bit,
            .avx512bf16,
            .avx512bitalg,
            .avx512cd,
            .avx512dq,
            .avx512ifma,
            .avx512vbmi,
            .avx512vbmi2,
            .avx512vl,
            .avx512vnni,
            .avx512vp2intersect,
            .avx512vpopcntdq,
            .avxvnni,
            .bmi,
            .bmi2,
            .branchfusion,
            .clflushopt,
            .clwb,
            .clzero,
            .cmov,
            .cx16,
            .fast_15bytenop,
            .fast_bextr,
            .fast_dpwssd,
            .fast_imm16,
            .fast_lzcnt,
            .fast_movbe,
            .fast_scalar_fsqrt,
            .fast_scalar_shift_masks,
            .fast_variable_perlane_shuffle,
            .fast_vector_fsqrt,
            .fsgsbase,
            .fsrm,
            .fxsr,
            .gfni,
            .idivq_to_divl,
            .invpcid,
            .lzcnt,
            .macrofusion,
            .mmx,
            .movbe,
            .movdir64b,
            .movdiri,
            .mwaitx,
            .nopl,
            .pku,
            .popcnt,
            .prefetchi,
            .prfchw,
            .rdpid,
            .rdpru,
            .rdrnd,
            .rdseed,
            .sahf,
            .sbb_dep_breaking,
            .sha,
            .shstk,
            .smap,
            .smep,
            .sse4a,
            .vaes,
            .vpclmulqdq,
            .vzeroupper,
            .wbnoinvd,
            .x87,
            .xsavec,
            .xsaveopt,
            .xsaves,
        }),
    };
};
