//! Autogenerated by GenerateDef from src/aro/Builtins/aarch64.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    _AddressOfReturnAddress,
    _BitScanForward,
    _BitScanForward64,
    _BitScanReverse,
    _BitScanReverse64,
    _CopyDoubleFromInt64,
    _CopyFloatFromInt32,
    _CopyInt32FromFloat,
    _CopyInt64FromDouble,
    _CountLeadingOnes,
    _CountLeadingOnes64,
    _CountLeadingSigns,
    _CountLeadingSigns64,
    _CountLeadingZeros,
    _CountLeadingZeros64,
    _CountOneBits,
    _CountOneBits64,
    _InterlockedAdd,
    _InterlockedAdd64,
    _InterlockedAdd64_acq,
    _InterlockedAdd64_nf,
    _InterlockedAdd64_rel,
    _InterlockedAdd_acq,
    _InterlockedAdd_nf,
    _InterlockedAdd_rel,
    _InterlockedAnd16_acq,
    _InterlockedAnd16_nf,
    _InterlockedAnd16_rel,
    _InterlockedAnd64,
    _InterlockedAnd64_acq,
    _InterlockedAnd64_nf,
    _InterlockedAnd64_rel,
    _InterlockedAnd8_acq,
    _InterlockedAnd8_nf,
    _InterlockedAnd8_rel,
    _InterlockedAnd_acq,
    _InterlockedAnd_nf,
    _InterlockedAnd_rel,
    _InterlockedCompareExchange128,
    _InterlockedCompareExchange128_acq,
    _InterlockedCompareExchange128_nf,
    _InterlockedCompareExchange128_rel,
    _InterlockedCompareExchange16_acq,
    _InterlockedCompareExchange16_nf,
    _InterlockedCompareExchange16_rel,
    _InterlockedCompareExchange64_acq,
    _InterlockedCompareExchange64_nf,
    _InterlockedCompareExchange64_rel,
    _InterlockedCompareExchange8_acq,
    _InterlockedCompareExchange8_nf,
    _InterlockedCompareExchange8_rel,
    _InterlockedCompareExchangePointer_acq,
    _InterlockedCompareExchangePointer_rel,
    _InterlockedCompareExchange_acq,
    _InterlockedCompareExchange_nf,
    _InterlockedCompareExchange_rel,
    _InterlockedDecrement16_acq,
    _InterlockedDecrement16_nf,
    _InterlockedDecrement16_rel,
    _InterlockedDecrement64,
    _InterlockedDecrement64_acq,
    _InterlockedDecrement64_nf,
    _InterlockedDecrement64_rel,
    _InterlockedDecrement_acq,
    _InterlockedDecrement_nf,
    _InterlockedDecrement_rel,
    _InterlockedExchange16_acq,
    _InterlockedExchange16_nf,
    _InterlockedExchange16_rel,
    _InterlockedExchange64,
    _InterlockedExchange64_acq,
    _InterlockedExchange64_nf,
    _InterlockedExchange64_rel,
    _InterlockedExchange8_acq,
    _InterlockedExchange8_nf,
    _InterlockedExchange8_rel,
    _InterlockedExchangeAdd16_acq,
    _InterlockedExchangeAdd16_nf,
    _InterlockedExchangeAdd16_rel,
    _InterlockedExchangeAdd64,
    _InterlockedExchangeAdd64_acq,
    _InterlockedExchangeAdd64_nf,
    _InterlockedExchangeAdd64_rel,
    _InterlockedExchangeAdd8_acq,
    _InterlockedExchangeAdd8_nf,
    _InterlockedExchangeAdd8_rel,
    _InterlockedExchangeAdd_acq,
    _InterlockedExchangeAdd_nf,
    _InterlockedExchangeAdd_rel,
    _InterlockedExchangePointer_acq,
    _InterlockedExchangePointer_nf,
    _InterlockedExchangePointer_rel,
    _InterlockedExchangeSub64,
    _InterlockedExchange_acq,
    _InterlockedExchange_nf,
    _InterlockedExchange_rel,
    _InterlockedIncrement16_acq,
    _InterlockedIncrement16_nf,
    _InterlockedIncrement16_rel,
    _InterlockedIncrement64,
    _InterlockedIncrement64_acq,
    _InterlockedIncrement64_nf,
    _InterlockedIncrement64_rel,
    _InterlockedIncrement_acq,
    _InterlockedIncrement_nf,
    _InterlockedIncrement_rel,
    _InterlockedOr16_acq,
    _InterlockedOr16_nf,
    _InterlockedOr16_rel,
    _InterlockedOr64,
    _InterlockedOr64_acq,
    _InterlockedOr64_nf,
    _InterlockedOr64_rel,
    _InterlockedOr8_acq,
    _InterlockedOr8_nf,
    _InterlockedOr8_rel,
    _InterlockedOr_acq,
    _InterlockedOr_nf,
    _InterlockedOr_rel,
    _InterlockedXor16_acq,
    _InterlockedXor16_nf,
    _InterlockedXor16_rel,
    _InterlockedXor64,
    _InterlockedXor64_acq,
    _InterlockedXor64_nf,
    _InterlockedXor64_rel,
    _InterlockedXor8_acq,
    _InterlockedXor8_nf,
    _InterlockedXor8_rel,
    _InterlockedXor_acq,
    _InterlockedXor_nf,
    _InterlockedXor_rel,
    _ReadStatusReg,
    _ReadWriteBarrier,
    _WriteStatusReg,
    __addx18byte,
    __addx18dword,
    __addx18qword,
    __addx18word,
    __break,
    __builtin_arm_addg,
    __builtin_arm_chkfeat,
    __builtin_arm_clrex,
    __builtin_arm_cls,
    __builtin_arm_cls64,
    __builtin_arm_clz,
    __builtin_arm_clz64,
    __builtin_arm_crc32b,
    __builtin_arm_crc32cb,
    __builtin_arm_crc32cd,
    __builtin_arm_crc32ch,
    __builtin_arm_crc32cw,
    __builtin_arm_crc32d,
    __builtin_arm_crc32h,
    __builtin_arm_crc32w,
    __builtin_arm_dmb,
    __builtin_arm_dsb,
    __builtin_arm_gcspopm,
    __builtin_arm_gcsss,
    __builtin_arm_get_sme_state,
    __builtin_arm_gmi,
    __builtin_arm_irg,
    __builtin_arm_isb,
    __builtin_arm_jcvt,
    __builtin_arm_ld64b,
    __builtin_arm_ldaex,
    __builtin_arm_ldg,
    __builtin_arm_ldrex,
    __builtin_arm_mops_memset_tag,
    __builtin_arm_nop,
    __builtin_arm_prefetch,
    __builtin_arm_rbit,
    __builtin_arm_rbit64,
    __builtin_arm_rint32x,
    __builtin_arm_rint32xf,
    __builtin_arm_rint32z,
    __builtin_arm_rint32zf,
    __builtin_arm_rint64x,
    __builtin_arm_rint64xf,
    __builtin_arm_rint64z,
    __builtin_arm_rint64zf,
    __builtin_arm_rndr,
    __builtin_arm_rndrrs,
    __builtin_arm_rsr,
    __builtin_arm_rsr128,
    __builtin_arm_rsr64,
    __builtin_arm_rsrp,
    __builtin_arm_sev,
    __builtin_arm_sevl,
    __builtin_arm_st64b,
    __builtin_arm_st64bv,
    __builtin_arm_st64bv0,
    __builtin_arm_stg,
    __builtin_arm_stlex,
    __builtin_arm_strex,
    __builtin_arm_subp,
    __builtin_arm_tcancel,
    __builtin_arm_tcommit,
    __builtin_arm_trap,
    __builtin_arm_tstart,
    __builtin_arm_ttest,
    __builtin_arm_wfe,
    __builtin_arm_wfi,
    __builtin_arm_wsr,
    __builtin_arm_wsr128,
    __builtin_arm_wsr64,
    __builtin_arm_wsrp,
    __builtin_arm_yield,
    __builtin_sponentry,
    __clear_cache,
    __dmb,
    __dsb,
    __getReg,
    __hlt,
    __incx18byte,
    __incx18dword,
    __incx18qword,
    __incx18word,
    __isb,
    __mulh,
    __prefetch,
    __readx18byte,
    __readx18dword,
    __readx18qword,
    __readx18word,
    __sev,
    __sevl,
    __sys,
    __umulh,
    __wfe,
    __wfi,
    __writex18byte,
    __writex18dword,
    __writex18qword,
    __writex18word,
    __yield,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 5;
pub const longest_name = 38;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(472);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 236, .child_index = 2 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 9 },
    .{ .char = 'B', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 10 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 11 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = false, .number = 115, .child_index = 12 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 13 },
    .{ .char = 'W', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 14 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 101, .child_index = 15 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 29 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 30 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 31 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 33 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 34 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 35 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 36 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 70, .child_index = 37 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 39 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 40 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 42 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 43 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 44 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 46 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 47 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 48 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 49 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 51 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 52 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 54 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 55 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 56 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 57 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 58 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 59 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 60 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 61 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 62 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 63 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 64 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 65 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 66 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 67 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 69 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 70 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 71 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 72 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 73 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 74 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 46 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 75 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 77 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 78 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 79 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 80 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 81 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 84 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 85 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 86 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 88 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 89 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 90 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 91 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 92 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 93 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 89 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 94 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 95 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 62 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 96 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 97 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 98 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 99 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 100 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 101 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 102 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 103 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 104 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 106 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 107 },
    .{ .char = 'W', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 108 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 109 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 110 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 111 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 112 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 113 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 114 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 115 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 116 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 117 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 118 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 119 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 120 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 121 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 122 },
    .{ .char = 'L', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 123 },
    .{ .char = 'O', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 124 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 125 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 126 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 127 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 107 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 128 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 129 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 130 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 131 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 132 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 89 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 134 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 136 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 137 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 138 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 140 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 141 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 142 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 143 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 144 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 145 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 149 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 151 },
    .{ .char = 'O', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 152 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 153 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 154 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 155 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 156 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 157 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 158 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 159 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 160 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 161 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 162 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 163 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 164 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 165 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 165 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 166 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 167 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 94 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 169 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 170 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 171 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 173 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 174 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 175 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 176 },
    .{ .char = 'B', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 177 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 178 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 179 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 180 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 166 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 182 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 69, .child_index = 183 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 185 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 187 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 188 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 189 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 191 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 192 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 193 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 194 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 195 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 93 },
    .{ .char = 'B', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 196 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 197 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 117 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 68, .child_index = 198 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 199 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 200 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 201 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 202 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 203 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 204 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 205 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 206 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 207 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 208 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 209 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 115, .child_index = 210 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 217 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 218 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 219 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 197 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 220 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 221 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 222 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 225 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 226 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 227 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = false, .number = 21, .child_index = 231 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 233 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 234 },
    .{ .char = 'E', .end_of_word = false, .end_of_list = false, .number = 30, .child_index = 235 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 236 },
    .{ .char = 'O', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 237 },
    .{ .char = 'X', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 238 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 239 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 240 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 241 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 243 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 244 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 245 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 246 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 248 },
    .{ .char = 'O', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 249 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 250 },
    .{ .char = 'Z', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 251 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 252 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 253 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 254 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 255 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 256 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 257 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 256 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 258 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 237 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 68, .child_index = 263 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 278 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 279 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 280 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 281 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 282 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 283 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 284 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 285 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 286 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 8, .child_index = 287 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 258 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 289 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 290 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 291 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 292 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 293 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 294 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 298 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 299 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 300 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 40 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 303 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 306 },
    .{ .char = 'j', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 308 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 309 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 310 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 311 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 47 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 312 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 316 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 319 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 323 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 54 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 326 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 329 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 330 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 209 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 331 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 332 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 293 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 333 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 334 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 335 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 294 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 336 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 337 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 338 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 339 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 340 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 342 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 343 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 346 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 347 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 348 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 349 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 131 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 351 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 355 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 357 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 358 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 359 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 360 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 73 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 361 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 365 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 366 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 368 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 369 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 75 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 360 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 371 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 372 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 373 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 374 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 375 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 209 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 209 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 377 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 378 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 379 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 380 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 381 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 131 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 382 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 383 },
    .{ .char = 's', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 230 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 384 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 385 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 387 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 388 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 383 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 389 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 390 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 391 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 392 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 393 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 396 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 383 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 397 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 399 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 400 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 401 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 402 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 404 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 406 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 407 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 408 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 409 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 410 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 411 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 412 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 74 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 413 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 414 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 230 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 415 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 417 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 418 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 252 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 419 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 420 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 422 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 423 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 424 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 252 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 197 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 425 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 426 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 427 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 375 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 428 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 433 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 434 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 436 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 437 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 74 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 438 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 439 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 339 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 441 },
    .{ .char = 'E', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 442 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 443 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 444 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 451 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 455 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 456 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 457 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 458 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 458 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 460 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 461 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 462 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 463 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 292 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 293 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 294 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 466 },
    .{ .char = 'P', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 467 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 468 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 469 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 470 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 471 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 471 },
    .{ .char = '0', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 74 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 472 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 292 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 293 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 254 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 473 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 476 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 477 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 478 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 479 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 480 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 481 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 482 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 483 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 484 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 485 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 486 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 181 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 487 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 488 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 489 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 490 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 491 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 294 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 497 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 499 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 294 },
    .{ .char = 'P', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 500 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 295 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 131 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 501 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 294 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 294 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 502 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 336 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 503 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 504 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 505 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 507 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 508 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 337 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 339 },
};
pub const data = blk: {
    @setEvalBranchQuota(2124);
    break :blk [_]Properties{
        .{ .param_str = "v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*UNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*UNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "dSLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "fSi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "Sif", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "SLLid", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiSNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiSLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcLLiD*LLiLLiLLi*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcLLiD*LLiLLiLLi*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcLLiD*LLiLLiLLi*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcLLiD*LLiLLiLLi*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLii", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "viLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiUc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiUs", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*Ui", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "WUiWUi" },
        .{ .param_str = "v" },
        .{ .param_str = "UiZUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiZUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUc", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUc", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiWUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUs", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiWUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUs", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiWUi", .features = "gcs" },
        .{ .param_str = "v*v*", .features = "gcs" },
        .{ .param_str = "vWUi*WUi*" },
        .{ .param_str = "Uiv*Ui", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "v*v*Ui", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Zid", .attributes = .{ .@"const" = true }, .features = "v8_3a" },
        .{ .param_str = "vvC*WUi*", .features = "ls64" },
        .{ .param_str = "v.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "v*v*", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "v.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "v*v*iz", .features = "mte,mops" },
        .{ .param_str = "v" },
        .{ .param_str = "vvC*UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "WUiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "dd", .features = "v8_5a" },
        .{ .param_str = "ff", .features = "v8_5a" },
        .{ .param_str = "dd", .features = "v8_5a" },
        .{ .param_str = "ff", .features = "v8_5a" },
        .{ .param_str = "dd", .features = "v8_5a" },
        .{ .param_str = "ff", .features = "v8_5a" },
        .{ .param_str = "dd", .features = "v8_5a" },
        .{ .param_str = "ff", .features = "v8_5a" },
        .{ .param_str = "iWUi*", .features = "rand" },
        .{ .param_str = "iWUi*", .features = "rand" },
        .{ .param_str = "UicC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLLUicC*", .attributes = .{ .@"const" = true }, .features = "d128" },
        .{ .param_str = "WUicC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v*cC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "vv*WUiC*", .features = "ls64" },
        .{ .param_str = "WUiv*WUiC*", .features = "ls64" },
        .{ .param_str = "WUiv*WUiC*", .features = "ls64" },
        .{ .param_str = "vv*", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "i.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "i.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "Uiv*v*", .attributes = .{ .custom_typecheck = true }, .features = "mte" },
        .{ .param_str = "vWUIi" },
        .{ .param_str = "v" },
        .{ .param_str = "vUIs", .attributes = .{ .@"noreturn" = true } },
        .{ .param_str = "WUi", .attributes = .{ .returns_twice = true } },
        .{ .param_str = "WUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "vcC*Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vcC*LLLUi", .attributes = .{ .@"const" = true }, .features = "d128" },
        .{ .param_str = "vcC*WUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vcC*vC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vv*v*" },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "ULLii", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiUi.", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "SLLiSLLiSLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vvC*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UNiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ULLiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UsUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "UiiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ULLiULLiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "vUNiUc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiUNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vUNiUs", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v", .header = .arm_acle },
    };
};
};
}
