//! Autogenerated by GenerateDef from src/aro/Attribute/names.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    aarch64_sve_pcs,
    aarch64_vector_pcs,
    access,
    alias,
    @"align",
    aligned,
    alloc_align,
    alloc_size,
    allocate,
    allocator,
    always_inline,
    appdomain,
    artificial,
    assume_aligned,
    availability,
    cdecl,
    cleanup,
    code_seg,
    cold,
    common,
    @"const",
    constructor,
    copy,
    deprecated,
    designated_init,
    destructor,
    dllexport,
    dllimport,
    @"error",
    externally_visible,
    fallthrough,
    fastcall,
    flatten,
    format,
    format_arg,
    gnu_inline,
    hot,
    ifunc,
    internal_linkage,
    interrupt,
    interrupt_handler,
    jitintrinsic,
    leaf,
    malloc,
    may_alias,
    maybe_unused,
    mode,
    ms_abi,
    naked,
    no_address_safety_analysis,
    no_icf,
    no_instrument_function,
    no_profile_instrument_function,
    no_reorder,
    no_sanitize,
    no_sanitize_address,
    no_sanitize_coverage,
    no_sanitize_thread,
    no_sanitize_undefined,
    no_split_stack,
    no_stack_limit,
    no_stack_protector,
    @"noalias",
    noclone,
    nocommon,
    nodiscard,
    noinit,
    @"noinline",
    noipa,
    nonstring,
    noplt,
    @"noreturn",
    nothrow,
    @"packed",
    patchable_function_entry,
    pcs,
    persistent,
    process,
    pure,
    reproducible,
    restrict,
    retain,
    returns_nonnull,
    returns_twice,
    riscv_vector_cc,
    safebuffers,
    scalar_storage_order,
    section,
    selectany,
    sentinel,
    simd,
    spectre,
    stack_protect,
    stdcall,
    symver,
    sysv_abi,
    target,
    target_clones,
    thiscall,
    thread,
    tls_model,
    transparent_union,
    unavailable,
    uninitialized,
    unsequenced,
    unused,
    used,
    uuid,
    vector_size,
    vectorcall,
    visibility,
    warn_if_not_aligned,
    warn_unused_result,
    warning,
    weak,
    weakref,
    zero_call_used_regs,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 3;
pub const longest_name = 30;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(234);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 15, .child_index = 21 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 28 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 31 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 33 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 35 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 38 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 39 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 40 },
    .{ .char = 'j', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 42 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 43 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 44 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 25, .child_index = 47 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 49 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 54 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 11, .child_index = 56 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 63 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 67 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 70 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 72 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 74 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 75 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 76 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 77 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 80 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 81 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 82 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 83 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 84 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 85 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 86 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 91 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 93 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 94 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 95 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 96 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 98 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 99 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 100 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 102 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 103 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 104 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 105 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 106 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 108 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 109 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 24, .child_index = 111 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 120 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 122 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 123 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 124 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 125 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 126 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 129 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 130 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 131 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 132 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 135 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 136 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 137 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 139 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 141 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 142 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 144 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 145 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 146 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 150 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 151 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 152 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 154 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 155 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 156 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 157 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 158 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 159 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 161 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 162 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 163 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 164 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 165 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 166 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 169 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 170 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 171 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 172 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 173 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 174 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 175 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 177 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 179 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 180 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 181 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 182 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 183 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 184 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 185 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 187 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 188 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 189 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 190 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 191 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 194 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 195 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 200 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 201 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 203 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 204 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 206 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 207 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 208 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 209 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 210 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 76 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 212 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 213 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 214 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 216 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 217 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 218 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 219 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 220 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 221 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 223 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 225 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 226 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 227 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 228 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 229 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 230 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 232 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 233 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 234 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 235 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 236 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 237 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 238 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 239 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 240 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 241 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 122 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 243 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 244 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 245 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 246 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 247 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 248 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 249 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 251 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 252 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 254 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 255 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 256 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 257 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 258 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 259 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 261 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 264 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 265 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 267 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 268 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 269 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 270 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 271 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 272 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 273 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 274 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 276 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 277 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 278 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 281 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 282 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 283 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 284 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 285 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 287 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 288 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 289 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 290 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 291 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 292 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 293 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 294 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 295 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 296 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 297 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 298 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 299 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 300 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 301 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 302 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 303 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 304 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 305 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 109 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 307 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 308 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 309 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 310 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 312 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 314 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 315 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 316 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 318 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 319 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 320 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 321 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 322 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 324 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 326 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 329 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 330 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 332 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 333 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 334 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 337 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 338 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 339 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 340 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 342 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 200 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 346 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 347 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 189 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 348 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 349 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 351 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 352 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 353 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 354 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 355 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 171 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 101 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 357 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 358 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 359 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 360 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 361 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 362 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 363 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 364 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 365 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 366 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 367 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 368 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 369 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 125 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 371 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 372 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 373 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 374 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 375 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 377 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 378 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 379 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 380 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 381 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 385 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 386 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 387 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 389 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 185 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 390 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 391 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 392 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 315 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 393 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 394 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 396 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 397 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 399 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 400 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 401 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 402 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 403 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 404 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 406 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 407 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 408 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 409 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 410 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 411 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 412 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 413 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 414 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 355 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 415 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 416 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 417 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 418 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 419 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 420 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 422 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 423 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 424 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 425 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 426 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 427 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 428 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 429 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 431 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 432 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 433 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 434 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 435 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 437 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 438 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 189 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 441 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 442 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 443 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 445 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 295 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 447 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 448 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 449 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 450 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 451 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 452 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 453 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 454 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 455 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 357 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 456 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 457 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 459 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 460 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 461 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 462 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 463 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 464 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 465 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 466 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 467 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 468 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 469 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 470 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 471 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 472 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 473 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 476 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 477 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 427 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 478 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 479 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 480 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 481 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 482 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 305 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 483 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 484 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 485 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 486 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 487 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 489 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 490 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 491 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 492 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 493 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 179 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 494 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 495 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 497 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 498 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 499 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 500 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 501 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 502 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 503 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 504 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 505 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 508 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 509 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 510 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 512 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 513 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 514 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 173 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 515 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 516 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 517 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 518 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 519 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 520 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 521 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 523 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 524 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 525 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 526 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 527 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 528 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 529 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 530 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 531 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 532 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 533 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 534 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 235 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 535 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 536 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 537 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 538 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 539 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 540 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 542 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 518 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 543 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 544 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 545 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 546 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 547 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 548 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 549 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 550 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 551 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 552 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 173 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 553 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 555 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 556 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 557 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 558 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 559 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 560 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 561 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 562 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 563 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 564 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 565 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 566 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 568 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 569 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 570 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 571 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 572 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 573 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 574 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 575 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 576 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 577 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 578 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 579 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 580 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 581 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 582 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 583 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 584 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 585 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 587 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 588 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 589 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 590 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 591 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 592 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 593 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 594 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 596 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 597 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 598 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 599 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 601 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 602 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 603 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 604 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 392 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 606 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 607 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 608 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 609 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 610 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 611 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 612 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 613 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 614 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 615 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 616 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 620 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 621 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 622 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 623 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 624 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 625 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 626 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 627 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 628 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 629 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 630 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 631 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 621 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 632 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 633 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 634 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 635 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 636 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 348 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 637 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 638 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 639 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 640 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 641 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 101 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 642 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 643 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 372 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 644 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 645 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 646 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 647 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 648 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 584 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 509 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 649 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 650 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 651 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 652 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 653 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 654 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 655 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 656 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 397 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 657 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 658 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 300 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 659 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 660 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 661 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 662 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 663 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 664 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 229 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 665 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 666 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 667 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 668 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 669 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 670 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 158 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 671 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 672 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 673 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 207 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 674 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 675 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 676 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 633 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 677 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 678 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 679 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 680 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 219 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 681 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 682 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 683 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 684 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 685 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 686 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 687 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 688 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 689 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 690 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 173 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 691 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 122 },
};
pub const data = blk: {
    @setEvalBranchQuota(1053);
    break :blk [_]Properties{
        .{ .tag = .aarch64_sve_pcs, .gnu = true },
        .{ .tag = .aarch64_vector_pcs, .gnu = true },
        .{ .tag = .access, .gnu = true },
        .{ .tag = .alias, .gnu = true },
        .{ .tag = .aligned, .declspec = true },
        .{ .tag = .aligned, .gnu = true },
        .{ .tag = .alloc_align, .gnu = true },
        .{ .tag = .alloc_size, .gnu = true },
        .{ .tag = .allocate, .declspec = true },
        .{ .tag = .allocator, .declspec = true },
        .{ .tag = .always_inline, .gnu = true },
        .{ .tag = .appdomain, .declspec = true },
        .{ .tag = .artificial, .gnu = true },
        .{ .tag = .assume_aligned, .gnu = true },
        .{ .tag = .availability, .gnu = true },
        .{ .tag = .cdecl, .gnu = true },
        .{ .tag = .cleanup, .gnu = true },
        .{ .tag = .code_seg, .declspec = true },
        .{ .tag = .cold, .gnu = true },
        .{ .tag = .common, .gnu = true },
        .{ .tag = .@"const", .gnu = true },
        .{ .tag = .constructor, .gnu = true },
        .{ .tag = .copy, .gnu = true },
        .{ .tag = .deprecated, .c23 = true, .gnu = true, .declspec = true },
        .{ .tag = .designated_init, .gnu = true },
        .{ .tag = .destructor, .gnu = true },
        .{ .tag = .dllexport, .declspec = true },
        .{ .tag = .dllimport, .declspec = true },
        .{ .tag = .@"error", .gnu = true },
        .{ .tag = .externally_visible, .gnu = true },
        .{ .tag = .fallthrough, .c23 = true, .gnu = true },
        .{ .tag = .fastcall, .gnu = true },
        .{ .tag = .flatten, .gnu = true },
        .{ .tag = .format, .gnu = true },
        .{ .tag = .format_arg, .gnu = true },
        .{ .tag = .gnu_inline, .gnu = true },
        .{ .tag = .hot, .gnu = true },
        .{ .tag = .ifunc, .gnu = true },
        .{ .tag = .internal_linkage, .gnu = true },
        .{ .tag = .interrupt, .gnu = true },
        .{ .tag = .interrupt_handler, .gnu = true },
        .{ .tag = .jitintrinsic, .declspec = true },
        .{ .tag = .leaf, .gnu = true },
        .{ .tag = .malloc, .gnu = true },
        .{ .tag = .may_alias, .gnu = true },
        .{ .tag = .unused, .c23 = true },
        .{ .tag = .mode, .gnu = true },
        .{ .tag = .ms_abi, .gnu = true },
        .{ .tag = .naked, .declspec = true },
        .{ .tag = .no_address_safety_analysis, .gnu = true },
        .{ .tag = .no_icf, .gnu = true },
        .{ .tag = .no_instrument_function, .gnu = true },
        .{ .tag = .no_profile_instrument_function, .gnu = true },
        .{ .tag = .no_reorder, .gnu = true },
        .{ .tag = .no_sanitize, .gnu = true },
        .{ .tag = .no_sanitize_address, .gnu = true, .declspec = true },
        .{ .tag = .no_sanitize_coverage, .gnu = true },
        .{ .tag = .no_sanitize_thread, .gnu = true },
        .{ .tag = .no_sanitize_undefined, .gnu = true },
        .{ .tag = .no_split_stack, .gnu = true },
        .{ .tag = .no_stack_limit, .gnu = true },
        .{ .tag = .no_stack_protector, .gnu = true },
        .{ .tag = .@"noalias", .declspec = true },
        .{ .tag = .noclone, .gnu = true },
        .{ .tag = .nocommon, .gnu = true },
        .{ .tag = .nodiscard, .c23 = true },
        .{ .tag = .noinit, .gnu = true },
        .{ .tag = .@"noinline", .gnu = true, .declspec = true },
        .{ .tag = .noipa, .gnu = true },
        .{ .tag = .nonstring, .gnu = true },
        .{ .tag = .noplt, .gnu = true },
        .{ .tag = .@"noreturn", .c23 = true, .gnu = true, .declspec = true },
        .{ .tag = .nothrow, .gnu = true },
        .{ .tag = .@"packed", .gnu = true },
        .{ .tag = .patchable_function_entry, .gnu = true },
        .{ .tag = .pcs, .gnu = true },
        .{ .tag = .persistent, .gnu = true },
        .{ .tag = .process, .declspec = true },
        .{ .tag = .pure, .gnu = true },
        .{ .tag = .reproducible, .c23 = true },
        .{ .tag = .restrict, .declspec = true },
        .{ .tag = .retain, .gnu = true },
        .{ .tag = .returns_nonnull, .gnu = true },
        .{ .tag = .returns_twice, .gnu = true },
        .{ .tag = .riscv_vector_cc, .gnu = true },
        .{ .tag = .safebuffers, .declspec = true },
        .{ .tag = .scalar_storage_order, .gnu = true },
        .{ .tag = .section, .gnu = true },
        .{ .tag = .selectany, .gnu = true, .declspec = true },
        .{ .tag = .sentinel, .gnu = true },
        .{ .tag = .simd, .gnu = true },
        .{ .tag = .spectre, .declspec = true },
        .{ .tag = .stack_protect, .gnu = true },
        .{ .tag = .stdcall, .gnu = true },
        .{ .tag = .symver, .gnu = true },
        .{ .tag = .sysv_abi, .gnu = true },
        .{ .tag = .target, .gnu = true },
        .{ .tag = .target_clones, .gnu = true },
        .{ .tag = .thiscall, .gnu = true },
        .{ .tag = .thread, .declspec = true },
        .{ .tag = .tls_model, .gnu = true },
        .{ .tag = .transparent_union, .gnu = true },
        .{ .tag = .unavailable, .gnu = true },
        .{ .tag = .uninitialized, .gnu = true },
        .{ .tag = .unsequenced, .c23 = true },
        .{ .tag = .unused, .gnu = true },
        .{ .tag = .used, .gnu = true },
        .{ .tag = .uuid, .declspec = true },
        .{ .tag = .vector_size, .gnu = true },
        .{ .tag = .vectorcall, .gnu = true },
        .{ .tag = .visibility, .gnu = true },
        .{ .tag = .warn_if_not_aligned, .gnu = true },
        .{ .tag = .warn_unused_result, .gnu = true },
        .{ .tag = .warning, .gnu = true },
        .{ .tag = .weak, .gnu = true },
        .{ .tag = .weakref, .gnu = true },
        .{ .tag = .zero_call_used_regs, .gnu = true },
    };
};
};
}
