const common = @import("./common.zig");
const truncf = @import("./truncf.zig").truncf;

comptime {
    if (common.want_aeabi) {
        @export(&__aeabi_d2f, .{ .name = "__aeabi_d2f", .linkage = common.linkage, .visibility = common.visibility });
    } else {
        @export(&__truncdfsf2, .{ .name = "__truncdfsf2", .linkage = common.linkage, .visibility = common.visibility });
    }
}

pub fn __truncdfsf2(a: f64) callconv(.c) f32 {
    return truncf(f32, f64, a);
}

fn __aeabi_d2f(a: f64) callconv(.{ .arm_aapcs = .{} }) f32 {
    return truncf(f32, f64, a);
}
