const common = @import("./common.zig");
const floatFromInt = @import("./float_from_int.zig").floatFromInt;

comptime {
    if (common.want_aeabi) {
        @export(&__aeabi_i2d, .{ .name = "__aeabi_i2d", .linkage = common.linkage, .visibility = common.visibility });
    } else {
        @export(&__floatsidf, .{ .name = "__floatsidf", .linkage = common.linkage, .visibility = common.visibility });
    }
}

pub fn __floatsidf(a: i32) callconv(.c) f64 {
    return floatFromInt(f64, a);
}

fn __aeabi_i2d(a: i32) callconv(.{ .arm_aapcs = .{} }) f64 {
    return floatFromInt(f64, a);
}
