//! Autogenerated by GenerateDef from src/aro/Builtins/x86_64.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    _BitScanForward64,
    _BitScanReverse64,
    _InterlockedCompareExchange128,
    __builtin_ia32_aadd64,
    __builtin_ia32_aand64,
    __builtin_ia32_addcarryx_u64,
    __builtin_ia32_aor64,
    __builtin_ia32_axor64,
    __builtin_ia32_bextr_u64,
    __builtin_ia32_bextri_u64,
    __builtin_ia32_bzhi_di,
    __builtin_ia32_clui,
    __builtin_ia32_cmpccxadd32,
    __builtin_ia32_cmpccxadd64,
    __builtin_ia32_crc32di,
    __builtin_ia32_cvtsd2si64,
    __builtin_ia32_cvtsi2sd64,
    __builtin_ia32_cvtsi2ss64,
    __builtin_ia32_cvtss2si64,
    __builtin_ia32_cvttsd2si64,
    __builtin_ia32_cvttss2si64,
    __builtin_ia32_cvtusi2sd64,
    __builtin_ia32_cvtusi2ss64,
    __builtin_ia32_directstore_u64,
    __builtin_ia32_fxrstor64,
    __builtin_ia32_fxsave64,
    __builtin_ia32_incsspq,
    __builtin_ia32_lwpins64,
    __builtin_ia32_lwpval64,
    __builtin_ia32_lzcnt_u64,
    __builtin_ia32_movnti64,
    __builtin_ia32_movrsdi,
    __builtin_ia32_movrshi,
    __builtin_ia32_movrsqi,
    __builtin_ia32_movrssi,
    __builtin_ia32_pdep_di,
    __builtin_ia32_pext_di,
    __builtin_ia32_prefetchi,
    __builtin_ia32_ptwrite64,
    __builtin_ia32_rdfsbase32,
    __builtin_ia32_rdfsbase64,
    __builtin_ia32_rdgsbase32,
    __builtin_ia32_rdgsbase64,
    __builtin_ia32_rdrand64_step,
    __builtin_ia32_rdseed64_step,
    __builtin_ia32_rdsspq,
    __builtin_ia32_readeflags_u64,
    __builtin_ia32_senduipi,
    __builtin_ia32_stui,
    __builtin_ia32_subborrow_u64,
    __builtin_ia32_t2rpntlvwz0,
    __builtin_ia32_t2rpntlvwz0_internal,
    __builtin_ia32_t2rpntlvwz0rs,
    __builtin_ia32_t2rpntlvwz0rs_internal,
    __builtin_ia32_t2rpntlvwz0rst1,
    __builtin_ia32_t2rpntlvwz0rst1_internal,
    __builtin_ia32_t2rpntlvwz0t1,
    __builtin_ia32_t2rpntlvwz0t1_internal,
    __builtin_ia32_t2rpntlvwz1,
    __builtin_ia32_t2rpntlvwz1_internal,
    __builtin_ia32_t2rpntlvwz1rs,
    __builtin_ia32_t2rpntlvwz1rs_internal,
    __builtin_ia32_t2rpntlvwz1rst1,
    __builtin_ia32_t2rpntlvwz1rst1_internal,
    __builtin_ia32_t2rpntlvwz1t1,
    __builtin_ia32_t2rpntlvwz1t1_internal,
    __builtin_ia32_tcmmimfp16ps,
    __builtin_ia32_tcmmimfp16ps_internal,
    __builtin_ia32_tcmmrlfp16ps,
    __builtin_ia32_tcmmrlfp16ps_internal,
    __builtin_ia32_tconjtcmmimfp16ps,
    __builtin_ia32_tconjtcmmimfp16ps_internal,
    __builtin_ia32_tconjtfp16,
    __builtin_ia32_tconjtfp16_internal,
    __builtin_ia32_tcvtrowd2ps,
    __builtin_ia32_tcvtrowd2ps_internal,
    __builtin_ia32_tcvtrowps2bf16h,
    __builtin_ia32_tcvtrowps2bf16h_internal,
    __builtin_ia32_tcvtrowps2bf16l,
    __builtin_ia32_tcvtrowps2bf16l_internal,
    __builtin_ia32_tcvtrowps2phh,
    __builtin_ia32_tcvtrowps2phh_internal,
    __builtin_ia32_tcvtrowps2phl,
    __builtin_ia32_tcvtrowps2phl_internal,
    __builtin_ia32_tdpbf16ps,
    __builtin_ia32_tdpbf16ps_internal,
    __builtin_ia32_tdpbf8ps,
    __builtin_ia32_tdpbf8ps_internal,
    __builtin_ia32_tdpbhf8ps,
    __builtin_ia32_tdpbhf8ps_internal,
    __builtin_ia32_tdpbssd,
    __builtin_ia32_tdpbssd_internal,
    __builtin_ia32_tdpbsud,
    __builtin_ia32_tdpbsud_internal,
    __builtin_ia32_tdpbusd,
    __builtin_ia32_tdpbusd_internal,
    __builtin_ia32_tdpbuud,
    __builtin_ia32_tdpbuud_internal,
    __builtin_ia32_tdpfp16ps,
    __builtin_ia32_tdpfp16ps_internal,
    __builtin_ia32_tdphbf8ps,
    __builtin_ia32_tdphbf8ps_internal,
    __builtin_ia32_tdphf8ps,
    __builtin_ia32_tdphf8ps_internal,
    __builtin_ia32_testui,
    __builtin_ia32_tile_loadconfig,
    __builtin_ia32_tile_loadconfig_internal,
    __builtin_ia32_tile_storeconfig,
    __builtin_ia32_tileloadd64,
    __builtin_ia32_tileloadd64_internal,
    __builtin_ia32_tileloaddrs64,
    __builtin_ia32_tileloaddrs64_internal,
    __builtin_ia32_tileloaddrst164,
    __builtin_ia32_tileloaddrst164_internal,
    __builtin_ia32_tileloaddt164,
    __builtin_ia32_tileloaddt164_internal,
    __builtin_ia32_tilemovrow,
    __builtin_ia32_tilemovrow_internal,
    __builtin_ia32_tilerelease,
    __builtin_ia32_tilestored64,
    __builtin_ia32_tilestored64_internal,
    __builtin_ia32_tilezero,
    __builtin_ia32_tilezero_internal,
    __builtin_ia32_tmmultf32ps,
    __builtin_ia32_tmmultf32ps_internal,
    __builtin_ia32_ttcmmimfp16ps,
    __builtin_ia32_ttcmmimfp16ps_internal,
    __builtin_ia32_ttcmmrlfp16ps,
    __builtin_ia32_ttcmmrlfp16ps_internal,
    __builtin_ia32_ttdpbf16ps,
    __builtin_ia32_ttdpbf16ps_internal,
    __builtin_ia32_ttdpfp16ps,
    __builtin_ia32_ttdpfp16ps_internal,
    __builtin_ia32_ttmmultf32ps,
    __builtin_ia32_ttmmultf32ps_internal,
    __builtin_ia32_ttransposed,
    __builtin_ia32_ttransposed_internal,
    __builtin_ia32_tzcnt_u64,
    __builtin_ia32_urdmsr,
    __builtin_ia32_uwrmsr,
    __builtin_ia32_vcvtsd2si64,
    __builtin_ia32_vcvtsd2usi64,
    __builtin_ia32_vcvtsh2si64,
    __builtin_ia32_vcvtsh2usi64,
    __builtin_ia32_vcvtsi642sh,
    __builtin_ia32_vcvtss2si64,
    __builtin_ia32_vcvtss2usi64,
    __builtin_ia32_vcvttsd2si64,
    __builtin_ia32_vcvttsd2sis64,
    __builtin_ia32_vcvttsd2usi64,
    __builtin_ia32_vcvttsd2usis64,
    __builtin_ia32_vcvttsh2si64,
    __builtin_ia32_vcvttsh2usi64,
    __builtin_ia32_vcvttss2si64,
    __builtin_ia32_vcvttss2sis64,
    __builtin_ia32_vcvttss2usi64,
    __builtin_ia32_vcvttss2usis64,
    __builtin_ia32_vcvtusi642sh,
    __builtin_ia32_vec_ext_v4di,
    __builtin_ia32_vec_set_v2di,
    __builtin_ia32_vec_set_v4di,
    __builtin_ia32_vmovrsb128,
    __builtin_ia32_vmovrsb256,
    __builtin_ia32_vmovrsb512,
    __builtin_ia32_vmovrsd128,
    __builtin_ia32_vmovrsd256,
    __builtin_ia32_vmovrsd512,
    __builtin_ia32_vmovrsq128,
    __builtin_ia32_vmovrsq256,
    __builtin_ia32_vmovrsq512,
    __builtin_ia32_vmovrsw128,
    __builtin_ia32_vmovrsw256,
    __builtin_ia32_vmovrsw512,
    __builtin_ia32_wrfsbase32,
    __builtin_ia32_wrfsbase64,
    __builtin_ia32_wrgsbase32,
    __builtin_ia32_wrgsbase64,
    __builtin_ia32_writeeflags_u64,
    __builtin_ia32_wrssq,
    __builtin_ia32_wrussq,
    __builtin_ia32_xrstor64,
    __builtin_ia32_xrstors64,
    __builtin_ia32_xsave64,
    __builtin_ia32_xsavec64,
    __builtin_ia32_xsaveopt64,
    __builtin_ia32_xsaves64,
    __faststorefence,
    __mulh,
    __shiftleft128,
    __shiftright128,
    __umulh,
    _mul128,
    _umul128,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 6;
pub const longest_name = 41;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(386);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 193, .child_index = 2 },
    .{ .char = 'B', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 7 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 8 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 188, .child_index = 9 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 14 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 15 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 16 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 17 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 183, .child_index = 18 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 19 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 20 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 21 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 22 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 23 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 14 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 24 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 25 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 26 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 27 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 28 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 29 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 20 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 31 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 32 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 33 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 34 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 35 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 36 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 37 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 38 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 39 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 40 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 41 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 42 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 43 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 44 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 45 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 46 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 47 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 48 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 50 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 52 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 53 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 54 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 55 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 56 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 57 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 58 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 59 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 60 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 61 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 62 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 63 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 64 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 65 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 67 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 69 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 70 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 71 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 72 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 73 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 74 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 75 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 69 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 76 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 77 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 78 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 79 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 80 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 81 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 82 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 83 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 84 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 85 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 86 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 87 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 88 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 89 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 90 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 92 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 183, .child_index = 93 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 109 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 110 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 111 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 112 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 116 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 118 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 122 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 123 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 124 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 125 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 127 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 128 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 132 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 134 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 88, .child_index = 137 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 145 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = false, .number = 33, .child_index = 147 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 150 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 151 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 154 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 156 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 157 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 158 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 159 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 160 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 161 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 162 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 163 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 164 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 165 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 166 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 169 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 171 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 172 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 173 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 174 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 175 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 176 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 180 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 181 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 161 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 182 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 16, .child_index = 183 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 184 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 20, .child_index = 187 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 188 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 189 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 190 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 191 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 170 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 195 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 196 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 18, .child_index = 197 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 198 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 199 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 200 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 205 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 206 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 207 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 86 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 86 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 208 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 157 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 209 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 210 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 212 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 213 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 214 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 217 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 218 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 219 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 220 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 221 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 224 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 226 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 227 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 228 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 229 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 230 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 230 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 231 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 232 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 234 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 235 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 236 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 237 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 238 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 239 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 240 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 20, .child_index = 241 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 244 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 245 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 246 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 247 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 248 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 190 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 249 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 250 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 251 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 252 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 253 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 230 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 230 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 254 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 255 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 256 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 257 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 258 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 259 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 261 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 263 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 264 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 265 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 268 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 269 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 270 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 271 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 272 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 273 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 274 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 275 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 276 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 277 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 278 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 279 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 280 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 281 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 282 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 283 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 284 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 285 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 286 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 287 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 288 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 289 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 291 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 292 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 293 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 297 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 298 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 161 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 300 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 306 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 238 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 307 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 309 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 310 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 18, .child_index = 311 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 314 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 316 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 317 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 318 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 255 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 319 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 320 },
    .{ .char = 'E', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 321 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 322 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 323 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 326 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 327 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 328 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 329 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 331 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 332 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 158 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 87 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 284 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 333 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 334 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 337 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 341 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 342 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 343 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 318 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 346 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 347 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 348 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 349 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 350 },
    .{ .char = 'j', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 351 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 352 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 353 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 355 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 356 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 356 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 358 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 355 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 359 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 360 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 362 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 363 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 364 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 365 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 366 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 367 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 368 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 297 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 369 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 371 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 375 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 377 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 378 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 379 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 285 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 380 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 381 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 385 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 386 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 387 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 388 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 389 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 390 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 327 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 327 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 328 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 391 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 387 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 211 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 211 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 211 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 392 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 87 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 393 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 394 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 396 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 397 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 398 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 399 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 399 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 400 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 402 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 403 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 404 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 359 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 405 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 405 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 403 },
    .{ .char = '8', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 404 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 406 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 407 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 408 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 409 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 410 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 411 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 412 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 413 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 358 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 414 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 415 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 415 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 416 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 415 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 417 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 420 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 422 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 12, .child_index = 423 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 427 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 91 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 429 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 431 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 432 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 433 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 436 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 437 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 438 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 441 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 297 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 442 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 443 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 444 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 404 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 446 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 448 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 449 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 450 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 451 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 452 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 453 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 454 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 455 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 456 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 457 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 459 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 460 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 415 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 460 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 416 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 461 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 462 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 463 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 463 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 463 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 463 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 466 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 467 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 468 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 469 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 91 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 470 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 211 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 471 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 473 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 476 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 477 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 478 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 479 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 480 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 481 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 482 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 483 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 484 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 485 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 486 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 487 },
    .{ .char = 'o', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 479 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 488 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 336 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 389 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 489 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 490 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 492 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 493 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 37 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 494 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 495 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 471 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 497 },
    .{ .char = '3', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 498 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 110 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 499 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 500 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 501 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 502 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 503 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 404 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 504 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 505 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 506 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 508 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 511 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 512 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 513 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 514 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 515 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 516 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 517 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 518 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 519 },
    .{ .char = '5', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 521 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 498 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 523 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 524 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 16, .child_index = 525 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 349 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 527 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 529 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 530 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 531 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 532 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 533 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 534 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 109 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 535 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 405 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 35 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 427 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 516 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = '2', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 325 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 536 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 537 },
    .{ .char = '0', .end_of_word = true, .end_of_list = false, .number = 8, .child_index = 538 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 8, .child_index = 538 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 541 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 542 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 543 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 544 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 545 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 546 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 535 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 532 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 548 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 481 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 549 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 550 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 551 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 552 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 555 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 556 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 532 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 534 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 557 },
    .{ .char = '1', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 559 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 447 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 560 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 561 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 562 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 481 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 550 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 552 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 563 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 564 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 565 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 566 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 447 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 567 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
};
pub const data = blk: {
    @setEvalBranchQuota(1737);
    break :blk [_]Properties{
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcLLiD*LLiLLiLLi*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "vv*SOi", .features = "raoint" },
        .{ .param_str = "vv*SOi", .features = "raoint" },
        .{ .param_str = "UcUcUOiUOiUOi*", .attributes = .{ .const_evaluable = true } },
        .{ .param_str = "vv*SOi", .features = "raoint" },
        .{ .param_str = "vv*SOi", .features = "raoint" },
        .{ .param_str = "UOiUOiUOi", .features = "bmi", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "UOiUOiIUOi", .features = "tbm", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "UOiUOiUOi", .features = "bmi2", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "v", .features = "uintr" },
        .{ .param_str = "Siv*SiSiIi", .features = "cmpccxadd" },
        .{ .param_str = "SOiSOi*SOiSOiIi", .features = "cmpccxadd" },
        .{ .param_str = "UOiUOiUOi", .features = "crc32", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV2d", .features = "sse2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V2dV2dOiIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4fV4fOiIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4f", .features = "sse", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV2d", .features = "sse2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4f", .features = "sse", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V2dV2dUOiIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4fV4fUOiIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vULi*ULi", .features = "movdiri" },
        .{ .param_str = "vv*", .features = "fxsr" },
        .{ .param_str = "vv*", .features = "fxsr" },
        .{ .param_str = "vUOi", .features = "shstk" },
        .{ .param_str = "UcUOiUiIUi", .features = "lwp" },
        .{ .param_str = "vUOiUiIUi", .features = "lwp" },
        .{ .param_str = "UOiUOi", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "vOi*Oi", .features = "sse2" },
        .{ .param_str = "SOivC*", .features = "movrs" },
        .{ .param_str = "SsvC*", .features = "movrs" },
        .{ .param_str = "ScvC*", .features = "movrs" },
        .{ .param_str = "SivC*", .features = "movrs" },
        .{ .param_str = "UOiUOiUOi", .features = "bmi2", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "UOiUOiUOi", .features = "bmi2", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "vvC*Ui", .features = "prefetchi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUOi", .features = "ptwrite" },
        .{ .param_str = "Ui", .features = "fsgsbase" },
        .{ .param_str = "UOi", .features = "fsgsbase" },
        .{ .param_str = "Ui", .features = "fsgsbase" },
        .{ .param_str = "UOi", .features = "fsgsbase" },
        .{ .param_str = "UiUOi*", .features = "rdrnd" },
        .{ .param_str = "UiUOi*", .features = "rdseed" },
        .{ .param_str = "UOiUOi", .features = "shstk" },
        .{ .param_str = "UOi" },
        .{ .param_str = "vUWi", .features = "uintr" },
        .{ .param_str = "v", .features = "uintr" },
        .{ .param_str = "UcUcUOiUOiUOi*", .attributes = .{ .const_evaluable = true } },
        .{ .param_str = "vIUcvC*z", .features = "amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_movrs,amx_transpose" },
        .{ .param_str = "vIUcvC*z", .features = "amx_transpose" },
        .{ .param_str = "vUsUsUsV256i*V256i*vC*z", .features = "amx_transpose" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_complex" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_complex" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_complex" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_complex" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "vIUcIUc", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "V256iUsUsV256i", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "V16fIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V16fUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32yIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32yUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32yIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32yUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32xIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32xUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32xIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V32xUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_bf16" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_bf16" },
        .{ .param_str = "vIUcUIcUIc", .features = "amx_fp8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp8" },
        .{ .param_str = "vIUcUIcUIc", .features = "amx_fp8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp8" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_int8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_int8" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_int8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_int8" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_int8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_int8" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_int8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_int8" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_fp16" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp16" },
        .{ .param_str = "vIUcUIcUIc", .features = "amx_fp8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp8" },
        .{ .param_str = "vIUcUIcUIc", .features = "amx_fp8" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp8" },
        .{ .param_str = "Uc", .features = "uintr" },
        .{ .param_str = "vvC*", .features = "amx_tile" },
        .{ .param_str = "vvC*", .features = "amx_tile" },
        .{ .param_str = "vvC*", .features = "amx_tile" },
        .{ .param_str = "vIUcvC*z", .features = "amx_tile" },
        .{ .param_str = "V256iUsUsvC*z", .features = "amx_tile" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs" },
        .{ .param_str = "V256iUsUsvC*z", .features = "amx_movrs" },
        .{ .param_str = "vIUcvC*z", .features = "amx_movrs" },
        .{ .param_str = "V256iUsUsvC*z", .features = "amx_movrs" },
        .{ .param_str = "vIUcvC*z", .features = "amx_tile" },
        .{ .param_str = "V256iUsUsvC*z", .features = "amx_tile" },
        .{ .param_str = "V16iIUcUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "V16iUsUsV256iUi", .features = "amx_avx512,avx10_2" },
        .{ .param_str = "v", .features = "amx_tile" },
        .{ .param_str = "vIUcv*z", .features = "amx_tile" },
        .{ .param_str = "vUsUsv*zV256i", .features = "amx_tile" },
        .{ .param_str = "vUc", .features = "amx_tile" },
        .{ .param_str = "V256iUsUs", .features = "amx_tile" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_tf32" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_tf32" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_complex,amx_transpose" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_bf16,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_bf16,amx_transpose" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_fp16,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_fp16,amx_transpose" },
        .{ .param_str = "vIUcIUcIUc", .features = "amx_tf32,amx_transpose" },
        .{ .param_str = "V256iUsUsUsV256iV256iV256i", .features = "amx_tf32,amx_transpose" },
        .{ .param_str = "vIUcIUc", .features = "amx_transpose" },
        .{ .param_str = "V256iUsUsV256i", .features = "amx_transpose" },
        .{ .param_str = "UOiUOi", .attributes = .{ .@"const" = true, .const_evaluable = true } },
        .{ .param_str = "UOiUOi", .features = "usermsr" },
        .{ .param_str = "vUOiUOi", .features = "usermsr" },
        .{ .param_str = "OiV2dIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV2dIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV8xIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV8xIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V8xV8xOiIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4fIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV4fIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV2dIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV2dIi", .features = "avx10_2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV2dIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV2dIi", .features = "avx10_2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV8xIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV8xIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4fIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4fIi", .features = "avx10_2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV4fIi", .features = "avx512f", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UOiV4fIi", .features = "avx10_2", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V8xV8xUOiIi", .features = "avx512fp16", .attributes = .{ .@"const" = true } },
        .{ .param_str = "OiV4OiIi", .features = "avx", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V2OiV2OiOiIi", .features = "sse4_1", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V4OiV4OiOiIi", .features = "avx", .attributes = .{ .@"const" = true } },
        .{ .param_str = "V16cV16cC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V32cV32cC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V64cV64cC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V4iV4iC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V8iV8iC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V16iV16iC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V2OiV2OiC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V4OiV4OiC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V8OiV8OiC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V8sV8sC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V16sV16sC*", .features = "movrs,avx10_2" },
        .{ .param_str = "V32sV32sC*", .features = "movrs,avx10_2" },
        .{ .param_str = "vUi", .features = "fsgsbase" },
        .{ .param_str = "vUOi", .features = "fsgsbase" },
        .{ .param_str = "vUi", .features = "fsgsbase" },
        .{ .param_str = "vUOi", .features = "fsgsbase" },
        .{ .param_str = "vUOi" },
        .{ .param_str = "vUOiv*", .features = "shstk" },
        .{ .param_str = "vUOiv*", .features = "shstk" },
        .{ .param_str = "vv*UOi", .features = "xsave" },
        .{ .param_str = "vv*UOi", .features = "xsaves" },
        .{ .param_str = "vv*UOi", .features = "xsave" },
        .{ .param_str = "vv*UOi", .features = "xsavec" },
        .{ .param_str = "vv*UOi", .features = "xsaveopt" },
        .{ .param_str = "vv*UOi", .features = "xsaves" },
        .{ .param_str = "v", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiLLi", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
        .{ .param_str = "ULLiULLiULLiUc", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
        .{ .param_str = "ULLiULLiULLiUc", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
        .{ .param_str = "ULLiULLiULLi", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLiLLiLLiLLi*", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
        .{ .param_str = "ULLiULLiULLiULLi*", .header = .intrin, .language = .all_ms_languages, .attributes = .{ .@"const" = true } },
    };
};
};
}
