/*	$OpenBSD: videoio.h,v 1.26 2025/08/02 09:27:59 kirill Exp $	*/

/*
 *  Video for Linux Two header file
 *
 *  Copyright (C) 1999-2012 the contributors
 *  Copyright (C) 2012 Nokia Corporation
 *  Contact: Sakari Ailus <sakari.ailus@iki.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  Alternatively you can redistribute this file under the terms of the
 *  BSD license as stated below:
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *  3. The names of its contributors may not be used to endorse or promote
 *     products derived from this software without specific prior written
 *     permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	Header file for v4l or V4L2 drivers and applications
 * with public API.
 * All kernel-specific stuff were moved to media/v4l2-dev.h, so
 * no #if __KERNEL tests are allowed here
 *
 *	See https://linuxtv.org for more info
 *
 *	Author: Bill Dirks <bill@thedirks.org>
 *		Justin Schoeman
 *              Hans Verkuil <hverkuil@xs4all.nl>
 *		et al.
 */

#ifndef _SYS_VIDEOIO_H_
#define _SYS_VIDEOIO_H_
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioccom.h>
/* Inline #include <linux/v4l2-common.h>
 * (v4l2-common.h was split off from videodev2.h and has the same BSD license.)
 *
 * Begin of v4l2-common.h
 */
/*
 *
 * Selection interface definitions
 *
 */

/* Current cropping area */
#define V4L2_SEL_TGT_CROP		0x0000
/* Default cropping area */
#define V4L2_SEL_TGT_CROP_DEFAULT	0x0001
/* Cropping bounds */
#define V4L2_SEL_TGT_CROP_BOUNDS	0x0002
/* Native frame size */
#define V4L2_SEL_TGT_NATIVE_SIZE	0x0003
/* Current composing area */
#define V4L2_SEL_TGT_COMPOSE		0x0100
/* Default composing area */
#define V4L2_SEL_TGT_COMPOSE_DEFAULT	0x0101
/* Composing bounds */
#define V4L2_SEL_TGT_COMPOSE_BOUNDS	0x0102
/* Current composing area plus all padding pixels */
#define V4L2_SEL_TGT_COMPOSE_PADDED	0x0103

/* Backward compatibility target definitions --- to be removed. */
#define V4L2_SEL_TGT_CROP_ACTIVE	V4L2_SEL_TGT_CROP
#define V4L2_SEL_TGT_COMPOSE_ACTIVE	V4L2_SEL_TGT_COMPOSE
#define V4L2_SUBDEV_SEL_TGT_CROP_ACTUAL	V4L2_SEL_TGT_CROP
#define V4L2_SUBDEV_SEL_TGT_COMPOSE_ACTUAL V4L2_SEL_TGT_COMPOSE
#define V4L2_SUBDEV_SEL_TGT_CROP_BOUNDS	V4L2_SEL_TGT_CROP_BOUNDS
#define V4L2_SUBDEV_SEL_TGT_COMPOSE_BOUNDS V4L2_SEL_TGT_COMPOSE_BOUNDS

/* Selection flags */
#define V4L2_SEL_FLAG_GE		(1 << 0)
#define V4L2_SEL_FLAG_LE		(1 << 1)
#define V4L2_SEL_FLAG_KEEP_CONFIG	(1 << 2)

struct v4l2_edid {
	u_int32_t pad;
	u_int32_t start_block;
	u_int32_t blocks;
	u_int32_t reserved[5];
	u_int8_t  *edid;
};

/* Backward compatibility target definitions --- to be removed. */
#define V4L2_SEL_TGT_CROP_ACTIVE	V4L2_SEL_TGT_CROP
#define V4L2_SEL_TGT_COMPOSE_ACTIVE	V4L2_SEL_TGT_COMPOSE
#define V4L2_SUBDEV_SEL_TGT_CROP_ACTUAL	V4L2_SEL_TGT_CROP
#define V4L2_SUBDEV_SEL_TGT_COMPOSE_ACTUAL V4L2_SEL_TGT_COMPOSE
#define V4L2_SUBDEV_SEL_TGT_CROP_BOUNDS	V4L2_SEL_TGT_CROP_BOUNDS
#define V4L2_SUBDEV_SEL_TGT_COMPOSE_BOUNDS V4L2_SEL_TGT_COMPOSE_BOUNDS

/* Backward compatibility flag definitions --- to be removed. */
#define V4L2_SUBDEV_SEL_FLAG_SIZE_GE	V4L2_SEL_FLAG_GE
#define V4L2_SUBDEV_SEL_FLAG_SIZE_LE	V4L2_SEL_FLAG_LE
#define V4L2_SUBDEV_SEL_FLAG_KEEP_CONFIG V4L2_SEL_FLAG_KEEP_CONFIG
/*
 * End of v4l2-common.h
 */
/* Inline #include <linux/v4l2-controls.h>
 * (v4l2-controls.h was split off from videodev2.h and has the same BSD license.)
 *
 * Begin of v4l2-controls.h
 */
/* Control classes */
#define V4L2_CTRL_CLASS_USER		0x00980000	/* Old-style 'user' controls */
#define V4L2_CTRL_CLASS_CODEC		0x00990000	/* Stateful codec controls */
#define V4L2_CTRL_CLASS_CAMERA		0x009a0000	/* Camera class controls */
#define V4L2_CTRL_CLASS_FM_TX		0x009b0000	/* FM Modulator controls */
#define V4L2_CTRL_CLASS_FLASH		0x009c0000	/* Camera flash controls */
#define V4L2_CTRL_CLASS_JPEG		0x009d0000	/* JPEG-compression controls */
#define V4L2_CTRL_CLASS_IMAGE_SOURCE	0x009e0000	/* Image source controls */
#define V4L2_CTRL_CLASS_IMAGE_PROC	0x009f0000	/* Image processing controls */
#define V4L2_CTRL_CLASS_DV		0x00a00000	/* Digital Video controls */
#define V4L2_CTRL_CLASS_FM_RX		0x00a10000	/* FM Receiver controls */
#define V4L2_CTRL_CLASS_RF_TUNER	0x00a20000	/* RF tuner controls */
#define V4L2_CTRL_CLASS_DETECT		0x00a30000	/* Detection controls */
#define V4L2_CTRL_CLASS_CODEC_STATELESS 0x00a40000	/* Stateless codecs controls */
#define V4L2_CTRL_CLASS_COLORIMETRY	0x00a50000	/* Colorimetry controls */

/* User-class control IDs */

#define V4L2_CID_BASE			(V4L2_CTRL_CLASS_USER | 0x900)
#define V4L2_CID_USER_BASE		V4L2_CID_BASE
#define V4L2_CID_USER_CLASS		(V4L2_CTRL_CLASS_USER | 1)
#define V4L2_CID_BRIGHTNESS		(V4L2_CID_BASE+0)
#define V4L2_CID_CONTRAST		(V4L2_CID_BASE+1)
#define V4L2_CID_SATURATION		(V4L2_CID_BASE+2)
#define V4L2_CID_HUE			(V4L2_CID_BASE+3)
#define V4L2_CID_AUDIO_VOLUME		(V4L2_CID_BASE+5)
#define V4L2_CID_AUDIO_BALANCE		(V4L2_CID_BASE+6)
#define V4L2_CID_AUDIO_BASS		(V4L2_CID_BASE+7)
#define V4L2_CID_AUDIO_TREBLE		(V4L2_CID_BASE+8)
#define V4L2_CID_AUDIO_MUTE		(V4L2_CID_BASE+9)
#define V4L2_CID_AUDIO_LOUDNESS		(V4L2_CID_BASE+10)
#define V4L2_CID_BLACK_LEVEL		(V4L2_CID_BASE+11) /* Deprecated */
#define V4L2_CID_AUTO_WHITE_BALANCE	(V4L2_CID_BASE+12)
#define V4L2_CID_DO_WHITE_BALANCE	(V4L2_CID_BASE+13)
#define V4L2_CID_RED_BALANCE		(V4L2_CID_BASE+14)
#define V4L2_CID_BLUE_BALANCE		(V4L2_CID_BASE+15)
#define V4L2_CID_GAMMA			(V4L2_CID_BASE+16)
#define V4L2_CID_WHITENESS		(V4L2_CID_GAMMA) /* Deprecated */
#define V4L2_CID_EXPOSURE		(V4L2_CID_BASE+17)
#define V4L2_CID_AUTOGAIN		(V4L2_CID_BASE+18)
#define V4L2_CID_GAIN			(V4L2_CID_BASE+19)
#define V4L2_CID_HFLIP			(V4L2_CID_BASE+20)
#define V4L2_CID_VFLIP			(V4L2_CID_BASE+21)

#define V4L2_CID_POWER_LINE_FREQUENCY	(V4L2_CID_BASE+24)
enum v4l2_power_line_frequency {
	V4L2_CID_POWER_LINE_FREQUENCY_DISABLED	= 0,
	V4L2_CID_POWER_LINE_FREQUENCY_50HZ	= 1,
	V4L2_CID_POWER_LINE_FREQUENCY_60HZ	= 2,
	V4L2_CID_POWER_LINE_FREQUENCY_AUTO	= 3,
};
#define V4L2_CID_HUE_AUTO			(V4L2_CID_BASE+25)
#define V4L2_CID_WHITE_BALANCE_TEMPERATURE	(V4L2_CID_BASE+26)
#define V4L2_CID_SHARPNESS			(V4L2_CID_BASE+27)
#define V4L2_CID_BACKLIGHT_COMPENSATION		(V4L2_CID_BASE+28)
#define V4L2_CID_CHROMA_AGC                     (V4L2_CID_BASE+29)
#define V4L2_CID_COLOR_KILLER                   (V4L2_CID_BASE+30)
#define V4L2_CID_COLORFX			(V4L2_CID_BASE+31)
enum v4l2_colorfx {
	V4L2_COLORFX_NONE			= 0,
	V4L2_COLORFX_BW				= 1,
	V4L2_COLORFX_SEPIA			= 2,
	V4L2_COLORFX_NEGATIVE			= 3,
	V4L2_COLORFX_EMBOSS			= 4,
	V4L2_COLORFX_SKETCH			= 5,
	V4L2_COLORFX_SKY_BLUE			= 6,
	V4L2_COLORFX_GRASS_GREEN		= 7,
	V4L2_COLORFX_SKIN_WHITEN		= 8,
	V4L2_COLORFX_VIVID			= 9,
	V4L2_COLORFX_AQUA			= 10,
	V4L2_COLORFX_ART_FREEZE			= 11,
	V4L2_COLORFX_SILHOUETTE			= 12,
	V4L2_COLORFX_SOLARIZATION		= 13,
	V4L2_COLORFX_ANTIQUE			= 14,
	V4L2_COLORFX_SET_CBCR			= 15,
	V4L2_COLORFX_SET_RGB			= 16,
};
#define V4L2_CID_AUTOBRIGHTNESS			(V4L2_CID_BASE+32)
#define V4L2_CID_BAND_STOP_FILTER		(V4L2_CID_BASE+33)

#define V4L2_CID_ROTATE				(V4L2_CID_BASE+34)
#define V4L2_CID_BG_COLOR			(V4L2_CID_BASE+35)

#define V4L2_CID_CHROMA_GAIN                    (V4L2_CID_BASE+36)

#define V4L2_CID_ILLUMINATORS_1			(V4L2_CID_BASE+37)
#define V4L2_CID_ILLUMINATORS_2			(V4L2_CID_BASE+38)

#define V4L2_CID_MIN_BUFFERS_FOR_CAPTURE	(V4L2_CID_BASE+39)
#define V4L2_CID_MIN_BUFFERS_FOR_OUTPUT		(V4L2_CID_BASE+40)

#define V4L2_CID_ALPHA_COMPONENT		(V4L2_CID_BASE+41)
#define V4L2_CID_COLORFX_CBCR			(V4L2_CID_BASE+42)
#define V4L2_CID_COLORFX_RGB			(V4L2_CID_BASE+43)

/* last CID + 1 */
#define V4L2_CID_LASTP1                         (V4L2_CID_BASE+44)

/* USER-class private control IDs */

/*
 * The base for the meye driver controls. This driver was removed, but
 * we keep this define in case any software still uses it.
 */
#define V4L2_CID_USER_MEYE_BASE			(V4L2_CID_USER_BASE + 0x1000)

/* The base for the bttv driver controls.
 * We reserve 32 controls for this driver. */
#define V4L2_CID_USER_BTTV_BASE			(V4L2_CID_USER_BASE + 0x1010)


/* The base for the s2255 driver controls.
 * We reserve 16 controls for this driver. */
#define V4L2_CID_USER_S2255_BASE		(V4L2_CID_USER_BASE + 0x1030)

/*
 * The base for the si476x driver controls. See include/media/drv-intf/si476x.h
 * for the list of controls. Total of 16 controls is reserved for this driver
 */
#define V4L2_CID_USER_SI476X_BASE		(V4L2_CID_USER_BASE + 0x1040)

/* The base for the TI VPE driver controls. Total of 16 controls is reserved for
 * this driver */
#define V4L2_CID_USER_TI_VPE_BASE		(V4L2_CID_USER_BASE + 0x1050)

/* The base for the saa7134 driver controls.
 * We reserve 16 controls for this driver. */
#define V4L2_CID_USER_SAA7134_BASE		(V4L2_CID_USER_BASE + 0x1060)

/* The base for the adv7180 driver controls.
 * We reserve 16 controls for this driver. */
#define V4L2_CID_USER_ADV7180_BASE		(V4L2_CID_USER_BASE + 0x1070)

/* The base for the tc358743 driver controls.
 * We reserve 16 controls for this driver. */
#define V4L2_CID_USER_TC358743_BASE		(V4L2_CID_USER_BASE + 0x1080)

/* The base for the max217x driver controls.
 * We reserve 32 controls for this driver
 */
#define V4L2_CID_USER_MAX217X_BASE		(V4L2_CID_USER_BASE + 0x1090)

/* The base for the imx driver controls.
 * We reserve 16 controls for this driver. */
#define V4L2_CID_USER_IMX_BASE			(V4L2_CID_USER_BASE + 0x10b0)

/*
 * The base for the atmel isc driver controls.
 * We reserve 32 controls for this driver.
 */
#define V4L2_CID_USER_ATMEL_ISC_BASE		(V4L2_CID_USER_BASE + 0x10c0)

/*
 * The base for the CODA driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_CODA_BASE			(V4L2_CID_USER_BASE + 0x10e0)
/*
 * The base for MIPI CCS driver controls.
 * We reserve 128 controls for this driver.
 */
#define V4L2_CID_USER_CCS_BASE			(V4L2_CID_USER_BASE + 0x10f0)
/*
 * The base for Allegro driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_ALLEGRO_BASE		(V4L2_CID_USER_BASE + 0x1170)

/*
 * The base for the isl7998x driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_ISL7998X_BASE		(V4L2_CID_USER_BASE + 0x1180)

/*
 * The base for DW100 driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_DW100_BASE		(V4L2_CID_USER_BASE + 0x1190)

/*
 * The base for Aspeed driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_ASPEED_BASE		(V4L2_CID_USER_BASE + 0x11a0)

/*
 * The base for Nuvoton NPCM driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_NPCM_BASE			(V4L2_CID_USER_BASE + 0x11b0)

/*
 * The base for THine THP7312 driver controls.
 * We reserve 32 controls for this driver.
 */
#define V4L2_CID_USER_THP7312_BASE		(V4L2_CID_USER_BASE + 0x11c0)

/*
 * The base for the uvc driver controls.
 * See linux/uvcvideo.h for the list of controls.
 * We reserve 64 controls for this driver.
 */
#define V4L2_CID_USER_UVC_BASE			(V4L2_CID_USER_BASE + 0x11e0)

/*
 * The base for Rockchip ISP1 driver controls.
 * We reserve 16 controls for this driver.
 */
#define V4L2_CID_USER_RKISP1_BASE		(V4L2_CID_USER_BASE + 0x1220)

/* MPEG-class control IDs */
/* The MPEG controls are applicable to all codec controls
 * and the 'MPEG' part of the define is historical */

#define V4L2_CID_CODEC_BASE			(V4L2_CTRL_CLASS_CODEC | 0x900)
#define V4L2_CID_CODEC_CLASS			(V4L2_CTRL_CLASS_CODEC | 1)

/*  MPEG streams, specific to multiplexed streams */
#define V4L2_CID_MPEG_STREAM_TYPE		(V4L2_CID_CODEC_BASE+0)
enum v4l2_mpeg_stream_type {
	V4L2_MPEG_STREAM_TYPE_MPEG2_PS   = 0, /* MPEG-2 program stream */
	V4L2_MPEG_STREAM_TYPE_MPEG2_TS   = 1, /* MPEG-2 transport stream */
	V4L2_MPEG_STREAM_TYPE_MPEG1_SS   = 2, /* MPEG-1 system stream */
	V4L2_MPEG_STREAM_TYPE_MPEG2_DVD  = 3, /* MPEG-2 DVD-compatible stream */
	V4L2_MPEG_STREAM_TYPE_MPEG1_VCD  = 4, /* MPEG-1 VCD-compatible stream */
	V4L2_MPEG_STREAM_TYPE_MPEG2_SVCD = 5, /* MPEG-2 SVCD-compatible stream */
};
#define V4L2_CID_MPEG_STREAM_PID_PMT		(V4L2_CID_CODEC_BASE+1)
#define V4L2_CID_MPEG_STREAM_PID_AUDIO		(V4L2_CID_CODEC_BASE+2)
#define V4L2_CID_MPEG_STREAM_PID_VIDEO		(V4L2_CID_CODEC_BASE+3)
#define V4L2_CID_MPEG_STREAM_PID_PCR		(V4L2_CID_CODEC_BASE+4)
#define V4L2_CID_MPEG_STREAM_PES_ID_AUDIO	(V4L2_CID_CODEC_BASE+5)
#define V4L2_CID_MPEG_STREAM_PES_ID_VIDEO	(V4L2_CID_CODEC_BASE+6)
#define V4L2_CID_MPEG_STREAM_VBI_FMT		(V4L2_CID_CODEC_BASE+7)
enum v4l2_mpeg_stream_vbi_fmt {
	V4L2_MPEG_STREAM_VBI_FMT_NONE = 0,  /* No VBI in the MPEG stream */
	V4L2_MPEG_STREAM_VBI_FMT_IVTV = 1,  /* VBI in private packets, IVTV format */
};

/*  MPEG audio controls specific to multiplexed streams  */
#define V4L2_CID_MPEG_AUDIO_SAMPLING_FREQ	(V4L2_CID_CODEC_BASE+100)
enum v4l2_mpeg_audio_sampling_freq {
	V4L2_MPEG_AUDIO_SAMPLING_FREQ_44100 = 0,
	V4L2_MPEG_AUDIO_SAMPLING_FREQ_48000 = 1,
	V4L2_MPEG_AUDIO_SAMPLING_FREQ_32000 = 2,
};
#define V4L2_CID_MPEG_AUDIO_ENCODING		(V4L2_CID_CODEC_BASE+101)
enum v4l2_mpeg_audio_encoding {
	V4L2_MPEG_AUDIO_ENCODING_LAYER_1 = 0,
	V4L2_MPEG_AUDIO_ENCODING_LAYER_2 = 1,
	V4L2_MPEG_AUDIO_ENCODING_LAYER_3 = 2,
	V4L2_MPEG_AUDIO_ENCODING_AAC     = 3,
	V4L2_MPEG_AUDIO_ENCODING_AC3     = 4,
};
#define V4L2_CID_MPEG_AUDIO_L1_BITRATE		(V4L2_CID_CODEC_BASE+102)
enum v4l2_mpeg_audio_l1_bitrate {
	V4L2_MPEG_AUDIO_L1_BITRATE_32K  = 0,
	V4L2_MPEG_AUDIO_L1_BITRATE_64K  = 1,
	V4L2_MPEG_AUDIO_L1_BITRATE_96K  = 2,
	V4L2_MPEG_AUDIO_L1_BITRATE_128K = 3,
	V4L2_MPEG_AUDIO_L1_BITRATE_160K = 4,
	V4L2_MPEG_AUDIO_L1_BITRATE_192K = 5,
	V4L2_MPEG_AUDIO_L1_BITRATE_224K = 6,
	V4L2_MPEG_AUDIO_L1_BITRATE_256K = 7,
	V4L2_MPEG_AUDIO_L1_BITRATE_288K = 8,
	V4L2_MPEG_AUDIO_L1_BITRATE_320K = 9,
	V4L2_MPEG_AUDIO_L1_BITRATE_352K = 10,
	V4L2_MPEG_AUDIO_L1_BITRATE_384K = 11,
	V4L2_MPEG_AUDIO_L1_BITRATE_416K = 12,
	V4L2_MPEG_AUDIO_L1_BITRATE_448K = 13,
};
#define V4L2_CID_MPEG_AUDIO_L2_BITRATE		(V4L2_CID_CODEC_BASE+103)
enum v4l2_mpeg_audio_l2_bitrate {
	V4L2_MPEG_AUDIO_L2_BITRATE_32K  = 0,
	V4L2_MPEG_AUDIO_L2_BITRATE_48K  = 1,
	V4L2_MPEG_AUDIO_L2_BITRATE_56K  = 2,
	V4L2_MPEG_AUDIO_L2_BITRATE_64K  = 3,
	V4L2_MPEG_AUDIO_L2_BITRATE_80K  = 4,
	V4L2_MPEG_AUDIO_L2_BITRATE_96K  = 5,
	V4L2_MPEG_AUDIO_L2_BITRATE_112K = 6,
	V4L2_MPEG_AUDIO_L2_BITRATE_128K = 7,
	V4L2_MPEG_AUDIO_L2_BITRATE_160K = 8,
	V4L2_MPEG_AUDIO_L2_BITRATE_192K = 9,
	V4L2_MPEG_AUDIO_L2_BITRATE_224K = 10,
	V4L2_MPEG_AUDIO_L2_BITRATE_256K = 11,
	V4L2_MPEG_AUDIO_L2_BITRATE_320K = 12,
	V4L2_MPEG_AUDIO_L2_BITRATE_384K = 13,
};
#define V4L2_CID_MPEG_AUDIO_L3_BITRATE		(V4L2_CID_CODEC_BASE+104)
enum v4l2_mpeg_audio_l3_bitrate {
	V4L2_MPEG_AUDIO_L3_BITRATE_32K  = 0,
	V4L2_MPEG_AUDIO_L3_BITRATE_40K  = 1,
	V4L2_MPEG_AUDIO_L3_BITRATE_48K  = 2,
	V4L2_MPEG_AUDIO_L3_BITRATE_56K  = 3,
	V4L2_MPEG_AUDIO_L3_BITRATE_64K  = 4,
	V4L2_MPEG_AUDIO_L3_BITRATE_80K  = 5,
	V4L2_MPEG_AUDIO_L3_BITRATE_96K  = 6,
	V4L2_MPEG_AUDIO_L3_BITRATE_112K = 7,
	V4L2_MPEG_AUDIO_L3_BITRATE_128K = 8,
	V4L2_MPEG_AUDIO_L3_BITRATE_160K = 9,
	V4L2_MPEG_AUDIO_L3_BITRATE_192K = 10,
	V4L2_MPEG_AUDIO_L3_BITRATE_224K = 11,
	V4L2_MPEG_AUDIO_L3_BITRATE_256K = 12,
	V4L2_MPEG_AUDIO_L3_BITRATE_320K = 13,
};
#define V4L2_CID_MPEG_AUDIO_MODE		(V4L2_CID_CODEC_BASE+105)
enum v4l2_mpeg_audio_mode {
	V4L2_MPEG_AUDIO_MODE_STEREO       = 0,
	V4L2_MPEG_AUDIO_MODE_JOINT_STEREO = 1,
	V4L2_MPEG_AUDIO_MODE_DUAL         = 2,
	V4L2_MPEG_AUDIO_MODE_MONO         = 3,
};
#define V4L2_CID_MPEG_AUDIO_MODE_EXTENSION	(V4L2_CID_CODEC_BASE+106)
enum v4l2_mpeg_audio_mode_extension {
	V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_4  = 0,
	V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_8  = 1,
	V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_12 = 2,
	V4L2_MPEG_AUDIO_MODE_EXTENSION_BOUND_16 = 3,
};
#define V4L2_CID_MPEG_AUDIO_EMPHASIS		(V4L2_CID_CODEC_BASE+107)
enum v4l2_mpeg_audio_emphasis {
	V4L2_MPEG_AUDIO_EMPHASIS_NONE         = 0,
	V4L2_MPEG_AUDIO_EMPHASIS_50_DIV_15_uS = 1,
	V4L2_MPEG_AUDIO_EMPHASIS_CCITT_J17    = 2,
};
#define V4L2_CID_MPEG_AUDIO_CRC			(V4L2_CID_CODEC_BASE+108)
enum v4l2_mpeg_audio_crc {
	V4L2_MPEG_AUDIO_CRC_NONE  = 0,
	V4L2_MPEG_AUDIO_CRC_CRC16 = 1,
};
#define V4L2_CID_MPEG_AUDIO_MUTE		(V4L2_CID_CODEC_BASE+109)
#define V4L2_CID_MPEG_AUDIO_AAC_BITRATE		(V4L2_CID_CODEC_BASE+110)
#define V4L2_CID_MPEG_AUDIO_AC3_BITRATE		(V4L2_CID_CODEC_BASE+111)
enum v4l2_mpeg_audio_ac3_bitrate {
	V4L2_MPEG_AUDIO_AC3_BITRATE_32K  = 0,
	V4L2_MPEG_AUDIO_AC3_BITRATE_40K  = 1,
	V4L2_MPEG_AUDIO_AC3_BITRATE_48K  = 2,
	V4L2_MPEG_AUDIO_AC3_BITRATE_56K  = 3,
	V4L2_MPEG_AUDIO_AC3_BITRATE_64K  = 4,
	V4L2_MPEG_AUDIO_AC3_BITRATE_80K  = 5,
	V4L2_MPEG_AUDIO_AC3_BITRATE_96K  = 6,
	V4L2_MPEG_AUDIO_AC3_BITRATE_112K = 7,
	V4L2_MPEG_AUDIO_AC3_BITRATE_128K = 8,
	V4L2_MPEG_AUDIO_AC3_BITRATE_160K = 9,
	V4L2_MPEG_AUDIO_AC3_BITRATE_192K = 10,
	V4L2_MPEG_AUDIO_AC3_BITRATE_224K = 11,
	V4L2_MPEG_AUDIO_AC3_BITRATE_256K = 12,
	V4L2_MPEG_AUDIO_AC3_BITRATE_320K = 13,
	V4L2_MPEG_AUDIO_AC3_BITRATE_384K = 14,
	V4L2_MPEG_AUDIO_AC3_BITRATE_448K = 15,
	V4L2_MPEG_AUDIO_AC3_BITRATE_512K = 16,
	V4L2_MPEG_AUDIO_AC3_BITRATE_576K = 17,
	V4L2_MPEG_AUDIO_AC3_BITRATE_640K = 18,
};
#define V4L2_CID_MPEG_AUDIO_DEC_PLAYBACK	(V4L2_CID_CODEC_BASE+112)
enum v4l2_mpeg_audio_dec_playback {
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_AUTO	    = 0,
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_STEREO	    = 1,
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_LEFT	    = 2,
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_RIGHT	    = 3,
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_MONO	    = 4,
	V4L2_MPEG_AUDIO_DEC_PLAYBACK_SWAPPED_STEREO = 5,
};
#define V4L2_CID_MPEG_AUDIO_DEC_MULTILINGUAL_PLAYBACK (V4L2_CID_CODEC_BASE+113)

/*  MPEG video controls specific to multiplexed streams */
#define V4L2_CID_MPEG_VIDEO_ENCODING		(V4L2_CID_CODEC_BASE+200)
enum v4l2_mpeg_video_encoding {
	V4L2_MPEG_VIDEO_ENCODING_MPEG_1     = 0,
	V4L2_MPEG_VIDEO_ENCODING_MPEG_2     = 1,
	V4L2_MPEG_VIDEO_ENCODING_MPEG_4_AVC = 2,
};
#define V4L2_CID_MPEG_VIDEO_ASPECT		(V4L2_CID_CODEC_BASE+201)
enum v4l2_mpeg_video_aspect {
	V4L2_MPEG_VIDEO_ASPECT_1x1     = 0,
	V4L2_MPEG_VIDEO_ASPECT_4x3     = 1,
	V4L2_MPEG_VIDEO_ASPECT_16x9    = 2,
	V4L2_MPEG_VIDEO_ASPECT_221x100 = 3,
};
#define V4L2_CID_MPEG_VIDEO_B_FRAMES		(V4L2_CID_CODEC_BASE+202)
#define V4L2_CID_MPEG_VIDEO_GOP_SIZE		(V4L2_CID_CODEC_BASE+203)
#define V4L2_CID_MPEG_VIDEO_GOP_CLOSURE		(V4L2_CID_CODEC_BASE+204)
#define V4L2_CID_MPEG_VIDEO_PULLDOWN		(V4L2_CID_CODEC_BASE+205)
#define V4L2_CID_MPEG_VIDEO_BITRATE_MODE	(V4L2_CID_CODEC_BASE+206)
enum v4l2_mpeg_video_bitrate_mode {
	V4L2_MPEG_VIDEO_BITRATE_MODE_VBR = 0,
	V4L2_MPEG_VIDEO_BITRATE_MODE_CBR = 1,
	V4L2_MPEG_VIDEO_BITRATE_MODE_CQ  = 2,
};
#define V4L2_CID_MPEG_VIDEO_BITRATE		(V4L2_CID_CODEC_BASE+207)
#define V4L2_CID_MPEG_VIDEO_BITRATE_PEAK	(V4L2_CID_CODEC_BASE+208)
#define V4L2_CID_MPEG_VIDEO_TEMPORAL_DECIMATION (V4L2_CID_CODEC_BASE+209)
#define V4L2_CID_MPEG_VIDEO_MUTE		(V4L2_CID_CODEC_BASE+210)
#define V4L2_CID_MPEG_VIDEO_MUTE_YUV		(V4L2_CID_CODEC_BASE+211)
#define V4L2_CID_MPEG_VIDEO_DECODER_SLICE_INTERFACE		(V4L2_CID_CODEC_BASE+212)
#define V4L2_CID_MPEG_VIDEO_DECODER_MPEG4_DEBLOCK_FILTER	(V4L2_CID_CODEC_BASE+213)
#define V4L2_CID_MPEG_VIDEO_CYCLIC_INTRA_REFRESH_MB		(V4L2_CID_CODEC_BASE+214)
#define V4L2_CID_MPEG_VIDEO_FRAME_RC_ENABLE			(V4L2_CID_CODEC_BASE+215)
#define V4L2_CID_MPEG_VIDEO_HEADER_MODE				(V4L2_CID_CODEC_BASE+216)
enum v4l2_mpeg_video_header_mode {
	V4L2_MPEG_VIDEO_HEADER_MODE_SEPARATE			= 0,
	V4L2_MPEG_VIDEO_HEADER_MODE_JOINED_WITH_1ST_FRAME	= 1,

};
#define V4L2_CID_MPEG_VIDEO_MAX_REF_PIC			(V4L2_CID_CODEC_BASE+217)
#define V4L2_CID_MPEG_VIDEO_MB_RC_ENABLE		(V4L2_CID_CODEC_BASE+218)
#define V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_BYTES	(V4L2_CID_CODEC_BASE+219)
#define V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MAX_MB		(V4L2_CID_CODEC_BASE+220)
#define V4L2_CID_MPEG_VIDEO_MULTI_SLICE_MODE		(V4L2_CID_CODEC_BASE+221)
enum v4l2_mpeg_video_multi_slice_mode {
	V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_SINGLE		= 0,
	V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_MB		= 1,
	V4L2_MPEG_VIDEO_MULTI_SLICE_MODE_MAX_BYTES	= 2,
	/* Kept for backwards compatibility reasons. Stupid typo... */
	V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_MB		= 1,
	V4L2_MPEG_VIDEO_MULTI_SICE_MODE_MAX_BYTES	= 2,
};
#define V4L2_CID_MPEG_VIDEO_VBV_SIZE			(V4L2_CID_CODEC_BASE+222)
#define V4L2_CID_MPEG_VIDEO_DEC_PTS			(V4L2_CID_CODEC_BASE+223)
#define V4L2_CID_MPEG_VIDEO_DEC_FRAME			(V4L2_CID_CODEC_BASE+224)
#define V4L2_CID_MPEG_VIDEO_VBV_DELAY			(V4L2_CID_CODEC_BASE+225)
#define V4L2_CID_MPEG_VIDEO_REPEAT_SEQ_HEADER		(V4L2_CID_CODEC_BASE+226)
#define V4L2_CID_MPEG_VIDEO_MV_H_SEARCH_RANGE		(V4L2_CID_CODEC_BASE+227)
#define V4L2_CID_MPEG_VIDEO_MV_V_SEARCH_RANGE		(V4L2_CID_CODEC_BASE+228)
#define V4L2_CID_MPEG_VIDEO_FORCE_KEY_FRAME		(V4L2_CID_CODEC_BASE+229)
#define V4L2_CID_MPEG_VIDEO_BASELAYER_PRIORITY_ID	(V4L2_CID_CODEC_BASE+230)
#define V4L2_CID_MPEG_VIDEO_AU_DELIMITER		(V4L2_CID_CODEC_BASE+231)
#define V4L2_CID_MPEG_VIDEO_LTR_COUNT			(V4L2_CID_CODEC_BASE+232)
#define V4L2_CID_MPEG_VIDEO_FRAME_LTR_INDEX		(V4L2_CID_CODEC_BASE+233)
#define V4L2_CID_MPEG_VIDEO_USE_LTR_FRAMES		(V4L2_CID_CODEC_BASE+234)
#define V4L2_CID_MPEG_VIDEO_DEC_CONCEAL_COLOR		(V4L2_CID_CODEC_BASE+235)
#define V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD	(V4L2_CID_CODEC_BASE+236)
#define V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD_TYPE	(V4L2_CID_CODEC_BASE+237)
enum v4l2_mpeg_video_intra_refresh_period_type {
	V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD_TYPE_RANDOM	= 0,
	V4L2_CID_MPEG_VIDEO_INTRA_REFRESH_PERIOD_TYPE_CYCLIC	= 1,
};

/* CIDs for the MPEG-2 Part 2 (H.262) codec */
#define V4L2_CID_MPEG_VIDEO_MPEG2_LEVEL			(V4L2_CID_CODEC_BASE+270)
enum v4l2_mpeg_video_mpeg2_level {
	V4L2_MPEG_VIDEO_MPEG2_LEVEL_LOW		= 0,
	V4L2_MPEG_VIDEO_MPEG2_LEVEL_MAIN	= 1,
	V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH_1440	= 2,
	V4L2_MPEG_VIDEO_MPEG2_LEVEL_HIGH	= 3,
};
#define V4L2_CID_MPEG_VIDEO_MPEG2_PROFILE		(V4L2_CID_CODEC_BASE+271)
enum v4l2_mpeg_video_mpeg2_profile {
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_SIMPLE				= 0,
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_MAIN				= 1,
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_SNR_SCALABLE			= 2,
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_SPATIALLY_SCALABLE		= 3,
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_HIGH				= 4,
	V4L2_MPEG_VIDEO_MPEG2_PROFILE_MULTIVIEW				= 5,
};

/* CIDs for the FWHT codec as used by the vicodec driver. */
#define V4L2_CID_FWHT_I_FRAME_QP             (V4L2_CID_CODEC_BASE + 290)
#define V4L2_CID_FWHT_P_FRAME_QP             (V4L2_CID_CODEC_BASE + 291)

#define V4L2_CID_MPEG_VIDEO_H263_I_FRAME_QP		(V4L2_CID_CODEC_BASE+300)
#define V4L2_CID_MPEG_VIDEO_H263_P_FRAME_QP		(V4L2_CID_CODEC_BASE+301)
#define V4L2_CID_MPEG_VIDEO_H263_B_FRAME_QP		(V4L2_CID_CODEC_BASE+302)
#define V4L2_CID_MPEG_VIDEO_H263_MIN_QP			(V4L2_CID_CODEC_BASE+303)
#define V4L2_CID_MPEG_VIDEO_H263_MAX_QP			(V4L2_CID_CODEC_BASE+304)
#define V4L2_CID_MPEG_VIDEO_H264_I_FRAME_QP		(V4L2_CID_CODEC_BASE+350)
#define V4L2_CID_MPEG_VIDEO_H264_P_FRAME_QP		(V4L2_CID_CODEC_BASE+351)
#define V4L2_CID_MPEG_VIDEO_H264_B_FRAME_QP		(V4L2_CID_CODEC_BASE+352)
#define V4L2_CID_MPEG_VIDEO_H264_MIN_QP			(V4L2_CID_CODEC_BASE+353)
#define V4L2_CID_MPEG_VIDEO_H264_MAX_QP			(V4L2_CID_CODEC_BASE+354)
#define V4L2_CID_MPEG_VIDEO_H264_8X8_TRANSFORM		(V4L2_CID_CODEC_BASE+355)
#define V4L2_CID_MPEG_VIDEO_H264_CPB_SIZE		(V4L2_CID_CODEC_BASE+356)
#define V4L2_CID_MPEG_VIDEO_H264_ENTROPY_MODE		(V4L2_CID_CODEC_BASE+357)
enum v4l2_mpeg_video_h264_entropy_mode {
	V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CAVLC	= 0,
	V4L2_MPEG_VIDEO_H264_ENTROPY_MODE_CABAC	= 1,
};
#define V4L2_CID_MPEG_VIDEO_H264_I_PERIOD		(V4L2_CID_CODEC_BASE+358)
#define V4L2_CID_MPEG_VIDEO_H264_LEVEL			(V4L2_CID_CODEC_BASE+359)
enum v4l2_mpeg_video_h264_level {
	V4L2_MPEG_VIDEO_H264_LEVEL_1_0	= 0,
	V4L2_MPEG_VIDEO_H264_LEVEL_1B	= 1,
	V4L2_MPEG_VIDEO_H264_LEVEL_1_1	= 2,
	V4L2_MPEG_VIDEO_H264_LEVEL_1_2	= 3,
	V4L2_MPEG_VIDEO_H264_LEVEL_1_3	= 4,
	V4L2_MPEG_VIDEO_H264_LEVEL_2_0	= 5,
	V4L2_MPEG_VIDEO_H264_LEVEL_2_1	= 6,
	V4L2_MPEG_VIDEO_H264_LEVEL_2_2	= 7,
	V4L2_MPEG_VIDEO_H264_LEVEL_3_0	= 8,
	V4L2_MPEG_VIDEO_H264_LEVEL_3_1	= 9,
	V4L2_MPEG_VIDEO_H264_LEVEL_3_2	= 10,
	V4L2_MPEG_VIDEO_H264_LEVEL_4_0	= 11,
	V4L2_MPEG_VIDEO_H264_LEVEL_4_1	= 12,
	V4L2_MPEG_VIDEO_H264_LEVEL_4_2	= 13,
	V4L2_MPEG_VIDEO_H264_LEVEL_5_0	= 14,
	V4L2_MPEG_VIDEO_H264_LEVEL_5_1	= 15,
	V4L2_MPEG_VIDEO_H264_LEVEL_5_2	= 16,
	V4L2_MPEG_VIDEO_H264_LEVEL_6_0	= 17,
	V4L2_MPEG_VIDEO_H264_LEVEL_6_1	= 18,
	V4L2_MPEG_VIDEO_H264_LEVEL_6_2	= 19,
};
#define V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_ALPHA	(V4L2_CID_CODEC_BASE+360)
#define V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_BETA	(V4L2_CID_CODEC_BASE+361)
#define V4L2_CID_MPEG_VIDEO_H264_LOOP_FILTER_MODE	(V4L2_CID_CODEC_BASE+362)
enum v4l2_mpeg_video_h264_loop_filter_mode {
	V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_ENABLED				= 0,
	V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED				= 1,
	V4L2_MPEG_VIDEO_H264_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY	= 2,
};
#define V4L2_CID_MPEG_VIDEO_H264_PROFILE		(V4L2_CID_CODEC_BASE+363)
enum v4l2_mpeg_video_h264_profile {
	V4L2_MPEG_VIDEO_H264_PROFILE_BASELINE			= 0,
	V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_BASELINE	= 1,
	V4L2_MPEG_VIDEO_H264_PROFILE_MAIN			= 2,
	V4L2_MPEG_VIDEO_H264_PROFILE_EXTENDED			= 3,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH			= 4,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10			= 5,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422			= 6,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_PREDICTIVE	= 7,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_10_INTRA		= 8,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_422_INTRA		= 9,
	V4L2_MPEG_VIDEO_H264_PROFILE_HIGH_444_INTRA		= 10,
	V4L2_MPEG_VIDEO_H264_PROFILE_CAVLC_444_INTRA		= 11,
	V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_BASELINE		= 12,
	V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH		= 13,
	V4L2_MPEG_VIDEO_H264_PROFILE_SCALABLE_HIGH_INTRA	= 14,
	V4L2_MPEG_VIDEO_H264_PROFILE_STEREO_HIGH		= 15,
	V4L2_MPEG_VIDEO_H264_PROFILE_MULTIVIEW_HIGH		= 16,
	V4L2_MPEG_VIDEO_H264_PROFILE_CONSTRAINED_HIGH		= 17,
};
#define V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_HEIGHT	(V4L2_CID_CODEC_BASE+364)
#define V4L2_CID_MPEG_VIDEO_H264_VUI_EXT_SAR_WIDTH	(V4L2_CID_CODEC_BASE+365)
#define V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_ENABLE		(V4L2_CID_CODEC_BASE+366)
#define V4L2_CID_MPEG_VIDEO_H264_VUI_SAR_IDC		(V4L2_CID_CODEC_BASE+367)
enum v4l2_mpeg_video_h264_vui_sar_idc {
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_UNSPECIFIED	= 0,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_1x1		= 1,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_12x11		= 2,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_10x11		= 3,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_16x11		= 4,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_40x33		= 5,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_24x11		= 6,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_20x11		= 7,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_32x11		= 8,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_80x33		= 9,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_18x11		= 10,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_15x11		= 11,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_64x33		= 12,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_160x99		= 13,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_4x3		= 14,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_3x2		= 15,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_2x1		= 16,
	V4L2_MPEG_VIDEO_H264_VUI_SAR_IDC_EXTENDED	= 17,
};
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FRAME_PACKING		(V4L2_CID_CODEC_BASE+368)
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_CURRENT_FRAME_0		(V4L2_CID_CODEC_BASE+369)
#define V4L2_CID_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE	(V4L2_CID_CODEC_BASE+370)
enum v4l2_mpeg_video_h264_sei_fp_arrangement_type {
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_CHECKERBOARD	= 0,
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_COLUMN		= 1,
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_ROW		= 2,
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_SIDE_BY_SIDE	= 3,
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TOP_BOTTOM		= 4,
	V4L2_MPEG_VIDEO_H264_SEI_FP_ARRANGEMENT_TYPE_TEMPORAL		= 5,
};
#define V4L2_CID_MPEG_VIDEO_H264_FMO			(V4L2_CID_CODEC_BASE+371)
#define V4L2_CID_MPEG_VIDEO_H264_FMO_MAP_TYPE		(V4L2_CID_CODEC_BASE+372)
enum v4l2_mpeg_video_h264_fmo_map_type {
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_INTERLEAVED_SLICES		= 0,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_SCATTERED_SLICES		= 1,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_FOREGROUND_WITH_LEFT_OVER	= 2,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_BOX_OUT			= 3,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_RASTER_SCAN			= 4,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_WIPE_SCAN			= 5,
	V4L2_MPEG_VIDEO_H264_FMO_MAP_TYPE_EXPLICIT			= 6,
};
#define V4L2_CID_MPEG_VIDEO_H264_FMO_SLICE_GROUP	(V4L2_CID_CODEC_BASE+373)
#define V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_DIRECTION	(V4L2_CID_CODEC_BASE+374)
enum v4l2_mpeg_video_h264_fmo_change_dir {
	V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_RIGHT	= 0,
	V4L2_MPEG_VIDEO_H264_FMO_CHANGE_DIR_LEFT	= 1,
};
#define V4L2_CID_MPEG_VIDEO_H264_FMO_CHANGE_RATE	(V4L2_CID_CODEC_BASE+375)
#define V4L2_CID_MPEG_VIDEO_H264_FMO_RUN_LENGTH		(V4L2_CID_CODEC_BASE+376)
#define V4L2_CID_MPEG_VIDEO_H264_ASO			(V4L2_CID_CODEC_BASE+377)
#define V4L2_CID_MPEG_VIDEO_H264_ASO_SLICE_ORDER	(V4L2_CID_CODEC_BASE+378)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING		(V4L2_CID_CODEC_BASE+379)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_TYPE	(V4L2_CID_CODEC_BASE+380)
enum v4l2_mpeg_video_h264_hierarchical_coding_type {
	V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_B	= 0,
	V4L2_MPEG_VIDEO_H264_HIERARCHICAL_CODING_P	= 1,
};
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER	(V4L2_CID_CODEC_BASE+381)
#define V4L2_CID_MPEG_VIDEO_H264_HIERARCHICAL_CODING_LAYER_QP	(V4L2_CID_CODEC_BASE+382)
#define V4L2_CID_MPEG_VIDEO_H264_CONSTRAINED_INTRA_PREDICTION	(V4L2_CID_CODEC_BASE+383)
#define V4L2_CID_MPEG_VIDEO_H264_CHROMA_QP_INDEX_OFFSET		(V4L2_CID_CODEC_BASE+384)
#define V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MIN_QP	(V4L2_CID_CODEC_BASE+385)
#define V4L2_CID_MPEG_VIDEO_H264_I_FRAME_MAX_QP	(V4L2_CID_CODEC_BASE+386)
#define V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MIN_QP	(V4L2_CID_CODEC_BASE+387)
#define V4L2_CID_MPEG_VIDEO_H264_P_FRAME_MAX_QP	(V4L2_CID_CODEC_BASE+388)
#define V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MIN_QP	(V4L2_CID_CODEC_BASE+389)
#define V4L2_CID_MPEG_VIDEO_H264_B_FRAME_MAX_QP	(V4L2_CID_CODEC_BASE+390)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L0_BR	(V4L2_CID_CODEC_BASE+391)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L1_BR	(V4L2_CID_CODEC_BASE+392)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L2_BR	(V4L2_CID_CODEC_BASE+393)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L3_BR	(V4L2_CID_CODEC_BASE+394)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L4_BR	(V4L2_CID_CODEC_BASE+395)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L5_BR	(V4L2_CID_CODEC_BASE+396)
#define V4L2_CID_MPEG_VIDEO_H264_HIER_CODING_L6_BR	(V4L2_CID_CODEC_BASE+397)
#define V4L2_CID_MPEG_VIDEO_MPEG4_I_FRAME_QP	(V4L2_CID_CODEC_BASE+400)
#define V4L2_CID_MPEG_VIDEO_MPEG4_P_FRAME_QP	(V4L2_CID_CODEC_BASE+401)
#define V4L2_CID_MPEG_VIDEO_MPEG4_B_FRAME_QP	(V4L2_CID_CODEC_BASE+402)
#define V4L2_CID_MPEG_VIDEO_MPEG4_MIN_QP	(V4L2_CID_CODEC_BASE+403)
#define V4L2_CID_MPEG_VIDEO_MPEG4_MAX_QP	(V4L2_CID_CODEC_BASE+404)
#define V4L2_CID_MPEG_VIDEO_MPEG4_LEVEL		(V4L2_CID_CODEC_BASE+405)
enum v4l2_mpeg_video_mpeg4_level {
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_0	= 0,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_0B	= 1,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_1	= 2,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_2	= 3,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_3	= 4,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_3B	= 5,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_4	= 6,
	V4L2_MPEG_VIDEO_MPEG4_LEVEL_5	= 7,
};
#define V4L2_CID_MPEG_VIDEO_MPEG4_PROFILE	(V4L2_CID_CODEC_BASE+406)
enum v4l2_mpeg_video_mpeg4_profile {
	V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE				= 0,
	V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_SIMPLE			= 1,
	V4L2_MPEG_VIDEO_MPEG4_PROFILE_CORE				= 2,
	V4L2_MPEG_VIDEO_MPEG4_PROFILE_SIMPLE_SCALABLE			= 3,
	V4L2_MPEG_VIDEO_MPEG4_PROFILE_ADVANCED_CODING_EFFICIENCY	= 4,
};
#define V4L2_CID_MPEG_VIDEO_MPEG4_QPEL		(V4L2_CID_CODEC_BASE+407)

/*  Control IDs for VP8 streams
 *  Although VP8 is not part of MPEG we add these controls to the MPEG class
 *  as that class is already handling other video compression standards
 */
#define V4L2_CID_MPEG_VIDEO_VPX_NUM_PARTITIONS		(V4L2_CID_CODEC_BASE+500)
enum v4l2_vp8_num_partitions {
	V4L2_CID_MPEG_VIDEO_VPX_1_PARTITION	= 0,
	V4L2_CID_MPEG_VIDEO_VPX_2_PARTITIONS	= 1,
	V4L2_CID_MPEG_VIDEO_VPX_4_PARTITIONS	= 2,
	V4L2_CID_MPEG_VIDEO_VPX_8_PARTITIONS	= 3,
};
#define V4L2_CID_MPEG_VIDEO_VPX_IMD_DISABLE_4X4		(V4L2_CID_CODEC_BASE+501)
#define V4L2_CID_MPEG_VIDEO_VPX_NUM_REF_FRAMES		(V4L2_CID_CODEC_BASE+502)
enum v4l2_vp8_num_ref_frames {
	V4L2_CID_MPEG_VIDEO_VPX_1_REF_FRAME	= 0,
	V4L2_CID_MPEG_VIDEO_VPX_2_REF_FRAME	= 1,
	V4L2_CID_MPEG_VIDEO_VPX_3_REF_FRAME	= 2,
};
#define V4L2_CID_MPEG_VIDEO_VPX_FILTER_LEVEL		(V4L2_CID_CODEC_BASE+503)
#define V4L2_CID_MPEG_VIDEO_VPX_FILTER_SHARPNESS	(V4L2_CID_CODEC_BASE+504)
#define V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_REF_PERIOD	(V4L2_CID_CODEC_BASE+505)
#define V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_SEL	(V4L2_CID_CODEC_BASE+506)
enum v4l2_vp8_golden_frame_sel {
	V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_PREV		= 0,
	V4L2_CID_MPEG_VIDEO_VPX_GOLDEN_FRAME_USE_REF_PERIOD	= 1,
};
#define V4L2_CID_MPEG_VIDEO_VPX_MIN_QP			(V4L2_CID_CODEC_BASE+507)
#define V4L2_CID_MPEG_VIDEO_VPX_MAX_QP			(V4L2_CID_CODEC_BASE+508)
#define V4L2_CID_MPEG_VIDEO_VPX_I_FRAME_QP		(V4L2_CID_CODEC_BASE+509)
#define V4L2_CID_MPEG_VIDEO_VPX_P_FRAME_QP		(V4L2_CID_CODEC_BASE+510)

#define V4L2_CID_MPEG_VIDEO_VP8_PROFILE			(V4L2_CID_CODEC_BASE+511)
enum v4l2_mpeg_video_vp8_profile {
	V4L2_MPEG_VIDEO_VP8_PROFILE_0				= 0,
	V4L2_MPEG_VIDEO_VP8_PROFILE_1				= 1,
	V4L2_MPEG_VIDEO_VP8_PROFILE_2				= 2,
	V4L2_MPEG_VIDEO_VP8_PROFILE_3				= 3,
};
/* Deprecated alias for compatibility reasons. */
#define V4L2_CID_MPEG_VIDEO_VPX_PROFILE	V4L2_CID_MPEG_VIDEO_VP8_PROFILE
#define V4L2_CID_MPEG_VIDEO_VP9_PROFILE			(V4L2_CID_CODEC_BASE+512)
enum v4l2_mpeg_video_vp9_profile {
	V4L2_MPEG_VIDEO_VP9_PROFILE_0				= 0,
	V4L2_MPEG_VIDEO_VP9_PROFILE_1				= 1,
	V4L2_MPEG_VIDEO_VP9_PROFILE_2				= 2,
	V4L2_MPEG_VIDEO_VP9_PROFILE_3				= 3,
};
#define V4L2_CID_MPEG_VIDEO_VP9_LEVEL			(V4L2_CID_CODEC_BASE+513)
enum v4l2_mpeg_video_vp9_level {
	V4L2_MPEG_VIDEO_VP9_LEVEL_1_0	= 0,
	V4L2_MPEG_VIDEO_VP9_LEVEL_1_1	= 1,
	V4L2_MPEG_VIDEO_VP9_LEVEL_2_0	= 2,
	V4L2_MPEG_VIDEO_VP9_LEVEL_2_1	= 3,
	V4L2_MPEG_VIDEO_VP9_LEVEL_3_0	= 4,
	V4L2_MPEG_VIDEO_VP9_LEVEL_3_1	= 5,
	V4L2_MPEG_VIDEO_VP9_LEVEL_4_0	= 6,
	V4L2_MPEG_VIDEO_VP9_LEVEL_4_1	= 7,
	V4L2_MPEG_VIDEO_VP9_LEVEL_5_0	= 8,
	V4L2_MPEG_VIDEO_VP9_LEVEL_5_1	= 9,
	V4L2_MPEG_VIDEO_VP9_LEVEL_5_2	= 10,
	V4L2_MPEG_VIDEO_VP9_LEVEL_6_0	= 11,
	V4L2_MPEG_VIDEO_VP9_LEVEL_6_1	= 12,
	V4L2_MPEG_VIDEO_VP9_LEVEL_6_2	= 13,
};

/* CIDs for HEVC encoding. */

#define V4L2_CID_MPEG_VIDEO_HEVC_MIN_QP		(V4L2_CID_CODEC_BASE + 600)
#define V4L2_CID_MPEG_VIDEO_HEVC_MAX_QP		(V4L2_CID_CODEC_BASE + 601)
#define V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_QP	(V4L2_CID_CODEC_BASE + 602)
#define V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_QP	(V4L2_CID_CODEC_BASE + 603)
#define V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_QP	(V4L2_CID_CODEC_BASE + 604)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_QP	(V4L2_CID_CODEC_BASE + 605)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_TYPE (V4L2_CID_CODEC_BASE + 606)
enum v4l2_mpeg_video_hevc_hier_coding_type {
	V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_B	= 0,
	V4L2_MPEG_VIDEO_HEVC_HIERARCHICAL_CODING_P	= 1,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_LAYER	(V4L2_CID_CODEC_BASE + 607)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_QP	(V4L2_CID_CODEC_BASE + 608)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_QP	(V4L2_CID_CODEC_BASE + 609)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_QP	(V4L2_CID_CODEC_BASE + 610)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_QP	(V4L2_CID_CODEC_BASE + 611)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_QP	(V4L2_CID_CODEC_BASE + 612)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_QP	(V4L2_CID_CODEC_BASE + 613)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_QP	(V4L2_CID_CODEC_BASE + 614)
#define V4L2_CID_MPEG_VIDEO_HEVC_PROFILE	(V4L2_CID_CODEC_BASE + 615)
enum v4l2_mpeg_video_hevc_profile {
	V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN = 0,
	V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_STILL_PICTURE = 1,
	V4L2_MPEG_VIDEO_HEVC_PROFILE_MAIN_10 = 2,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_LEVEL		(V4L2_CID_CODEC_BASE + 616)
enum v4l2_mpeg_video_hevc_level {
	V4L2_MPEG_VIDEO_HEVC_LEVEL_1	= 0,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_2	= 1,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_2_1	= 2,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_3	= 3,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_3_1	= 4,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_4	= 5,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_4_1	= 6,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_5	= 7,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_5_1	= 8,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_5_2	= 9,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_6	= 10,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_6_1	= 11,
	V4L2_MPEG_VIDEO_HEVC_LEVEL_6_2	= 12,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_FRAME_RATE_RESOLUTION	(V4L2_CID_CODEC_BASE + 617)
#define V4L2_CID_MPEG_VIDEO_HEVC_TIER			(V4L2_CID_CODEC_BASE + 618)
enum v4l2_mpeg_video_hevc_tier {
	V4L2_MPEG_VIDEO_HEVC_TIER_MAIN = 0,
	V4L2_MPEG_VIDEO_HEVC_TIER_HIGH = 1,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_MAX_PARTITION_DEPTH	(V4L2_CID_CODEC_BASE + 619)
#define V4L2_CID_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE	(V4L2_CID_CODEC_BASE + 620)
enum v4l2_cid_mpeg_video_hevc_loop_filter_mode {
	V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED			 = 0,
	V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_ENABLED			 = 1,
	V4L2_MPEG_VIDEO_HEVC_LOOP_FILTER_MODE_DISABLED_AT_SLICE_BOUNDARY = 2,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_LF_BETA_OFFSET_DIV2	(V4L2_CID_CODEC_BASE + 621)
#define V4L2_CID_MPEG_VIDEO_HEVC_LF_TC_OFFSET_DIV2	(V4L2_CID_CODEC_BASE + 622)
#define V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_TYPE		(V4L2_CID_CODEC_BASE + 623)
enum v4l2_cid_mpeg_video_hevc_refresh_type {
	V4L2_MPEG_VIDEO_HEVC_REFRESH_NONE		= 0,
	V4L2_MPEG_VIDEO_HEVC_REFRESH_CRA		= 1,
	V4L2_MPEG_VIDEO_HEVC_REFRESH_IDR		= 2,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_REFRESH_PERIOD		(V4L2_CID_CODEC_BASE + 624)
#define V4L2_CID_MPEG_VIDEO_HEVC_LOSSLESS_CU		(V4L2_CID_CODEC_BASE + 625)
#define V4L2_CID_MPEG_VIDEO_HEVC_CONST_INTRA_PRED	(V4L2_CID_CODEC_BASE + 626)
#define V4L2_CID_MPEG_VIDEO_HEVC_WAVEFRONT		(V4L2_CID_CODEC_BASE + 627)
#define V4L2_CID_MPEG_VIDEO_HEVC_GENERAL_PB		(V4L2_CID_CODEC_BASE + 628)
#define V4L2_CID_MPEG_VIDEO_HEVC_TEMPORAL_ID		(V4L2_CID_CODEC_BASE + 629)
#define V4L2_CID_MPEG_VIDEO_HEVC_STRONG_SMOOTHING	(V4L2_CID_CODEC_BASE + 630)
#define V4L2_CID_MPEG_VIDEO_HEVC_MAX_NUM_MERGE_MV_MINUS1	(V4L2_CID_CODEC_BASE + 631)
#define V4L2_CID_MPEG_VIDEO_HEVC_INTRA_PU_SPLIT		(V4L2_CID_CODEC_BASE + 632)
#define V4L2_CID_MPEG_VIDEO_HEVC_TMV_PREDICTION		(V4L2_CID_CODEC_BASE + 633)
#define V4L2_CID_MPEG_VIDEO_HEVC_WITHOUT_STARTCODE	(V4L2_CID_CODEC_BASE + 634)
#define V4L2_CID_MPEG_VIDEO_HEVC_SIZE_OF_LENGTH_FIELD	(V4L2_CID_CODEC_BASE + 635)
enum v4l2_cid_mpeg_video_hevc_size_of_length_field {
	V4L2_MPEG_VIDEO_HEVC_SIZE_0		= 0,
	V4L2_MPEG_VIDEO_HEVC_SIZE_1		= 1,
	V4L2_MPEG_VIDEO_HEVC_SIZE_2		= 2,
	V4L2_MPEG_VIDEO_HEVC_SIZE_4		= 3,
};
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L0_BR	(V4L2_CID_CODEC_BASE + 636)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L1_BR	(V4L2_CID_CODEC_BASE + 637)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L2_BR	(V4L2_CID_CODEC_BASE + 638)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L3_BR	(V4L2_CID_CODEC_BASE + 639)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L4_BR	(V4L2_CID_CODEC_BASE + 640)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L5_BR	(V4L2_CID_CODEC_BASE + 641)
#define V4L2_CID_MPEG_VIDEO_HEVC_HIER_CODING_L6_BR	(V4L2_CID_CODEC_BASE + 642)
#define V4L2_CID_MPEG_VIDEO_REF_NUMBER_FOR_PFRAMES	(V4L2_CID_CODEC_BASE + 643)
#define V4L2_CID_MPEG_VIDEO_PREPEND_SPSPPS_TO_IDR	(V4L2_CID_CODEC_BASE + 644)
#define V4L2_CID_MPEG_VIDEO_CONSTANT_QUALITY		(V4L2_CID_CODEC_BASE + 645)
#define V4L2_CID_MPEG_VIDEO_FRAME_SKIP_MODE		(V4L2_CID_CODEC_BASE + 646)
enum v4l2_mpeg_video_frame_skip_mode {
	V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_DISABLED	= 0,
	V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT	= 1,
	V4L2_MPEG_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT	= 2,
};

#define V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MIN_QP        (V4L2_CID_CODEC_BASE + 647)
#define V4L2_CID_MPEG_VIDEO_HEVC_I_FRAME_MAX_QP        (V4L2_CID_CODEC_BASE + 648)
#define V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MIN_QP        (V4L2_CID_CODEC_BASE + 649)
#define V4L2_CID_MPEG_VIDEO_HEVC_P_FRAME_MAX_QP        (V4L2_CID_CODEC_BASE + 650)
#define V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MIN_QP        (V4L2_CID_CODEC_BASE + 651)
#define V4L2_CID_MPEG_VIDEO_HEVC_B_FRAME_MAX_QP        (V4L2_CID_CODEC_BASE + 652)

#define V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY		(V4L2_CID_CODEC_BASE + 653)
#define V4L2_CID_MPEG_VIDEO_DEC_DISPLAY_DELAY_ENABLE	(V4L2_CID_CODEC_BASE + 654)

#define V4L2_CID_MPEG_VIDEO_AV1_PROFILE (V4L2_CID_CODEC_BASE + 655)
/**
 * enum v4l2_mpeg_video_av1_profile - AV1 profiles
 *
 * @V4L2_MPEG_VIDEO_AV1_PROFILE_MAIN: compliant decoders must be able to decode
 * streams with seq_profile equal to 0.
 * @V4L2_MPEG_VIDEO_AV1_PROFILE_HIGH: compliant decoders must be able to decode
 * streams with seq_profile equal less than or equal to 1.
 * @V4L2_MPEG_VIDEO_AV1_PROFILE_PROFESSIONAL: compliant decoders must be able to
 * decode streams with seq_profile less than or equal to 2.
 *
 * Conveys the highest profile a decoder can work with.
 */
enum v4l2_mpeg_video_av1_profile {
	V4L2_MPEG_VIDEO_AV1_PROFILE_MAIN = 0,
	V4L2_MPEG_VIDEO_AV1_PROFILE_HIGH = 1,
	V4L2_MPEG_VIDEO_AV1_PROFILE_PROFESSIONAL = 2,
};

#define V4L2_CID_MPEG_VIDEO_AV1_LEVEL (V4L2_CID_CODEC_BASE + 656)
/**
 * enum v4l2_mpeg_video_av1_level - AV1 levels
 *
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_2_0: Level 2.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_2_1: Level 2.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_2_2: Level 2.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_2_3: Level 2.3.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_3_0: Level 3.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_3_1: Level 3.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_3_2: Level 3.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_3_3: Level 3.3.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_4_0: Level 4.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_4_1: Level 4.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_4_2: Level 4.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_4_3: Level 4.3.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_5_0: Level 5.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_5_1: Level 5.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_5_2: Level 5.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_5_3: Level 5.3.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_6_0: Level 6.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_6_1: Level 6.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_6_2: Level 6.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_6_3: Level 6.3.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_7_0: Level 7.0.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_7_1: Level 7.1.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_7_2: Level 7.2.
 * @V4L2_MPEG_VIDEO_AV1_LEVEL_7_3: Level 7.3.
 *
 * Conveys the highest level a decoder can work with.
 */
enum v4l2_mpeg_video_av1_level {
	V4L2_MPEG_VIDEO_AV1_LEVEL_2_0 = 0,
	V4L2_MPEG_VIDEO_AV1_LEVEL_2_1 = 1,
	V4L2_MPEG_VIDEO_AV1_LEVEL_2_2 = 2,
	V4L2_MPEG_VIDEO_AV1_LEVEL_2_3 = 3,

	V4L2_MPEG_VIDEO_AV1_LEVEL_3_0 = 4,
	V4L2_MPEG_VIDEO_AV1_LEVEL_3_1 = 5,
	V4L2_MPEG_VIDEO_AV1_LEVEL_3_2 = 6,
	V4L2_MPEG_VIDEO_AV1_LEVEL_3_3 = 7,

	V4L2_MPEG_VIDEO_AV1_LEVEL_4_0 = 8,
	V4L2_MPEG_VIDEO_AV1_LEVEL_4_1 = 9,
	V4L2_MPEG_VIDEO_AV1_LEVEL_4_2 = 10,
	V4L2_MPEG_VIDEO_AV1_LEVEL_4_3 = 11,

	V4L2_MPEG_VIDEO_AV1_LEVEL_5_0 = 12,
	V4L2_MPEG_VIDEO_AV1_LEVEL_5_1 = 13,
	V4L2_MPEG_VIDEO_AV1_LEVEL_5_2 = 14,
	V4L2_MPEG_VIDEO_AV1_LEVEL_5_3 = 15,

	V4L2_MPEG_VIDEO_AV1_LEVEL_6_0 = 16,
	V4L2_MPEG_VIDEO_AV1_LEVEL_6_1 = 17,
	V4L2_MPEG_VIDEO_AV1_LEVEL_6_2 = 18,
	V4L2_MPEG_VIDEO_AV1_LEVEL_6_3 = 19,

	V4L2_MPEG_VIDEO_AV1_LEVEL_7_0 = 20,
	V4L2_MPEG_VIDEO_AV1_LEVEL_7_1 = 21,
	V4L2_MPEG_VIDEO_AV1_LEVEL_7_2 = 22,
	V4L2_MPEG_VIDEO_AV1_LEVEL_7_3 = 23
};

#define V4L2_CID_MPEG_VIDEO_AVERAGE_QP  (V4L2_CID_CODEC_BASE + 657)

/*  MPEG-class control IDs specific to the CX2341x driver as defined by V4L2 */
#define V4L2_CID_CODEC_CX2341X_BASE				(V4L2_CTRL_CLASS_CODEC | 0x1000)
#define V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE		(V4L2_CID_CODEC_CX2341X_BASE+0)
enum v4l2_mpeg_cx2341x_video_spatial_filter_mode {
	V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_MANUAL = 0,
	V4L2_MPEG_CX2341X_VIDEO_SPATIAL_FILTER_MODE_AUTO   = 1,
};
#define V4L2_CID_MPEG_CX2341X_VIDEO_SPATIAL_FILTER		(V4L2_CID_CODEC_CX2341X_BASE+1)
#define V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE	(V4L2_CID_CODEC_CX2341X_BASE+2)
enum v4l2_mpeg_cx2341x_video_luma_spatial_filter_type {
	V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_OFF                  = 0,
	V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_HOR               = 1,
	V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_1D_VERT              = 2,
	V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_HV_SEPARABLE      = 3,
	V4L2_MPEG_CX2341X_VIDEO_LUMA_SPATIAL_FILTER_TYPE_2D_SYM_NON_SEPARABLE = 4,
};
#define V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE	(V4L2_CID_CODEC_CX2341X_BASE+3)
enum v4l2_mpeg_cx2341x_video_chroma_spatial_filter_type {
	V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_OFF    = 0,
	V4L2_MPEG_CX2341X_VIDEO_CHROMA_SPATIAL_FILTER_TYPE_1D_HOR = 1,
};
#define V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE	(V4L2_CID_CODEC_CX2341X_BASE+4)
enum v4l2_mpeg_cx2341x_video_temporal_filter_mode {
	V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_MANUAL = 0,
	V4L2_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER_MODE_AUTO   = 1,
};
#define V4L2_CID_MPEG_CX2341X_VIDEO_TEMPORAL_FILTER		(V4L2_CID_CODEC_CX2341X_BASE+5)
#define V4L2_CID_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE		(V4L2_CID_CODEC_CX2341X_BASE+6)
enum v4l2_mpeg_cx2341x_video_median_filter_type {
	V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_OFF      = 0,
	V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR      = 1,
	V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_VERT     = 2,
	V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_HOR_VERT = 3,
	V4L2_MPEG_CX2341X_VIDEO_MEDIAN_FILTER_TYPE_DIAG     = 4,
};
#define V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_BOTTOM	(V4L2_CID_CODEC_CX2341X_BASE+7)
#define V4L2_CID_MPEG_CX2341X_VIDEO_LUMA_MEDIAN_FILTER_TOP	(V4L2_CID_CODEC_CX2341X_BASE+8)
#define V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_BOTTOM	(V4L2_CID_CODEC_CX2341X_BASE+9)
#define V4L2_CID_MPEG_CX2341X_VIDEO_CHROMA_MEDIAN_FILTER_TOP	(V4L2_CID_CODEC_CX2341X_BASE+10)
#define V4L2_CID_MPEG_CX2341X_STREAM_INSERT_NAV_PACKETS		(V4L2_CID_CODEC_CX2341X_BASE+11)

/*  MPEG-class control IDs specific to the Samsung MFC 5.1 driver as defined by V4L2 */
#define V4L2_CID_CODEC_MFC51_BASE				(V4L2_CTRL_CLASS_CODEC | 0x1100)

#define V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY		(V4L2_CID_CODEC_MFC51_BASE+0)
#define V4L2_CID_MPEG_MFC51_VIDEO_DECODER_H264_DISPLAY_DELAY_ENABLE	(V4L2_CID_CODEC_MFC51_BASE+1)
#define V4L2_CID_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE			(V4L2_CID_CODEC_MFC51_BASE+2)
enum v4l2_mpeg_mfc51_video_frame_skip_mode {
	V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_DISABLED		= 0,
	V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_LEVEL_LIMIT	= 1,
	V4L2_MPEG_MFC51_VIDEO_FRAME_SKIP_MODE_BUF_LIMIT		= 2,
};
#define V4L2_CID_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE			(V4L2_CID_CODEC_MFC51_BASE+3)
enum v4l2_mpeg_mfc51_video_force_frame_type {
	V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_DISABLED		= 0,
	V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_I_FRAME		= 1,
	V4L2_MPEG_MFC51_VIDEO_FORCE_FRAME_TYPE_NOT_CODED	= 2,
};
#define V4L2_CID_MPEG_MFC51_VIDEO_PADDING				(V4L2_CID_CODEC_MFC51_BASE+4)
#define V4L2_CID_MPEG_MFC51_VIDEO_PADDING_YUV				(V4L2_CID_CODEC_MFC51_BASE+5)
#define V4L2_CID_MPEG_MFC51_VIDEO_RC_FIXED_TARGET_BIT			(V4L2_CID_CODEC_MFC51_BASE+6)
#define V4L2_CID_MPEG_MFC51_VIDEO_RC_REACTION_COEFF			(V4L2_CID_CODEC_MFC51_BASE+7)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_ACTIVITY		(V4L2_CID_CODEC_MFC51_BASE+50)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_DARK			(V4L2_CID_CODEC_MFC51_BASE+51)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_SMOOTH		(V4L2_CID_CODEC_MFC51_BASE+52)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_ADAPTIVE_RC_STATIC		(V4L2_CID_CODEC_MFC51_BASE+53)
#define V4L2_CID_MPEG_MFC51_VIDEO_H264_NUM_REF_PIC_FOR_P		(V4L2_CID_CODEC_MFC51_BASE+54)

/*  Camera class control IDs */

#define V4L2_CID_CAMERA_CLASS_BASE	(V4L2_CTRL_CLASS_CAMERA | 0x900)
#define V4L2_CID_CAMERA_CLASS		(V4L2_CTRL_CLASS_CAMERA | 1)

#define V4L2_CID_EXPOSURE_AUTO			(V4L2_CID_CAMERA_CLASS_BASE+1)
enum  v4l2_exposure_auto_type {
	V4L2_EXPOSURE_AUTO = 0,
	V4L2_EXPOSURE_MANUAL = 1,
	V4L2_EXPOSURE_SHUTTER_PRIORITY = 2,
	V4L2_EXPOSURE_APERTURE_PRIORITY = 3
};
#define V4L2_CID_EXPOSURE_ABSOLUTE		(V4L2_CID_CAMERA_CLASS_BASE+2)
#define V4L2_CID_EXPOSURE_AUTO_PRIORITY		(V4L2_CID_CAMERA_CLASS_BASE+3)

#define V4L2_CID_PAN_RELATIVE			(V4L2_CID_CAMERA_CLASS_BASE+4)
#define V4L2_CID_TILT_RELATIVE			(V4L2_CID_CAMERA_CLASS_BASE+5)
#define V4L2_CID_PAN_RESET			(V4L2_CID_CAMERA_CLASS_BASE+6)
#define V4L2_CID_TILT_RESET			(V4L2_CID_CAMERA_CLASS_BASE+7)

#define V4L2_CID_PAN_ABSOLUTE			(V4L2_CID_CAMERA_CLASS_BASE+8)
#define V4L2_CID_TILT_ABSOLUTE			(V4L2_CID_CAMERA_CLASS_BASE+9)

#define V4L2_CID_FOCUS_ABSOLUTE			(V4L2_CID_CAMERA_CLASS_BASE+10)
#define V4L2_CID_FOCUS_RELATIVE			(V4L2_CID_CAMERA_CLASS_BASE+11)
#define V4L2_CID_FOCUS_AUTO			(V4L2_CID_CAMERA_CLASS_BASE+12)

#define V4L2_CID_ZOOM_ABSOLUTE			(V4L2_CID_CAMERA_CLASS_BASE+13)
#define V4L2_CID_ZOOM_RELATIVE			(V4L2_CID_CAMERA_CLASS_BASE+14)
#define V4L2_CID_ZOOM_CONTINUOUS		(V4L2_CID_CAMERA_CLASS_BASE+15)

#define V4L2_CID_PRIVACY			(V4L2_CID_CAMERA_CLASS_BASE+16)

#define V4L2_CID_IRIS_ABSOLUTE			(V4L2_CID_CAMERA_CLASS_BASE+17)
#define V4L2_CID_IRIS_RELATIVE			(V4L2_CID_CAMERA_CLASS_BASE+18)

#define V4L2_CID_AUTO_EXPOSURE_BIAS		(V4L2_CID_CAMERA_CLASS_BASE+19)

#define V4L2_CID_AUTO_N_PRESET_WHITE_BALANCE	(V4L2_CID_CAMERA_CLASS_BASE+20)
enum v4l2_auto_n_preset_white_balance {
	V4L2_WHITE_BALANCE_MANUAL		= 0,
	V4L2_WHITE_BALANCE_AUTO			= 1,
	V4L2_WHITE_BALANCE_INCANDESCENT		= 2,
	V4L2_WHITE_BALANCE_FLUORESCENT		= 3,
	V4L2_WHITE_BALANCE_FLUORESCENT_H	= 4,
	V4L2_WHITE_BALANCE_HORIZON		= 5,
	V4L2_WHITE_BALANCE_DAYLIGHT		= 6,
	V4L2_WHITE_BALANCE_FLASH		= 7,
	V4L2_WHITE_BALANCE_CLOUDY		= 8,
	V4L2_WHITE_BALANCE_SHADE		= 9,
};

#define V4L2_CID_WIDE_DYNAMIC_RANGE		(V4L2_CID_CAMERA_CLASS_BASE+21)
#define V4L2_CID_IMAGE_STABILIZATION		(V4L2_CID_CAMERA_CLASS_BASE+22)

#define V4L2_CID_ISO_SENSITIVITY		(V4L2_CID_CAMERA_CLASS_BASE+23)
#define V4L2_CID_ISO_SENSITIVITY_AUTO		(V4L2_CID_CAMERA_CLASS_BASE+24)
enum v4l2_iso_sensitivity_auto_type {
	V4L2_ISO_SENSITIVITY_MANUAL		= 0,
	V4L2_ISO_SENSITIVITY_AUTO		= 1,
};

#define V4L2_CID_EXPOSURE_METERING		(V4L2_CID_CAMERA_CLASS_BASE+25)
enum v4l2_exposure_metering {
	V4L2_EXPOSURE_METERING_AVERAGE		= 0,
	V4L2_EXPOSURE_METERING_CENTER_WEIGHTED	= 1,
	V4L2_EXPOSURE_METERING_SPOT		= 2,
	V4L2_EXPOSURE_METERING_MATRIX		= 3,
};

#define V4L2_CID_SCENE_MODE			(V4L2_CID_CAMERA_CLASS_BASE+26)
enum v4l2_scene_mode {
	V4L2_SCENE_MODE_NONE			= 0,
	V4L2_SCENE_MODE_BACKLIGHT		= 1,
	V4L2_SCENE_MODE_BEACH_SNOW		= 2,
	V4L2_SCENE_MODE_CANDLE_LIGHT		= 3,
	V4L2_SCENE_MODE_DAWN_DUSK		= 4,
	V4L2_SCENE_MODE_FALL_COLORS		= 5,
	V4L2_SCENE_MODE_FIREWORKS		= 6,
	V4L2_SCENE_MODE_LANDSCAPE		= 7,
	V4L2_SCENE_MODE_NIGHT			= 8,
	V4L2_SCENE_MODE_PARTY_INDOOR		= 9,
	V4L2_SCENE_MODE_PORTRAIT		= 10,
	V4L2_SCENE_MODE_SPORTS			= 11,
	V4L2_SCENE_MODE_SUNSET			= 12,
	V4L2_SCENE_MODE_TEXT			= 13,
};

#define V4L2_CID_3A_LOCK			(V4L2_CID_CAMERA_CLASS_BASE+27)
#define V4L2_LOCK_EXPOSURE			(1 << 0)
#define V4L2_LOCK_WHITE_BALANCE			(1 << 1)
#define V4L2_LOCK_FOCUS				(1 << 2)

#define V4L2_CID_AUTO_FOCUS_START		(V4L2_CID_CAMERA_CLASS_BASE+28)
#define V4L2_CID_AUTO_FOCUS_STOP		(V4L2_CID_CAMERA_CLASS_BASE+29)
#define V4L2_CID_AUTO_FOCUS_STATUS		(V4L2_CID_CAMERA_CLASS_BASE+30)
#define V4L2_AUTO_FOCUS_STATUS_IDLE		(0 << 0)
#define V4L2_AUTO_FOCUS_STATUS_BUSY		(1 << 0)
#define V4L2_AUTO_FOCUS_STATUS_REACHED		(1 << 1)
#define V4L2_AUTO_FOCUS_STATUS_FAILED		(1 << 2)

#define V4L2_CID_AUTO_FOCUS_RANGE		(V4L2_CID_CAMERA_CLASS_BASE+31)
enum v4l2_auto_focus_range {
	V4L2_AUTO_FOCUS_RANGE_AUTO		= 0,
	V4L2_AUTO_FOCUS_RANGE_NORMAL		= 1,
	V4L2_AUTO_FOCUS_RANGE_MACRO		= 2,
	V4L2_AUTO_FOCUS_RANGE_INFINITY		= 3,
};

#define V4L2_CID_PAN_SPEED			(V4L2_CID_CAMERA_CLASS_BASE+32)
#define V4L2_CID_TILT_SPEED			(V4L2_CID_CAMERA_CLASS_BASE+33)

#define V4L2_CID_CAMERA_ORIENTATION		(V4L2_CID_CAMERA_CLASS_BASE+34)
#define V4L2_CAMERA_ORIENTATION_FRONT		0
#define V4L2_CAMERA_ORIENTATION_BACK		1
#define V4L2_CAMERA_ORIENTATION_EXTERNAL	2

#define V4L2_CID_CAMERA_SENSOR_ROTATION		(V4L2_CID_CAMERA_CLASS_BASE+35)

#define V4L2_CID_HDR_SENSOR_MODE		(V4L2_CID_CAMERA_CLASS_BASE+36)

/* FM Modulator class control IDs */

#define V4L2_CID_FM_TX_CLASS_BASE		(V4L2_CTRL_CLASS_FM_TX | 0x900)
#define V4L2_CID_FM_TX_CLASS			(V4L2_CTRL_CLASS_FM_TX | 1)

#define V4L2_CID_RDS_TX_DEVIATION		(V4L2_CID_FM_TX_CLASS_BASE + 1)
#define V4L2_CID_RDS_TX_PI			(V4L2_CID_FM_TX_CLASS_BASE + 2)
#define V4L2_CID_RDS_TX_PTY			(V4L2_CID_FM_TX_CLASS_BASE + 3)
#define V4L2_CID_RDS_TX_PS_NAME			(V4L2_CID_FM_TX_CLASS_BASE + 5)
#define V4L2_CID_RDS_TX_RADIO_TEXT		(V4L2_CID_FM_TX_CLASS_BASE + 6)
#define V4L2_CID_RDS_TX_MONO_STEREO		(V4L2_CID_FM_TX_CLASS_BASE + 7)
#define V4L2_CID_RDS_TX_ARTIFICIAL_HEAD		(V4L2_CID_FM_TX_CLASS_BASE + 8)
#define V4L2_CID_RDS_TX_COMPRESSED		(V4L2_CID_FM_TX_CLASS_BASE + 9)
#define V4L2_CID_RDS_TX_DYNAMIC_PTY		(V4L2_CID_FM_TX_CLASS_BASE + 10)
#define V4L2_CID_RDS_TX_TRAFFIC_ANNOUNCEMENT	(V4L2_CID_FM_TX_CLASS_BASE + 11)
#define V4L2_CID_RDS_TX_TRAFFIC_PROGRAM		(V4L2_CID_FM_TX_CLASS_BASE + 12)
#define V4L2_CID_RDS_TX_MUSIC_SPEECH		(V4L2_CID_FM_TX_CLASS_BASE + 13)
#define V4L2_CID_RDS_TX_ALT_FREQS_ENABLE	(V4L2_CID_FM_TX_CLASS_BASE + 14)
#define V4L2_CID_RDS_TX_ALT_FREQS		(V4L2_CID_FM_TX_CLASS_BASE + 15)

#define V4L2_CID_AUDIO_LIMITER_ENABLED		(V4L2_CID_FM_TX_CLASS_BASE + 64)
#define V4L2_CID_AUDIO_LIMITER_RELEASE_TIME	(V4L2_CID_FM_TX_CLASS_BASE + 65)
#define V4L2_CID_AUDIO_LIMITER_DEVIATION	(V4L2_CID_FM_TX_CLASS_BASE + 66)

#define V4L2_CID_AUDIO_COMPRESSION_ENABLED	(V4L2_CID_FM_TX_CLASS_BASE + 80)
#define V4L2_CID_AUDIO_COMPRESSION_GAIN		(V4L2_CID_FM_TX_CLASS_BASE + 81)
#define V4L2_CID_AUDIO_COMPRESSION_THRESHOLD	(V4L2_CID_FM_TX_CLASS_BASE + 82)
#define V4L2_CID_AUDIO_COMPRESSION_ATTACK_TIME	(V4L2_CID_FM_TX_CLASS_BASE + 83)
#define V4L2_CID_AUDIO_COMPRESSION_RELEASE_TIME	(V4L2_CID_FM_TX_CLASS_BASE + 84)

#define V4L2_CID_PILOT_TONE_ENABLED		(V4L2_CID_FM_TX_CLASS_BASE + 96)
#define V4L2_CID_PILOT_TONE_DEVIATION		(V4L2_CID_FM_TX_CLASS_BASE + 97)
#define V4L2_CID_PILOT_TONE_FREQUENCY		(V4L2_CID_FM_TX_CLASS_BASE + 98)

#define V4L2_CID_TUNE_PREEMPHASIS		(V4L2_CID_FM_TX_CLASS_BASE + 112)
enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED	= 0,
	V4L2_PREEMPHASIS_50_uS		= 1,
	V4L2_PREEMPHASIS_75_uS		= 2,
};
#define V4L2_CID_TUNE_POWER_LEVEL		(V4L2_CID_FM_TX_CLASS_BASE + 113)
#define V4L2_CID_TUNE_ANTENNA_CAPACITOR		(V4L2_CID_FM_TX_CLASS_BASE + 114)


/* Flash and privacy (indicator) light controls */

#define V4L2_CID_FLASH_CLASS_BASE		(V4L2_CTRL_CLASS_FLASH | 0x900)
#define V4L2_CID_FLASH_CLASS			(V4L2_CTRL_CLASS_FLASH | 1)

#define V4L2_CID_FLASH_LED_MODE			(V4L2_CID_FLASH_CLASS_BASE + 1)
enum v4l2_flash_led_mode {
	V4L2_FLASH_LED_MODE_NONE,
	V4L2_FLASH_LED_MODE_FLASH,
	V4L2_FLASH_LED_MODE_TORCH,
};

#define V4L2_CID_FLASH_STROBE_SOURCE		(V4L2_CID_FLASH_CLASS_BASE + 2)
enum v4l2_flash_strobe_source {
	V4L2_FLASH_STROBE_SOURCE_SOFTWARE,
	V4L2_FLASH_STROBE_SOURCE_EXTERNAL,
};

#define V4L2_CID_FLASH_STROBE			(V4L2_CID_FLASH_CLASS_BASE + 3)
#define V4L2_CID_FLASH_STROBE_STOP		(V4L2_CID_FLASH_CLASS_BASE + 4)
#define V4L2_CID_FLASH_STROBE_STATUS		(V4L2_CID_FLASH_CLASS_BASE + 5)

#define V4L2_CID_FLASH_TIMEOUT			(V4L2_CID_FLASH_CLASS_BASE + 6)
#define V4L2_CID_FLASH_INTENSITY		(V4L2_CID_FLASH_CLASS_BASE + 7)
#define V4L2_CID_FLASH_TORCH_INTENSITY		(V4L2_CID_FLASH_CLASS_BASE + 8)
#define V4L2_CID_FLASH_INDICATOR_INTENSITY	(V4L2_CID_FLASH_CLASS_BASE + 9)

#define V4L2_CID_FLASH_FAULT			(V4L2_CID_FLASH_CLASS_BASE + 10)
#define V4L2_FLASH_FAULT_OVER_VOLTAGE		(1 << 0)
#define V4L2_FLASH_FAULT_TIMEOUT		(1 << 1)
#define V4L2_FLASH_FAULT_OVER_TEMPERATURE	(1 << 2)
#define V4L2_FLASH_FAULT_SHORT_CIRCUIT		(1 << 3)
#define V4L2_FLASH_FAULT_OVER_CURRENT		(1 << 4)
#define V4L2_FLASH_FAULT_INDICATOR		(1 << 5)
#define V4L2_FLASH_FAULT_UNDER_VOLTAGE		(1 << 6)
#define V4L2_FLASH_FAULT_INPUT_VOLTAGE		(1 << 7)
#define V4L2_FLASH_FAULT_LED_OVER_TEMPERATURE	(1 << 8)

#define V4L2_CID_FLASH_CHARGE			(V4L2_CID_FLASH_CLASS_BASE + 11)
#define V4L2_CID_FLASH_READY			(V4L2_CID_FLASH_CLASS_BASE + 12)


/* JPEG-class control IDs */

#define V4L2_CID_JPEG_CLASS_BASE		(V4L2_CTRL_CLASS_JPEG | 0x900)
#define V4L2_CID_JPEG_CLASS			(V4L2_CTRL_CLASS_JPEG | 1)

#define	V4L2_CID_JPEG_CHROMA_SUBSAMPLING	(V4L2_CID_JPEG_CLASS_BASE + 1)
enum v4l2_jpeg_chroma_subsampling {
	V4L2_JPEG_CHROMA_SUBSAMPLING_444	= 0,
	V4L2_JPEG_CHROMA_SUBSAMPLING_422	= 1,
	V4L2_JPEG_CHROMA_SUBSAMPLING_420	= 2,
	V4L2_JPEG_CHROMA_SUBSAMPLING_411	= 3,
	V4L2_JPEG_CHROMA_SUBSAMPLING_410	= 4,
	V4L2_JPEG_CHROMA_SUBSAMPLING_GRAY	= 5,
};
#define	V4L2_CID_JPEG_RESTART_INTERVAL		(V4L2_CID_JPEG_CLASS_BASE + 2)
#define	V4L2_CID_JPEG_COMPRESSION_QUALITY	(V4L2_CID_JPEG_CLASS_BASE + 3)

#define	V4L2_CID_JPEG_ACTIVE_MARKER		(V4L2_CID_JPEG_CLASS_BASE + 4)
#define	V4L2_JPEG_ACTIVE_MARKER_APP0		(1 << 0)
#define	V4L2_JPEG_ACTIVE_MARKER_APP1		(1 << 1)
#define	V4L2_JPEG_ACTIVE_MARKER_COM		(1 << 16)
#define	V4L2_JPEG_ACTIVE_MARKER_DQT		(1 << 17)
#define	V4L2_JPEG_ACTIVE_MARKER_DHT		(1 << 18)


/* Image source controls */
#define V4L2_CID_IMAGE_SOURCE_CLASS_BASE	(V4L2_CTRL_CLASS_IMAGE_SOURCE | 0x900)
#define V4L2_CID_IMAGE_SOURCE_CLASS		(V4L2_CTRL_CLASS_IMAGE_SOURCE | 1)

#define V4L2_CID_VBLANK				(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 1)
#define V4L2_CID_HBLANK				(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 2)
#define V4L2_CID_ANALOGUE_GAIN			(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 3)
#define V4L2_CID_TEST_PATTERN_RED		(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 4)
#define V4L2_CID_TEST_PATTERN_GREENR		(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 5)
#define V4L2_CID_TEST_PATTERN_BLUE		(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 6)
#define V4L2_CID_TEST_PATTERN_GREENB		(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 7)
#define V4L2_CID_UNIT_CELL_SIZE			(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 8)
#define V4L2_CID_NOTIFY_GAINS			(V4L2_CID_IMAGE_SOURCE_CLASS_BASE + 9)


/* Image processing controls */

#define V4L2_CID_IMAGE_PROC_CLASS_BASE		(V4L2_CTRL_CLASS_IMAGE_PROC | 0x900)
#define V4L2_CID_IMAGE_PROC_CLASS		(V4L2_CTRL_CLASS_IMAGE_PROC | 1)

#define V4L2_CID_LINK_FREQ			(V4L2_CID_IMAGE_PROC_CLASS_BASE + 1)
#define V4L2_CID_PIXEL_RATE			(V4L2_CID_IMAGE_PROC_CLASS_BASE + 2)
#define V4L2_CID_TEST_PATTERN			(V4L2_CID_IMAGE_PROC_CLASS_BASE + 3)
#define V4L2_CID_DEINTERLACING_MODE		(V4L2_CID_IMAGE_PROC_CLASS_BASE + 4)
#define V4L2_CID_DIGITAL_GAIN			(V4L2_CID_IMAGE_PROC_CLASS_BASE + 5)

/*  DV-class control IDs defined by V4L2 */
#define V4L2_CID_DV_CLASS_BASE			(V4L2_CTRL_CLASS_DV | 0x900)
#define V4L2_CID_DV_CLASS			(V4L2_CTRL_CLASS_DV | 1)

#define	V4L2_CID_DV_TX_HOTPLUG			(V4L2_CID_DV_CLASS_BASE + 1)
#define	V4L2_CID_DV_TX_RXSENSE			(V4L2_CID_DV_CLASS_BASE + 2)
#define	V4L2_CID_DV_TX_EDID_PRESENT		(V4L2_CID_DV_CLASS_BASE + 3)
#define	V4L2_CID_DV_TX_MODE			(V4L2_CID_DV_CLASS_BASE + 4)
enum v4l2_dv_tx_mode {
	V4L2_DV_TX_MODE_DVI_D	= 0,
	V4L2_DV_TX_MODE_HDMI	= 1,
};
#define V4L2_CID_DV_TX_RGB_RANGE		(V4L2_CID_DV_CLASS_BASE + 5)
enum v4l2_dv_rgb_range {
	V4L2_DV_RGB_RANGE_AUTO	  = 0,
	V4L2_DV_RGB_RANGE_LIMITED = 1,
	V4L2_DV_RGB_RANGE_FULL	  = 2,
};

#define V4L2_CID_DV_TX_IT_CONTENT_TYPE		(V4L2_CID_DV_CLASS_BASE + 6)
enum v4l2_dv_it_content_type {
	V4L2_DV_IT_CONTENT_TYPE_GRAPHICS  = 0,
	V4L2_DV_IT_CONTENT_TYPE_PHOTO	  = 1,
	V4L2_DV_IT_CONTENT_TYPE_CINEMA	  = 2,
	V4L2_DV_IT_CONTENT_TYPE_GAME	  = 3,
	V4L2_DV_IT_CONTENT_TYPE_NO_ITC	  = 4,
};

#define	V4L2_CID_DV_RX_POWER_PRESENT		(V4L2_CID_DV_CLASS_BASE + 100)
#define V4L2_CID_DV_RX_RGB_RANGE		(V4L2_CID_DV_CLASS_BASE + 101)
#define V4L2_CID_DV_RX_IT_CONTENT_TYPE		(V4L2_CID_DV_CLASS_BASE + 102)

#define V4L2_CID_FM_RX_CLASS_BASE		(V4L2_CTRL_CLASS_FM_RX | 0x900)
#define V4L2_CID_FM_RX_CLASS			(V4L2_CTRL_CLASS_FM_RX | 1)

#define V4L2_CID_TUNE_DEEMPHASIS		(V4L2_CID_FM_RX_CLASS_BASE + 1)
enum v4l2_deemphasis {
	V4L2_DEEMPHASIS_DISABLED	= V4L2_PREEMPHASIS_DISABLED,
	V4L2_DEEMPHASIS_50_uS		= V4L2_PREEMPHASIS_50_uS,
	V4L2_DEEMPHASIS_75_uS		= V4L2_PREEMPHASIS_75_uS,
};

#define V4L2_CID_RDS_RECEPTION			(V4L2_CID_FM_RX_CLASS_BASE + 2)
#define V4L2_CID_RDS_RX_PTY			(V4L2_CID_FM_RX_CLASS_BASE + 3)
#define V4L2_CID_RDS_RX_PS_NAME			(V4L2_CID_FM_RX_CLASS_BASE + 4)
#define V4L2_CID_RDS_RX_RADIO_TEXT		(V4L2_CID_FM_RX_CLASS_BASE + 5)
#define V4L2_CID_RDS_RX_TRAFFIC_ANNOUNCEMENT	(V4L2_CID_FM_RX_CLASS_BASE + 6)
#define V4L2_CID_RDS_RX_TRAFFIC_PROGRAM		(V4L2_CID_FM_RX_CLASS_BASE + 7)
#define V4L2_CID_RDS_RX_MUSIC_SPEECH		(V4L2_CID_FM_RX_CLASS_BASE + 8)

#define V4L2_CID_RF_TUNER_CLASS_BASE		(V4L2_CTRL_CLASS_RF_TUNER | 0x900)
#define V4L2_CID_RF_TUNER_CLASS			(V4L2_CTRL_CLASS_RF_TUNER | 1)

#define V4L2_CID_RF_TUNER_BANDWIDTH_AUTO	(V4L2_CID_RF_TUNER_CLASS_BASE + 11)
#define V4L2_CID_RF_TUNER_BANDWIDTH		(V4L2_CID_RF_TUNER_CLASS_BASE + 12)
#define V4L2_CID_RF_TUNER_RF_GAIN		(V4L2_CID_RF_TUNER_CLASS_BASE + 32)
#define V4L2_CID_RF_TUNER_LNA_GAIN_AUTO		(V4L2_CID_RF_TUNER_CLASS_BASE + 41)
#define V4L2_CID_RF_TUNER_LNA_GAIN		(V4L2_CID_RF_TUNER_CLASS_BASE + 42)
#define V4L2_CID_RF_TUNER_MIXER_GAIN_AUTO	(V4L2_CID_RF_TUNER_CLASS_BASE + 51)
#define V4L2_CID_RF_TUNER_MIXER_GAIN		(V4L2_CID_RF_TUNER_CLASS_BASE + 52)
#define V4L2_CID_RF_TUNER_IF_GAIN_AUTO		(V4L2_CID_RF_TUNER_CLASS_BASE + 61)
#define V4L2_CID_RF_TUNER_IF_GAIN		(V4L2_CID_RF_TUNER_CLASS_BASE + 62)
#define V4L2_CID_RF_TUNER_PLL_LOCK			(V4L2_CID_RF_TUNER_CLASS_BASE + 91)


/*  Detection-class control IDs defined by V4L2 */
#define V4L2_CID_DETECT_CLASS_BASE		(V4L2_CTRL_CLASS_DETECT | 0x900)
#define V4L2_CID_DETECT_CLASS			(V4L2_CTRL_CLASS_DETECT | 1)

#define V4L2_CID_DETECT_MD_MODE			(V4L2_CID_DETECT_CLASS_BASE + 1)
enum v4l2_detect_md_mode {
	V4L2_DETECT_MD_MODE_DISABLED		= 0,
	V4L2_DETECT_MD_MODE_GLOBAL		= 1,
	V4L2_DETECT_MD_MODE_THRESHOLD_GRID	= 2,
	V4L2_DETECT_MD_MODE_REGION_GRID		= 3,
};
#define V4L2_CID_DETECT_MD_GLOBAL_THRESHOLD	(V4L2_CID_DETECT_CLASS_BASE + 2)
#define V4L2_CID_DETECT_MD_THRESHOLD_GRID	(V4L2_CID_DETECT_CLASS_BASE + 3)
#define V4L2_CID_DETECT_MD_REGION_GRID		(V4L2_CID_DETECT_CLASS_BASE + 4)


/*  Stateless CODECs controls */
#define V4L2_CID_CODEC_STATELESS_BASE          (V4L2_CTRL_CLASS_CODEC_STATELESS | 0x900)
#define V4L2_CID_CODEC_STATELESS_CLASS         (V4L2_CTRL_CLASS_CODEC_STATELESS | 1)

#define V4L2_CID_STATELESS_H264_DECODE_MODE	(V4L2_CID_CODEC_STATELESS_BASE + 0)
/**
 * enum v4l2_stateless_h264_decode_mode - Decoding mode
 *
 * @V4L2_STATELESS_H264_DECODE_MODE_SLICE_BASED: indicates that decoding
 * is performed one slice at a time. In this mode,
 * V4L2_CID_STATELESS_H264_SLICE_PARAMS must contain the parsed slice
 * parameters and the OUTPUT buffer must contain a single slice.
 * V4L2_BUF_CAP_SUPPORTS_M2M_HOLD_CAPTURE_BUF feature is used
 * in order to support multislice frames.
 * @V4L2_STATELESS_H264_DECODE_MODE_FRAME_BASED: indicates that
 * decoding is performed per frame. The OUTPUT buffer must contain
 * all slices and also both fields. This mode is typically supported
 * by device drivers that are able to parse the slice(s) header(s)
 * in hardware. When this mode is selected,
 * V4L2_CID_STATELESS_H264_SLICE_PARAMS is not used.
 */
enum v4l2_stateless_h264_decode_mode {
	V4L2_STATELESS_H264_DECODE_MODE_SLICE_BASED,
	V4L2_STATELESS_H264_DECODE_MODE_FRAME_BASED,
};

#define V4L2_CID_STATELESS_H264_START_CODE	(V4L2_CID_CODEC_STATELESS_BASE + 1)
/**
 * enum v4l2_stateless_h264_start_code - Start code
 *
 * @V4L2_STATELESS_H264_START_CODE_NONE: slices are passed
 * to the driver without any start code.
 * @V4L2_STATELESS_H264_START_CODE_ANNEX_B: slices are passed
 * to the driver with an Annex B start code prefix
 * (legal start codes can be 3-bytes 0x000001 or 4-bytes 0x00000001).
 * This mode is typically supported by device drivers that parse
 * the start code in hardware.
 */
enum v4l2_stateless_h264_start_code {
	V4L2_STATELESS_H264_START_CODE_NONE,
	V4L2_STATELESS_H264_START_CODE_ANNEX_B,
};

#define V4L2_H264_SPS_CONSTRAINT_SET0_FLAG			0x01
#define V4L2_H264_SPS_CONSTRAINT_SET1_FLAG			0x02
#define V4L2_H264_SPS_CONSTRAINT_SET2_FLAG			0x04
#define V4L2_H264_SPS_CONSTRAINT_SET3_FLAG			0x08
#define V4L2_H264_SPS_CONSTRAINT_SET4_FLAG			0x10
#define V4L2_H264_SPS_CONSTRAINT_SET5_FLAG			0x20

#define V4L2_H264_SPS_FLAG_SEPARATE_COLOUR_PLANE		0x01
#define V4L2_H264_SPS_FLAG_QPPRIME_Y_ZERO_TRANSFORM_BYPASS	0x02
#define V4L2_H264_SPS_FLAG_DELTA_PIC_ORDER_ALWAYS_ZERO		0x04
#define V4L2_H264_SPS_FLAG_GAPS_IN_FRAME_NUM_VALUE_ALLOWED	0x08
#define V4L2_H264_SPS_FLAG_FRAME_MBS_ONLY			0x10
#define V4L2_H264_SPS_FLAG_MB_ADAPTIVE_FRAME_FIELD		0x20
#define V4L2_H264_SPS_FLAG_DIRECT_8X8_INFERENCE			0x40

#define V4L2_H264_SPS_HAS_CHROMA_FORMAT(sps) \
	((sps)->profile_idc == 100 || (sps)->profile_idc == 110 || \
	 (sps)->profile_idc == 122 || (sps)->profile_idc == 244 || \
	 (sps)->profile_idc == 44  || (sps)->profile_idc == 83  || \
	 (sps)->profile_idc == 86  || (sps)->profile_idc == 118 || \
	 (sps)->profile_idc == 128 || (sps)->profile_idc == 138 || \
	 (sps)->profile_idc == 139 || (sps)->profile_idc == 134 || \
	 (sps)->profile_idc == 135)

#define V4L2_CID_STATELESS_H264_SPS		(V4L2_CID_CODEC_STATELESS_BASE + 2)
/**
 * struct v4l2_ctrl_h264_sps - H264 sequence parameter set
 *
 * All the members on this sequence parameter set structure match the
 * sequence parameter set syntax as specified by the H264 specification.
 *
 * @profile_idc: see H264 specification.
 * @constraint_set_flags: see H264 specification.
 * @level_idc: see H264 specification.
 * @seq_parameter_set_id: see H264 specification.
 * @chroma_format_idc: see H264 specification.
 * @bit_depth_luma_minus8: see H264 specification.
 * @bit_depth_chroma_minus8: see H264 specification.
 * @log2_max_frame_num_minus4: see H264 specification.
 * @pic_order_cnt_type: see H264 specification.
 * @log2_max_pic_order_cnt_lsb_minus4: see H264 specification.
 * @max_num_ref_frames: see H264 specification.
 * @num_ref_frames_in_pic_order_cnt_cycle: see H264 specification.
 * @offset_for_ref_frame: see H264 specification.
 * @offset_for_non_ref_pic: see H264 specification.
 * @offset_for_top_to_bottom_field: see H264 specification.
 * @pic_width_in_mbs_minus1: see H264 specification.
 * @pic_height_in_map_units_minus1: see H264 specification.
 * @flags: see V4L2_H264_SPS_FLAG_{}.
 */
struct v4l2_ctrl_h264_sps {
	u_int8_t profile_idc;
	u_int8_t constraint_set_flags;
	u_int8_t level_idc;
	u_int8_t seq_parameter_set_id;
	u_int8_t chroma_format_idc;
	u_int8_t bit_depth_luma_minus8;
	u_int8_t bit_depth_chroma_minus8;
	u_int8_t log2_max_frame_num_minus4;
	u_int8_t pic_order_cnt_type;
	u_int8_t log2_max_pic_order_cnt_lsb_minus4;
	u_int8_t max_num_ref_frames;
	u_int8_t num_ref_frames_in_pic_order_cnt_cycle;
	int32_t offset_for_ref_frame[255];
	int32_t offset_for_non_ref_pic;
	int32_t offset_for_top_to_bottom_field;
	u_int16_t pic_width_in_mbs_minus1;
	u_int16_t pic_height_in_map_units_minus1;
	u_int32_t flags;
};

#define V4L2_H264_PPS_FLAG_ENTROPY_CODING_MODE				0x0001
#define V4L2_H264_PPS_FLAG_BOTTOM_FIELD_PIC_ORDER_IN_FRAME_PRESENT	0x0002
#define V4L2_H264_PPS_FLAG_WEIGHTED_PRED				0x0004
#define V4L2_H264_PPS_FLAG_DEBLOCKING_FILTER_CONTROL_PRESENT		0x0008
#define V4L2_H264_PPS_FLAG_CONSTRAINED_INTRA_PRED			0x0010
#define V4L2_H264_PPS_FLAG_REDUNDANT_PIC_CNT_PRESENT			0x0020
#define V4L2_H264_PPS_FLAG_TRANSFORM_8X8_MODE				0x0040
#define V4L2_H264_PPS_FLAG_SCALING_MATRIX_PRESENT			0x0080

#define V4L2_CID_STATELESS_H264_PPS		(V4L2_CID_CODEC_STATELESS_BASE + 3)
/**
 * struct v4l2_ctrl_h264_pps - H264 picture parameter set
 *
 * Except where noted, all the members on this picture parameter set
 * structure match the picture parameter set syntax as specified
 * by the H264 specification.
 *
 * In particular, V4L2_H264_PPS_FLAG_SCALING_MATRIX_PRESENT flag
 * has a specific meaning. This flag should be set if a non-flat
 * scaling matrix applies to the picture. In this case, applications
 * are expected to use V4L2_CID_STATELESS_H264_SCALING_MATRIX,
 * to pass the values of the non-flat matrices.
 *
 * @pic_parameter_set_id: see H264 specification.
 * @seq_parameter_set_id: see H264 specification.
 * @num_slice_groups_minus1: see H264 specification.
 * @num_ref_idx_l0_default_active_minus1: see H264 specification.
 * @num_ref_idx_l1_default_active_minus1: see H264 specification.
 * @weighted_bipred_idc: see H264 specification.
 * @pic_init_qp_minus26: see H264 specification.
 * @pic_init_qs_minus26: see H264 specification.
 * @chroma_qp_index_offset: see H264 specification.
 * @second_chroma_qp_index_offset: see H264 specification.
 * @flags: see V4L2_H264_PPS_FLAG_{}.
 */
struct v4l2_ctrl_h264_pps {
	u_int8_t pic_parameter_set_id;
	u_int8_t seq_parameter_set_id;
	u_int8_t num_slice_groups_minus1;
	u_int8_t num_ref_idx_l0_default_active_minus1;
	u_int8_t num_ref_idx_l1_default_active_minus1;
	u_int8_t weighted_bipred_idc;
	int8_t pic_init_qp_minus26;
	int8_t pic_init_qs_minus26;
	int8_t chroma_qp_index_offset;
	int8_t second_chroma_qp_index_offset;
	u_int16_t flags;
};

#define V4L2_CID_STATELESS_H264_SCALING_MATRIX	(V4L2_CID_CODEC_STATELESS_BASE + 4)
/**
 * struct v4l2_ctrl_h264_scaling_matrix - H264 scaling matrices
 *
 * @scaling_list_4x4: scaling matrix after applying the inverse
 * scanning process. Expected list order is Intra Y, Intra Cb,
 * Intra Cr, Inter Y, Inter Cb, Inter Cr. The values on each
 * scaling list are expected in raster scan order.
 * @scaling_list_8x8: scaling matrix after applying the inverse
 * scanning process. Expected list order is Intra Y, Inter Y,
 * Intra Cb, Inter Cb, Intra Cr, Inter Cr. The values on each
 * scaling list are expected in raster scan order.
 *
 * Note that the list order is different for the 4x4 and 8x8
 * matrices as per the H264 specification, see table 7-2 "Assignment
 * of mnemonic names to scaling list indices and specification of
 * fall-back rule".
 */
struct v4l2_ctrl_h264_scaling_matrix {
	u_int8_t scaling_list_4x4[6][16];
	u_int8_t scaling_list_8x8[6][64];
};

struct v4l2_h264_weight_factors {
	int16_t luma_weight[32];
	int16_t luma_offset[32];
	int16_t chroma_weight[32][2];
	int16_t chroma_offset[32][2];
};

#define V4L2_H264_CTRL_PRED_WEIGHTS_REQUIRED(pps, slice) \
	((((pps)->flags & V4L2_H264_PPS_FLAG_WEIGHTED_PRED) && \
	 ((slice)->slice_type == V4L2_H264_SLICE_TYPE_P || \
	  (slice)->slice_type == V4L2_H264_SLICE_TYPE_SP)) || \
	 ((pps)->weighted_bipred_idc == 1 && \
	  (slice)->slice_type == V4L2_H264_SLICE_TYPE_B))

#define V4L2_CID_STATELESS_H264_PRED_WEIGHTS	(V4L2_CID_CODEC_STATELESS_BASE + 5)
/**
 * struct v4l2_ctrl_h264_pred_weights - Prediction weight table
 *
 * Prediction weight table, which matches the syntax specified
 * by the H264 specification.
 *
 * @luma_log2_weight_denom: see H264 specification.
 * @chroma_log2_weight_denom: see H264 specification.
 * @weight_factors: luma and chroma weight factors.
 */
struct v4l2_ctrl_h264_pred_weights {
	u_int16_t luma_log2_weight_denom;
	u_int16_t chroma_log2_weight_denom;
	struct v4l2_h264_weight_factors weight_factors[2];
};

#define V4L2_H264_SLICE_TYPE_P				0
#define V4L2_H264_SLICE_TYPE_B				1
#define V4L2_H264_SLICE_TYPE_I				2
#define V4L2_H264_SLICE_TYPE_SP				3
#define V4L2_H264_SLICE_TYPE_SI				4

#define V4L2_H264_SLICE_FLAG_DIRECT_SPATIAL_MV_PRED	0x01
#define V4L2_H264_SLICE_FLAG_SP_FOR_SWITCH		0x02

#define V4L2_H264_TOP_FIELD_REF				0x1
#define V4L2_H264_BOTTOM_FIELD_REF			0x2
#define V4L2_H264_FRAME_REF				0x3

/**
 * struct v4l2_h264_reference - H264 picture reference
 *
 * @fields: indicates how the picture is referenced.
 * Valid values are V4L2_H264_{}_REF.
 * @index: index into v4l2_ctrl_h264_decode_params.dpb[].
 */
struct v4l2_h264_reference {
	u_int8_t fields;
	u_int8_t index;
};

/*
 * Maximum DPB size, as specified by section 'A.3.1 Level limits
 * common to the Baseline, Main, and Extended profiles'.
 */
#define V4L2_H264_NUM_DPB_ENTRIES 16
#define V4L2_H264_REF_LIST_LEN (2 * V4L2_H264_NUM_DPB_ENTRIES)

#define V4L2_CID_STATELESS_H264_SLICE_PARAMS	(V4L2_CID_CODEC_STATELESS_BASE + 6)
/**
 * struct v4l2_ctrl_h264_slice_params - H264 slice parameters
 *
 * This structure holds the H264 syntax elements that are specified
 * as non-invariant for the slices in a given frame.
 *
 * Slice invariant syntax elements are contained in struct
 * v4l2_ctrl_h264_decode_params. This is done to reduce the API surface
 * on frame-based decoders, where slice header parsing is done by the
 * hardware.
 *
 * Slice invariant syntax elements are specified in specification section
 * "7.4.3 Slice header semantics".
 *
 * Except where noted, the members on this struct match the slice header syntax.
 *
 * @header_bit_size: offset in bits to slice_data() from the beginning of this slice.
 * @first_mb_in_slice: see H264 specification.
 * @slice_type: see H264 specification.
 * @colour_plane_id: see H264 specification.
 * @redundant_pic_cnt: see H264 specification.
 * @cabac_init_idc: see H264 specification.
 * @slice_qp_delta: see H264 specification.
 * @slice_qs_delta: see H264 specification.
 * @disable_deblocking_filter_idc: see H264 specification.
 * @slice_alpha_c0_offset_div2: see H264 specification.
 * @slice_beta_offset_div2: see H264 specification.
 * @num_ref_idx_l0_active_minus1: see H264 specification.
 * @num_ref_idx_l1_active_minus1: see H264 specification.
 * @reserved: padding field. Should be zeroed by applications.
 * @ref_pic_list0: reference picture list 0 after applying the per-slice modifications.
 * @ref_pic_list1: reference picture list 1 after applying the per-slice modifications.
 * @flags: see V4L2_H264_SLICE_FLAG_{}.
 */
struct v4l2_ctrl_h264_slice_params {
	u_int32_t header_bit_size;
	u_int32_t first_mb_in_slice;
	u_int8_t slice_type;
	u_int8_t colour_plane_id;
	u_int8_t redundant_pic_cnt;
	u_int8_t cabac_init_idc;
	int8_t slice_qp_delta;
	int8_t slice_qs_delta;
	u_int8_t disable_deblocking_filter_idc;
	int8_t slice_alpha_c0_offset_div2;
	int8_t slice_beta_offset_div2;
	u_int8_t num_ref_idx_l0_active_minus1;
	u_int8_t num_ref_idx_l1_active_minus1;

	u_int8_t reserved;

	struct v4l2_h264_reference ref_pic_list0[V4L2_H264_REF_LIST_LEN];
	struct v4l2_h264_reference ref_pic_list1[V4L2_H264_REF_LIST_LEN];

	u_int32_t flags;
};

#define V4L2_H264_DPB_ENTRY_FLAG_VALID		0x01
#define V4L2_H264_DPB_ENTRY_FLAG_ACTIVE		0x02
#define V4L2_H264_DPB_ENTRY_FLAG_LONG_TERM	0x04
#define V4L2_H264_DPB_ENTRY_FLAG_FIELD		0x08

/**
 * struct v4l2_h264_dpb_entry - H264 decoded picture buffer entry
 *
 * @reference_ts: timestamp of the V4L2 capture buffer to use as reference.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @pic_num: matches PicNum variable assigned during the reference
 * picture lists construction process.
 * @frame_num: frame identifier which matches frame_num syntax element.
 * @fields: indicates how the DPB entry is referenced. Valid values are
 * V4L2_H264_{}_REF.
 * @reserved: padding field. Should be zeroed by applications.
 * @top_field_order_cnt: matches TopFieldOrderCnt picture value.
 * @bottom_field_order_cnt: matches BottomFieldOrderCnt picture value.
 * Note that picture field is indicated by v4l2_buffer.field.
 * @flags: see V4L2_H264_DPB_ENTRY_FLAG_{}.
 */
struct v4l2_h264_dpb_entry {
	u_int64_t reference_ts;
	u_int32_t pic_num;
	u_int16_t frame_num;
	u_int8_t fields;
	u_int8_t reserved[5];
	int32_t top_field_order_cnt;
	int32_t bottom_field_order_cnt;
	u_int32_t flags;
};

#define V4L2_H264_DECODE_PARAM_FLAG_IDR_PIC		0x01
#define V4L2_H264_DECODE_PARAM_FLAG_FIELD_PIC		0x02
#define V4L2_H264_DECODE_PARAM_FLAG_BOTTOM_FIELD	0x04
#define V4L2_H264_DECODE_PARAM_FLAG_PFRAME		0x08
#define V4L2_H264_DECODE_PARAM_FLAG_BFRAME		0x10

#define V4L2_CID_STATELESS_H264_DECODE_PARAMS	(V4L2_CID_CODEC_STATELESS_BASE + 7)
/**
 * struct v4l2_ctrl_h264_decode_params - H264 decoding parameters
 *
 * @dpb: decoded picture buffer.
 * @nal_ref_idc: slice header syntax element.
 * @frame_num: slice header syntax element.
 * @top_field_order_cnt: matches TopFieldOrderCnt picture value.
 * @bottom_field_order_cnt: matches BottomFieldOrderCnt picture value.
 * Note that picture field is indicated by v4l2_buffer.field.
 * @idr_pic_id: slice header syntax element.
 * @pic_order_cnt_lsb: slice header syntax element.
 * @delta_pic_order_cnt_bottom: slice header syntax element.
 * @delta_pic_order_cnt0: slice header syntax element.
 * @delta_pic_order_cnt1: slice header syntax element.
 * @dec_ref_pic_marking_bit_size: size in bits of dec_ref_pic_marking()
 * syntax element.
 * @pic_order_cnt_bit_size: size in bits of pic order count syntax.
 * @slice_group_change_cycle: slice header syntax element.
 * @reserved: padding field. Should be zeroed by applications.
 * @flags: see V4L2_H264_DECODE_PARAM_FLAG_{}.
 */
struct v4l2_ctrl_h264_decode_params {
	struct v4l2_h264_dpb_entry dpb[V4L2_H264_NUM_DPB_ENTRIES];
	u_int16_t nal_ref_idc;
	u_int16_t frame_num;
	int32_t top_field_order_cnt;
	int32_t bottom_field_order_cnt;
	u_int16_t idr_pic_id;
	u_int16_t pic_order_cnt_lsb;
	int32_t delta_pic_order_cnt_bottom;
	int32_t delta_pic_order_cnt0;
	int32_t delta_pic_order_cnt1;
	u_int32_t dec_ref_pic_marking_bit_size;
	u_int32_t pic_order_cnt_bit_size;
	u_int32_t slice_group_change_cycle;

	u_int32_t reserved;
	u_int32_t flags;
};


/* Stateless FWHT control, used by the vicodec driver */

/* Current FWHT version */
#define V4L2_FWHT_VERSION			3

/* Set if this is an interlaced format */
#define V4L2_FWHT_FL_IS_INTERLACED		_BITUL(0)
/* Set if this is a bottom-first (NTSC) interlaced format */
#define V4L2_FWHT_FL_IS_BOTTOM_FIRST		_BITUL(1)
/* Set if each 'frame' contains just one field */
#define V4L2_FWHT_FL_IS_ALTERNATE		_BITUL(2)
/*
 * If V4L2_FWHT_FL_IS_ALTERNATE was set, then this is set if this
 * 'frame' is the bottom field, else it is the top field.
 */
#define V4L2_FWHT_FL_IS_BOTTOM_FIELD		_BITUL(3)
/* Set if the Y' plane is uncompressed */
#define V4L2_FWHT_FL_LUMA_IS_UNCOMPRESSED	_BITUL(4)
/* Set if the Cb plane is uncompressed */
#define V4L2_FWHT_FL_CB_IS_UNCOMPRESSED		_BITUL(5)
/* Set if the Cr plane is uncompressed */
#define V4L2_FWHT_FL_CR_IS_UNCOMPRESSED		_BITUL(6)
/* Set if the chroma plane is full height, if cleared it is half height */
#define V4L2_FWHT_FL_CHROMA_FULL_HEIGHT		_BITUL(7)
/* Set if the chroma plane is full width, if cleared it is half width */
#define V4L2_FWHT_FL_CHROMA_FULL_WIDTH		_BITUL(8)
/* Set if the alpha plane is uncompressed */
#define V4L2_FWHT_FL_ALPHA_IS_UNCOMPRESSED	_BITUL(9)
/* Set if this is an I Frame */
#define V4L2_FWHT_FL_I_FRAME			_BITUL(10)

/* A 4-values flag - the number of components - 1 */
#define V4L2_FWHT_FL_COMPONENTS_NUM_MSK		GENMASK(18, 16)
#define V4L2_FWHT_FL_COMPONENTS_NUM_OFFSET	16

/* A 4-values flag - the pixel encoding type */
#define V4L2_FWHT_FL_PIXENC_MSK			GENMASK(20, 19)
#define V4L2_FWHT_FL_PIXENC_OFFSET		19
#define V4L2_FWHT_FL_PIXENC_YUV			(1 << V4L2_FWHT_FL_PIXENC_OFFSET)
#define V4L2_FWHT_FL_PIXENC_RGB			(2 << V4L2_FWHT_FL_PIXENC_OFFSET)
#define V4L2_FWHT_FL_PIXENC_HSV			(3 << V4L2_FWHT_FL_PIXENC_OFFSET)

#define V4L2_CID_STATELESS_FWHT_PARAMS		(V4L2_CID_CODEC_STATELESS_BASE + 100)
/**
 * struct v4l2_ctrl_fwht_params - FWHT parameters
 *
 * @backward_ref_ts: timestamp of the V4L2 capture buffer to use as reference.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @version: must be V4L2_FWHT_VERSION.
 * @width: width of frame.
 * @height: height of frame.
 * @flags: FWHT flags (see V4L2_FWHT_FL_*).
 * @colorspace: the colorspace (enum v4l2_colorspace).
 * @xfer_func: the transfer function (enum v4l2_xfer_func).
 * @ycbcr_enc: the Y'CbCr encoding (enum v4l2_ycbcr_encoding).
 * @quantization: the quantization (enum v4l2_quantization).
 */
struct v4l2_ctrl_fwht_params {
	u_int64_t backward_ref_ts;
	u_int32_t version;
	u_int32_t width;
	u_int32_t height;
	u_int32_t flags;
	u_int32_t colorspace;
	u_int32_t xfer_func;
	u_int32_t ycbcr_enc;
	u_int32_t quantization;
};

/* Stateless VP8 control */

#define V4L2_VP8_SEGMENT_FLAG_ENABLED              0x01
#define V4L2_VP8_SEGMENT_FLAG_UPDATE_MAP           0x02
#define V4L2_VP8_SEGMENT_FLAG_UPDATE_FEATURE_DATA  0x04
#define V4L2_VP8_SEGMENT_FLAG_DELTA_VALUE_MODE     0x08

/**
 * struct v4l2_vp8_segment - VP8 segment-based adjustments parameters
 *
 * @quant_update: update values for the segment quantizer.
 * @lf_update: update values for the loop filter level.
 * @segment_probs: branch probabilities of the segment_id decoding tree.
 * @padding: padding field. Should be zeroed by applications.
 * @flags: see V4L2_VP8_SEGMENT_FLAG_{}.
 *
 * This structure contains segment-based adjustments related parameters.
 * See the 'update_segmentation()' part of the frame header syntax,
 * and section '9.3. Segment-Based Adjustments' of the VP8 specification
 * for more details.
 */
struct v4l2_vp8_segment {
	int8_t quant_update[4];
	int8_t lf_update[4];
	u_int8_t segment_probs[3];
	u_int8_t padding;
	u_int32_t flags;
};

#define V4L2_VP8_LF_ADJ_ENABLE	0x01
#define V4L2_VP8_LF_DELTA_UPDATE	0x02
#define V4L2_VP8_LF_FILTER_TYPE_SIMPLE	0x04

/**
 * struct v4l2_vp8_loop_filter - VP8 loop filter parameters
 *
 * @ref_frm_delta: Reference frame signed delta values.
 * @mb_mode_delta: MB prediction mode signed delta values.
 * @sharpness_level: matches sharpness_level syntax element.
 * @level: matches loop_filter_level syntax element.
 * @padding: padding field. Should be zeroed by applications.
 * @flags: see V4L2_VP8_LF_{}.
 *
 * This structure contains loop filter related parameters.
 * See the 'mb_lf_adjustments()' part of the frame header syntax,
 * and section '9.4. Loop Filter Type and Levels' of the VP8 specification
 * for more details.
 */
struct v4l2_vp8_loop_filter {
	int8_t ref_frm_delta[4];
	int8_t mb_mode_delta[4];
	u_int8_t sharpness_level;
	u_int8_t level;
	u_int16_t padding;
	u_int32_t flags;
};

/**
 * struct v4l2_vp8_quantization - VP8 quantizattion indices
 *
 * @y_ac_qi: luma AC coefficient table index.
 * @y_dc_delta: luma DC delta vaue.
 * @y2_dc_delta: y2 block DC delta value.
 * @y2_ac_delta: y2 block AC delta value.
 * @uv_dc_delta: chroma DC delta value.
 * @uv_ac_delta: chroma AC delta value.
 * @padding: padding field. Should be zeroed by applications.
 *
 * This structure contains the quantization indices present
 * in 'quant_indices()' part of the frame header syntax.
 * See section '9.6. Dequantization Indices' of the VP8 specification
 * for more details.
 */
struct v4l2_vp8_quantization {
	u_int8_t y_ac_qi;
	int8_t y_dc_delta;
	int8_t y2_dc_delta;
	int8_t y2_ac_delta;
	int8_t uv_dc_delta;
	int8_t uv_ac_delta;
	u_int16_t padding;
};

#define V4L2_VP8_COEFF_PROB_CNT 11
#define V4L2_VP8_MV_PROB_CNT 19

/**
 * struct v4l2_vp8_entropy - VP8 update probabilities
 *
 * @coeff_probs: coefficient probability update values.
 * @y_mode_probs: luma intra-prediction probabilities.
 * @uv_mode_probs: chroma intra-prediction probabilities.
 * @mv_probs: mv decoding probability.
 * @padding: padding field. Should be zeroed by applications.
 *
 * This structure contains the update probabilities present in
 * 'token_prob_update()' and 'mv_prob_update()' part of the frame header.
 * See section '17.2. Probability Updates' of the VP8 specification
 * for more details.
 */
struct v4l2_vp8_entropy {
	u_int8_t coeff_probs[4][8][3][V4L2_VP8_COEFF_PROB_CNT];
	u_int8_t y_mode_probs[4];
	u_int8_t uv_mode_probs[3];
	u_int8_t mv_probs[2][V4L2_VP8_MV_PROB_CNT];
	u_int8_t padding[3];
};

/**
 * struct v4l2_vp8_entropy_coder_state - VP8 boolean coder state
 *
 * @range: coder state value for "Range"
 * @value: coder state value for "Value"
 * @bit_count: number of bits left in range "Value".
 * @padding: padding field. Should be zeroed by applications.
 *
 * This structure contains the state for the boolean coder, as
 * explained in section '7. Boolean Entropy Decoder' of the VP8 specification.
 */
struct v4l2_vp8_entropy_coder_state {
	u_int8_t range;
	u_int8_t value;
	u_int8_t bit_count;
	u_int8_t padding;
};

#define V4L2_VP8_FRAME_FLAG_KEY_FRAME		0x01
#define V4L2_VP8_FRAME_FLAG_EXPERIMENTAL		0x02
#define V4L2_VP8_FRAME_FLAG_SHOW_FRAME		0x04
#define V4L2_VP8_FRAME_FLAG_MB_NO_SKIP_COEFF	0x08
#define V4L2_VP8_FRAME_FLAG_SIGN_BIAS_GOLDEN	0x10
#define V4L2_VP8_FRAME_FLAG_SIGN_BIAS_ALT	0x20

#define V4L2_VP8_FRAME_IS_KEY_FRAME(hdr) \
	(!!((hdr)->flags & V4L2_VP8_FRAME_FLAG_KEY_FRAME))

#define V4L2_CID_STATELESS_VP8_FRAME (V4L2_CID_CODEC_STATELESS_BASE + 200)
/**
 * struct v4l2_ctrl_vp8_frame - VP8 frame parameters
 *
 * @segment: segmentation parameters. See &v4l2_vp8_segment for more details
 * @lf: loop filter parameters. See &v4l2_vp8_loop_filter for more details
 * @quant: quantization parameters. See &v4l2_vp8_quantization for more details
 * @entropy: update probabilities. See &v4l2_vp8_entropy for more details
 * @coder_state: boolean coder state. See &v4l2_vp8_entropy_coder_state for more details
 * @width: frame width.
 * @height: frame height.
 * @horizontal_scale: horizontal scaling factor.
 * @vertical_scale: vertical scaling factor.
 * @version: bitstream version.
 * @prob_skip_false: frame header syntax element.
 * @prob_intra: frame header syntax element.
 * @prob_last: frame header syntax element.
 * @prob_gf: frame header syntax element.
 * @num_dct_parts: number of DCT coefficients partitions.
 * @first_part_size: size of the first partition, i.e. the control partition.
 * @first_part_header_bits: size in bits of the first partition header portion.
 * @dct_part_sizes: DCT coefficients sizes.
 * @last_frame_ts: "last" reference buffer timestamp.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @golden_frame_ts: "golden" reference buffer timestamp.
 * @alt_frame_ts: "alt" reference buffer timestamp.
 * @flags: see V4L2_VP8_FRAME_FLAG_{}.
 */
struct v4l2_ctrl_vp8_frame {
	struct v4l2_vp8_segment segment;
	struct v4l2_vp8_loop_filter lf;
	struct v4l2_vp8_quantization quant;
	struct v4l2_vp8_entropy entropy;
	struct v4l2_vp8_entropy_coder_state coder_state;

	u_int16_t width;
	u_int16_t height;

	u_int8_t horizontal_scale;
	u_int8_t vertical_scale;

	u_int8_t version;
	u_int8_t prob_skip_false;
	u_int8_t prob_intra;
	u_int8_t prob_last;
	u_int8_t prob_gf;
	u_int8_t num_dct_parts;

	u_int32_t first_part_size;
	u_int32_t first_part_header_bits;
	u_int32_t dct_part_sizes[8];

	u_int64_t last_frame_ts;
	u_int64_t golden_frame_ts;
	u_int64_t alt_frame_ts;

	u_int64_t flags;
};

/* Stateless MPEG-2 controls */

#define V4L2_MPEG2_SEQ_FLAG_PROGRESSIVE	0x01

#define V4L2_CID_STATELESS_MPEG2_SEQUENCE (V4L2_CID_CODEC_STATELESS_BASE+220)
/**
 * struct v4l2_ctrl_mpeg2_sequence - MPEG-2 sequence header
 *
 * All the members on this structure match the sequence header and sequence
 * extension syntaxes as specified by the MPEG-2 specification.
 *
 * Fields horizontal_size, vertical_size and vbv_buffer_size are a
 * combination of respective _value and extension syntax elements,
 * as described in section 6.3.3 "Sequence header".
 *
 * @horizontal_size: combination of elements horizontal_size_value and
 * horizontal_size_extension.
 * @vertical_size: combination of elements vertical_size_value and
 * vertical_size_extension.
 * @vbv_buffer_size: combination of elements vbv_buffer_size_value and
 * vbv_buffer_size_extension.
 * @profile_and_level_indication: see MPEG-2 specification.
 * @chroma_format: see MPEG-2 specification.
 * @flags: see V4L2_MPEG2_SEQ_FLAG_{}.
 */
struct v4l2_ctrl_mpeg2_sequence {
	u_int16_t	horizontal_size;
	u_int16_t	vertical_size;
	u_int32_t	vbv_buffer_size;
	u_int16_t	profile_and_level_indication;
	u_int8_t	chroma_format;
	u_int8_t	flags;
};

#define V4L2_MPEG2_PIC_CODING_TYPE_I			1
#define V4L2_MPEG2_PIC_CODING_TYPE_P			2
#define V4L2_MPEG2_PIC_CODING_TYPE_B			3
#define V4L2_MPEG2_PIC_CODING_TYPE_D			4

#define V4L2_MPEG2_PIC_TOP_FIELD			0x1
#define V4L2_MPEG2_PIC_BOTTOM_FIELD			0x2
#define V4L2_MPEG2_PIC_FRAME				0x3

#define V4L2_MPEG2_PIC_FLAG_TOP_FIELD_FIRST		0x0001
#define V4L2_MPEG2_PIC_FLAG_FRAME_PRED_DCT		0x0002
#define V4L2_MPEG2_PIC_FLAG_CONCEALMENT_MV		0x0004
#define V4L2_MPEG2_PIC_FLAG_Q_SCALE_TYPE		0x0008
#define V4L2_MPEG2_PIC_FLAG_INTRA_VLC			0x0010
#define V4L2_MPEG2_PIC_FLAG_ALT_SCAN			0x0020
#define V4L2_MPEG2_PIC_FLAG_REPEAT_FIRST		0x0040
#define V4L2_MPEG2_PIC_FLAG_PROGRESSIVE			0x0080

#define V4L2_CID_STATELESS_MPEG2_PICTURE (V4L2_CID_CODEC_STATELESS_BASE+221)
/**
 * struct v4l2_ctrl_mpeg2_picture - MPEG-2 picture header
 *
 * All the members on this structure match the picture header and picture
 * coding extension syntaxes as specified by the MPEG-2 specification.
 *
 * @backward_ref_ts: timestamp of the V4L2 capture buffer to use as
 * reference for backward prediction.
 * @forward_ref_ts: timestamp of the V4L2 capture buffer to use as
 * reference for forward prediction. These timestamp refers to the
 * timestamp field in struct v4l2_buffer. Use v4l2_timeval_to_ns()
 * to convert the struct timeval to a u_int64_t.
 * @flags: see V4L2_MPEG2_PIC_FLAG_{}.
 * @f_code: see MPEG-2 specification.
 * @picture_coding_type: see MPEG-2 specification.
 * @picture_structure: see V4L2_MPEG2_PIC_{}_FIELD.
 * @intra_dc_precision: see MPEG-2 specification.
 * @reserved: padding field. Should be zeroed by applications.
 */
struct v4l2_ctrl_mpeg2_picture {
	u_int64_t	backward_ref_ts;
	u_int64_t	forward_ref_ts;
	u_int32_t	flags;
	u_int8_t	f_code[2][2];
	u_int8_t	picture_coding_type;
	u_int8_t	picture_structure;
	u_int8_t	intra_dc_precision;
	u_int8_t	reserved[5];
};

#define V4L2_CID_STATELESS_MPEG2_QUANTISATION (V4L2_CID_CODEC_STATELESS_BASE+222)
/**
 * struct v4l2_ctrl_mpeg2_quantisation - MPEG-2 quantisation
 *
 * Quantisation matrices as specified by section 6.3.7
 * "Quant matrix extension".
 *
 * @intra_quantiser_matrix: The quantisation matrix coefficients
 * for intra-coded frames, in zigzag scanning order. It is relevant
 * for both luma and chroma components, although it can be superseded
 * by the chroma-specific matrix for non-4:2:0 YUV formats.
 * @non_intra_quantiser_matrix: The quantisation matrix coefficients
 * for non-intra-coded frames, in zigzag scanning order. It is relevant
 * for both luma and chroma components, although it can be superseded
 * by the chroma-specific matrix for non-4:2:0 YUV formats.
 * @chroma_intra_quantiser_matrix: The quantisation matrix coefficients
 * for the chominance component of intra-coded frames, in zigzag scanning
 * order. Only relevant for 4:2:2 and 4:4:4 YUV formats.
 * @chroma_non_intra_quantiser_matrix: The quantisation matrix coefficients
 * for the chrominance component of non-intra-coded frames, in zigzag scanning
 * order. Only relevant for 4:2:2 and 4:4:4 YUV formats.
 */
struct v4l2_ctrl_mpeg2_quantisation {
	u_int8_t	intra_quantiser_matrix[64];
	u_int8_t	non_intra_quantiser_matrix[64];
	u_int8_t	chroma_intra_quantiser_matrix[64];
	u_int8_t	chroma_non_intra_quantiser_matrix[64];
};

#define V4L2_CID_STATELESS_HEVC_SPS		(V4L2_CID_CODEC_STATELESS_BASE + 400)
#define V4L2_CID_STATELESS_HEVC_PPS		(V4L2_CID_CODEC_STATELESS_BASE + 401)
#define V4L2_CID_STATELESS_HEVC_SLICE_PARAMS	(V4L2_CID_CODEC_STATELESS_BASE + 402)
#define V4L2_CID_STATELESS_HEVC_SCALING_MATRIX	(V4L2_CID_CODEC_STATELESS_BASE + 403)
#define V4L2_CID_STATELESS_HEVC_DECODE_PARAMS	(V4L2_CID_CODEC_STATELESS_BASE + 404)
#define V4L2_CID_STATELESS_HEVC_DECODE_MODE	(V4L2_CID_CODEC_STATELESS_BASE + 405)
#define V4L2_CID_STATELESS_HEVC_START_CODE	(V4L2_CID_CODEC_STATELESS_BASE + 406)
#define V4L2_CID_STATELESS_HEVC_ENTRY_POINT_OFFSETS (V4L2_CID_CODEC_STATELESS_BASE + 407)

enum v4l2_stateless_hevc_decode_mode {
	V4L2_STATELESS_HEVC_DECODE_MODE_SLICE_BASED,
	V4L2_STATELESS_HEVC_DECODE_MODE_FRAME_BASED,
};

enum v4l2_stateless_hevc_start_code {
	V4L2_STATELESS_HEVC_START_CODE_NONE,
	V4L2_STATELESS_HEVC_START_CODE_ANNEX_B,
};

#define V4L2_HEVC_SLICE_TYPE_B	0
#define V4L2_HEVC_SLICE_TYPE_P	1
#define V4L2_HEVC_SLICE_TYPE_I	2

#define V4L2_HEVC_SPS_FLAG_SEPARATE_COLOUR_PLANE		(1ULL << 0)
#define V4L2_HEVC_SPS_FLAG_SCALING_LIST_ENABLED			(1ULL << 1)
#define V4L2_HEVC_SPS_FLAG_AMP_ENABLED				(1ULL << 2)
#define V4L2_HEVC_SPS_FLAG_SAMPLE_ADAPTIVE_OFFSET		(1ULL << 3)
#define V4L2_HEVC_SPS_FLAG_PCM_ENABLED				(1ULL << 4)
#define V4L2_HEVC_SPS_FLAG_PCM_LOOP_FILTER_DISABLED		(1ULL << 5)
#define V4L2_HEVC_SPS_FLAG_LONG_TERM_REF_PICS_PRESENT		(1ULL << 6)
#define V4L2_HEVC_SPS_FLAG_SPS_TEMPORAL_MVP_ENABLED		(1ULL << 7)
#define V4L2_HEVC_SPS_FLAG_STRONG_INTRA_SMOOTHING_ENABLED	(1ULL << 8)

/**
 * struct v4l2_ctrl_hevc_sps - ITU-T Rec. H.265: Sequence parameter set
 *
 * @video_parameter_set_id: specifies the value of the
 *			vps_video_parameter_set_id of the active VPS
 * @seq_parameter_set_id: provides an identifier for the SPS for
 *			  reference by other syntax elements
 * @pic_width_in_luma_samples:	specifies the width of each decoded picture
 *				in units of luma samples
 * @pic_height_in_luma_samples: specifies the height of each decoded picture
 *				in units of luma samples
 * @bit_depth_luma_minus8: this value plus 8specifies the bit depth of the
 *                         samples of the luma array
 * @bit_depth_chroma_minus8: this value plus 8 specifies the bit depth of the
 *                           samples of the chroma arrays
 * @log2_max_pic_order_cnt_lsb_minus4: this value plus 4 specifies the value of
 *                                     the variable MaxPicOrderCntLsb
 * @sps_max_dec_pic_buffering_minus1: this value plus 1 specifies the maximum
 *                                    required size of the decoded picture
 *                                    buffer for the codec video sequence
 * @sps_max_num_reorder_pics: indicates the maximum allowed number of pictures
 * @sps_max_latency_increase_plus1: not equal to 0 is used to compute the
 *				    value of SpsMaxLatencyPictures array
 * @log2_min_luma_coding_block_size_minus3: plus 3 specifies the minimum
 *					    luma coding block size
 * @log2_diff_max_min_luma_coding_block_size: specifies the difference between
 *					      the maximum and minimum luma
 *					      coding block size
 * @log2_min_luma_transform_block_size_minus2: plus 2 specifies the minimum luma
 *					       transform block size
 * @log2_diff_max_min_luma_transform_block_size: specifies the difference between
 *						 the maximum and minimum luma
 *						 transform block size
 * @max_transform_hierarchy_depth_inter: specifies the maximum hierarchy
 *					 depth for transform units of
 *					 coding units coded in inter
 *					 prediction mode
 * @max_transform_hierarchy_depth_intra: specifies the maximum hierarchy
 *					 depth for transform units of
 *					 coding units coded in intra
 *					 prediction mode
 * @pcm_sample_bit_depth_luma_minus1: this value plus 1 specifies the number of
 *                                    bits used to represent each of PCM sample
 *                                    values of the luma component
 * @pcm_sample_bit_depth_chroma_minus1: this value plus 1 specifies the number
 *                                      of bits used to represent each of PCM
 *                                      sample values of the chroma components
 * @log2_min_pcm_luma_coding_block_size_minus3: this value plus 3 specifies the
 *                                              minimum size of coding blocks
 * @log2_diff_max_min_pcm_luma_coding_block_size: specifies the difference between
 *						  the maximum and minimum size of
 *						  coding blocks
 * @num_short_term_ref_pic_sets: specifies the number of st_ref_pic_set()
 *				 syntax structures included in the SPS
 * @num_long_term_ref_pics_sps: specifies the number of candidate long-term
 *				reference pictures that are specified in the SPS
 * @chroma_format_idc: specifies the chroma sampling
 * @sps_max_sub_layers_minus1: this value plus 1 specifies the maximum number
 *                             of temporal sub-layers
 * @reserved: padding field. Should be zeroed by applications.
 * @flags: see V4L2_HEVC_SPS_FLAG_{}
 */
struct v4l2_ctrl_hevc_sps {
	u_int8_t	video_parameter_set_id;
	u_int8_t	seq_parameter_set_id;
	u_int16_t	pic_width_in_luma_samples;
	u_int16_t	pic_height_in_luma_samples;
	u_int8_t	bit_depth_luma_minus8;
	u_int8_t	bit_depth_chroma_minus8;
	u_int8_t	log2_max_pic_order_cnt_lsb_minus4;
	u_int8_t	sps_max_dec_pic_buffering_minus1;
	u_int8_t	sps_max_num_reorder_pics;
	u_int8_t	sps_max_latency_increase_plus1;
	u_int8_t	log2_min_luma_coding_block_size_minus3;
	u_int8_t	log2_diff_max_min_luma_coding_block_size;
	u_int8_t	log2_min_luma_transform_block_size_minus2;
	u_int8_t	log2_diff_max_min_luma_transform_block_size;
	u_int8_t	max_transform_hierarchy_depth_inter;
	u_int8_t	max_transform_hierarchy_depth_intra;
	u_int8_t	pcm_sample_bit_depth_luma_minus1;
	u_int8_t	pcm_sample_bit_depth_chroma_minus1;
	u_int8_t	log2_min_pcm_luma_coding_block_size_minus3;
	u_int8_t	log2_diff_max_min_pcm_luma_coding_block_size;
	u_int8_t	num_short_term_ref_pic_sets;
	u_int8_t	num_long_term_ref_pics_sps;
	u_int8_t	chroma_format_idc;
	u_int8_t	sps_max_sub_layers_minus1;

	u_int8_t	reserved[6];
	u_int64_t	flags;
};

#define V4L2_HEVC_PPS_FLAG_DEPENDENT_SLICE_SEGMENT_ENABLED	(1ULL << 0)
#define V4L2_HEVC_PPS_FLAG_OUTPUT_FLAG_PRESENT			(1ULL << 1)
#define V4L2_HEVC_PPS_FLAG_SIGN_DATA_HIDING_ENABLED		(1ULL << 2)
#define V4L2_HEVC_PPS_FLAG_CABAC_INIT_PRESENT			(1ULL << 3)
#define V4L2_HEVC_PPS_FLAG_CONSTRAINED_INTRA_PRED		(1ULL << 4)
#define V4L2_HEVC_PPS_FLAG_TRANSFORM_SKIP_ENABLED		(1ULL << 5)
#define V4L2_HEVC_PPS_FLAG_CU_QP_DELTA_ENABLED			(1ULL << 6)
#define V4L2_HEVC_PPS_FLAG_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT	(1ULL << 7)
#define V4L2_HEVC_PPS_FLAG_WEIGHTED_PRED			(1ULL << 8)
#define V4L2_HEVC_PPS_FLAG_WEIGHTED_BIPRED			(1ULL << 9)
#define V4L2_HEVC_PPS_FLAG_TRANSQUANT_BYPASS_ENABLED		(1ULL << 10)
#define V4L2_HEVC_PPS_FLAG_TILES_ENABLED			(1ULL << 11)
#define V4L2_HEVC_PPS_FLAG_ENTROPY_CODING_SYNC_ENABLED		(1ULL << 12)
#define V4L2_HEVC_PPS_FLAG_LOOP_FILTER_ACROSS_TILES_ENABLED	(1ULL << 13)
#define V4L2_HEVC_PPS_FLAG_PPS_LOOP_FILTER_ACROSS_SLICES_ENABLED (1ULL << 14)
#define V4L2_HEVC_PPS_FLAG_DEBLOCKING_FILTER_OVERRIDE_ENABLED	(1ULL << 15)
#define V4L2_HEVC_PPS_FLAG_PPS_DISABLE_DEBLOCKING_FILTER	(1ULL << 16)
#define V4L2_HEVC_PPS_FLAG_LISTS_MODIFICATION_PRESENT		(1ULL << 17)
#define V4L2_HEVC_PPS_FLAG_SLICE_SEGMENT_HEADER_EXTENSION_PRESENT (1ULL << 18)
#define V4L2_HEVC_PPS_FLAG_DEBLOCKING_FILTER_CONTROL_PRESENT	(1ULL << 19)
#define V4L2_HEVC_PPS_FLAG_UNIFORM_SPACING			(1ULL << 20)

/**
 * struct v4l2_ctrl_hevc_pps - ITU-T Rec. H.265: Picture parameter set
 *
 * @pic_parameter_set_id: identifies the PPS for reference by other
 *			  syntax elements
 * @num_extra_slice_header_bits: specifies the number of extra slice header
 *				 bits that are present in the slice header RBSP
 *				 for coded pictures referring to the PPS.
 * @num_ref_idx_l0_default_active_minus1: this value plus 1 specifies the
 *                                        inferred value of num_ref_idx_l0_active_minus1
 * @num_ref_idx_l1_default_active_minus1: this value plus 1 specifies the
 *                                        inferred value of num_ref_idx_l1_active_minus1
 * @init_qp_minus26: this value plus 26 specifies the initial value of SliceQp Y for
 *		     each slice referring to the PPS
 * @diff_cu_qp_delta_depth: specifies the difference between the luma coding
 *			    tree block size and the minimum luma coding block
 *			    size of coding units that convey cu_qp_delta_abs
 *			    and cu_qp_delta_sign_flag
 * @pps_cb_qp_offset: specify the offsets to the luma quantization parameter Cb
 * @pps_cr_qp_offset: specify the offsets to the luma quantization parameter Cr
 * @num_tile_columns_minus1: this value plus 1 specifies the number of tile columns
 *			     partitioning the picture
 * @num_tile_rows_minus1: this value plus 1 specifies the number of tile rows partitioning
 *			  the picture
 * @column_width_minus1: this value plus 1 specifies the width of the each tile column in
 *			 units of coding tree blocks
 * @row_height_minus1: this value plus 1 specifies the height of the each tile row in
 *		       units of coding tree blocks
 * @pps_beta_offset_div2: specify the default deblocking parameter offsets for
 *			  beta divided by 2
 * @pps_tc_offset_div2: specify the default deblocking parameter offsets for tC
 *			divided by 2
 * @log2_parallel_merge_level_minus2: this value plus 2 specifies the value of
 *                                    the variable Log2ParMrgLevel
 * @reserved: padding field. Should be zeroed by applications.
 * @flags: see V4L2_HEVC_PPS_FLAG_{}
 */
struct v4l2_ctrl_hevc_pps {
	u_int8_t	pic_parameter_set_id;
	u_int8_t	num_extra_slice_header_bits;
	u_int8_t	num_ref_idx_l0_default_active_minus1;
	u_int8_t	num_ref_idx_l1_default_active_minus1;
	int8_t	init_qp_minus26;
	u_int8_t	diff_cu_qp_delta_depth;
	int8_t	pps_cb_qp_offset;
	int8_t	pps_cr_qp_offset;
	u_int8_t	num_tile_columns_minus1;
	u_int8_t	num_tile_rows_minus1;
	u_int8_t	column_width_minus1[20];
	u_int8_t	row_height_minus1[22];
	int8_t	pps_beta_offset_div2;
	int8_t	pps_tc_offset_div2;
	u_int8_t	log2_parallel_merge_level_minus2;
	u_int8_t	reserved;
	u_int64_t	flags;
};

#define V4L2_HEVC_DPB_ENTRY_LONG_TERM_REFERENCE	0x01

#define V4L2_HEVC_SEI_PIC_STRUCT_FRAME				0
#define V4L2_HEVC_SEI_PIC_STRUCT_TOP_FIELD			1
#define V4L2_HEVC_SEI_PIC_STRUCT_BOTTOM_FIELD			2
#define V4L2_HEVC_SEI_PIC_STRUCT_TOP_BOTTOM			3
#define V4L2_HEVC_SEI_PIC_STRUCT_BOTTOM_TOP			4
#define V4L2_HEVC_SEI_PIC_STRUCT_TOP_BOTTOM_TOP			5
#define V4L2_HEVC_SEI_PIC_STRUCT_BOTTOM_TOP_BOTTOM		6
#define V4L2_HEVC_SEI_PIC_STRUCT_FRAME_DOUBLING			7
#define V4L2_HEVC_SEI_PIC_STRUCT_FRAME_TRIPLING			8
#define V4L2_HEVC_SEI_PIC_STRUCT_TOP_PAIRED_PREVIOUS_BOTTOM	9
#define V4L2_HEVC_SEI_PIC_STRUCT_BOTTOM_PAIRED_PREVIOUS_TOP	10
#define V4L2_HEVC_SEI_PIC_STRUCT_TOP_PAIRED_NEXT_BOTTOM		11
#define V4L2_HEVC_SEI_PIC_STRUCT_BOTTOM_PAIRED_NEXT_TOP		12

#define V4L2_HEVC_DPB_ENTRIES_NUM_MAX		16

/**
 * struct v4l2_hevc_dpb_entry - HEVC decoded picture buffer entry
 *
 * @timestamp: timestamp of the V4L2 capture buffer to use as reference.
 * @flags: long term flag for the reference frame
 * @field_pic: whether the reference is a field picture or a frame.
 * @reserved: padding field. Should be zeroed by applications.
 * @pic_order_cnt_val: the picture order count of the current picture.
 */
struct v4l2_hevc_dpb_entry {
	u_int64_t	timestamp;
	u_int8_t	flags;
	u_int8_t	field_pic;
	u_int16_t	reserved;
	int32_t	pic_order_cnt_val;
};

/**
 * struct v4l2_hevc_pred_weight_table - HEVC weighted prediction parameters
 *
 * @delta_luma_weight_l0: the difference of the weighting factor applied
 *			  to the luma prediction value for list 0
 * @luma_offset_l0: the additive offset applied to the luma prediction value
 *		    for list 0
 * @delta_chroma_weight_l0: the difference of the weighting factor applied
 *			    to the chroma prediction values for list 0
 * @chroma_offset_l0: the difference of the additive offset applied to
 *		      the chroma prediction values for list 0
 * @delta_luma_weight_l1: the difference of the weighting factor applied
 *			  to the luma prediction value for list 1
 * @luma_offset_l1: the additive offset applied to the luma prediction value
 *		    for list 1
 * @delta_chroma_weight_l1: the difference of the weighting factor applied
 *			    to the chroma prediction values for list 1
 * @chroma_offset_l1: the difference of the additive offset applied to
 *		      the chroma prediction values for list 1
 * @luma_log2_weight_denom: the base 2 logarithm of the denominator for
 *			    all luma weighting factors
 * @delta_chroma_log2_weight_denom: the difference of the base 2 logarithm
 *				    of the denominator for all chroma
 *				    weighting factors
 */
struct v4l2_hevc_pred_weight_table {
	int8_t	delta_luma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	int8_t	luma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	int8_t	delta_chroma_weight_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2];
	int8_t	chroma_offset_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2];

	int8_t	delta_luma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	int8_t	luma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	int8_t	delta_chroma_weight_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2];
	int8_t	chroma_offset_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX][2];

	u_int8_t	luma_log2_weight_denom;
	int8_t	delta_chroma_log2_weight_denom;
};

#define V4L2_HEVC_SLICE_PARAMS_FLAG_SLICE_SAO_LUMA		(1ULL << 0)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_SLICE_SAO_CHROMA		(1ULL << 1)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_SLICE_TEMPORAL_MVP_ENABLED	(1ULL << 2)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_MVD_L1_ZERO			(1ULL << 3)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_CABAC_INIT			(1ULL << 4)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_COLLOCATED_FROM_L0		(1ULL << 5)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_USE_INTEGER_MV		(1ULL << 6)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_SLICE_DEBLOCKING_FILTER_DISABLED (1ULL << 7)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_SLICE_LOOP_FILTER_ACROSS_SLICES_ENABLED (1ULL << 8)
#define V4L2_HEVC_SLICE_PARAMS_FLAG_DEPENDENT_SLICE_SEGMENT	(1ULL << 9)

/**
 * struct v4l2_ctrl_hevc_slice_params - HEVC slice parameters
 *
 * This control is a dynamically sized 1-dimensional array,
 * V4L2_CTRL_FLAG_DYNAMIC_ARRAY flag must be set when using it.
 *
 * @bit_size: size (in bits) of the current slice data
 * @data_byte_offset: offset (in bytes) to the video data in the current slice data
 * @num_entry_point_offsets: specifies the number of entry point offset syntax
 *			     elements in the slice header.
 * @nal_unit_type: specifies the coding type of the slice (B, P or I)
 * @nuh_temporal_id_plus1: minus 1 specifies a temporal identifier for the NAL unit
 * @slice_type: see V4L2_HEVC_SLICE_TYPE_{}
 * @colour_plane_id: specifies the colour plane associated with the current slice
 * @slice_pic_order_cnt: specifies the picture order count
 * @num_ref_idx_l0_active_minus1: this value plus 1 specifies the maximum
 *                                reference index for reference picture list 0
 *                                that may be used to decode the slice
 * @num_ref_idx_l1_active_minus1: this value plus 1 specifies the maximum
 *                                reference index for reference picture list 1
 *                                that may be used to decode the slice
 * @collocated_ref_idx: specifies the reference index of the collocated picture used
 *			for temporal motion vector prediction
 * @five_minus_max_num_merge_cand: specifies the maximum number of merging
 *				   motion vector prediction candidates supported in
 *				   the slice subtracted from 5
 * @slice_qp_delta: specifies the initial value of QpY to be used for the coding
 *		    blocks in the slice
 * @slice_cb_qp_offset: specifies a difference to be added to the value of pps_cb_qp_offset
 * @slice_cr_qp_offset: specifies a difference to be added to the value of pps_cr_qp_offset
 * @slice_act_y_qp_offset: screen content extension parameters
 * @slice_act_cb_qp_offset: screen content extension parameters
 * @slice_act_cr_qp_offset: screen content extension parameters
 * @slice_beta_offset_div2: specify the deblocking parameter offsets for beta divided by 2
 * @slice_tc_offset_div2: specify the deblocking parameter offsets for tC divided by 2
 * @pic_struct: indicates whether a picture should be displayed as a frame or as one or
 *		more fields
 * @reserved0: padding field. Should be zeroed by applications.
 * @slice_segment_addr: specifies the address of the first coding tree block in
 *			the slice segment
 * @ref_idx_l0: the list of L0 reference elements as indices in the DPB
 * @ref_idx_l1: the list of L1 reference elements as indices in the DPB
 * @short_term_ref_pic_set_size: specifies the size of short-term reference
 *				 pictures set included in the SPS
 * @long_term_ref_pic_set_size: specifies the size of long-term reference
 *				pictures set include in the SPS
 * @pred_weight_table: the prediction weight coefficients for inter-picture
 *		       prediction
 * @reserved1: padding field. Should be zeroed by applications.
 * @flags: see V4L2_HEVC_SLICE_PARAMS_FLAG_{}
 */
struct v4l2_ctrl_hevc_slice_params {
	u_int32_t	bit_size;
	u_int32_t	data_byte_offset;
	u_int32_t	num_entry_point_offsets;

	/* ISO/IEC 23008-2, ITU-T Rec. H.265: NAL unit header */
	u_int8_t	nal_unit_type;
	u_int8_t	nuh_temporal_id_plus1;

	/* ISO/IEC 23008-2, ITU-T Rec. H.265: General slice segment header */
	u_int8_t	slice_type;
	u_int8_t	colour_plane_id;
	int32_t	slice_pic_order_cnt;
	u_int8_t	num_ref_idx_l0_active_minus1;
	u_int8_t	num_ref_idx_l1_active_minus1;
	u_int8_t	collocated_ref_idx;
	u_int8_t	five_minus_max_num_merge_cand;
	int8_t	slice_qp_delta;
	int8_t	slice_cb_qp_offset;
	int8_t	slice_cr_qp_offset;
	int8_t	slice_act_y_qp_offset;
	int8_t	slice_act_cb_qp_offset;
	int8_t	slice_act_cr_qp_offset;
	int8_t	slice_beta_offset_div2;
	int8_t	slice_tc_offset_div2;

	/* ISO/IEC 23008-2, ITU-T Rec. H.265: Picture timing SEI message */
	u_int8_t	pic_struct;

	u_int8_t	reserved0[3];
	/* ISO/IEC 23008-2, ITU-T Rec. H.265: General slice segment header */
	u_int32_t	slice_segment_addr;
	u_int8_t	ref_idx_l0[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int8_t	ref_idx_l1[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int16_t	short_term_ref_pic_set_size;
	u_int16_t	long_term_ref_pic_set_size;

	/* ISO/IEC 23008-2, ITU-T Rec. H.265: Weighted prediction parameter */
	struct v4l2_hevc_pred_weight_table pred_weight_table;

	u_int8_t	reserved1[2];
	u_int64_t	flags;
};

#define V4L2_HEVC_DECODE_PARAM_FLAG_IRAP_PIC		0x1
#define V4L2_HEVC_DECODE_PARAM_FLAG_IDR_PIC		0x2
#define V4L2_HEVC_DECODE_PARAM_FLAG_NO_OUTPUT_OF_PRIOR  0x4

/**
 * struct v4l2_ctrl_hevc_decode_params - HEVC decode parameters
 *
 * @pic_order_cnt_val: picture order count
 * @short_term_ref_pic_set_size: specifies the size of short-term reference
 *				 pictures set included in the SPS of the first slice
 * @long_term_ref_pic_set_size: specifies the size of long-term reference
 *				pictures set include in the SPS of the first slice
 * @num_active_dpb_entries: the number of entries in dpb
 * @num_poc_st_curr_before: the number of reference pictures in the short-term
 *			    set that come before the current frame
 * @num_poc_st_curr_after: the number of reference pictures in the short-term
 *			   set that come after the current frame
 * @num_poc_lt_curr: the number of reference pictures in the long-term set
 * @poc_st_curr_before: provides the index of the short term before references
 *			in DPB array
 * @poc_st_curr_after: provides the index of the short term after references
 *		       in DPB array
 * @poc_lt_curr: provides the index of the long term references in DPB array
 * @num_delta_pocs_of_ref_rps_idx: same as the derived value NumDeltaPocs[RefRpsIdx],
 *				   can be used to parse the RPS data in slice headers
 *				   instead of skipping it with @short_term_ref_pic_set_size.
 * @reserved: padding field. Should be zeroed by applications.
 * @dpb: the decoded picture buffer, for meta-data about reference frames
 * @flags: see V4L2_HEVC_DECODE_PARAM_FLAG_{}
 */
struct v4l2_ctrl_hevc_decode_params {
	int32_t	pic_order_cnt_val;
	u_int16_t	short_term_ref_pic_set_size;
	u_int16_t	long_term_ref_pic_set_size;
	u_int8_t	num_active_dpb_entries;
	u_int8_t	num_poc_st_curr_before;
	u_int8_t	num_poc_st_curr_after;
	u_int8_t	num_poc_lt_curr;
	u_int8_t	poc_st_curr_before[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int8_t	poc_st_curr_after[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int8_t	poc_lt_curr[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int8_t	num_delta_pocs_of_ref_rps_idx;
	u_int8_t	reserved[3];
	struct	v4l2_hevc_dpb_entry dpb[V4L2_HEVC_DPB_ENTRIES_NUM_MAX];
	u_int64_t	flags;
};

/**
 * struct v4l2_ctrl_hevc_scaling_matrix - HEVC scaling lists parameters
 *
 * @scaling_list_4x4: scaling list is used for the scaling process for
 *		      transform coefficients. The values on each scaling
 *		      list are expected in raster scan order
 * @scaling_list_8x8: scaling list is used for the scaling process for
 *		      transform coefficients. The values on each scaling
 *		      list are expected in raster scan order
 * @scaling_list_16x16:	scaling list is used for the scaling process for
 *			transform coefficients. The values on each scaling
 *			list are expected in raster scan order
 * @scaling_list_32x32:	scaling list is used for the scaling process for
 *			transform coefficients. The values on each scaling
 *			list are expected in raster scan order
 * @scaling_list_dc_coef_16x16:	scaling list is used for the scaling process
 *				for transform coefficients. The values on each
 *				scaling list are expected in raster scan order.
 * @scaling_list_dc_coef_32x32:	scaling list is used for the scaling process
 *				for transform coefficients. The values on each
 *				scaling list are expected in raster scan order.
 */
struct v4l2_ctrl_hevc_scaling_matrix {
	u_int8_t	scaling_list_4x4[6][16];
	u_int8_t	scaling_list_8x8[6][64];
	u_int8_t	scaling_list_16x16[6][64];
	u_int8_t	scaling_list_32x32[2][64];
	u_int8_t	scaling_list_dc_coef_16x16[6];
	u_int8_t	scaling_list_dc_coef_32x32[2];
};

#define V4L2_CID_COLORIMETRY_CLASS_BASE	(V4L2_CTRL_CLASS_COLORIMETRY | 0x900)
#define V4L2_CID_COLORIMETRY_CLASS	(V4L2_CTRL_CLASS_COLORIMETRY | 1)

#define V4L2_CID_COLORIMETRY_HDR10_CLL_INFO	(V4L2_CID_COLORIMETRY_CLASS_BASE + 0)

struct v4l2_ctrl_hdr10_cll_info {
	u_int16_t max_content_light_level;
	u_int16_t max_pic_average_light_level;
};

#define V4L2_CID_COLORIMETRY_HDR10_MASTERING_DISPLAY	(V4L2_CID_COLORIMETRY_CLASS_BASE + 1)

#define V4L2_HDR10_MASTERING_PRIMARIES_X_LOW	5
#define V4L2_HDR10_MASTERING_PRIMARIES_X_HIGH	37000
#define V4L2_HDR10_MASTERING_PRIMARIES_Y_LOW	5
#define V4L2_HDR10_MASTERING_PRIMARIES_Y_HIGH	42000
#define V4L2_HDR10_MASTERING_WHITE_POINT_X_LOW	5
#define V4L2_HDR10_MASTERING_WHITE_POINT_X_HIGH	37000
#define V4L2_HDR10_MASTERING_WHITE_POINT_Y_LOW	5
#define V4L2_HDR10_MASTERING_WHITE_POINT_Y_HIGH	42000
#define V4L2_HDR10_MASTERING_MAX_LUMA_LOW	50000
#define V4L2_HDR10_MASTERING_MAX_LUMA_HIGH	100000000
#define V4L2_HDR10_MASTERING_MIN_LUMA_LOW	1
#define V4L2_HDR10_MASTERING_MIN_LUMA_HIGH	50000

struct v4l2_ctrl_hdr10_mastering_display {
	u_int16_t display_primaries_x[3];
	u_int16_t display_primaries_y[3];
	u_int16_t white_point_x;
	u_int16_t white_point_y;
	u_int32_t max_display_mastering_luminance;
	u_int32_t min_display_mastering_luminance;
};

/* Stateless VP9 controls */

#define V4L2_VP9_LOOP_FILTER_FLAG_DELTA_ENABLED	0x1
#define	V4L2_VP9_LOOP_FILTER_FLAG_DELTA_UPDATE	0x2

/**
 * struct v4l2_vp9_loop_filter - VP9 loop filter parameters
 *
 * @ref_deltas: contains the adjustment needed for the filter level based on the
 * chosen reference frame. If this syntax element is not present in the bitstream,
 * users should pass its last value.
 * @mode_deltas: contains the adjustment needed for the filter level based on the
 * chosen mode.	If this syntax element is not present in the bitstream, users should
 * pass its last value.
 * @level: indicates the loop filter strength.
 * @sharpness: indicates the sharpness level.
 * @flags: combination of V4L2_VP9_LOOP_FILTER_FLAG_{} flags.
 * @reserved: padding field. Should be zeroed by applications.
 *
 * This structure contains all loop filter related parameters. See sections
 * '7.2.8 Loop filter semantics' of the VP9 specification for more details.
 */
struct v4l2_vp9_loop_filter {
	int8_t ref_deltas[4];
	int8_t mode_deltas[2];
	u_int8_t level;
	u_int8_t sharpness;
	u_int8_t flags;
	u_int8_t reserved[7];
};

/**
 * struct v4l2_vp9_quantization - VP9 quantization parameters
 *
 * @base_q_idx: indicates the base frame qindex.
 * @delta_q_y_dc: indicates the Y DC quantizer relative to base_q_idx.
 * @delta_q_uv_dc: indicates the UV DC quantizer relative to base_q_idx.
 * @delta_q_uv_ac: indicates the UV AC quantizer relative to base_q_idx.
 * @reserved: padding field. Should be zeroed by applications.
 *
 * Encodes the quantization parameters. See section '7.2.9 Quantization params
 * syntax' of the VP9 specification for more details.
 */
struct v4l2_vp9_quantization {
	u_int8_t base_q_idx;
	int8_t delta_q_y_dc;
	int8_t delta_q_uv_dc;
	int8_t delta_q_uv_ac;
	u_int8_t reserved[4];
};

#define V4L2_VP9_SEGMENTATION_FLAG_ENABLED		0x01
#define V4L2_VP9_SEGMENTATION_FLAG_UPDATE_MAP		0x02
#define V4L2_VP9_SEGMENTATION_FLAG_TEMPORAL_UPDATE	0x04
#define V4L2_VP9_SEGMENTATION_FLAG_UPDATE_DATA		0x08
#define V4L2_VP9_SEGMENTATION_FLAG_ABS_OR_DELTA_UPDATE	0x10

#define V4L2_VP9_SEG_LVL_ALT_Q				0
#define V4L2_VP9_SEG_LVL_ALT_L				1
#define V4L2_VP9_SEG_LVL_REF_FRAME			2
#define V4L2_VP9_SEG_LVL_SKIP				3
#define V4L2_VP9_SEG_LVL_MAX				4

#define V4L2_VP9_SEGMENT_FEATURE_ENABLED(id)	(1 << (id))
#define V4L2_VP9_SEGMENT_FEATURE_ENABLED_MASK	0xf

/**
 * struct v4l2_vp9_segmentation - VP9 segmentation parameters
 *
 * @feature_data: data attached to each feature. Data entry is only valid if
 * the feature is enabled. The array shall be indexed with segment number as
 * the first dimension (0..7) and one of V4L2_VP9_SEG_{} as the second dimension.
 * @feature_enabled: bitmask defining which features are enabled in each segment.
 * The value for each segment is a combination of V4L2_VP9_SEGMENT_FEATURE_ENABLED(id)
 * values where id is one of V4L2_VP9_SEG_LVL_{}.
 * @tree_probs: specifies the probability values to be used when decoding a
 * Segment-ID. See '5.15. Segmentation map' section of the VP9 specification
 * for more details.
 * @pred_probs: specifies the probability values to be used when decoding a
 * Predicted-Segment-ID. See '6.4.14. Get segment id syntax' section of :ref:`vp9`
 * for more details.
 * @flags: combination of V4L2_VP9_SEGMENTATION_FLAG_{} flags.
 * @reserved: padding field. Should be zeroed by applications.
 *
 * Encodes the quantization parameters. See section '7.2.10 Segmentation params syntax' of
 * the VP9 specification for more details.
 */
struct v4l2_vp9_segmentation {
	int16_t feature_data[8][4];
	u_int8_t feature_enabled[8];
	u_int8_t tree_probs[7];
	u_int8_t pred_probs[3];
	u_int8_t flags;
	u_int8_t reserved[5];
};

#define V4L2_VP9_FRAME_FLAG_KEY_FRAME			0x001
#define V4L2_VP9_FRAME_FLAG_SHOW_FRAME			0x002
#define V4L2_VP9_FRAME_FLAG_ERROR_RESILIENT		0x004
#define V4L2_VP9_FRAME_FLAG_INTRA_ONLY			0x008
#define V4L2_VP9_FRAME_FLAG_ALLOW_HIGH_PREC_MV		0x010
#define V4L2_VP9_FRAME_FLAG_REFRESH_FRAME_CTX		0x020
#define V4L2_VP9_FRAME_FLAG_PARALLEL_DEC_MODE		0x040
#define V4L2_VP9_FRAME_FLAG_X_SUBSAMPLING		0x080
#define V4L2_VP9_FRAME_FLAG_Y_SUBSAMPLING		0x100
#define V4L2_VP9_FRAME_FLAG_COLOR_RANGE_FULL_SWING	0x200

#define V4L2_VP9_SIGN_BIAS_LAST				0x1
#define V4L2_VP9_SIGN_BIAS_GOLDEN			0x2
#define V4L2_VP9_SIGN_BIAS_ALT				0x4

#define V4L2_VP9_RESET_FRAME_CTX_NONE			0
#define V4L2_VP9_RESET_FRAME_CTX_SPEC			1
#define V4L2_VP9_RESET_FRAME_CTX_ALL			2

#define V4L2_VP9_INTERP_FILTER_EIGHTTAP			0
#define V4L2_VP9_INTERP_FILTER_EIGHTTAP_SMOOTH		1
#define V4L2_VP9_INTERP_FILTER_EIGHTTAP_SHARP		2
#define V4L2_VP9_INTERP_FILTER_BILINEAR			3
#define V4L2_VP9_INTERP_FILTER_SWITCHABLE		4

#define V4L2_VP9_REFERENCE_MODE_SINGLE_REFERENCE	0
#define V4L2_VP9_REFERENCE_MODE_COMPOUND_REFERENCE	1
#define V4L2_VP9_REFERENCE_MODE_SELECT			2

#define V4L2_VP9_PROFILE_MAX				3

#define V4L2_CID_STATELESS_VP9_FRAME	(V4L2_CID_CODEC_STATELESS_BASE + 300)
/**
 * struct v4l2_ctrl_vp9_frame - VP9 frame decoding control
 *
 * @lf: loop filter parameters. See &v4l2_vp9_loop_filter for more details.
 * @quant: quantization parameters. See &v4l2_vp9_quantization for more details.
 * @seg: segmentation parameters. See &v4l2_vp9_segmentation for more details.
 * @flags: combination of V4L2_VP9_FRAME_FLAG_{} flags.
 * @compressed_header_size: compressed header size in bytes.
 * @uncompressed_header_size: uncompressed header size in bytes.
 * @frame_width_minus_1: add 1 to it and you'll get the frame width expressed in pixels.
 * @frame_height_minus_1: add 1 to it and you'll get the frame height expressed in pixels.
 * @render_width_minus_1: add 1 to it and you'll get the expected render width expressed in
 * pixels. This is not used during the decoding process but might be used by HW scalers
 * to prepare a frame that's ready for scanout.
 * @render_height_minus_1: add 1 to it and you'll get the expected render height expressed in
 * pixels. This is not used during the decoding process but might be used by HW scalers
 * to prepare a frame that's ready for scanout.
 * @last_frame_ts: "last" reference buffer timestamp.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @golden_frame_ts: "golden" reference buffer timestamp.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @alt_frame_ts: "alt" reference buffer timestamp.
 * The timestamp refers to the timestamp field in struct v4l2_buffer.
 * Use v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @ref_frame_sign_bias: a bitfield specifying whether the sign bias is set for a given
 * reference frame. Either of V4L2_VP9_SIGN_BIAS_{}.
 * @reset_frame_context: specifies whether the frame context should be reset to default values.
 * Either of V4L2_VP9_RESET_FRAME_CTX_{}.
 * @frame_context_idx: frame context that should be used/updated.
 * @profile: VP9 profile. Can be 0, 1, 2 or 3.
 * @bit_depth: bits per components. Can be 8, 10 or 12. Note that not all profiles support
 * 10 and/or 12 bits depths.
 * @interpolation_filter: specifies the filter selection used for performing inter prediction.
 * Set to one of V4L2_VP9_INTERP_FILTER_{}.
 * @tile_cols_log2: specifies the base 2 logarithm of the width of each tile (where the width
 * is measured in units of 8x8 blocks). Shall be less than or equal to 6.
 * @tile_rows_log2: specifies the base 2 logarithm of the height of each tile (where the height
 * is measured in units of 8x8 blocks).
 * @reference_mode: specifies the type of inter prediction to be used.
 * Set to one of V4L2_VP9_REFERENCE_MODE_{}.
 * @reserved: padding field. Should be zeroed by applications.
 */
struct v4l2_ctrl_vp9_frame {
	struct v4l2_vp9_loop_filter lf;
	struct v4l2_vp9_quantization quant;
	struct v4l2_vp9_segmentation seg;
	u_int32_t flags;
	u_int16_t compressed_header_size;
	u_int16_t uncompressed_header_size;
	u_int16_t frame_width_minus_1;
	u_int16_t frame_height_minus_1;
	u_int16_t render_width_minus_1;
	u_int16_t render_height_minus_1;
	u_int64_t last_frame_ts;
	u_int64_t golden_frame_ts;
	u_int64_t alt_frame_ts;
	u_int8_t ref_frame_sign_bias;
	u_int8_t reset_frame_context;
	u_int8_t frame_context_idx;
	u_int8_t profile;
	u_int8_t bit_depth;
	u_int8_t interpolation_filter;
	u_int8_t tile_cols_log2;
	u_int8_t tile_rows_log2;
	u_int8_t reference_mode;
	u_int8_t reserved[7];
};

#define V4L2_VP9_NUM_FRAME_CTX	4

/**
 * struct v4l2_vp9_mv_probs - VP9 Motion vector probability updates
 * @joint: motion vector joint probability updates.
 * @sign: motion vector sign probability updates.
 * @classes: motion vector class probability updates.
 * @class0_bit: motion vector class0 bit probability updates.
 * @bits: motion vector bits probability updates.
 * @class0_fr: motion vector class0 fractional bit probability updates.
 * @fr: motion vector fractional bit probability updates.
 * @class0_hp: motion vector class0 high precision fractional bit probability updates.
 * @hp: motion vector high precision fractional bit probability updates.
 *
 * This structure contains new values of motion vector probabilities.
 * A value of zero in an array element means there is no update of the relevant probability.
 * See `struct v4l2_vp9_prob_updates` for details.
 */
struct v4l2_vp9_mv_probs {
	u_int8_t joint[3];
	u_int8_t sign[2];
	u_int8_t classes[2][10];
	u_int8_t class0_bit[2];
	u_int8_t bits[2][10];
	u_int8_t class0_fr[2][2][3];
	u_int8_t fr[2][3];
	u_int8_t class0_hp[2];
	u_int8_t hp[2];
};

#define V4L2_CID_STATELESS_VP9_COMPRESSED_HDR	(V4L2_CID_CODEC_STATELESS_BASE + 301)

#define V4L2_VP9_TX_MODE_ONLY_4X4			0
#define V4L2_VP9_TX_MODE_ALLOW_8X8			1
#define V4L2_VP9_TX_MODE_ALLOW_16X16			2
#define V4L2_VP9_TX_MODE_ALLOW_32X32			3
#define V4L2_VP9_TX_MODE_SELECT				4

/**
 * struct v4l2_ctrl_vp9_compressed_hdr - VP9 probability updates control
 * @tx_mode: specifies the TX mode. Set to one of V4L2_VP9_TX_MODE_{}.
 * @tx8: TX 8x8 probability updates.
 * @tx16: TX 16x16 probability updates.
 * @tx32: TX 32x32 probability updates.
 * @coef: coefficient probability updates.
 * @skip: skip probability updates.
 * @inter_mode: inter mode probability updates.
 * @interp_filter: interpolation filter probability updates.
 * @is_inter: is inter-block probability updates.
 * @comp_mode: compound prediction mode probability updates.
 * @single_ref: single ref probability updates.
 * @comp_ref: compound ref probability updates.
 * @y_mode: Y prediction mode probability updates.
 * @uv_mode: UV prediction mode probability updates.
 * @partition: partition probability updates.
 * @mv: motion vector probability updates.
 *
 * This structure holds the probabilities update as parsed in the compressed
 * header (Spec 6.3). These values represent the value of probability update after
 * being translated with inv_map_table[] (see 6.3.5). A value of zero in an array element
 * means that there is no update of the relevant probability.
 *
 * This control is optional and needs to be used when dealing with the hardware which is
 * not capable of parsing the compressed header itself. Only drivers which need it will
 * implement it.
 */
struct v4l2_ctrl_vp9_compressed_hdr {
	u_int8_t tx_mode;
	u_int8_t tx8[2][1];
	u_int8_t tx16[2][2];
	u_int8_t tx32[2][3];
	u_int8_t coef[4][2][2][6][6][3];
	u_int8_t skip[3];
	u_int8_t inter_mode[7][3];
	u_int8_t interp_filter[4][2];
	u_int8_t is_inter[4];
	u_int8_t comp_mode[5];
	u_int8_t single_ref[5][2];
	u_int8_t comp_ref[5];
	u_int8_t y_mode[4][9];
	u_int8_t uv_mode[10][9];
	u_int8_t partition[16][3];

	struct v4l2_vp9_mv_probs mv;
};

/* Stateless AV1 controls */

#define V4L2_AV1_TOTAL_REFS_PER_FRAME	8
#define V4L2_AV1_CDEF_MAX		8
#define V4L2_AV1_NUM_PLANES_MAX		3 /* 1 if monochrome, 3 otherwise */
#define V4L2_AV1_MAX_SEGMENTS		8
#define V4L2_AV1_MAX_OPERATING_POINTS	(1 << 5) /* 5 bits to encode */
#define V4L2_AV1_REFS_PER_FRAME		7
#define V4L2_AV1_MAX_NUM_Y_POINTS	(1 << 4) /* 4 bits to encode */
#define V4L2_AV1_MAX_NUM_CB_POINTS	(1 << 4) /* 4 bits to encode */
#define V4L2_AV1_MAX_NUM_CR_POINTS	(1 << 4) /* 4 bits to encode */
#define V4L2_AV1_AR_COEFFS_SIZE		25 /* (2 * 3 * (3 + 1)) + 1 */
#define V4L2_AV1_MAX_NUM_PLANES		3
#define V4L2_AV1_MAX_TILE_COLS		64
#define V4L2_AV1_MAX_TILE_ROWS		64
#define V4L2_AV1_MAX_TILE_COUNT		512

#define V4L2_AV1_SEQUENCE_FLAG_STILL_PICTURE		  0x00000001
#define V4L2_AV1_SEQUENCE_FLAG_USE_128X128_SUPERBLOCK	  0x00000002
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_FILTER_INTRA	  0x00000004
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_INTRA_EDGE_FILTER   0x00000008
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_INTERINTRA_COMPOUND 0x00000010
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_MASKED_COMPOUND	  0x00000020
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_WARPED_MOTION	  0x00000040
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_DUAL_FILTER	  0x00000080
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_ORDER_HINT	  0x00000100
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_JNT_COMP		  0x00000200
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_REF_FRAME_MVS	  0x00000400
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_SUPERRES		  0x00000800
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_CDEF		  0x00001000
#define V4L2_AV1_SEQUENCE_FLAG_ENABLE_RESTORATION	  0x00002000
#define V4L2_AV1_SEQUENCE_FLAG_MONO_CHROME		  0x00004000
#define V4L2_AV1_SEQUENCE_FLAG_COLOR_RANGE		  0x00008000
#define V4L2_AV1_SEQUENCE_FLAG_SUBSAMPLING_X		  0x00010000
#define V4L2_AV1_SEQUENCE_FLAG_SUBSAMPLING_Y		  0x00020000
#define V4L2_AV1_SEQUENCE_FLAG_FILM_GRAIN_PARAMS_PRESENT  0x00040000
#define V4L2_AV1_SEQUENCE_FLAG_SEPARATE_UV_DELTA_Q	  0x00080000

#define V4L2_CID_STATELESS_AV1_SEQUENCE (V4L2_CID_CODEC_STATELESS_BASE + 500)
/**
 * struct v4l2_ctrl_av1_sequence - AV1 Sequence
 *
 * Represents an AV1 Sequence OBU. See section 5.5 "Sequence header OBU syntax"
 * for more details.
 *
 * @flags: See V4L2_AV1_SEQUENCE_FLAG_{}.
 * @seq_profile: specifies the features that can be used in the coded video
 * sequence.
 * @order_hint_bits: specifies the number of bits used for the order_hint field
 * at each frame.
 * @bit_depth: the bitdepth to use for the sequence as described in section
 * 5.5.2 "Color config syntax".
 * @reserved: padding field. Should be zeroed by applications.
 * @max_frame_width_minus_1: specifies the maximum frame width minus 1 for the
 * frames represented by this sequence header.
 * @max_frame_height_minus_1: specifies the maximum frame height minus 1 for the
 * frames represented by this sequence header.
 */
struct v4l2_ctrl_av1_sequence {
	u_int32_t flags;
	u_int8_t seq_profile;
	u_int8_t order_hint_bits;
	u_int8_t bit_depth;
	u_int8_t reserved;
	u_int16_t max_frame_width_minus_1;
	u_int16_t max_frame_height_minus_1;
};

#define V4L2_CID_STATELESS_AV1_TILE_GROUP_ENTRY (V4L2_CID_CODEC_STATELESS_BASE + 501)
/**
 * struct v4l2_ctrl_av1_tile_group_entry - AV1 Tile Group entry
 *
 * Represents a single AV1 tile inside an AV1 Tile Group. Note that MiRowStart,
 * MiRowEnd, MiColStart and MiColEnd can be retrieved from struct
 * v4l2_av1_tile_info in struct v4l2_ctrl_av1_frame using tile_row and
 * tile_col. See section 6.10.1 "General tile group OBU semantics" for more
 * details.
 *
 * @tile_offset: offset from the OBU data, i.e. where the coded tile data
 * actually starts.
 * @tile_size: specifies the size in bytes of the coded tile. Equivalent to
 * "TileSize" in the AV1 Specification.
 * @tile_row: specifies the row of the current tile. Equivalent to "TileRow" in
 * the AV1 Specification.
 * @tile_col: specifies the col of the current tile. Equivalent to "TileCol" in
 * the AV1 Specification.
 */
struct v4l2_ctrl_av1_tile_group_entry {
	u_int32_t tile_offset;
	u_int32_t tile_size;
	u_int32_t tile_row;
	u_int32_t tile_col;
};

/**
 * enum v4l2_av1_warp_model - AV1 Warp Model as described in section 3
 * "Symbols and abbreviated terms" of the AV1 Specification.
 *
 * @V4L2_AV1_WARP_MODEL_IDENTITY: Warp model is just an identity transform.
 * @V4L2_AV1_WARP_MODEL_TRANSLATION: Warp model is a pure translation.
 * @V4L2_AV1_WARP_MODEL_ROTZOOM: Warp model is a rotation + symmetric zoom +
 * translation.
 * @V4L2_AV1_WARP_MODEL_AFFINE: Warp model is a general affine transform.
 */
enum v4l2_av1_warp_model {
	V4L2_AV1_WARP_MODEL_IDENTITY = 0,
	V4L2_AV1_WARP_MODEL_TRANSLATION = 1,
	V4L2_AV1_WARP_MODEL_ROTZOOM = 2,
	V4L2_AV1_WARP_MODEL_AFFINE = 3,
};

/**
 * enum v4l2_av1_reference_frame - AV1 reference frames
 *
 * @V4L2_AV1_REF_INTRA_FRAME: Intra Frame Reference
 * @V4L2_AV1_REF_LAST_FRAME: Last Reference Frame
 * @V4L2_AV1_REF_LAST2_FRAME: Last2 Reference Frame
 * @V4L2_AV1_REF_LAST3_FRAME: Last3 Reference Frame
 * @V4L2_AV1_REF_GOLDEN_FRAME: Golden Reference Frame
 * @V4L2_AV1_REF_BWDREF_FRAME: BWD Reference Frame
 * @V4L2_AV1_REF_ALTREF2_FRAME: Alternative2 Reference Frame
 * @V4L2_AV1_REF_ALTREF_FRAME: Alternative Reference Frame
 */
enum v4l2_av1_reference_frame {
	V4L2_AV1_REF_INTRA_FRAME = 0,
	V4L2_AV1_REF_LAST_FRAME = 1,
	V4L2_AV1_REF_LAST2_FRAME = 2,
	V4L2_AV1_REF_LAST3_FRAME = 3,
	V4L2_AV1_REF_GOLDEN_FRAME = 4,
	V4L2_AV1_REF_BWDREF_FRAME = 5,
	V4L2_AV1_REF_ALTREF2_FRAME = 6,
	V4L2_AV1_REF_ALTREF_FRAME = 7,
};

#define V4L2_AV1_GLOBAL_MOTION_IS_INVALID(ref) (1 << (ref))

#define V4L2_AV1_GLOBAL_MOTION_FLAG_IS_GLOBAL	   0x1
#define V4L2_AV1_GLOBAL_MOTION_FLAG_IS_ROT_ZOOM	   0x2
#define V4L2_AV1_GLOBAL_MOTION_FLAG_IS_TRANSLATION 0x4
/**
 * struct v4l2_av1_global_motion - AV1 Global Motion parameters as described in
 * section 6.8.17 "Global motion params semantics" of the AV1 specification.
 *
 * @flags: A bitfield containing the flags per reference frame. See
 * V4L2_AV1_GLOBAL_MOTION_FLAG_{}
 * @type: The type of global motion transform used.
 * @params: this field has the same meaning as "gm_params" in the AV1
 * specification.
 * @invalid: bitfield indicating whether the global motion params are invalid
 * for a given reference frame. See section 7.11.3.6 Setup shear process and
 * the variable "warpValid". Use V4L2_AV1_GLOBAL_MOTION_IS_INVALID(ref) to
 * create a suitable mask.
 * @reserved: padding field. Should be zeroed by applications.
 */

struct v4l2_av1_global_motion {
	u_int8_t flags[V4L2_AV1_TOTAL_REFS_PER_FRAME];
	enum v4l2_av1_warp_model type[V4L2_AV1_TOTAL_REFS_PER_FRAME];
	int32_t params[V4L2_AV1_TOTAL_REFS_PER_FRAME][6];
	u_int8_t invalid;
	u_int8_t reserved[3];
};

/**
 * enum v4l2_av1_frame_restoration_type - AV1 Frame Restoration Type
 * @V4L2_AV1_FRAME_RESTORE_NONE: no filtering is applied.
 * @V4L2_AV1_FRAME_RESTORE_WIENER: Wiener filter process is invoked.
 * @V4L2_AV1_FRAME_RESTORE_SGRPROJ: self guided filter process is invoked.
 * @V4L2_AV1_FRAME_RESTORE_SWITCHABLE: restoration filter is swichtable.
 */
enum v4l2_av1_frame_restoration_type {
	V4L2_AV1_FRAME_RESTORE_NONE = 0,
	V4L2_AV1_FRAME_RESTORE_WIENER = 1,
	V4L2_AV1_FRAME_RESTORE_SGRPROJ = 2,
	V4L2_AV1_FRAME_RESTORE_SWITCHABLE = 3,
};

#define V4L2_AV1_LOOP_RESTORATION_FLAG_USES_LR		0x1
#define V4L2_AV1_LOOP_RESTORATION_FLAG_USES_CHROMA_LR	0x2

/**
 * struct v4l2_av1_loop_restoration - AV1 Loop Restauration as described in
 * section 6.10.15 "Loop restoration params semantics" of the AV1 specification.
 *
 * @flags: See V4L2_AV1_LOOP_RESTORATION_FLAG_{}.
 * @lr_unit_shift: specifies if the luma restoration size should be halved.
 * @lr_uv_shift: specifies if the chroma size should be half the luma size.
 * @reserved: padding field. Should be zeroed by applications.
 * @frame_restoration_type: specifies the type of restoration used for each
 * plane. See enum v4l2_av1_frame_restoration_type.
 * @loop_restoration_size: specifies the size of loop restoration units in units
 * of samples in the current plane.
 */
struct v4l2_av1_loop_restoration {
	u_int8_t flags;
	u_int8_t lr_unit_shift;
	u_int8_t lr_uv_shift;
	u_int8_t reserved;
	enum v4l2_av1_frame_restoration_type frame_restoration_type[V4L2_AV1_NUM_PLANES_MAX];
	u_int32_t loop_restoration_size[V4L2_AV1_MAX_NUM_PLANES];
};

/**
 * struct v4l2_av1_cdef - AV1 CDEF params semantics as described in section
 * 6.10.14 "CDEF params semantics" of the AV1 specification
 *
 * @damping_minus_3: controls the amount of damping in the deringing filter.
 * @bits: specifies the number of bits needed to specify which CDEF filter to
 * apply.
 * @y_pri_strength: specifies the strength of the primary filter.
 * @y_sec_strength: specifies the strength of the secondary filter.
 * @uv_pri_strength: specifies the strength of the primary filter.
 * @uv_sec_strength: specifies the strength of the secondary filter.
 */
struct v4l2_av1_cdef {
	u_int8_t damping_minus_3;
	u_int8_t bits;
	u_int8_t y_pri_strength[V4L2_AV1_CDEF_MAX];
	u_int8_t y_sec_strength[V4L2_AV1_CDEF_MAX];
	u_int8_t uv_pri_strength[V4L2_AV1_CDEF_MAX];
	u_int8_t uv_sec_strength[V4L2_AV1_CDEF_MAX];
};

#define V4L2_AV1_SEGMENTATION_FLAG_ENABLED	   0x1
#define V4L2_AV1_SEGMENTATION_FLAG_UPDATE_MAP	   0x2
#define V4L2_AV1_SEGMENTATION_FLAG_TEMPORAL_UPDATE 0x4
#define V4L2_AV1_SEGMENTATION_FLAG_UPDATE_DATA	   0x8
#define V4L2_AV1_SEGMENTATION_FLAG_SEG_ID_PRE_SKIP 0x10

/**
 * enum v4l2_av1_segment_feature - AV1 segment features as described in section
 * 3 "Symbols and abbreviated terms" of the AV1 specification.
 *
 * @V4L2_AV1_SEG_LVL_ALT_Q: Index for quantizer segment feature.
 * @V4L2_AV1_SEG_LVL_ALT_LF_Y_V: Index for vertical luma loop filter segment
 * feature.
 * @V4L2_AV1_SEG_LVL_REF_FRAME: Index for reference frame segment feature.
 * @V4L2_AV1_SEG_LVL_REF_SKIP: Index for skip segment feature.
 * @V4L2_AV1_SEG_LVL_REF_GLOBALMV: Index for global mv feature.
 * @V4L2_AV1_SEG_LVL_MAX: Number of segment features.
 */
enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8
};

#define V4L2_AV1_SEGMENT_FEATURE_ENABLED(id)	(1 << (id))

/**
 * struct v4l2_av1_segmentation - AV1 Segmentation params as defined in section
 * 6.8.13 "Segmentation params semantics" of the AV1 specification.
 *
 * @flags: see V4L2_AV1_SEGMENTATION_FLAG_{}.
 * @last_active_seg_id: indicates the highest numbered segment id that has some
 * enabled feature. This is used when decoding the segment id to only decode
 * choices corresponding to used segments.
 * @feature_enabled: bitmask defining which features are enabled in each
 * segment. Use V4L2_AV1_SEGMENT_FEATURE_ENABLED to build a suitable mask.
 * @feature_data: data attached to each feature. Data entry is only valid if the
 * feature is enabled
 */
struct v4l2_av1_segmentation {
	u_int8_t flags;
	u_int8_t last_active_seg_id;
	u_int8_t feature_enabled[V4L2_AV1_MAX_SEGMENTS];
	int16_t feature_data[V4L2_AV1_MAX_SEGMENTS][V4L2_AV1_SEG_LVL_MAX];
};

#define V4L2_AV1_LOOP_FILTER_FLAG_DELTA_ENABLED    0x1
#define V4L2_AV1_LOOP_FILTER_FLAG_DELTA_UPDATE     0x2
#define V4L2_AV1_LOOP_FILTER_FLAG_DELTA_LF_PRESENT 0x4
#define V4L2_AV1_LOOP_FILTER_FLAG_DELTA_LF_MULTI   0x8

/**
 * struct v4l2_av1_loop_filter - AV1 Loop filter params as defined in section
 * 6.8.10 "Loop filter semantics" and 6.8.16 "Loop filter delta parameters
 * semantics" of the AV1 specification.
 *
 * @flags: see V4L2_AV1_LOOP_FILTER_FLAG_{}
 * @level: an array containing loop filter strength values. Different loop
 * filter strength values from the array are used depending on the image plane
 * being filtered, and the edge direction (vertical or horizontal) being
 * filtered.
 * @sharpness: indicates the sharpness level. The loop_filter_level and
 * loop_filter_sharpness together determine when a block edge is filtered, and
 * by how much the filtering can change the sample values. The loop filter
 * process is described in section 7.14 of the AV1 specification.
 * @ref_deltas: contains the adjustment needed for the filter level based on the
 * chosen reference frame. If this syntax element is not present, it maintains
 * its previous value.
 * @mode_deltas: contains the adjustment needed for the filter level based on
 * the chosen mode. If this syntax element is not present, it maintains its
 * previous value.
 * @delta_lf_res: specifies the left shift which should be applied to decoded
 * loop filter delta values.
 */
struct v4l2_av1_loop_filter {
	u_int8_t flags;
	u_int8_t level[4];
	u_int8_t sharpness;
	int8_t ref_deltas[V4L2_AV1_TOTAL_REFS_PER_FRAME];
	int8_t mode_deltas[2];
	u_int8_t delta_lf_res;
};

#define V4L2_AV1_QUANTIZATION_FLAG_DIFF_UV_DELTA   0x1
#define V4L2_AV1_QUANTIZATION_FLAG_USING_QMATRIX   0x2
#define V4L2_AV1_QUANTIZATION_FLAG_DELTA_Q_PRESENT 0x4

/**
 * struct v4l2_av1_quantization - AV1 Quantization params as defined in section
 * 6.8.11 "Quantization params semantics" of the AV1 specification.
 *
 * @flags: see V4L2_AV1_QUANTIZATION_FLAG_{}
 * @base_q_idx: indicates the base frame qindex. This is used for Y AC
 * coefficients and as the base value for the other quantizers.
 * @delta_q_y_dc: indicates the Y DC quantizer relative to base_q_idx.
 * @delta_q_u_dc: indicates the U DC quantizer relative to base_q_idx.
 * @delta_q_u_ac: indicates the U AC quantizer relative to base_q_idx.
 * @delta_q_v_dc: indicates the V DC quantizer relative to base_q_idx.
 * @delta_q_v_ac: indicates the V AC quantizer relative to base_q_idx.
 * @qm_y: specifies the level in the quantizer matrix that should be used for
 * luma plane decoding.
 * @qm_u: specifies the level in the quantizer matrix that should be used for
 * chroma U plane decoding.
 * @qm_v: specifies the level in the quantizer matrix that should be used for
 * chroma V plane decoding.
 * @delta_q_res: specifies the left shift which should be applied to decoded
 * quantizer index delta values.
 */
struct v4l2_av1_quantization {
	u_int8_t flags;
	u_int8_t base_q_idx;
	int8_t delta_q_y_dc;
	int8_t delta_q_u_dc;
	int8_t delta_q_u_ac;
	int8_t delta_q_v_dc;
	int8_t delta_q_v_ac;
	u_int8_t qm_y;
	u_int8_t qm_u;
	u_int8_t qm_v;
	u_int8_t delta_q_res;
};

#define V4L2_AV1_TILE_INFO_FLAG_UNIFORM_TILE_SPACING	0x1

/**
 * struct v4l2_av1_tile_info - AV1 Tile info as defined in section 6.8.14 "Tile
 * info semantics" of the AV1 specification.
 *
 * @flags: see V4L2_AV1_TILE_INFO_FLAG_{}
 * @context_update_tile_id: specifies which tile to use for the CDF update.
 * @tile_rows: specifies the number of tiles down the frame.
 * @tile_cols: specifies the number of tiles across the frame.
 * @mi_col_starts: an array specifying the start column (in units of 4x4 luma
 * samples) for each tile across the image.
 * @mi_row_starts: an array specifying the start row (in units of 4x4 luma
 * samples) for each tile down the image.
 * @width_in_sbs_minus_1: specifies the width of a tile minus 1 in units of
 * superblocks.
 * @height_in_sbs_minus_1:  specifies the height of a tile minus 1 in units of
 * superblocks.
 * @tile_size_bytes: specifies the number of bytes needed to code each tile
 * size.
 * @reserved: padding field. Should be zeroed by applications.
 */
struct v4l2_av1_tile_info {
	u_int8_t flags;
	u_int8_t context_update_tile_id;
	u_int8_t tile_cols;
	u_int8_t tile_rows;
	u_int32_t mi_col_starts[V4L2_AV1_MAX_TILE_COLS + 1];
	u_int32_t mi_row_starts[V4L2_AV1_MAX_TILE_ROWS + 1];
	u_int32_t width_in_sbs_minus_1[V4L2_AV1_MAX_TILE_COLS];
	u_int32_t height_in_sbs_minus_1[V4L2_AV1_MAX_TILE_ROWS];
	u_int8_t tile_size_bytes;
	u_int8_t reserved[3];
};

/**
 * enum v4l2_av1_frame_type - AV1 Frame Type
 *
 * @V4L2_AV1_KEY_FRAME: Key frame
 * @V4L2_AV1_INTER_FRAME: Inter frame
 * @V4L2_AV1_INTRA_ONLY_FRAME: Intra-only frame
 * @V4L2_AV1_SWITCH_FRAME: Switch frame
 */
enum v4l2_av1_frame_type {
	V4L2_AV1_KEY_FRAME = 0,
	V4L2_AV1_INTER_FRAME = 1,
	V4L2_AV1_INTRA_ONLY_FRAME = 2,
	V4L2_AV1_SWITCH_FRAME = 3
};

/**
 * enum v4l2_av1_interpolation_filter - AV1 interpolation filter types
 *
 * @V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP: eight tap filter
 * @V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH: eight tap smooth filter
 * @V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP: eight tap sharp filter
 * @V4L2_AV1_INTERPOLATION_FILTER_BILINEAR: bilinear filter
 * @V4L2_AV1_INTERPOLATION_FILTER_SWITCHABLE: filter selection is signaled at
 * the block level
 *
 * See section 6.8.9 "Interpolation filter semantics" of the AV1 specification
 * for more details.
 */
enum v4l2_av1_interpolation_filter {
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP = 0,
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH = 1,
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP = 2,
	V4L2_AV1_INTERPOLATION_FILTER_BILINEAR = 3,
	V4L2_AV1_INTERPOLATION_FILTER_SWITCHABLE = 4,
};

/**
 * enum v4l2_av1_tx_mode - AV1 Tx mode as described in section 6.8.21 "TX mode
 * semantics" of the AV1 specification.
 * @V4L2_AV1_TX_MODE_ONLY_4X4: the inverse transform will use only 4x4
 * transforms
 * @V4L2_AV1_TX_MODE_LARGEST: the inverse transform will use the largest
 * transform size that fits inside the block
 * @V4L2_AV1_TX_MODE_SELECT: the choice of transform size is specified
 * explicitly for each block.
 */
enum v4l2_av1_tx_mode {
	V4L2_AV1_TX_MODE_ONLY_4X4 = 0,
	V4L2_AV1_TX_MODE_LARGEST = 1,
	V4L2_AV1_TX_MODE_SELECT = 2
};

#define V4L2_AV1_FRAME_FLAG_SHOW_FRAME			 0x00000001
#define V4L2_AV1_FRAME_FLAG_SHOWABLE_FRAME		 0x00000002
#define V4L2_AV1_FRAME_FLAG_ERROR_RESILIENT_MODE	 0x00000004
#define V4L2_AV1_FRAME_FLAG_DISABLE_CDF_UPDATE		 0x00000008
#define V4L2_AV1_FRAME_FLAG_ALLOW_SCREEN_CONTENT_TOOLS	 0x00000010
#define V4L2_AV1_FRAME_FLAG_FORCE_INTEGER_MV		 0x00000020
#define V4L2_AV1_FRAME_FLAG_ALLOW_INTRABC		 0x00000040
#define V4L2_AV1_FRAME_FLAG_USE_SUPERRES		 0x00000080
#define V4L2_AV1_FRAME_FLAG_ALLOW_HIGH_PRECISION_MV	 0x00000100
#define V4L2_AV1_FRAME_FLAG_IS_MOTION_MODE_SWITCHABLE	 0x00000200
#define V4L2_AV1_FRAME_FLAG_USE_REF_FRAME_MVS		 0x00000400
#define V4L2_AV1_FRAME_FLAG_DISABLE_FRAME_END_UPDATE_CDF 0x00000800
#define V4L2_AV1_FRAME_FLAG_ALLOW_WARPED_MOTION		 0x00001000
#define V4L2_AV1_FRAME_FLAG_REFERENCE_SELECT		 0x00002000
#define V4L2_AV1_FRAME_FLAG_REDUCED_TX_SET		 0x00004000
#define V4L2_AV1_FRAME_FLAG_SKIP_MODE_ALLOWED		 0x00008000
#define V4L2_AV1_FRAME_FLAG_SKIP_MODE_PRESENT		 0x00010000
#define V4L2_AV1_FRAME_FLAG_FRAME_SIZE_OVERRIDE		 0x00020000
#define V4L2_AV1_FRAME_FLAG_BUFFER_REMOVAL_TIME_PRESENT	 0x00040000
#define V4L2_AV1_FRAME_FLAG_FRAME_REFS_SHORT_SIGNALING	 0x00080000

#define V4L2_CID_STATELESS_AV1_FRAME (V4L2_CID_CODEC_STATELESS_BASE + 502)
/**
 * struct v4l2_ctrl_av1_frame - Represents an AV1 Frame Header OBU.
 *
 * @tile_info: tile info
 * @quantization: quantization params
 * @segmentation: segmentation params
 * @superres_denom: the denominator for the upscaling ratio.
 * @loop_filter: loop filter params
 * @cdef: cdef params
 * @skip_mode_frame: specifies the frames to use for compound prediction when
 * skip_mode is equal to 1.
 * @primary_ref_frame: specifies which reference frame contains the CDF values
 * and other state that should be loaded at the start of the frame.
 * @loop_restoration: loop restoration params
 * @global_motion: global motion params
 * @flags: see V4L2_AV1_FRAME_FLAG_{}
 * @frame_type: specifies the AV1 frame type
 * @order_hint: specifies OrderHintBits least significant bits of the expected
 * output order for this frame.
 * @upscaled_width: the upscaled width.
 * @interpolation_filter: specifies the filter selection used for performing
 * inter prediction.
 * @tx_mode: specifies how the transform size is determined.
 * @frame_width_minus_1: add 1 to get the frame's width.
 * @frame_height_minus_1: add 1 to get the frame's height
 * @render_width_minus_1: add 1 to get the render width of the frame in luma
 * samples.
 * @render_height_minus_1: add 1 to get the render height of the frame in luma
 * samples.
 * @current_frame_id: specifies the frame id number for the current frame. Frame
 * id numbers are additional information that do not affect the decoding
 * process, but provide decoders with a way of detecting missing reference
 * frames so that appropriate action can be taken.
 * @buffer_removal_time: specifies the frame removal time in units of DecCT clock
 * ticks counted from the removal time of the last random access point for
 * operating point opNum.
 * @reserved: padding field. Should be zeroed by applications.
 * @order_hints: specifies the expected output order hint for each reference
 * frame. This field corresponds to the OrderHints variable from the
 * specification (section 5.9.2 "Uncompressed header syntax"). As such, this is
 * only used for non-intra frames and ignored otherwise. order_hints[0] is
 * always ignored.
 * @reference_frame_ts: the V4L2 timestamp of the reference frame slots.
 * @ref_frame_idx: used to index into @reference_frame_ts when decoding
 * inter-frames. The meaning of this array is the same as in the specification.
 * The timestamp refers to the timestamp field in struct v4l2_buffer. Use
 * v4l2_timeval_to_ns() to convert the struct timeval to a u_int64_t.
 * @refresh_frame_flags: contains a bitmask that specifies which reference frame
 * slots will be updated with the current frame after it is decoded.
 */
struct v4l2_ctrl_av1_frame {
	struct v4l2_av1_tile_info tile_info;
	struct v4l2_av1_quantization quantization;
	u_int8_t superres_denom;
	struct v4l2_av1_segmentation segmentation;
	struct v4l2_av1_loop_filter loop_filter;
	struct v4l2_av1_cdef cdef;
	u_int8_t skip_mode_frame[2];
	u_int8_t primary_ref_frame;
	struct v4l2_av1_loop_restoration loop_restoration;
	struct v4l2_av1_global_motion global_motion;
	u_int32_t flags;
	enum v4l2_av1_frame_type frame_type;
	u_int32_t order_hint;
	u_int32_t upscaled_width;
	enum v4l2_av1_interpolation_filter interpolation_filter;
	enum v4l2_av1_tx_mode tx_mode;
	u_int32_t frame_width_minus_1;
	u_int32_t frame_height_minus_1;
	u_int16_t render_width_minus_1;
	u_int16_t render_height_minus_1;

	u_int32_t current_frame_id;
	u_int32_t buffer_removal_time[V4L2_AV1_MAX_OPERATING_POINTS];
	u_int8_t reserved[4];
	u_int32_t order_hints[V4L2_AV1_TOTAL_REFS_PER_FRAME];
	u_int64_t reference_frame_ts[V4L2_AV1_TOTAL_REFS_PER_FRAME];
	int8_t ref_frame_idx[V4L2_AV1_REFS_PER_FRAME];
	u_int8_t refresh_frame_flags;
};

#define V4L2_AV1_FILM_GRAIN_FLAG_APPLY_GRAIN 0x1
#define V4L2_AV1_FILM_GRAIN_FLAG_UPDATE_GRAIN 0x2
#define V4L2_AV1_FILM_GRAIN_FLAG_CHROMA_SCALING_FROM_LUMA 0x4
#define V4L2_AV1_FILM_GRAIN_FLAG_OVERLAP 0x8
#define V4L2_AV1_FILM_GRAIN_FLAG_CLIP_TO_RESTRICTED_RANGE 0x10

#define V4L2_CID_STATELESS_AV1_FILM_GRAIN (V4L2_CID_CODEC_STATELESS_BASE + 505)
/**
 * struct v4l2_ctrl_av1_film_grain - AV1 Film Grain parameters.
 *
 * Film grain parameters as specified by section 6.8.20 of the AV1 Specification.
 *
 * @flags: see V4L2_AV1_FILM_GRAIN_{}.
 * @cr_mult: represents a multiplier for the cr component used in derivation of
 * the input index to the cr component scaling function.
 * @grain_seed: specifies the starting value for the pseudo-random numbers used
 * during film grain synthesis.
 * @film_grain_params_ref_idx: indicates which reference frame contains the
 * film grain parameters to be used for this frame.
 * @num_y_points: specifies the number of points for the piece-wise linear
 * scaling function of the luma component.
 * @point_y_value: represents the x (luma value) coordinate for the i-th point
 * of the piecewise linear scaling function for luma component. The values are
 * signaled on the scale of 0..255. In case of 10 bit video, these values
 * correspond to luma values divided by 4. In case of 12 bit video, these values
 * correspond to luma values divided by 16.
 * @point_y_scaling:  represents the scaling (output) value for the i-th point
 * of the piecewise linear scaling function for luma component.
 * @num_cb_points: specifies the number of points for the piece-wise linear
 * scaling function of the cb component.
 * @point_cb_value: represents the x coordinate for the i-th point of the
 * piece-wise linear scaling function for cb component. The values are signaled
 * on the scale of 0..255.
 * @point_cb_scaling: represents the scaling (output) value for the i-th point
 * of the piecewise linear scaling function for cb component.
 * @num_cr_points: specifies represents the number of points for the piece-wise
 * linear scaling function of the cr component.
 * @point_cr_value:  represents the x coordinate for the i-th point of the
 * piece-wise linear scaling function for cr component. The values are signaled
 * on the scale of 0..255.
 * @point_cr_scaling:  represents the scaling (output) value for the i-th point
 * of the piecewise linear scaling function for cr component.
 * @grain_scaling_minus_8: represents the shift – 8 applied to the values of the
 * chroma component. The grain_scaling_minus_8 can take values of 0..3 and
 * determines the range and quantization step of the standard deviation of film
 * grain.
 * @ar_coeff_lag: specifies the number of auto-regressive coefficients for luma
 * and chroma.
 * @ar_coeffs_y_plus_128: specifies auto-regressive coefficients used for the Y
 * plane.
 * @ar_coeffs_cb_plus_128: specifies auto-regressive coefficients used for the U
 * plane.
 * @ar_coeffs_cr_plus_128: specifies auto-regressive coefficients used for the V
 * plane.
 * @ar_coeff_shift_minus_6: specifies the range of the auto-regressive
 * coefficients. Values of 0, 1, 2, and 3 correspond to the ranges for
 * auto-regressive coefficients of [-2, 2), [-1, 1), [-0.5, 0.5) and [-0.25,
 * 0.25) respectively.
 * @grain_scale_shift: specifies how much the Gaussian random numbers should be
 * scaled down during the grain synthesis process.
 * @cb_mult: represents a multiplier for the cb component used in derivation of
 * the input index to the cb component scaling function.
 * @cb_luma_mult: represents a multiplier for the average luma component used in
 * derivation of the input index to the cb component scaling function.
 * @cr_luma_mult: represents a multiplier for the average luma component used in
 * derivation of the input index to the cr component scaling function.
 * @cb_offset: represents an offset used in derivation of the input index to the
 * cb component scaling function.
 * @cr_offset: represents an offset used in derivation of the input index to the
 * cr component scaling function.
 * @reserved: padding field. Should be zeroed by applications.
 */
struct v4l2_ctrl_av1_film_grain {
	u_int8_t flags;
	u_int8_t cr_mult;
	u_int16_t grain_seed;
	u_int8_t film_grain_params_ref_idx;
	u_int8_t num_y_points;
	u_int8_t point_y_value[V4L2_AV1_MAX_NUM_Y_POINTS];
	u_int8_t point_y_scaling[V4L2_AV1_MAX_NUM_Y_POINTS];
	u_int8_t num_cb_points;
	u_int8_t point_cb_value[V4L2_AV1_MAX_NUM_CB_POINTS];
	u_int8_t point_cb_scaling[V4L2_AV1_MAX_NUM_CB_POINTS];
	u_int8_t num_cr_points;
	u_int8_t point_cr_value[V4L2_AV1_MAX_NUM_CR_POINTS];
	u_int8_t point_cr_scaling[V4L2_AV1_MAX_NUM_CR_POINTS];
	u_int8_t grain_scaling_minus_8;
	u_int8_t ar_coeff_lag;
	u_int8_t ar_coeffs_y_plus_128[V4L2_AV1_AR_COEFFS_SIZE];
	u_int8_t ar_coeffs_cb_plus_128[V4L2_AV1_AR_COEFFS_SIZE];
	u_int8_t ar_coeffs_cr_plus_128[V4L2_AV1_AR_COEFFS_SIZE];
	u_int8_t ar_coeff_shift_minus_6;
	u_int8_t grain_scale_shift;
	u_int8_t cb_mult;
	u_int8_t cb_luma_mult;
	u_int8_t cr_luma_mult;
	u_int16_t cb_offset;
	u_int16_t cr_offset;
	u_int8_t reserved[4];
};

/* MPEG-compression definitions kept for backwards compatibility */
#define V4L2_CTRL_CLASS_MPEG            V4L2_CTRL_CLASS_CODEC
#define V4L2_CID_MPEG_CLASS             V4L2_CID_CODEC_CLASS
#define V4L2_CID_MPEG_BASE              V4L2_CID_CODEC_BASE
#define V4L2_CID_MPEG_CX2341X_BASE      V4L2_CID_CODEC_CX2341X_BASE
#define V4L2_CID_MPEG_MFC51_BASE        V4L2_CID_CODEC_MFC51_BASE
/*
 * End of v4l2-controls.h
 */

#ifndef __user
#define __user
#endif

/*
 * Common stuff for both V4L1 and V4L2
 * Moved from videodev.h
 */
#define VIDEO_MAX_FRAME               32
#define VIDEO_MAX_PLANES               8

/*
 *	M I S C E L L A N E O U S
 */

/*  Four-character-code (FOURCC) */
#define v4l2_fourcc(a, b, c, d)\
	((u_int32_t)(a) | ((u_int32_t)(b) << 8) | ((u_int32_t)(c) << 16) | ((u_int32_t)(d) << 24))
#define v4l2_fourcc_be(a, b, c, d)	(v4l2_fourcc(a, b, c, d) | (1U << 31))

/*
 *	E N U M S
 */
enum v4l2_field {
	V4L2_FIELD_ANY           = 0, /* driver can choose from none,
					 top, bottom, interlaced
					 depending on whatever it thinks
					 is approximate ... */
	V4L2_FIELD_NONE          = 1, /* this device has no fields ... */
	V4L2_FIELD_TOP           = 2, /* top field only */
	V4L2_FIELD_BOTTOM        = 3, /* bottom field only */
	V4L2_FIELD_INTERLACED    = 4, /* both fields interlaced */
	V4L2_FIELD_SEQ_TB        = 5, /* both fields sequential into one
					 buffer, top-bottom order */
	V4L2_FIELD_SEQ_BT        = 6, /* same as above + bottom-top order */
	V4L2_FIELD_ALTERNATE     = 7, /* both fields alternating into
					 separate buffers */
	V4L2_FIELD_INTERLACED_TB = 8, /* both fields interlaced, top field
					 first and the top field is
					 transmitted first */
	V4L2_FIELD_INTERLACED_BT = 9, /* both fields interlaced, top field
					 first and the bottom field is
					 transmitted first */
};
#define V4L2_FIELD_HAS_TOP(field)	\
	((field) == V4L2_FIELD_TOP	||\
	 (field) == V4L2_FIELD_INTERLACED ||\
	 (field) == V4L2_FIELD_INTERLACED_TB ||\
	 (field) == V4L2_FIELD_INTERLACED_BT ||\
	 (field) == V4L2_FIELD_SEQ_TB	||\
	 (field) == V4L2_FIELD_SEQ_BT)
#define V4L2_FIELD_HAS_BOTTOM(field)	\
	((field) == V4L2_FIELD_BOTTOM	||\
	 (field) == V4L2_FIELD_INTERLACED ||\
	 (field) == V4L2_FIELD_INTERLACED_TB ||\
	 (field) == V4L2_FIELD_INTERLACED_BT ||\
	 (field) == V4L2_FIELD_SEQ_TB	||\
	 (field) == V4L2_FIELD_SEQ_BT)
#define V4L2_FIELD_HAS_BOTH(field)	\
	((field) == V4L2_FIELD_INTERLACED ||\
	 (field) == V4L2_FIELD_INTERLACED_TB ||\
	 (field) == V4L2_FIELD_INTERLACED_BT ||\
	 (field) == V4L2_FIELD_SEQ_TB ||\
	 (field) == V4L2_FIELD_SEQ_BT)
#define V4L2_FIELD_HAS_T_OR_B(field)	\
	((field) == V4L2_FIELD_BOTTOM ||\
	 (field) == V4L2_FIELD_TOP ||\
	 (field) == V4L2_FIELD_ALTERNATE)
#define V4L2_FIELD_IS_INTERLACED(field) \
	((field) == V4L2_FIELD_INTERLACED ||\
	 (field) == V4L2_FIELD_INTERLACED_TB ||\
	 (field) == V4L2_FIELD_INTERLACED_BT)
#define V4L2_FIELD_IS_SEQUENTIAL(field) \
	((field) == V4L2_FIELD_SEQ_TB ||\
	 (field) == V4L2_FIELD_SEQ_BT)

enum v4l2_buf_type {
	V4L2_BUF_TYPE_VIDEO_CAPTURE        = 1,
	V4L2_BUF_TYPE_VIDEO_OUTPUT         = 2,
	V4L2_BUF_TYPE_VIDEO_OVERLAY        = 3,
	V4L2_BUF_TYPE_VBI_CAPTURE          = 4,
	V4L2_BUF_TYPE_VBI_OUTPUT           = 5,
	V4L2_BUF_TYPE_SLICED_VBI_CAPTURE   = 6,
	V4L2_BUF_TYPE_SLICED_VBI_OUTPUT    = 7,
	V4L2_BUF_TYPE_VIDEO_OUTPUT_OVERLAY = 8,
	V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE = 9,
	V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE  = 10,
	V4L2_BUF_TYPE_SDR_CAPTURE          = 11,
	V4L2_BUF_TYPE_SDR_OUTPUT           = 12,
	V4L2_BUF_TYPE_META_CAPTURE         = 13,
	V4L2_BUF_TYPE_META_OUTPUT	   = 14,
	/*
	 * Note: V4L2_TYPE_IS_VALID and V4L2_TYPE_IS_OUTPUT must
	 * be updated if a new type is added.
	 */
	/* Deprecated, do not use */
	V4L2_BUF_TYPE_PRIVATE              = 0x80,
};

#define V4L2_TYPE_IS_VALID(type)		 \
	((type) >= V4L2_BUF_TYPE_VIDEO_CAPTURE &&\
	 (type) <= V4L2_BUF_TYPE_META_OUTPUT)

#define V4L2_TYPE_IS_MULTIPLANAR(type)			\
	((type) == V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE	\
	 || (type) == V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE)

#define V4L2_TYPE_IS_OUTPUT(type)				\
	((type) == V4L2_BUF_TYPE_VIDEO_OUTPUT			\
	 || (type) == V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE		\
	 || (type) == V4L2_BUF_TYPE_VIDEO_OUTPUT_OVERLAY	\
	 || (type) == V4L2_BUF_TYPE_VBI_OUTPUT			\
	 || (type) == V4L2_BUF_TYPE_SLICED_VBI_OUTPUT		\
	 || (type) == V4L2_BUF_TYPE_SDR_OUTPUT			\
	 || (type) == V4L2_BUF_TYPE_META_OUTPUT)

#define V4L2_TYPE_IS_CAPTURE(type)	\
	(V4L2_TYPE_IS_VALID(type) && !V4L2_TYPE_IS_OUTPUT(type))

enum v4l2_tuner_type {
	V4L2_TUNER_RADIO	     = 1,
	V4L2_TUNER_ANALOG_TV	     = 2,
	V4L2_TUNER_DIGITAL_TV	     = 3,
	V4L2_TUNER_SDR               = 4,
	V4L2_TUNER_RF                = 5,
};

/* Deprecated, do not use */
#define V4L2_TUNER_ADC  V4L2_TUNER_SDR

enum v4l2_memory {
	V4L2_MEMORY_MMAP             = 1,
	V4L2_MEMORY_USERPTR          = 2,
	V4L2_MEMORY_OVERLAY          = 3,
	V4L2_MEMORY_DMABUF           = 4,
};

/* see also http://vektor.theorem.ca/graphics/ycbcr/ */
enum v4l2_colorspace {
	/*
	 * Default colorspace, i.e. let the driver figure it out.
	 * Can only be used with video capture.
	 */
	V4L2_COLORSPACE_DEFAULT       = 0,

	/* SMPTE 170M: used for broadcast NTSC/PAL SDTV */
	V4L2_COLORSPACE_SMPTE170M     = 1,

	/* Obsolete pre-1998 SMPTE 240M HDTV standard, superseded by Rec 709 */
	V4L2_COLORSPACE_SMPTE240M     = 2,

	/* Rec.709: used for HDTV */
	V4L2_COLORSPACE_REC709        = 3,

	/*
	 * Deprecated, do not use. No driver will ever return this. This was
	 * based on a misunderstanding of the bt878 datasheet.
	 */
	V4L2_COLORSPACE_BT878         = 4,

	/*
	 * NTSC 1953 colorspace. This only makes sense when dealing with
	 * really, really old NTSC recordings. Superseded by SMPTE 170M.
	 */
	V4L2_COLORSPACE_470_SYSTEM_M  = 5,

	/*
	 * EBU Tech 3213 PAL/SECAM colorspace.
	 */
	V4L2_COLORSPACE_470_SYSTEM_BG = 6,

	/*
	 * Effectively shorthand for V4L2_COLORSPACE_SRGB, V4L2_YCBCR_ENC_601
	 * and V4L2_QUANTIZATION_FULL_RANGE. To be used for (Motion-)JPEG.
	 */
	V4L2_COLORSPACE_JPEG          = 7,

	/* For RGB colorspaces such as produces by most webcams. */
	V4L2_COLORSPACE_SRGB          = 8,

	/* opRGB colorspace */
	V4L2_COLORSPACE_OPRGB         = 9,

	/* BT.2020 colorspace, used for UHDTV. */
	V4L2_COLORSPACE_BT2020        = 10,

	/* Raw colorspace: for RAW unprocessed images */
	V4L2_COLORSPACE_RAW           = 11,

	/* DCI-P3 colorspace, used by cinema projectors */
	V4L2_COLORSPACE_DCI_P3        = 12,
};

/*
 * Determine how COLORSPACE_DEFAULT should map to a proper colorspace.
 * This depends on whether this is a SDTV image (use SMPTE 170M), an
 * HDTV image (use Rec. 709), or something else (use sRGB).
 */
#define V4L2_MAP_COLORSPACE_DEFAULT(is_sdtv, is_hdtv) \
	((is_sdtv) ? V4L2_COLORSPACE_SMPTE170M : \
	 ((is_hdtv) ? V4L2_COLORSPACE_REC709 : V4L2_COLORSPACE_SRGB))

enum v4l2_xfer_func {
	/*
	 * Mapping of V4L2_XFER_FUNC_DEFAULT to actual transfer functions
	 * for the various colorspaces:
	 *
	 * V4L2_COLORSPACE_SMPTE170M, V4L2_COLORSPACE_470_SYSTEM_M,
	 * V4L2_COLORSPACE_470_SYSTEM_BG, V4L2_COLORSPACE_REC709 and
	 * V4L2_COLORSPACE_BT2020: V4L2_XFER_FUNC_709
	 *
	 * V4L2_COLORSPACE_SRGB, V4L2_COLORSPACE_JPEG: V4L2_XFER_FUNC_SRGB
	 *
	 * V4L2_COLORSPACE_OPRGB: V4L2_XFER_FUNC_OPRGB
	 *
	 * V4L2_COLORSPACE_SMPTE240M: V4L2_XFER_FUNC_SMPTE240M
	 *
	 * V4L2_COLORSPACE_RAW: V4L2_XFER_FUNC_NONE
	 *
	 * V4L2_COLORSPACE_DCI_P3: V4L2_XFER_FUNC_DCI_P3
	 */
	V4L2_XFER_FUNC_DEFAULT     = 0,
	V4L2_XFER_FUNC_709         = 1,
	V4L2_XFER_FUNC_SRGB        = 2,
	V4L2_XFER_FUNC_OPRGB       = 3,
	V4L2_XFER_FUNC_SMPTE240M   = 4,
	V4L2_XFER_FUNC_NONE        = 5,
	V4L2_XFER_FUNC_DCI_P3      = 6,
	V4L2_XFER_FUNC_SMPTE2084   = 7,
};

/*
 * Determine how XFER_FUNC_DEFAULT should map to a proper transfer function.
 * This depends on the colorspace.
 */
#define V4L2_MAP_XFER_FUNC_DEFAULT(colsp) \
	((colsp) == V4L2_COLORSPACE_OPRGB ? V4L2_XFER_FUNC_OPRGB : \
	 ((colsp) == V4L2_COLORSPACE_SMPTE240M ? V4L2_XFER_FUNC_SMPTE240M : \
	  ((colsp) == V4L2_COLORSPACE_DCI_P3 ? V4L2_XFER_FUNC_DCI_P3 : \
	   ((colsp) == V4L2_COLORSPACE_RAW ? V4L2_XFER_FUNC_NONE : \
	    ((colsp) == V4L2_COLORSPACE_SRGB || (colsp) == V4L2_COLORSPACE_JPEG ? \
	     V4L2_XFER_FUNC_SRGB : V4L2_XFER_FUNC_709)))))

enum v4l2_ycbcr_encoding {
	/*
	 * Mapping of V4L2_YCBCR_ENC_DEFAULT to actual encodings for the
	 * various colorspaces:
	 *
	 * V4L2_COLORSPACE_SMPTE170M, V4L2_COLORSPACE_470_SYSTEM_M,
	 * V4L2_COLORSPACE_470_SYSTEM_BG, V4L2_COLORSPACE_SRGB,
	 * V4L2_COLORSPACE_OPRGB and V4L2_COLORSPACE_JPEG: V4L2_YCBCR_ENC_601
	 *
	 * V4L2_COLORSPACE_REC709 and V4L2_COLORSPACE_DCI_P3: V4L2_YCBCR_ENC_709
	 *
	 * V4L2_COLORSPACE_BT2020: V4L2_YCBCR_ENC_BT2020
	 *
	 * V4L2_COLORSPACE_SMPTE240M: V4L2_YCBCR_ENC_SMPTE240M
	 */
	V4L2_YCBCR_ENC_DEFAULT        = 0,

	/* ITU-R 601 -- SDTV */
	V4L2_YCBCR_ENC_601            = 1,

	/* Rec. 709 -- HDTV */
	V4L2_YCBCR_ENC_709            = 2,

	/* ITU-R 601/EN 61966-2-4 Extended Gamut -- SDTV */
	V4L2_YCBCR_ENC_XV601          = 3,

	/* Rec. 709/EN 61966-2-4 Extended Gamut -- HDTV */
	V4L2_YCBCR_ENC_XV709          = 4,

	/*
	 * sYCC (Y'CbCr encoding of sRGB), identical to ENC_601. It was added
	 * originally due to a misunderstanding of the sYCC standard. It should
	 * not be used, instead use V4L2_YCBCR_ENC_601.
	 */
	V4L2_YCBCR_ENC_SYCC           = 5,

	/* BT.2020 Non-constant Luminance Y'CbCr */
	V4L2_YCBCR_ENC_BT2020         = 6,

	/* BT.2020 Constant Luminance Y'CbcCrc */
	V4L2_YCBCR_ENC_BT2020_CONST_LUM = 7,

	/* SMPTE 240M -- Obsolete HDTV */
	V4L2_YCBCR_ENC_SMPTE240M      = 8,
};

/*
 * enum v4l2_hsv_encoding values should not collide with the ones from
 * enum v4l2_ycbcr_encoding.
 */
enum v4l2_hsv_encoding {

	/* Hue mapped to 0 - 179 */
	V4L2_HSV_ENC_180		= 128,

	/* Hue mapped to 0-255 */
	V4L2_HSV_ENC_256		= 129,
};

/*
 * Determine how YCBCR_ENC_DEFAULT should map to a proper Y'CbCr encoding.
 * This depends on the colorspace.
 */
#define V4L2_MAP_YCBCR_ENC_DEFAULT(colsp) \
	(((colsp) == V4L2_COLORSPACE_REC709 || \
	  (colsp) == V4L2_COLORSPACE_DCI_P3) ? V4L2_YCBCR_ENC_709 : \
	 ((colsp) == V4L2_COLORSPACE_BT2020 ? V4L2_YCBCR_ENC_BT2020 : \
	  ((colsp) == V4L2_COLORSPACE_SMPTE240M ? V4L2_YCBCR_ENC_SMPTE240M : \
	   V4L2_YCBCR_ENC_601)))

enum v4l2_quantization {
	/*
	 * The default for R'G'B' quantization is always full range.
	 * For Y'CbCr the quantization is always limited range, except
	 * for COLORSPACE_JPEG: this is full range.
	 */
	V4L2_QUANTIZATION_DEFAULT     = 0,
	V4L2_QUANTIZATION_FULL_RANGE  = 1,
	V4L2_QUANTIZATION_LIM_RANGE   = 2,
};

/*
 * Determine how QUANTIZATION_DEFAULT should map to a proper quantization.
 * This depends on whether the image is RGB or not, the colorspace.
 * The Y'CbCr encoding is not used anymore, but is still there for backwards
 * compatibility.
 */
#define V4L2_MAP_QUANTIZATION_DEFAULT(is_rgb_or_hsv, colsp, ycbcr_enc) \
	(((is_rgb_or_hsv) || (colsp) == V4L2_COLORSPACE_JPEG) ? \
	 V4L2_QUANTIZATION_FULL_RANGE : V4L2_QUANTIZATION_LIM_RANGE)

/*
 * Deprecated names for opRGB colorspace (IEC 61966-2-5)
 *
 * WARNING: Please don't use these deprecated defines in your code, as
 * there is a chance we have to remove them in the future.
 */
#define V4L2_COLORSPACE_ADOBERGB V4L2_COLORSPACE_OPRGB
#define V4L2_XFER_FUNC_ADOBERGB  V4L2_XFER_FUNC_OPRGB

enum v4l2_priority {
	V4L2_PRIORITY_UNSET       = 0,  /* not initialized */
	V4L2_PRIORITY_BACKGROUND  = 1,
	V4L2_PRIORITY_INTERACTIVE = 2,
	V4L2_PRIORITY_RECORD      = 3,
	V4L2_PRIORITY_DEFAULT     = V4L2_PRIORITY_INTERACTIVE,
};

struct v4l2_rect {
	int32_t   left;
	int32_t   top;
	u_int32_t   width;
	u_int32_t   height;
};

struct v4l2_fract {
	u_int32_t   numerator;
	u_int32_t   denominator;
};

struct v4l2_area {
	u_int32_t   width;
	u_int32_t   height;
};

/**
  * struct v4l2_capability - Describes V4L2 device caps returned by VIDIOC_QUERYCAP
  *
  * @driver:	   name of the driver module (e.g. "bttv")
  * @card:	   name of the card (e.g. "Hauppauge WinTV")
  * @bus_info:	   name of the bus (e.g. "PCI:" + pci_name(pci_dev) )
  * @version:	   KERNEL_VERSION
  * @capabilities: capabilities of the physical device as a whole
  * @device_caps:  capabilities accessed via this particular device (node)
  * @reserved:	   reserved fields for future extensions
  */
struct v4l2_capability {
	u_int8_t	driver[16];
	u_int8_t	card[32];
	u_int8_t	bus_info[32];
	u_int32_t   version;
	u_int32_t	capabilities;
	u_int32_t	device_caps;
	u_int32_t	reserved[3];
};

/* Values for 'capabilities' field */
#define V4L2_CAP_VIDEO_CAPTURE		0x00000001  /* Is a video capture device */
#define V4L2_CAP_VIDEO_OUTPUT		0x00000002  /* Is a video output device */
#define V4L2_CAP_VIDEO_OVERLAY		0x00000004  /* Can do video overlay */
#define V4L2_CAP_VBI_CAPTURE		0x00000010  /* Is a raw VBI capture device */
#define V4L2_CAP_VBI_OUTPUT		0x00000020  /* Is a raw VBI output device */
#define V4L2_CAP_SLICED_VBI_CAPTURE	0x00000040  /* Is a sliced VBI capture device */
#define V4L2_CAP_SLICED_VBI_OUTPUT	0x00000080  /* Is a sliced VBI output device */
#define V4L2_CAP_RDS_CAPTURE		0x00000100  /* RDS data capture */
#define V4L2_CAP_VIDEO_OUTPUT_OVERLAY	0x00000200  /* Can do video output overlay */
#define V4L2_CAP_HW_FREQ_SEEK		0x00000400  /* Can do hardware frequency seek  */
#define V4L2_CAP_RDS_OUTPUT		0x00000800  /* Is an RDS encoder */

/* Is a video capture device that supports multiplanar formats */
#define V4L2_CAP_VIDEO_CAPTURE_MPLANE	0x00001000
/* Is a video output device that supports multiplanar formats */
#define V4L2_CAP_VIDEO_OUTPUT_MPLANE	0x00002000
/* Is a video mem-to-mem device that supports multiplanar formats */
#define V4L2_CAP_VIDEO_M2M_MPLANE	0x00004000
/* Is a video mem-to-mem device */
#define V4L2_CAP_VIDEO_M2M		0x00008000

#define V4L2_CAP_TUNER			0x00010000  /* has a tuner */
#define V4L2_CAP_AUDIO			0x00020000  /* has audio support */
#define V4L2_CAP_RADIO			0x00040000  /* is a radio device */
#define V4L2_CAP_MODULATOR		0x00080000  /* has a modulator */

#define V4L2_CAP_SDR_CAPTURE		0x00100000  /* Is a SDR capture device */
#define V4L2_CAP_EXT_PIX_FORMAT		0x00200000  /* Supports the extended pixel format */
#define V4L2_CAP_SDR_OUTPUT		0x00400000  /* Is a SDR output device */
#define V4L2_CAP_META_CAPTURE		0x00800000  /* Is a metadata capture device */

#define V4L2_CAP_READWRITE              0x01000000  /* read/write systemcalls */
#define V4L2_CAP_EDID			0x02000000  /* Is an EDID-only device */
#define V4L2_CAP_STREAMING              0x04000000  /* streaming I/O ioctls */
#define V4L2_CAP_META_OUTPUT		0x08000000  /* Is a metadata output device */

#define V4L2_CAP_TOUCH                  0x10000000  /* Is a touch device */

#define V4L2_CAP_IO_MC			0x20000000  /* Is input/output controlled by the media controller */

#define V4L2_CAP_DEVICE_CAPS            0x80000000  /* sets device capabilities field */

/*
 *	V I D E O   I M A G E   F O R M A T
 */
struct v4l2_pix_format {
	u_int32_t			width;
	u_int32_t			height;
	u_int32_t			pixelformat;
	u_int32_t			field;		/* enum v4l2_field */
	u_int32_t			bytesperline;	/* for padding, zero if unused */
	u_int32_t			sizeimage;
	u_int32_t			colorspace;	/* enum v4l2_colorspace */
	u_int32_t			priv;		/* private data, depends on pixelformat */
	u_int32_t			flags;		/* format flags (V4L2_PIX_FMT_FLAG_*) */
	union {
		/* enum v4l2_ycbcr_encoding */
		u_int32_t			ycbcr_enc;
		/* enum v4l2_hsv_encoding */
		u_int32_t			hsv_enc;
	};
	u_int32_t			quantization;	/* enum v4l2_quantization */
	u_int32_t			xfer_func;	/* enum v4l2_xfer_func */
};

/*      Pixel format         FOURCC                          depth  Description  */

/* RGB formats (1 or 2 bytes per pixel) */
#define V4L2_PIX_FMT_RGB332  v4l2_fourcc('R', 'G', 'B', '1') /*  8  RGB-3-3-2     */
#define V4L2_PIX_FMT_RGB444  v4l2_fourcc('R', '4', '4', '4') /* 16  xxxxrrrr ggggbbbb */
#define V4L2_PIX_FMT_ARGB444 v4l2_fourcc('A', 'R', '1', '2') /* 16  aaaarrrr ggggbbbb */
#define V4L2_PIX_FMT_XRGB444 v4l2_fourcc('X', 'R', '1', '2') /* 16  xxxxrrrr ggggbbbb */
#define V4L2_PIX_FMT_RGBA444 v4l2_fourcc('R', 'A', '1', '2') /* 16  rrrrgggg bbbbaaaa */
#define V4L2_PIX_FMT_RGBX444 v4l2_fourcc('R', 'X', '1', '2') /* 16  rrrrgggg bbbbxxxx */
#define V4L2_PIX_FMT_ABGR444 v4l2_fourcc('A', 'B', '1', '2') /* 16  aaaabbbb ggggrrrr */
#define V4L2_PIX_FMT_XBGR444 v4l2_fourcc('X', 'B', '1', '2') /* 16  xxxxbbbb ggggrrrr */
#define V4L2_PIX_FMT_BGRA444 v4l2_fourcc('G', 'A', '1', '2') /* 16  bbbbgggg rrrraaaa */
#define V4L2_PIX_FMT_BGRX444 v4l2_fourcc('B', 'X', '1', '2') /* 16  bbbbgggg rrrrxxxx */
#define V4L2_PIX_FMT_RGB555  v4l2_fourcc('R', 'G', 'B', 'O') /* 16  RGB-5-5-5     */
#define V4L2_PIX_FMT_ARGB555 v4l2_fourcc('A', 'R', '1', '5') /* 16  ARGB-1-5-5-5  */
#define V4L2_PIX_FMT_XRGB555 v4l2_fourcc('X', 'R', '1', '5') /* 16  XRGB-1-5-5-5  */
#define V4L2_PIX_FMT_RGBA555 v4l2_fourcc('R', 'A', '1', '5') /* 16  RGBA-5-5-5-1  */
#define V4L2_PIX_FMT_RGBX555 v4l2_fourcc('R', 'X', '1', '5') /* 16  RGBX-5-5-5-1  */
#define V4L2_PIX_FMT_ABGR555 v4l2_fourcc('A', 'B', '1', '5') /* 16  ABGR-1-5-5-5  */
#define V4L2_PIX_FMT_XBGR555 v4l2_fourcc('X', 'B', '1', '5') /* 16  XBGR-1-5-5-5  */
#define V4L2_PIX_FMT_BGRA555 v4l2_fourcc('B', 'A', '1', '5') /* 16  BGRA-5-5-5-1  */
#define V4L2_PIX_FMT_BGRX555 v4l2_fourcc('B', 'X', '1', '5') /* 16  BGRX-5-5-5-1  */
#define V4L2_PIX_FMT_RGB565  v4l2_fourcc('R', 'G', 'B', 'P') /* 16  RGB-5-6-5     */
#define V4L2_PIX_FMT_RGB555X v4l2_fourcc('R', 'G', 'B', 'Q') /* 16  RGB-5-5-5 BE  */
#define V4L2_PIX_FMT_ARGB555X v4l2_fourcc_be('A', 'R', '1', '5') /* 16  ARGB-5-5-5 BE */
#define V4L2_PIX_FMT_XRGB555X v4l2_fourcc_be('X', 'R', '1', '5') /* 16  XRGB-5-5-5 BE */
#define V4L2_PIX_FMT_RGB565X v4l2_fourcc('R', 'G', 'B', 'R') /* 16  RGB-5-6-5 BE  */

/* RGB formats (3 or 4 bytes per pixel) */
#define V4L2_PIX_FMT_BGR666  v4l2_fourcc('B', 'G', 'R', 'H') /* 18  BGR-6-6-6	  */
#define V4L2_PIX_FMT_BGR24   v4l2_fourcc('B', 'G', 'R', '3') /* 24  BGR-8-8-8     */
#define V4L2_PIX_FMT_RGB24   v4l2_fourcc('R', 'G', 'B', '3') /* 24  RGB-8-8-8     */
#define V4L2_PIX_FMT_BGR32   v4l2_fourcc('B', 'G', 'R', '4') /* 32  BGR-8-8-8-8   */
#define V4L2_PIX_FMT_ABGR32  v4l2_fourcc('A', 'R', '2', '4') /* 32  BGRA-8-8-8-8  */
#define V4L2_PIX_FMT_XBGR32  v4l2_fourcc('X', 'R', '2', '4') /* 32  BGRX-8-8-8-8  */
#define V4L2_PIX_FMT_BGRA32  v4l2_fourcc('R', 'A', '2', '4') /* 32  ABGR-8-8-8-8  */
#define V4L2_PIX_FMT_BGRX32  v4l2_fourcc('R', 'X', '2', '4') /* 32  XBGR-8-8-8-8  */
#define V4L2_PIX_FMT_RGB32   v4l2_fourcc('R', 'G', 'B', '4') /* 32  RGB-8-8-8-8   */
#define V4L2_PIX_FMT_RGBA32  v4l2_fourcc('A', 'B', '2', '4') /* 32  RGBA-8-8-8-8  */
#define V4L2_PIX_FMT_RGBX32  v4l2_fourcc('X', 'B', '2', '4') /* 32  RGBX-8-8-8-8  */
#define V4L2_PIX_FMT_ARGB32  v4l2_fourcc('B', 'A', '2', '4') /* 32  ARGB-8-8-8-8  */
#define V4L2_PIX_FMT_XRGB32  v4l2_fourcc('B', 'X', '2', '4') /* 32  XRGB-8-8-8-8  */
#define V4L2_PIX_FMT_RGBX1010102 v4l2_fourcc('R', 'X', '3', '0') /* 32  RGBX-10-10-10-2 */
#define V4L2_PIX_FMT_RGBA1010102 v4l2_fourcc('R', 'A', '3', '0') /* 32  RGBA-10-10-10-2 */
#define V4L2_PIX_FMT_ARGB2101010 v4l2_fourcc('A', 'R', '3', '0') /* 32  ARGB-2-10-10-10 */

/* RGB formats (6 or 8 bytes per pixel) */
#define V4L2_PIX_FMT_BGR48_12    v4l2_fourcc('B', '3', '1', '2') /* 48  BGR 12-bit per component */
#define V4L2_PIX_FMT_BGR48       v4l2_fourcc('B', 'G', 'R', '6') /* 48  BGR 16-bit per component */
#define V4L2_PIX_FMT_RGB48       v4l2_fourcc('R', 'G', 'B', '6') /* 48  RGB 16-bit per component */
#define V4L2_PIX_FMT_ABGR64_12   v4l2_fourcc('B', '4', '1', '2') /* 64  BGRA 12-bit per component */

/* Grey formats */
#define V4L2_PIX_FMT_GREY    v4l2_fourcc('G', 'R', 'E', 'Y') /*  8  Greyscale     */
#define V4L2_PIX_FMT_Y4      v4l2_fourcc('Y', '0', '4', ' ') /*  4  Greyscale     */
#define V4L2_PIX_FMT_Y6      v4l2_fourcc('Y', '0', '6', ' ') /*  6  Greyscale     */
#define V4L2_PIX_FMT_Y10     v4l2_fourcc('Y', '1', '0', ' ') /* 10  Greyscale     */
#define V4L2_PIX_FMT_Y12     v4l2_fourcc('Y', '1', '2', ' ') /* 12  Greyscale     */
#define V4L2_PIX_FMT_Y012    v4l2_fourcc('Y', '0', '1', '2') /* 12  Greyscale     */
#define V4L2_PIX_FMT_Y14     v4l2_fourcc('Y', '1', '4', ' ') /* 14  Greyscale     */
#define V4L2_PIX_FMT_Y16     v4l2_fourcc('Y', '1', '6', ' ') /* 16  Greyscale     */
#define V4L2_PIX_FMT_Y16_BE  v4l2_fourcc_be('Y', '1', '6', ' ') /* 16  Greyscale BE  */

/* Grey bit-packed formats */
#define V4L2_PIX_FMT_Y10BPACK    v4l2_fourcc('Y', '1', '0', 'B') /* 10  Greyscale bit-packed */
#define V4L2_PIX_FMT_Y10P    v4l2_fourcc('Y', '1', '0', 'P') /* 10  Greyscale, MIPI RAW10 packed */
#define V4L2_PIX_FMT_IPU3_Y10		v4l2_fourcc('i', 'p', '3', 'y') /* IPU3 packed 10-bit greyscale */
#define V4L2_PIX_FMT_Y12P    v4l2_fourcc('Y', '1', '2', 'P') /* 12  Greyscale, MIPI RAW12 packed */
#define V4L2_PIX_FMT_Y14P    v4l2_fourcc('Y', '1', '4', 'P') /* 14  Greyscale, MIPI RAW14 packed */

/* Palette formats */
#define V4L2_PIX_FMT_PAL8    v4l2_fourcc('P', 'A', 'L', '8') /*  8  8-bit palette */

/* Chrominance formats */
#define V4L2_PIX_FMT_UV8     v4l2_fourcc('U', 'V', '8', ' ') /*  8  UV 4:4 */

/* Luminance+Chrominance formats */
#define V4L2_PIX_FMT_YUYV    v4l2_fourcc('Y', 'U', 'Y', 'V') /* 16  YUV 4:2:2     */
#define V4L2_PIX_FMT_YYUV    v4l2_fourcc('Y', 'Y', 'U', 'V') /* 16  YUV 4:2:2     */
#define V4L2_PIX_FMT_YVYU    v4l2_fourcc('Y', 'V', 'Y', 'U') /* 16 YVU 4:2:2 */
#define V4L2_PIX_FMT_UYVY    v4l2_fourcc('U', 'Y', 'V', 'Y') /* 16  YUV 4:2:2     */
#define V4L2_PIX_FMT_VYUY    v4l2_fourcc('V', 'Y', 'U', 'Y') /* 16  YUV 4:2:2     */
#define V4L2_PIX_FMT_Y41P    v4l2_fourcc('Y', '4', '1', 'P') /* 12  YUV 4:1:1     */
#define V4L2_PIX_FMT_YUV444  v4l2_fourcc('Y', '4', '4', '4') /* 16  xxxxyyyy uuuuvvvv */
#define V4L2_PIX_FMT_YUV555  v4l2_fourcc('Y', 'U', 'V', 'O') /* 16  YUV-5-5-5     */
#define V4L2_PIX_FMT_YUV565  v4l2_fourcc('Y', 'U', 'V', 'P') /* 16  YUV-5-6-5     */
#define V4L2_PIX_FMT_YUV24   v4l2_fourcc('Y', 'U', 'V', '3') /* 24  YUV-8-8-8     */
#define V4L2_PIX_FMT_YUV32   v4l2_fourcc('Y', 'U', 'V', '4') /* 32  YUV-8-8-8-8   */
#define V4L2_PIX_FMT_AYUV32  v4l2_fourcc('A', 'Y', 'U', 'V') /* 32  AYUV-8-8-8-8  */
#define V4L2_PIX_FMT_XYUV32  v4l2_fourcc('X', 'Y', 'U', 'V') /* 32  XYUV-8-8-8-8  */
#define V4L2_PIX_FMT_VUYA32  v4l2_fourcc('V', 'U', 'Y', 'A') /* 32  VUYA-8-8-8-8  */
#define V4L2_PIX_FMT_VUYX32  v4l2_fourcc('V', 'U', 'Y', 'X') /* 32  VUYX-8-8-8-8  */
#define V4L2_PIX_FMT_YUVA32  v4l2_fourcc('Y', 'U', 'V', 'A') /* 32  YUVA-8-8-8-8  */
#define V4L2_PIX_FMT_YUVX32  v4l2_fourcc('Y', 'U', 'V', 'X') /* 32  YUVX-8-8-8-8  */
#define V4L2_PIX_FMT_M420    v4l2_fourcc('M', '4', '2', '0') /* 12  YUV 4:2:0 2 lines y, 1 line uv interleaved */
#define V4L2_PIX_FMT_YUV48_12    v4l2_fourcc('Y', '3', '1', '2') /* 48  YUV 4:4:4 12-bit per component */

/*
 * YCbCr packed format. For each Y2xx format, xx bits of valid data occupy the MSBs
 * of the 16 bit components, and 16-xx bits of zero padding occupy the LSBs.
 */
#define V4L2_PIX_FMT_Y210    v4l2_fourcc('Y', '2', '1', '0') /* 32  YUYV 4:2:2 */
#define V4L2_PIX_FMT_Y212    v4l2_fourcc('Y', '2', '1', '2') /* 32  YUYV 4:2:2 */
#define V4L2_PIX_FMT_Y216    v4l2_fourcc('Y', '2', '1', '6') /* 32  YUYV 4:2:2 */

/* two planes -- one Y, one Cr + Cb interleaved  */
#define V4L2_PIX_FMT_NV12    v4l2_fourcc('N', 'V', '1', '2') /* 12  Y/CbCr 4:2:0  */
#define V4L2_PIX_FMT_NV21    v4l2_fourcc('N', 'V', '2', '1') /* 12  Y/CrCb 4:2:0  */
#define V4L2_PIX_FMT_NV15    v4l2_fourcc('N', 'V', '1', '5') /* 15  Y/CbCr 4:2:0 10-bit packed */
#define V4L2_PIX_FMT_NV16    v4l2_fourcc('N', 'V', '1', '6') /* 16  Y/CbCr 4:2:2  */
#define V4L2_PIX_FMT_NV61    v4l2_fourcc('N', 'V', '6', '1') /* 16  Y/CrCb 4:2:2  */
#define V4L2_PIX_FMT_NV20    v4l2_fourcc('N', 'V', '2', '0') /* 20  Y/CbCr 4:2:2 10-bit packed */
#define V4L2_PIX_FMT_NV24    v4l2_fourcc('N', 'V', '2', '4') /* 24  Y/CbCr 4:4:4  */
#define V4L2_PIX_FMT_NV42    v4l2_fourcc('N', 'V', '4', '2') /* 24  Y/CrCb 4:4:4  */
#define V4L2_PIX_FMT_P010    v4l2_fourcc('P', '0', '1', '0') /* 24  Y/CbCr 4:2:0 10-bit per component */
#define V4L2_PIX_FMT_P012    v4l2_fourcc('P', '0', '1', '2') /* 24  Y/CbCr 4:2:0 12-bit per component */

/* two non contiguous planes - one Y, one Cr + Cb interleaved  */
#define V4L2_PIX_FMT_NV12M   v4l2_fourcc('N', 'M', '1', '2') /* 12  Y/CbCr 4:2:0  */
#define V4L2_PIX_FMT_NV21M   v4l2_fourcc('N', 'M', '2', '1') /* 21  Y/CrCb 4:2:0  */
#define V4L2_PIX_FMT_NV16M   v4l2_fourcc('N', 'M', '1', '6') /* 16  Y/CbCr 4:2:2  */
#define V4L2_PIX_FMT_NV61M   v4l2_fourcc('N', 'M', '6', '1') /* 16  Y/CrCb 4:2:2  */
#define V4L2_PIX_FMT_P012M   v4l2_fourcc('P', 'M', '1', '2') /* 24  Y/CbCr 4:2:0 12-bit per component */

/* three planes - Y Cb, Cr */
#define V4L2_PIX_FMT_YUV410  v4l2_fourcc('Y', 'U', 'V', '9') /*  9  YUV 4:1:0     */
#define V4L2_PIX_FMT_YVU410  v4l2_fourcc('Y', 'V', 'U', '9') /*  9  YVU 4:1:0     */
#define V4L2_PIX_FMT_YUV411P v4l2_fourcc('4', '1', '1', 'P') /* 12  YVU411 planar */
#define V4L2_PIX_FMT_YUV420  v4l2_fourcc('Y', 'U', '1', '2') /* 12  YUV 4:2:0     */
#define V4L2_PIX_FMT_YVU420  v4l2_fourcc('Y', 'V', '1', '2') /* 12  YVU 4:2:0     */
#define V4L2_PIX_FMT_YUV422P v4l2_fourcc('4', '2', '2', 'P') /* 16  YVU422 planar */

/* three non contiguous planes - Y, Cb, Cr */
#define V4L2_PIX_FMT_YUV420M v4l2_fourcc('Y', 'M', '1', '2') /* 12  YUV420 planar */
#define V4L2_PIX_FMT_YVU420M v4l2_fourcc('Y', 'M', '2', '1') /* 12  YVU420 planar */
#define V4L2_PIX_FMT_YUV422M v4l2_fourcc('Y', 'M', '1', '6') /* 16  YUV422 planar */
#define V4L2_PIX_FMT_YVU422M v4l2_fourcc('Y', 'M', '6', '1') /* 16  YVU422 planar */
#define V4L2_PIX_FMT_YUV444M v4l2_fourcc('Y', 'M', '2', '4') /* 24  YUV444 planar */
#define V4L2_PIX_FMT_YVU444M v4l2_fourcc('Y', 'M', '4', '2') /* 24  YVU444 planar */

/* Tiled YUV formats */
#define V4L2_PIX_FMT_NV12_4L4 v4l2_fourcc('V', 'T', '1', '2')   /* 12  Y/CbCr 4:2:0  4x4 tiles */
#define V4L2_PIX_FMT_NV12_16L16 v4l2_fourcc('H', 'M', '1', '2') /* 12  Y/CbCr 4:2:0 16x16 tiles */
#define V4L2_PIX_FMT_NV12_32L32 v4l2_fourcc('S', 'T', '1', '2') /* 12  Y/CbCr 4:2:0 32x32 tiles */
#define V4L2_PIX_FMT_NV15_4L4 v4l2_fourcc('V', 'T', '1', '5') /* 15 Y/CbCr 4:2:0 10-bit 4x4 tiles */
#define V4L2_PIX_FMT_P010_4L4 v4l2_fourcc('T', '0', '1', '0') /* 12  Y/CbCr 4:2:0 10-bit 4x4 macroblocks */
#define V4L2_PIX_FMT_NV12_8L128       v4l2_fourcc('A', 'T', '1', '2') /* Y/CbCr 4:2:0 8x128 tiles */
#define V4L2_PIX_FMT_NV12_10BE_8L128  v4l2_fourcc_be('A', 'X', '1', '2') /* Y/CbCr 4:2:0 10-bit 8x128 tiles */

/* Tiled YUV formats, non contiguous planes */
#define V4L2_PIX_FMT_NV12MT  v4l2_fourcc('T', 'M', '1', '2') /* 12  Y/CbCr 4:2:0 64x32 tiles */
#define V4L2_PIX_FMT_NV12MT_16X16 v4l2_fourcc('V', 'M', '1', '2') /* 12  Y/CbCr 4:2:0 16x16 tiles */
#define V4L2_PIX_FMT_NV12M_8L128      v4l2_fourcc('N', 'A', '1', '2') /* Y/CbCr 4:2:0 8x128 tiles */
#define V4L2_PIX_FMT_NV12M_10BE_8L128 v4l2_fourcc_be('N', 'T', '1', '2') /* Y/CbCr 4:2:0 10-bit 8x128 tiles */

/* Bayer formats - see http://www.siliconimaging.com/RGB%20Bayer.htm */
#define V4L2_PIX_FMT_SBGGR8  v4l2_fourcc('B', 'A', '8', '1') /*  8  BGBG.. GRGR.. */
#define V4L2_PIX_FMT_SGBRG8  v4l2_fourcc('G', 'B', 'R', 'G') /*  8  GBGB.. RGRG.. */
#define V4L2_PIX_FMT_SGRBG8  v4l2_fourcc('G', 'R', 'B', 'G') /*  8  GRGR.. BGBG.. */
#define V4L2_PIX_FMT_SRGGB8  v4l2_fourcc('R', 'G', 'G', 'B') /*  8  RGRG.. GBGB.. */
#define V4L2_PIX_FMT_SBGGR10 v4l2_fourcc('B', 'G', '1', '0') /* 10  BGBG.. GRGR.. */
#define V4L2_PIX_FMT_SGBRG10 v4l2_fourcc('G', 'B', '1', '0') /* 10  GBGB.. RGRG.. */
#define V4L2_PIX_FMT_SGRBG10 v4l2_fourcc('B', 'A', '1', '0') /* 10  GRGR.. BGBG.. */
#define V4L2_PIX_FMT_SRGGB10 v4l2_fourcc('R', 'G', '1', '0') /* 10  RGRG.. GBGB.. */
	/* 10bit raw bayer packed, 5 bytes for every 4 pixels */
#define V4L2_PIX_FMT_SBGGR10P v4l2_fourcc('p', 'B', 'A', 'A')
#define V4L2_PIX_FMT_SGBRG10P v4l2_fourcc('p', 'G', 'A', 'A')
#define V4L2_PIX_FMT_SGRBG10P v4l2_fourcc('p', 'g', 'A', 'A')
#define V4L2_PIX_FMT_SRGGB10P v4l2_fourcc('p', 'R', 'A', 'A')
	/* 10bit raw bayer a-law compressed to 8 bits */
#define V4L2_PIX_FMT_SBGGR10ALAW8 v4l2_fourcc('a', 'B', 'A', '8')
#define V4L2_PIX_FMT_SGBRG10ALAW8 v4l2_fourcc('a', 'G', 'A', '8')
#define V4L2_PIX_FMT_SGRBG10ALAW8 v4l2_fourcc('a', 'g', 'A', '8')
#define V4L2_PIX_FMT_SRGGB10ALAW8 v4l2_fourcc('a', 'R', 'A', '8')
	/* 10bit raw bayer DPCM compressed to 8 bits */
#define V4L2_PIX_FMT_SBGGR10DPCM8 v4l2_fourcc('b', 'B', 'A', '8')
#define V4L2_PIX_FMT_SGBRG10DPCM8 v4l2_fourcc('b', 'G', 'A', '8')
#define V4L2_PIX_FMT_SGRBG10DPCM8 v4l2_fourcc('B', 'D', '1', '0')
#define V4L2_PIX_FMT_SRGGB10DPCM8 v4l2_fourcc('b', 'R', 'A', '8')
#define V4L2_PIX_FMT_SBGGR12 v4l2_fourcc('B', 'G', '1', '2') /* 12  BGBG.. GRGR.. */
#define V4L2_PIX_FMT_SGBRG12 v4l2_fourcc('G', 'B', '1', '2') /* 12  GBGB.. RGRG.. */
#define V4L2_PIX_FMT_SGRBG12 v4l2_fourcc('B', 'A', '1', '2') /* 12  GRGR.. BGBG.. */
#define V4L2_PIX_FMT_SRGGB12 v4l2_fourcc('R', 'G', '1', '2') /* 12  RGRG.. GBGB.. */
	/* 12bit raw bayer packed, 3 bytes for every 2 pixels */
#define V4L2_PIX_FMT_SBGGR12P v4l2_fourcc('p', 'B', 'C', 'C')
#define V4L2_PIX_FMT_SGBRG12P v4l2_fourcc('p', 'G', 'C', 'C')
#define V4L2_PIX_FMT_SGRBG12P v4l2_fourcc('p', 'g', 'C', 'C')
#define V4L2_PIX_FMT_SRGGB12P v4l2_fourcc('p', 'R', 'C', 'C')
#define V4L2_PIX_FMT_SBGGR14 v4l2_fourcc('B', 'G', '1', '4') /* 14  BGBG.. GRGR.. */
#define V4L2_PIX_FMT_SGBRG14 v4l2_fourcc('G', 'B', '1', '4') /* 14  GBGB.. RGRG.. */
#define V4L2_PIX_FMT_SGRBG14 v4l2_fourcc('G', 'R', '1', '4') /* 14  GRGR.. BGBG.. */
#define V4L2_PIX_FMT_SRGGB14 v4l2_fourcc('R', 'G', '1', '4') /* 14  RGRG.. GBGB.. */
	/* 14bit raw bayer packed, 7 bytes for every 4 pixels */
#define V4L2_PIX_FMT_SBGGR14P v4l2_fourcc('p', 'B', 'E', 'E')
#define V4L2_PIX_FMT_SGBRG14P v4l2_fourcc('p', 'G', 'E', 'E')
#define V4L2_PIX_FMT_SGRBG14P v4l2_fourcc('p', 'g', 'E', 'E')
#define V4L2_PIX_FMT_SRGGB14P v4l2_fourcc('p', 'R', 'E', 'E')
#define V4L2_PIX_FMT_SBGGR16 v4l2_fourcc('B', 'Y', 'R', '2') /* 16  BGBG.. GRGR.. */
#define V4L2_PIX_FMT_SGBRG16 v4l2_fourcc('G', 'B', '1', '6') /* 16  GBGB.. RGRG.. */
#define V4L2_PIX_FMT_SGRBG16 v4l2_fourcc('G', 'R', '1', '6') /* 16  GRGR.. BGBG.. */
#define V4L2_PIX_FMT_SRGGB16 v4l2_fourcc('R', 'G', '1', '6') /* 16  RGRG.. GBGB.. */

/* HSV formats */
#define V4L2_PIX_FMT_HSV24 v4l2_fourcc('H', 'S', 'V', '3')
#define V4L2_PIX_FMT_HSV32 v4l2_fourcc('H', 'S', 'V', '4')

/* compressed formats */
#define V4L2_PIX_FMT_MJPEG    v4l2_fourcc('M', 'J', 'P', 'G') /* Motion-JPEG   */
#define V4L2_PIX_FMT_JPEG     v4l2_fourcc('J', 'P', 'E', 'G') /* JFIF JPEG     */
#define V4L2_PIX_FMT_DV       v4l2_fourcc('d', 'v', 's', 'd') /* 1394          */
#define V4L2_PIX_FMT_MPEG     v4l2_fourcc('M', 'P', 'E', 'G') /* MPEG-1/2/4 Multiplexed */
#define V4L2_PIX_FMT_H264     v4l2_fourcc('H', '2', '6', '4') /* H264 with start codes */
#define V4L2_PIX_FMT_H264_NO_SC v4l2_fourcc('A', 'V', 'C', '1') /* H264 without start codes */
#define V4L2_PIX_FMT_H264_MVC v4l2_fourcc('M', '2', '6', '4') /* H264 MVC */
#define V4L2_PIX_FMT_H263     v4l2_fourcc('H', '2', '6', '3') /* H263          */
#define V4L2_PIX_FMT_MPEG1    v4l2_fourcc('M', 'P', 'G', '1') /* MPEG-1 ES     */
#define V4L2_PIX_FMT_MPEG2    v4l2_fourcc('M', 'P', 'G', '2') /* MPEG-2 ES     */
#define V4L2_PIX_FMT_MPEG2_SLICE v4l2_fourcc('M', 'G', '2', 'S') /* MPEG-2 parsed slice data */
#define V4L2_PIX_FMT_MPEG4    v4l2_fourcc('M', 'P', 'G', '4') /* MPEG-4 part 2 ES */
#define V4L2_PIX_FMT_XVID     v4l2_fourcc('X', 'V', 'I', 'D') /* Xvid           */
#define V4L2_PIX_FMT_VC1_ANNEX_G v4l2_fourcc('V', 'C', '1', 'G') /* SMPTE 421M Annex G compliant stream */
#define V4L2_PIX_FMT_VC1_ANNEX_L v4l2_fourcc('V', 'C', '1', 'L') /* SMPTE 421M Annex L compliant stream */
#define V4L2_PIX_FMT_VP8      v4l2_fourcc('V', 'P', '8', '0') /* VP8 */
#define V4L2_PIX_FMT_VP8_FRAME v4l2_fourcc('V', 'P', '8', 'F') /* VP8 parsed frame */
#define V4L2_PIX_FMT_VP9      v4l2_fourcc('V', 'P', '9', '0') /* VP9 */
#define V4L2_PIX_FMT_VP9_FRAME v4l2_fourcc('V', 'P', '9', 'F') /* VP9 parsed frame */
#define V4L2_PIX_FMT_HEVC     v4l2_fourcc('H', 'E', 'V', 'C') /* HEVC aka H.265 */
#define V4L2_PIX_FMT_FWHT     v4l2_fourcc('F', 'W', 'H', 'T') /* Fast Walsh Hadamard Transform (vicodec) */
#define V4L2_PIX_FMT_FWHT_STATELESS     v4l2_fourcc('S', 'F', 'W', 'H') /* Stateless FWHT (vicodec) */
#define V4L2_PIX_FMT_H264_SLICE v4l2_fourcc('S', '2', '6', '4') /* H264 parsed slices */
#define V4L2_PIX_FMT_HEVC_SLICE v4l2_fourcc('S', '2', '6', '5') /* HEVC parsed slices */
#define V4L2_PIX_FMT_AV1_FRAME v4l2_fourcc('A', 'V', '1', 'F') /* AV1 parsed frame */
#define V4L2_PIX_FMT_SPK      v4l2_fourcc('S', 'P', 'K', '0') /* Sorenson Spark */
#define V4L2_PIX_FMT_RV30     v4l2_fourcc('R', 'V', '3', '0') /* RealVideo 8 */
#define V4L2_PIX_FMT_RV40     v4l2_fourcc('R', 'V', '4', '0') /* RealVideo 9 & 10 */

/*  Vendor-specific formats   */
#define V4L2_PIX_FMT_CPIA1    v4l2_fourcc('C', 'P', 'I', 'A') /* cpia1 YUV */
#define V4L2_PIX_FMT_WNVA     v4l2_fourcc('W', 'N', 'V', 'A') /* Winnov hw compress */
#define V4L2_PIX_FMT_SN9C10X  v4l2_fourcc('S', '9', '1', '0') /* SN9C10x compression */
#define V4L2_PIX_FMT_SN9C20X_I420 v4l2_fourcc('S', '9', '2', '0') /* SN9C20x YUV 4:2:0 */
#define V4L2_PIX_FMT_PWC1     v4l2_fourcc('P', 'W', 'C', '1') /* pwc older webcam */
#define V4L2_PIX_FMT_PWC2     v4l2_fourcc('P', 'W', 'C', '2') /* pwc newer webcam */
#define V4L2_PIX_FMT_ET61X251 v4l2_fourcc('E', '6', '2', '5') /* ET61X251 compression */
#define V4L2_PIX_FMT_SPCA501  v4l2_fourcc('S', '5', '0', '1') /* YUYV per line */
#define V4L2_PIX_FMT_SPCA505  v4l2_fourcc('S', '5', '0', '5') /* YYUV per line */
#define V4L2_PIX_FMT_SPCA508  v4l2_fourcc('S', '5', '0', '8') /* YUVY per line */
#define V4L2_PIX_FMT_SPCA561  v4l2_fourcc('S', '5', '6', '1') /* compressed GBRG bayer */
#define V4L2_PIX_FMT_PAC207   v4l2_fourcc('P', '2', '0', '7') /* compressed BGGR bayer */
#define V4L2_PIX_FMT_MR97310A v4l2_fourcc('M', '3', '1', '0') /* compressed BGGR bayer */
#define V4L2_PIX_FMT_JL2005BCD v4l2_fourcc('J', 'L', '2', '0') /* compressed RGGB bayer */
#define V4L2_PIX_FMT_SN9C2028 v4l2_fourcc('S', 'O', 'N', 'X') /* compressed GBRG bayer */
#define V4L2_PIX_FMT_SQ905C   v4l2_fourcc('9', '0', '5', 'C') /* compressed RGGB bayer */
#define V4L2_PIX_FMT_PJPG     v4l2_fourcc('P', 'J', 'P', 'G') /* Pixart 73xx JPEG */
#define V4L2_PIX_FMT_OV511    v4l2_fourcc('O', '5', '1', '1') /* ov511 JPEG */
#define V4L2_PIX_FMT_OV518    v4l2_fourcc('O', '5', '1', '8') /* ov518 JPEG */
#define V4L2_PIX_FMT_STV0680  v4l2_fourcc('S', '6', '8', '0') /* stv0680 bayer */
#define V4L2_PIX_FMT_TM6000   v4l2_fourcc('T', 'M', '6', '0') /* tm5600/tm60x0 */
#define V4L2_PIX_FMT_CIT_YYVYUY v4l2_fourcc('C', 'I', 'T', 'V') /* one line of Y then 1 line of VYUY */
#define V4L2_PIX_FMT_KONICA420  v4l2_fourcc('K', 'O', 'N', 'I') /* YUV420 planar in blocks of 256 pixels */
#define V4L2_PIX_FMT_JPGL	v4l2_fourcc('J', 'P', 'G', 'L') /* JPEG-Lite */
#define V4L2_PIX_FMT_SE401      v4l2_fourcc('S', '4', '0', '1') /* se401 janggu compressed rgb */
#define V4L2_PIX_FMT_S5C_UYVY_JPG v4l2_fourcc('S', '5', 'C', 'I') /* S5C73M3 interleaved UYVY/JPEG */
#define V4L2_PIX_FMT_Y8I      v4l2_fourcc('Y', '8', 'I', ' ') /* Greyscale 8-bit L/R interleaved */
#define V4L2_PIX_FMT_Y12I     v4l2_fourcc('Y', '1', '2', 'I') /* Greyscale 12-bit L/R interleaved */
#define V4L2_PIX_FMT_Y16I     v4l2_fourcc('Y', '1', '6', 'I') /* Greyscale 16-bit L/R interleaved */
#define V4L2_PIX_FMT_Z16      v4l2_fourcc('Z', '1', '6', ' ') /* Depth data 16-bit */
#define V4L2_PIX_FMT_MT21C    v4l2_fourcc('M', 'T', '2', '1') /* Mediatek compressed block mode  */
#define V4L2_PIX_FMT_MM21     v4l2_fourcc('M', 'M', '2', '1') /* Mediatek 8-bit block mode, two non-contiguous planes */
#define V4L2_PIX_FMT_MT2110T  v4l2_fourcc('M', 'T', '2', 'T') /* Mediatek 10-bit block tile mode */
#define V4L2_PIX_FMT_MT2110R  v4l2_fourcc('M', 'T', '2', 'R') /* Mediatek 10-bit block raster mode */
#define V4L2_PIX_FMT_INZI     v4l2_fourcc('I', 'N', 'Z', 'I') /* Intel Planar Greyscale 10-bit and Depth 16-bit */
#define V4L2_PIX_FMT_CNF4     v4l2_fourcc('C', 'N', 'F', '4') /* Intel 4-bit packed depth confidence information */
#define V4L2_PIX_FMT_HI240    v4l2_fourcc('H', 'I', '2', '4') /* BTTV 8-bit dithered RGB */
#define V4L2_PIX_FMT_QC08C    v4l2_fourcc('Q', '0', '8', 'C') /* Qualcomm 8-bit compressed */
#define V4L2_PIX_FMT_QC10C    v4l2_fourcc('Q', '1', '0', 'C') /* Qualcomm 10-bit compressed */
#define V4L2_PIX_FMT_AJPG     v4l2_fourcc('A', 'J', 'P', 'G') /* Aspeed JPEG */
#define V4L2_PIX_FMT_HEXTILE  v4l2_fourcc('H', 'X', 'T', 'L') /* Hextile compressed */

/* 10bit raw packed, 32 bytes for every 25 pixels, last LSB 6 bits unused */
#define V4L2_PIX_FMT_IPU3_SBGGR10	v4l2_fourcc('i', 'p', '3', 'b') /* IPU3 packed 10-bit BGGR bayer */
#define V4L2_PIX_FMT_IPU3_SGBRG10	v4l2_fourcc('i', 'p', '3', 'g') /* IPU3 packed 10-bit GBRG bayer */
#define V4L2_PIX_FMT_IPU3_SGRBG10	v4l2_fourcc('i', 'p', '3', 'G') /* IPU3 packed 10-bit GRBG bayer */
#define V4L2_PIX_FMT_IPU3_SRGGB10	v4l2_fourcc('i', 'p', '3', 'r') /* IPU3 packed 10-bit RGGB bayer */

/* Raspberry Pi PiSP compressed formats. */
#define V4L2_PIX_FMT_PISP_COMP1_RGGB	v4l2_fourcc('P', 'C', '1', 'R') /* PiSP 8-bit mode 1 compressed RGGB bayer */
#define V4L2_PIX_FMT_PISP_COMP1_GRBG	v4l2_fourcc('P', 'C', '1', 'G') /* PiSP 8-bit mode 1 compressed GRBG bayer */
#define V4L2_PIX_FMT_PISP_COMP1_GBRG	v4l2_fourcc('P', 'C', '1', 'g') /* PiSP 8-bit mode 1 compressed GBRG bayer */
#define V4L2_PIX_FMT_PISP_COMP1_BGGR	v4l2_fourcc('P', 'C', '1', 'B') /* PiSP 8-bit mode 1 compressed BGGR bayer */
#define V4L2_PIX_FMT_PISP_COMP1_MONO	v4l2_fourcc('P', 'C', '1', 'M') /* PiSP 8-bit mode 1 compressed monochrome */
#define V4L2_PIX_FMT_PISP_COMP2_RGGB	v4l2_fourcc('P', 'C', '2', 'R') /* PiSP 8-bit mode 2 compressed RGGB bayer */
#define V4L2_PIX_FMT_PISP_COMP2_GRBG	v4l2_fourcc('P', 'C', '2', 'G') /* PiSP 8-bit mode 2 compressed GRBG bayer */
#define V4L2_PIX_FMT_PISP_COMP2_GBRG	v4l2_fourcc('P', 'C', '2', 'g') /* PiSP 8-bit mode 2 compressed GBRG bayer */
#define V4L2_PIX_FMT_PISP_COMP2_BGGR	v4l2_fourcc('P', 'C', '2', 'B') /* PiSP 8-bit mode 2 compressed BGGR bayer */
#define V4L2_PIX_FMT_PISP_COMP2_MONO	v4l2_fourcc('P', 'C', '2', 'M') /* PiSP 8-bit mode 2 compressed monochrome */

/* Renesas RZ/V2H CRU packed formats. 64-bit units with contiguous pixels */
#define V4L2_PIX_FMT_RAW_CRU10	v4l2_fourcc('C', 'R', '1', '0')
#define V4L2_PIX_FMT_RAW_CRU12	v4l2_fourcc('C', 'R', '1', '2')
#define V4L2_PIX_FMT_RAW_CRU14	v4l2_fourcc('C', 'R', '1', '4')
#define V4L2_PIX_FMT_RAW_CRU20	v4l2_fourcc('C', 'R', '2', '0')

/* SDR formats - used only for Software Defined Radio devices */
#define V4L2_SDR_FMT_CU8          v4l2_fourcc('C', 'U', '0', '8') /* IQ u8 */
#define V4L2_SDR_FMT_CU16LE       v4l2_fourcc('C', 'U', '1', '6') /* IQ u16le */
#define V4L2_SDR_FMT_CS8          v4l2_fourcc('C', 'S', '0', '8') /* complex s8 */
#define V4L2_SDR_FMT_CS14LE       v4l2_fourcc('C', 'S', '1', '4') /* complex s14le */
#define V4L2_SDR_FMT_RU12LE       v4l2_fourcc('R', 'U', '1', '2') /* real u12le */
#define V4L2_SDR_FMT_PCU16BE	  v4l2_fourcc('P', 'C', '1', '6') /* planar complex u16be */
#define V4L2_SDR_FMT_PCU18BE	  v4l2_fourcc('P', 'C', '1', '8') /* planar complex u18be */
#define V4L2_SDR_FMT_PCU20BE	  v4l2_fourcc('P', 'C', '2', '0') /* planar complex u20be */

/* Touch formats - used for Touch devices */
#define V4L2_TCH_FMT_DELTA_TD16	v4l2_fourcc('T', 'D', '1', '6') /* 16-bit signed deltas */
#define V4L2_TCH_FMT_DELTA_TD08	v4l2_fourcc('T', 'D', '0', '8') /* 8-bit signed deltas */
#define V4L2_TCH_FMT_TU16	v4l2_fourcc('T', 'U', '1', '6') /* 16-bit unsigned touch data */
#define V4L2_TCH_FMT_TU08	v4l2_fourcc('T', 'U', '0', '8') /* 8-bit unsigned touch data */

/* Meta-data formats */
#define V4L2_META_FMT_VSP1_HGO    v4l2_fourcc('V', 'S', 'P', 'H') /* R-Car VSP1 1-D Histogram */
#define V4L2_META_FMT_VSP1_HGT    v4l2_fourcc('V', 'S', 'P', 'T') /* R-Car VSP1 2-D Histogram */
#define V4L2_META_FMT_UVC         v4l2_fourcc('U', 'V', 'C', 'H') /* UVC Payload Header metadata */
#define V4L2_META_FMT_D4XX        v4l2_fourcc('D', '4', 'X', 'X') /* D4XX Payload Header metadata */
#define V4L2_META_FMT_UVC_MSXU_1_5  v4l2_fourcc('U', 'V', 'C', 'M') /* UVC MSXU metadata */
#define V4L2_META_FMT_VIVID	  v4l2_fourcc('V', 'I', 'V', 'D') /* Vivid Metadata */

/* Vendor specific - used for RK_ISP1 camera sub-system */
#define V4L2_META_FMT_RK_ISP1_PARAMS	v4l2_fourcc('R', 'K', '1', 'P') /* Rockchip ISP1 3A Parameters */
#define V4L2_META_FMT_RK_ISP1_STAT_3A	v4l2_fourcc('R', 'K', '1', 'S') /* Rockchip ISP1 3A Statistics */
#define V4L2_META_FMT_RK_ISP1_EXT_PARAMS	v4l2_fourcc('R', 'K', '1', 'E') /* Rockchip ISP1 3a Extensible Parameters */

/* Vendor specific - used for C3_ISP */
#define V4L2_META_FMT_C3ISP_PARAMS	v4l2_fourcc('C', '3', 'P', 'M') /* Amlogic C3 ISP Parameters */
#define V4L2_META_FMT_C3ISP_STATS	v4l2_fourcc('C', '3', 'S', 'T') /* Amlogic C3 ISP Statistics */

/* Vendor specific - used for RaspberryPi PiSP */
#define V4L2_META_FMT_RPI_BE_CFG	v4l2_fourcc('R', 'P', 'B', 'C') /* PiSP BE configuration */
#define V4L2_META_FMT_RPI_FE_CFG	v4l2_fourcc('R', 'P', 'F', 'C') /* PiSP FE configuration */
#define V4L2_META_FMT_RPI_FE_STATS	v4l2_fourcc('R', 'P', 'F', 'S') /* PiSP FE stats */

/* priv field value to indicates that subsequent fields are valid. */
#define V4L2_PIX_FMT_PRIV_MAGIC		0xfeedcafe

/* Flags */
#define V4L2_PIX_FMT_FLAG_PREMUL_ALPHA	0x00000001
#define V4L2_PIX_FMT_FLAG_SET_CSC	0x00000002

/*
 *	F O R M A T   E N U M E R A T I O N
 */
struct v4l2_fmtdesc {
	u_int32_t		    index;             /* Format number      */
	u_int32_t		    type;              /* enum v4l2_buf_type */
	u_int32_t               flags;
	u_int8_t		    description[32];   /* Description string */
	u_int32_t		    pixelformat;       /* Format fourcc      */
	u_int32_t		    mbus_code;		/* Media bus code    */
	u_int32_t		    reserved[3];
};

#define V4L2_FMT_FLAG_COMPRESSED		0x0001
#define V4L2_FMT_FLAG_EMULATED			0x0002
#define V4L2_FMT_FLAG_CONTINUOUS_BYTESTREAM	0x0004
#define V4L2_FMT_FLAG_DYN_RESOLUTION		0x0008
#define V4L2_FMT_FLAG_ENC_CAP_FRAME_INTERVAL	0x0010
#define V4L2_FMT_FLAG_CSC_COLORSPACE		0x0020
#define V4L2_FMT_FLAG_CSC_XFER_FUNC		0x0040
#define V4L2_FMT_FLAG_CSC_YCBCR_ENC		0x0080
#define V4L2_FMT_FLAG_CSC_HSV_ENC		V4L2_FMT_FLAG_CSC_YCBCR_ENC
#define V4L2_FMT_FLAG_CSC_QUANTIZATION		0x0100
#define V4L2_FMT_FLAG_META_LINE_BASED		0x0200

/*  Format description flag, to be ORed with the index */
#define V4L2_FMTDESC_FLAG_ENUM_ALL		0x80000000

	/* Frame Size and frame rate enumeration */
/*
 *	F R A M E   S I Z E   E N U M E R A T I O N
 */
enum v4l2_frmsizetypes {
	V4L2_FRMSIZE_TYPE_DISCRETE	= 1,
	V4L2_FRMSIZE_TYPE_CONTINUOUS	= 2,
	V4L2_FRMSIZE_TYPE_STEPWISE	= 3,
};

struct v4l2_frmsize_discrete {
	u_int32_t			width;		/* Frame width [pixel] */
	u_int32_t			height;		/* Frame height [pixel] */
};

struct v4l2_frmsize_stepwise {
	u_int32_t			min_width;	/* Minimum frame width [pixel] */
	u_int32_t			max_width;	/* Maximum frame width [pixel] */
	u_int32_t			step_width;	/* Frame width step size [pixel] */
	u_int32_t			min_height;	/* Minimum frame height [pixel] */
	u_int32_t			max_height;	/* Maximum frame height [pixel] */
	u_int32_t			step_height;	/* Frame height step size [pixel] */
};

struct v4l2_frmsizeenum {
	u_int32_t			index;		/* Frame size number */
	u_int32_t			pixel_format;	/* Pixel format */
	u_int32_t			type;		/* Frame size type the device supports. */

	union {					/* Frame size */
		struct v4l2_frmsize_discrete	discrete;
		struct v4l2_frmsize_stepwise	stepwise;
	};

	u_int32_t   reserved[2];			/* Reserved space for future use */
};

/*
 *	F R A M E   R A T E   E N U M E R A T I O N
 */
enum v4l2_frmivaltypes {
	V4L2_FRMIVAL_TYPE_DISCRETE	= 1,
	V4L2_FRMIVAL_TYPE_CONTINUOUS	= 2,
	V4L2_FRMIVAL_TYPE_STEPWISE	= 3,
};

struct v4l2_frmival_stepwise {
	struct v4l2_fract	min;		/* Minimum frame interval [s] */
	struct v4l2_fract	max;		/* Maximum frame interval [s] */
	struct v4l2_fract	step;		/* Frame interval step size [s] */
};

struct v4l2_frmivalenum {
	u_int32_t			index;		/* Frame format index */
	u_int32_t			pixel_format;	/* Pixel format */
	u_int32_t			width;		/* Frame width */
	u_int32_t			height;		/* Frame height */
	u_int32_t			type;		/* Frame interval type the device supports. */

	union {					/* Frame interval */
		struct v4l2_fract		discrete;
		struct v4l2_frmival_stepwise	stepwise;
	};

	u_int32_t	reserved[2];			/* Reserved space for future use */
};

/*
 *	T I M E C O D E
 */
struct v4l2_timecode {
	u_int32_t	type;
	u_int32_t	flags;
	u_int8_t	frames;
	u_int8_t	seconds;
	u_int8_t	minutes;
	u_int8_t	hours;
	u_int8_t	userbits[4];
};

/*  Type  */
#define V4L2_TC_TYPE_24FPS		1
#define V4L2_TC_TYPE_25FPS		2
#define V4L2_TC_TYPE_30FPS		3
#define V4L2_TC_TYPE_50FPS		4
#define V4L2_TC_TYPE_60FPS		5

/*  Flags  */
#define V4L2_TC_FLAG_DROPFRAME		0x0001 /* "drop-frame" mode */
#define V4L2_TC_FLAG_COLORFRAME		0x0002
#define V4L2_TC_USERBITS_field		0x000C
#define V4L2_TC_USERBITS_USERDEFINED	0x0000
#define V4L2_TC_USERBITS_8BITCHARS	0x0008
/* The above is based on SMPTE timecodes */

struct v4l2_jpegcompression {
	int quality;

	int  APPn;              /* Number of APP segment to be written,
				 * must be 0..15 */
	int  APP_len;           /* Length of data in JPEG APPn segment */
	char APP_data[60];      /* Data in the JPEG APPn segment. */

	int  COM_len;           /* Length of data in JPEG COM segment */
	char COM_data[60];      /* Data in JPEG COM segment */

	u_int32_t jpeg_markers;     /* Which markers should go into the JPEG
				 * output. Unless you exactly know what
				 * you do, leave them untouched.
				 * Including less markers will make the
				 * resulting code smaller, but there will
				 * be fewer applications which can read it.
				 * The presence of the APP and COM marker
				 * is influenced by APP_len and COM_len
				 * ONLY, not by this property! */

#define V4L2_JPEG_MARKER_DHT (1<<3)    /* Define Huffman Tables */
#define V4L2_JPEG_MARKER_DQT (1<<4)    /* Define Quantization Tables */
#define V4L2_JPEG_MARKER_DRI (1<<5)    /* Define Restart Interval */
#define V4L2_JPEG_MARKER_COM (1<<6)    /* Comment segment */
#define V4L2_JPEG_MARKER_APP (1<<7)    /* App segment, driver will
					* always use APP0 */
};

/*
 *	M E M O R Y - M A P P I N G   B U F F E R S
 */

struct v4l2_requestbuffers {
	u_int32_t			count;
	u_int32_t			type;		/* enum v4l2_buf_type */
	u_int32_t			memory;		/* enum v4l2_memory */
	u_int32_t			capabilities;
	u_int8_t			flags;
	u_int8_t			reserved[3];
};

#define V4L2_MEMORY_FLAG_NON_COHERENT			(1 << 0)

/* capabilities for struct v4l2_requestbuffers and v4l2_create_buffers */
#define V4L2_BUF_CAP_SUPPORTS_MMAP			(1 << 0)
#define V4L2_BUF_CAP_SUPPORTS_USERPTR			(1 << 1)
#define V4L2_BUF_CAP_SUPPORTS_DMABUF			(1 << 2)
#define V4L2_BUF_CAP_SUPPORTS_REQUESTS			(1 << 3)
#define V4L2_BUF_CAP_SUPPORTS_ORPHANED_BUFS		(1 << 4)
#define V4L2_BUF_CAP_SUPPORTS_M2M_HOLD_CAPTURE_BUF	(1 << 5)
#define V4L2_BUF_CAP_SUPPORTS_MMAP_CACHE_HINTS		(1 << 6)
#define V4L2_BUF_CAP_SUPPORTS_MAX_NUM_BUFFERS		(1 << 7)
#define V4L2_BUF_CAP_SUPPORTS_REMOVE_BUFS		(1 << 8)

/**
 * struct v4l2_plane - plane info for multi-planar buffers
 * @bytesused:		number of bytes occupied by data in the plane (payload)
 * @length:		size of this plane (NOT the payload) in bytes
 * @m.mem_offset:	when memory in the associated struct v4l2_buffer is
 *			V4L2_MEMORY_MMAP, equals the offset from the start of
 *			the device memory for this plane (or is a "cookie" that
 *			should be passed to mmap() called on the video node)
 * @m.userptr:		when memory is V4L2_MEMORY_USERPTR, a userspace pointer
 *			pointing to this plane
 * @m.fd:		when memory is V4L2_MEMORY_DMABUF, a userspace file
 *			descriptor associated with this plane
 * @m:			union of @mem_offset, @userptr and @fd
 * @data_offset:	offset in the plane to the start of data; usually 0,
 *			unless there is a header in front of the data
 * @reserved:		drivers and applications must zero this array
 *
 * Multi-planar buffers consist of one or more planes, e.g. an YCbCr buffer
 * with two planes can have one plane for Y, and another for interleaved CbCr
 * components. Each plane can reside in a separate memory buffer, or even in
 * a completely separate memory node (e.g. in embedded devices).
 */
struct v4l2_plane {
	u_int32_t			bytesused;
	u_int32_t			length;
	union {
		u_int32_t		mem_offset;
		unsigned long	userptr;
		int32_t		fd;
	} m;
	u_int32_t			data_offset;
	u_int32_t			reserved[11];
};

/**
 * struct v4l2_buffer - video buffer info
 * @index:	id number of the buffer
 * @type:	enum v4l2_buf_type; buffer type (type == *_MPLANE for
 *		multiplanar buffers);
 * @bytesused:	number of bytes occupied by data in the buffer (payload);
 *		unused (set to 0) for multiplanar buffers
 * @flags:	buffer informational flags
 * @field:	enum v4l2_field; field order of the image in the buffer
 * @timestamp:	frame timestamp
 * @timecode:	frame timecode
 * @sequence:	sequence count of this frame
 * @memory:	enum v4l2_memory; the method, in which the actual video data is
 *		passed
 * @m.offset:	for non-multiplanar buffers with memory == V4L2_MEMORY_MMAP;
 *		offset from the start of the device memory for this plane,
 *		(or a "cookie" that should be passed to mmap() as offset)
 * @m.userptr:	for non-multiplanar buffers with memory == V4L2_MEMORY_USERPTR;
 *		a userspace pointer pointing to this buffer
 * @m.fd:		for non-multiplanar buffers with memory == V4L2_MEMORY_DMABUF;
 *		a userspace file descriptor associated with this buffer
 * @m.planes:	for multiplanar buffers; userspace pointer to the array of plane
 *		info structs for this buffer
 * @m:		union of @offset, @userptr, @planes and @fd
 * @length:	size in bytes of the buffer (NOT its payload) for single-plane
 *		buffers (when type != *_MPLANE); number of elements in the
 *		planes array for multi-plane buffers
 * @reserved2:	drivers and applications must zero this field
 * @request_fd: fd of the request that this buffer should use
 * @reserved:	for backwards compatibility with applications that do not know
 *		about @request_fd
 *
 * Contains data exchanged by application and driver using one of the Streaming
 * I/O methods.
 */
struct v4l2_buffer {
	u_int32_t			index;
	u_int32_t			type;
	u_int32_t			bytesused;
	u_int32_t			flags;
	u_int32_t			field;
	struct timeval			timestamp;
	struct v4l2_timecode		timecode;
	u_int32_t			sequence;

	/* memory location */
	u_int32_t			memory;
	union {
		u_int32_t       offset;
		unsigned long   userptr;
		struct v4l2_plane *planes;
		int32_t		fd;
	} m;
	u_int32_t			length;
	u_int32_t			reserved2;
	union {
		int32_t			request_fd;
		u_int32_t		reserved;
	};
};

/**
 * v4l2_timeval_to_ns - Convert timeval to nanoseconds
 * @tv:		pointer to the timeval variable to be converted
 *
 * Returns the scalar nanosecond representation of the timeval
 * parameter.
 */
static inline u_int64_t v4l2_timeval_to_ns(const struct timeval *tv)
{
	return (u_int64_t)tv->tv_sec * 1000000000ULL + tv->tv_usec * 1000;
}

/*  Flags for 'flags' field */
/* Buffer is mapped (flag) */
#define V4L2_BUF_FLAG_MAPPED			0x00000001
/* Buffer is queued for processing */
#define V4L2_BUF_FLAG_QUEUED			0x00000002
/* Buffer is ready */
#define V4L2_BUF_FLAG_DONE			0x00000004
/* Image is a keyframe (I-frame) */
#define V4L2_BUF_FLAG_KEYFRAME			0x00000008
/* Image is a P-frame */
#define V4L2_BUF_FLAG_PFRAME			0x00000010
/* Image is a B-frame */
#define V4L2_BUF_FLAG_BFRAME			0x00000020
/* Buffer is ready, but the data contained within is corrupted. */
#define V4L2_BUF_FLAG_ERROR			0x00000040
/* Buffer is added to an unqueued request */
#define V4L2_BUF_FLAG_IN_REQUEST		0x00000080
/* timecode field is valid */
#define V4L2_BUF_FLAG_TIMECODE			0x00000100
/* Don't return the capture buffer until OUTPUT timestamp changes */
#define V4L2_BUF_FLAG_M2M_HOLD_CAPTURE_BUF	0x00000200
/* Buffer is prepared for queuing */
#define V4L2_BUF_FLAG_PREPARED			0x00000400
/* Cache handling flags */
#define V4L2_BUF_FLAG_NO_CACHE_INVALIDATE	0x00000800
#define V4L2_BUF_FLAG_NO_CACHE_CLEAN		0x00001000
/* Timestamp type */
#define V4L2_BUF_FLAG_TIMESTAMP_MASK		0x0000e000
#define V4L2_BUF_FLAG_TIMESTAMP_UNKNOWN		0x00000000
#define V4L2_BUF_FLAG_TIMESTAMP_MONOTONIC	0x00002000
#define V4L2_BUF_FLAG_TIMESTAMP_COPY		0x00004000
/* Timestamp sources. */
#define V4L2_BUF_FLAG_TSTAMP_SRC_MASK		0x00070000
#define V4L2_BUF_FLAG_TSTAMP_SRC_EOF		0x00000000
#define V4L2_BUF_FLAG_TSTAMP_SRC_SOE		0x00010000
/* mem2mem encoder/decoder */
#define V4L2_BUF_FLAG_LAST			0x00100000
/* request_fd is valid */
#define V4L2_BUF_FLAG_REQUEST_FD		0x00800000

/**
 * struct v4l2_exportbuffer - export of video buffer as DMABUF file descriptor
 *
 * @index:	id number of the buffer
 * @type:	enum v4l2_buf_type; buffer type (type == *_MPLANE for
 *		multiplanar buffers);
 * @plane:	index of the plane to be exported, 0 for single plane queues
 * @flags:	flags for newly created file, currently only O_CLOEXEC is
 *		supported, refer to manual of open syscall for more details
 * @fd:		file descriptor associated with DMABUF (set by driver)
 * @reserved:	drivers and applications must zero this array
 *
 * Contains data used for exporting a video buffer as DMABUF file descriptor.
 * The buffer is identified by a 'cookie' returned by VIDIOC_QUERYBUF
 * (identical to the cookie used to mmap() the buffer to userspace). All
 * reserved fields must be set to zero. The field reserved0 is expected to
 * become a structure 'type' allowing an alternative layout of the structure
 * content. Therefore this field should not be used for any other extensions.
 */
struct v4l2_exportbuffer {
	u_int32_t		type; /* enum v4l2_buf_type */
	u_int32_t		index;
	u_int32_t		plane;
	u_int32_t		flags;
	int32_t		fd;
	u_int32_t		reserved[11];
};

/*
 *	O V E R L A Y   P R E V I E W
 */
struct v4l2_framebuffer {
	u_int32_t			capability;
	u_int32_t			flags;
/* FIXME: in theory we should pass something like PCI device + memory
 * region + offset instead of some physical address */
	void                    *base;
	struct {
		u_int32_t		width;
		u_int32_t		height;
		u_int32_t		pixelformat;
		u_int32_t		field;		/* enum v4l2_field */
		u_int32_t		bytesperline;	/* for padding, zero if unused */
		u_int32_t		sizeimage;
		u_int32_t		colorspace;	/* enum v4l2_colorspace */
		u_int32_t		priv;		/* reserved field, set to 0 */
	} fmt;
};
/*  Flags for the 'capability' field. Read only */
#define V4L2_FBUF_CAP_EXTERNOVERLAY	0x0001
#define V4L2_FBUF_CAP_CHROMAKEY		0x0002
#define V4L2_FBUF_CAP_LIST_CLIPPING     0x0004
#define V4L2_FBUF_CAP_BITMAP_CLIPPING	0x0008
#define V4L2_FBUF_CAP_LOCAL_ALPHA	0x0010
#define V4L2_FBUF_CAP_GLOBAL_ALPHA	0x0020
#define V4L2_FBUF_CAP_LOCAL_INV_ALPHA	0x0040
#define V4L2_FBUF_CAP_SRC_CHROMAKEY	0x0080
/*  Flags for the 'flags' field. */
#define V4L2_FBUF_FLAG_PRIMARY		0x0001
#define V4L2_FBUF_FLAG_OVERLAY		0x0002
#define V4L2_FBUF_FLAG_CHROMAKEY	0x0004
#define V4L2_FBUF_FLAG_LOCAL_ALPHA	0x0008
#define V4L2_FBUF_FLAG_GLOBAL_ALPHA	0x0010
#define V4L2_FBUF_FLAG_LOCAL_INV_ALPHA	0x0020
#define V4L2_FBUF_FLAG_SRC_CHROMAKEY	0x0040

struct v4l2_clip {
	struct v4l2_rect        c;
	struct v4l2_clip	__user *next;
};

struct v4l2_window {
	struct v4l2_rect        w;
	u_int32_t			field;	 /* enum v4l2_field */
	u_int32_t			chromakey;
	struct v4l2_clip	*clips;
	u_int32_t			clipcount;
	void			__user *bitmap;
	u_int8_t                    global_alpha;
};

/*
 *	C A P T U R E   P A R A M E T E R S
 */
struct v4l2_captureparm {
	u_int32_t		   capability;	  /*  Supported modes */
	u_int32_t		   capturemode;	  /*  Current mode */
	struct v4l2_fract  timeperframe;  /*  Time per frame in seconds */
	u_int32_t		   extendedmode;  /*  Driver-specific extensions */
	u_int32_t              readbuffers;   /*  # of buffers for read */
	u_int32_t		   reserved[4];
};

/*  Flags for 'capability' and 'capturemode' fields */
#define V4L2_MODE_HIGHQUALITY	0x0001	/*  High quality imaging mode */
#define V4L2_CAP_TIMEPERFRAME	0x1000	/*  timeperframe field is supported */

struct v4l2_outputparm {
	u_int32_t		   capability;	 /*  Supported modes */
	u_int32_t		   outputmode;	 /*  Current mode */
	struct v4l2_fract  timeperframe; /*  Time per frame in seconds */
	u_int32_t		   extendedmode; /*  Driver-specific extensions */
	u_int32_t              writebuffers; /*  # of buffers for write */
	u_int32_t		   reserved[4];
};

/*
 *	I N P U T   I M A G E   C R O P P I N G
 */
struct v4l2_cropcap {
	u_int32_t			type;	/* enum v4l2_buf_type */
	struct v4l2_rect        bounds;
	struct v4l2_rect        defrect;
	struct v4l2_fract       pixelaspect;
};

struct v4l2_crop {
	u_int32_t			type;	/* enum v4l2_buf_type */
	struct v4l2_rect        c;
};

/**
 * struct v4l2_selection - selection info
 * @type:	buffer type (do not use *_MPLANE types)
 * @target:	Selection target, used to choose one of possible rectangles;
 *		defined in v4l2-common.h; V4L2_SEL_TGT_* .
 * @flags:	constraints flags, defined in v4l2-common.h; V4L2_SEL_FLAG_*.
 * @r:		coordinates of selection window
 * @reserved:	for future use, rounds structure size to 64 bytes, set to zero
 *
 * Hardware may use multiple helper windows to process a video stream.
 * The structure is used to exchange this selection areas between
 * an application and a driver.
 */
struct v4l2_selection {
	u_int32_t			type;
	u_int32_t			target;
	u_int32_t                   flags;
	struct v4l2_rect        r;
	u_int32_t                   reserved[9];
};


/*
 *      A N A L O G   V I D E O   S T A N D A R D
 */

typedef u_int64_t v4l2_std_id;

/*
 * Attention: Keep the V4L2_STD_* bit definitions in sync with
 * include/dt-bindings/display/sdtv-standards.h SDTV_STD_* bit definitions.
 */
/* one bit for each */
#define V4L2_STD_PAL_B          ((v4l2_std_id)0x00000001)
#define V4L2_STD_PAL_B1         ((v4l2_std_id)0x00000002)
#define V4L2_STD_PAL_G          ((v4l2_std_id)0x00000004)
#define V4L2_STD_PAL_H          ((v4l2_std_id)0x00000008)
#define V4L2_STD_PAL_I          ((v4l2_std_id)0x00000010)
#define V4L2_STD_PAL_D          ((v4l2_std_id)0x00000020)
#define V4L2_STD_PAL_D1         ((v4l2_std_id)0x00000040)
#define V4L2_STD_PAL_K          ((v4l2_std_id)0x00000080)

#define V4L2_STD_PAL_M          ((v4l2_std_id)0x00000100)
#define V4L2_STD_PAL_N          ((v4l2_std_id)0x00000200)
#define V4L2_STD_PAL_Nc         ((v4l2_std_id)0x00000400)
#define V4L2_STD_PAL_60         ((v4l2_std_id)0x00000800)

#define V4L2_STD_NTSC_M         ((v4l2_std_id)0x00001000)	/* BTSC */
#define V4L2_STD_NTSC_M_JP      ((v4l2_std_id)0x00002000)	/* EIA-J */
#define V4L2_STD_NTSC_443       ((v4l2_std_id)0x00004000)
#define V4L2_STD_NTSC_M_KR      ((v4l2_std_id)0x00008000)	/* FM A2 */

#define V4L2_STD_SECAM_B        ((v4l2_std_id)0x00010000)
#define V4L2_STD_SECAM_D        ((v4l2_std_id)0x00020000)
#define V4L2_STD_SECAM_G        ((v4l2_std_id)0x00040000)
#define V4L2_STD_SECAM_H        ((v4l2_std_id)0x00080000)
#define V4L2_STD_SECAM_K        ((v4l2_std_id)0x00100000)
#define V4L2_STD_SECAM_K1       ((v4l2_std_id)0x00200000)
#define V4L2_STD_SECAM_L        ((v4l2_std_id)0x00400000)
#define V4L2_STD_SECAM_LC       ((v4l2_std_id)0x00800000)

/* ATSC/HDTV */
#define V4L2_STD_ATSC_8_VSB     ((v4l2_std_id)0x01000000)
#define V4L2_STD_ATSC_16_VSB    ((v4l2_std_id)0x02000000)

/* FIXME:
   Although std_id is 64 bits, there is an issue on PPC32 architecture that
   makes switch(u_int64_t) to break. So, there's a hack on v4l2-common.c rounding
   this value to 32 bits.
   As, currently, the max value is for V4L2_STD_ATSC_16_VSB (30 bits wide),
   it should work fine. However, if needed to add more than two standards,
   v4l2-common.c should be fixed.
 */

/*
 * Some macros to merge video standards in order to make live easier for the
 * drivers and V4L2 applications
 */

/*
 * "Common" NTSC/M - It should be noticed that V4L2_STD_NTSC_443 is
 * Missing here.
 */
#define V4L2_STD_NTSC           (V4L2_STD_NTSC_M	|\
				 V4L2_STD_NTSC_M_JP     |\
				 V4L2_STD_NTSC_M_KR)
/* Secam macros */
#define V4L2_STD_SECAM_DK	(V4L2_STD_SECAM_D	|\
				 V4L2_STD_SECAM_K	|\
				 V4L2_STD_SECAM_K1)
/* All Secam Standards */
#define V4L2_STD_SECAM		(V4L2_STD_SECAM_B	|\
				 V4L2_STD_SECAM_G	|\
				 V4L2_STD_SECAM_H	|\
				 V4L2_STD_SECAM_DK	|\
				 V4L2_STD_SECAM_L       |\
				 V4L2_STD_SECAM_LC)
/* PAL macros */
#define V4L2_STD_PAL_BG		(V4L2_STD_PAL_B		|\
				 V4L2_STD_PAL_B1	|\
				 V4L2_STD_PAL_G)
#define V4L2_STD_PAL_DK		(V4L2_STD_PAL_D		|\
				 V4L2_STD_PAL_D1	|\
				 V4L2_STD_PAL_K)
/*
 * "Common" PAL - This macro is there to be compatible with the old
 * V4L1 concept of "PAL": /BGDKHI.
 * Several PAL standards are missing here: /M, /N and /Nc
 */
#define V4L2_STD_PAL		(V4L2_STD_PAL_BG	|\
				 V4L2_STD_PAL_DK	|\
				 V4L2_STD_PAL_H		|\
				 V4L2_STD_PAL_I)
/* Chroma "agnostic" standards */
#define V4L2_STD_B		(V4L2_STD_PAL_B		|\
				 V4L2_STD_PAL_B1	|\
				 V4L2_STD_SECAM_B)
#define V4L2_STD_G		(V4L2_STD_PAL_G		|\
				 V4L2_STD_SECAM_G)
#define V4L2_STD_H		(V4L2_STD_PAL_H		|\
				 V4L2_STD_SECAM_H)
#define V4L2_STD_L		(V4L2_STD_SECAM_L	|\
				 V4L2_STD_SECAM_LC)
#define V4L2_STD_GH		(V4L2_STD_G		|\
				 V4L2_STD_H)
#define V4L2_STD_DK		(V4L2_STD_PAL_DK	|\
				 V4L2_STD_SECAM_DK)
#define V4L2_STD_BG		(V4L2_STD_B		|\
				 V4L2_STD_G)
#define V4L2_STD_MN		(V4L2_STD_PAL_M		|\
				 V4L2_STD_PAL_N		|\
				 V4L2_STD_PAL_Nc	|\
				 V4L2_STD_NTSC)

/* Standards where MTS/BTSC stereo could be found */
#define V4L2_STD_MTS		(V4L2_STD_NTSC_M	|\
				 V4L2_STD_PAL_M		|\
				 V4L2_STD_PAL_N		|\
				 V4L2_STD_PAL_Nc)

/* Standards for Countries with 60Hz Line frequency */
#define V4L2_STD_525_60		(V4L2_STD_PAL_M		|\
				 V4L2_STD_PAL_60	|\
				 V4L2_STD_NTSC		|\
				 V4L2_STD_NTSC_443)
/* Standards for Countries with 50Hz Line frequency */
#define V4L2_STD_625_50		(V4L2_STD_PAL		|\
				 V4L2_STD_PAL_N		|\
				 V4L2_STD_PAL_Nc	|\
				 V4L2_STD_SECAM)

#define V4L2_STD_ATSC           (V4L2_STD_ATSC_8_VSB    |\
				 V4L2_STD_ATSC_16_VSB)
/* Macros with none and all analog standards */
#define V4L2_STD_UNKNOWN        0
#define V4L2_STD_ALL            (V4L2_STD_525_60	|\
				 V4L2_STD_625_50)

struct v4l2_standard {
	u_int32_t		     index;
	v4l2_std_id          id;
	u_int8_t		     name[24];
	struct v4l2_fract    frameperiod; /* Frames, not fields */
	u_int32_t		     framelines;
	u_int32_t		     reserved[4];
};

/*
 *	D V	B T	T I M I N G S
 */

/** struct v4l2_bt_timings - BT.656/BT.1120 timing data
 * @width:	total width of the active video in pixels
 * @height:	total height of the active video in lines
 * @interlaced:	Interlaced or progressive
 * @polarities:	Positive or negative polarities
 * @pixelclock:	Pixel clock in HZ. Ex. 74.25MHz->74250000
 * @hfrontporch:Horizontal front porch in pixels
 * @hsync:	Horizontal Sync length in pixels
 * @hbackporch:	Horizontal back porch in pixels
 * @vfrontporch:Vertical front porch in lines
 * @vsync:	Vertical Sync length in lines
 * @vbackporch:	Vertical back porch in lines
 * @il_vfrontporch:Vertical front porch for the even field
 *		(aka field 2) of interlaced field formats
 * @il_vsync:	Vertical Sync length for the even field
 *		(aka field 2) of interlaced field formats
 * @il_vbackporch:Vertical back porch for the even field
 *		(aka field 2) of interlaced field formats
 * @standards:	Standards the timing belongs to
 * @flags:	Flags
 * @picture_aspect: The picture aspect ratio (hor/vert).
 * @cea861_vic:	VIC code as per the CEA-861 standard.
 * @hdmi_vic:	VIC code as per the HDMI standard.
 * @reserved:	Reserved fields, must be zeroed.
 *
 * A note regarding vertical interlaced timings: height refers to the total
 * height of the active video frame (= two fields). The blanking timings refer
 * to the blanking of each field. So the height of the total frame is
 * calculated as follows:
 *
 * tot_height = height + vfrontporch + vsync + vbackporch +
 *                       il_vfrontporch + il_vsync + il_vbackporch
 *
 * The active height of each field is height / 2.
 */
struct v4l2_bt_timings {
	u_int32_t	width;
	u_int32_t	height;
	u_int32_t	interlaced;
	u_int32_t	polarities;
	u_int64_t	pixelclock;
	u_int32_t	hfrontporch;
	u_int32_t	hsync;
	u_int32_t	hbackporch;
	u_int32_t	vfrontporch;
	u_int32_t	vsync;
	u_int32_t	vbackporch;
	u_int32_t	il_vfrontporch;
	u_int32_t	il_vsync;
	u_int32_t	il_vbackporch;
	u_int32_t	standards;
	u_int32_t	flags;
	struct v4l2_fract picture_aspect;
	u_int8_t	cea861_vic;
	u_int8_t	hdmi_vic;
	u_int8_t	reserved[46];
} __attribute__ ((packed));

/* Interlaced or progressive format */
#define	V4L2_DV_PROGRESSIVE	0
#define	V4L2_DV_INTERLACED	1

/* Polarities. If bit is not set, it is assumed to be negative polarity */
#define V4L2_DV_VSYNC_POS_POL	0x00000001
#define V4L2_DV_HSYNC_POS_POL	0x00000002

/* Timings standards */
#define V4L2_DV_BT_STD_CEA861	(1 << 0)  /* CEA-861 Digital TV Profile */
#define V4L2_DV_BT_STD_DMT	(1 << 1)  /* VESA Discrete Monitor Timings */
#define V4L2_DV_BT_STD_CVT	(1 << 2)  /* VESA Coordinated Video Timings */
#define V4L2_DV_BT_STD_GTF	(1 << 3)  /* VESA Generalized Timings Formula */
#define V4L2_DV_BT_STD_SDI	(1 << 4)  /* SDI Timings */

/* Flags */

/*
 * CVT/GTF specific: timing uses reduced blanking (CVT) or the 'Secondary
 * GTF' curve (GTF). In both cases the horizontal and/or vertical blanking
 * intervals are reduced, allowing a higher resolution over the same
 * bandwidth. This is a read-only flag.
 */
#define V4L2_DV_FL_REDUCED_BLANKING		(1 << 0)
/*
 * CEA-861 specific: set for CEA-861 formats with a framerate of a multiple
 * of six. These formats can be optionally played at 1 / 1.001 speed.
 * This is a read-only flag.
 */
#define V4L2_DV_FL_CAN_REDUCE_FPS		(1 << 1)
/*
 * CEA-861 specific: only valid for video transmitters, the flag is cleared
 * by receivers.
 * If the framerate of the format is a multiple of six, then the pixelclock
 * used to set up the transmitter is divided by 1.001 to make it compatible
 * with 60 Hz based standards such as NTSC and PAL-M that use a framerate of
 * 29.97 Hz. Otherwise this flag is cleared. If the transmitter can't generate
 * such frequencies, then the flag will also be cleared.
 */
#define V4L2_DV_FL_REDUCED_FPS			(1 << 2)
/*
 * Specific to interlaced formats: if set, then field 1 is really one half-line
 * longer and field 2 is really one half-line shorter, so each field has
 * exactly the same number of half-lines. Whether half-lines can be detected
 * or used depends on the hardware.
 */
#define V4L2_DV_FL_HALF_LINE			(1 << 3)
/*
 * If set, then this is a Consumer Electronics (CE) video format. Such formats
 * differ from other formats (commonly called IT formats) in that if RGB
 * encoding is used then by default the RGB values use limited range (i.e.
 * use the range 16-235) as opposed to 0-255. All formats defined in CEA-861
 * except for the 640x480 format are CE formats.
 */
#define V4L2_DV_FL_IS_CE_VIDEO			(1 << 4)
/* Some formats like SMPTE-125M have an interlaced signal with a odd
 * total height. For these formats, if this flag is set, the first
 * field has the extra line. If not, it is the second field.
 */
#define V4L2_DV_FL_FIRST_FIELD_EXTRA_LINE	(1 << 5)
/*
 * If set, then the picture_aspect field is valid. Otherwise assume that the
 * pixels are square, so the picture aspect ratio is the same as the width to
 * height ratio.
 */
#define V4L2_DV_FL_HAS_PICTURE_ASPECT		(1 << 6)
/*
 * If set, then the cea861_vic field is valid and contains the Video
 * Identification Code as per the CEA-861 standard.
 */
#define V4L2_DV_FL_HAS_CEA861_VIC		(1 << 7)
/*
 * If set, then the hdmi_vic field is valid and contains the Video
 * Identification Code as per the HDMI standard (HDMI Vendor Specific
 * InfoFrame).
 */
#define V4L2_DV_FL_HAS_HDMI_VIC			(1 << 8)
/*
 * CEA-861 specific: only valid for video receivers.
 * If set, then HW can detect the difference between regular FPS and
 * 1000/1001 FPS. Note: This flag is only valid for HDMI VIC codes with
 * the V4L2_DV_FL_CAN_REDUCE_FPS flag set.
 */
#define V4L2_DV_FL_CAN_DETECT_REDUCED_FPS	(1 << 9)

/* A few useful defines to calculate the total blanking and frame sizes */
#define V4L2_DV_BT_BLANKING_WIDTH(bt) \
	((bt)->hfrontporch + (bt)->hsync + (bt)->hbackporch)
#define V4L2_DV_BT_FRAME_WIDTH(bt) \
	((bt)->width + V4L2_DV_BT_BLANKING_WIDTH(bt))
#define V4L2_DV_BT_BLANKING_HEIGHT(bt) \
	((bt)->vfrontporch + (bt)->vsync + (bt)->vbackporch + \
	 ((bt)->interlaced ? \
	  ((bt)->il_vfrontporch + (bt)->il_vsync + (bt)->il_vbackporch) : 0))
#define V4L2_DV_BT_FRAME_HEIGHT(bt) \
	((bt)->height + V4L2_DV_BT_BLANKING_HEIGHT(bt))

/** struct v4l2_dv_timings - DV timings
 * @type:	the type of the timings
 * @bt:	BT656/1120 timings
 */
struct v4l2_dv_timings {
	u_int32_t type;
	union {
		struct v4l2_bt_timings	bt;
		u_int32_t	reserved[32];
	};
} __attribute__ ((packed));

/* Values for the type field */
#define V4L2_DV_BT_656_1120	0	/* BT.656/1120 timing type */


/** struct v4l2_enum_dv_timings - DV timings enumeration
 * @index:	enumeration index
 * @pad:	the pad number for which to enumerate timings (used with
 *		v4l-subdev nodes only)
 * @reserved:	must be zeroed
 * @timings:	the timings for the given index
 */
struct v4l2_enum_dv_timings {
	u_int32_t index;
	u_int32_t pad;
	u_int32_t reserved[2];
	struct v4l2_dv_timings timings;
};

/** struct v4l2_bt_timings_cap - BT.656/BT.1120 timing capabilities
 * @min_width:		width in pixels
 * @max_width:		width in pixels
 * @min_height:		height in lines
 * @max_height:		height in lines
 * @min_pixelclock:	Pixel clock in HZ. Ex. 74.25MHz->74250000
 * @max_pixelclock:	Pixel clock in HZ. Ex. 74.25MHz->74250000
 * @standards:		Supported standards
 * @capabilities:	Supported capabilities
 * @reserved:		Must be zeroed
 */
struct v4l2_bt_timings_cap {
	u_int32_t	min_width;
	u_int32_t	max_width;
	u_int32_t	min_height;
	u_int32_t	max_height;
	u_int64_t	min_pixelclock;
	u_int64_t	max_pixelclock;
	u_int32_t	standards;
	u_int32_t	capabilities;
	u_int32_t	reserved[16];
} __attribute__ ((packed));

/* Supports interlaced formats */
#define V4L2_DV_BT_CAP_INTERLACED	(1 << 0)
/* Supports progressive formats */
#define V4L2_DV_BT_CAP_PROGRESSIVE	(1 << 1)
/* Supports CVT/GTF reduced blanking */
#define V4L2_DV_BT_CAP_REDUCED_BLANKING	(1 << 2)
/* Supports custom formats */
#define V4L2_DV_BT_CAP_CUSTOM		(1 << 3)

/** struct v4l2_dv_timings_cap - DV timings capabilities
 * @type:	the type of the timings (same as in struct v4l2_dv_timings)
 * @pad:	the pad number for which to query capabilities (used with
 *		v4l-subdev nodes only)
 * @bt:		the BT656/1120 timings capabilities
 */
struct v4l2_dv_timings_cap {
	u_int32_t type;
	u_int32_t pad;
	u_int32_t reserved[2];
	union {
		struct v4l2_bt_timings_cap bt;
		u_int32_t raw_data[32];
	};
};


/*
 *	V I D E O   I N P U T S
 */
struct v4l2_input {
	u_int32_t	     index;		/*  Which input */
	u_int8_t	     name[32];		/*  Label */
	u_int32_t	     type;		/*  Type of input */
	u_int32_t	     audioset;		/*  Associated audios (bitfield) */
	u_int32_t        tuner;             /*  Tuner index */
	v4l2_std_id  std;
	u_int32_t	     status;
	u_int32_t	     capabilities;
	u_int32_t	     reserved[3];
};

/*  Values for the 'type' field */
#define V4L2_INPUT_TYPE_TUNER		1
#define V4L2_INPUT_TYPE_CAMERA		2
#define V4L2_INPUT_TYPE_TOUCH		3

/* field 'status' - general */
#define V4L2_IN_ST_NO_POWER    0x00000001  /* Attached device is off */
#define V4L2_IN_ST_NO_SIGNAL   0x00000002
#define V4L2_IN_ST_NO_COLOR    0x00000004

/* field 'status' - sensor orientation */
/* If sensor is mounted upside down set both bits */
#define V4L2_IN_ST_HFLIP       0x00000010 /* Frames are flipped horizontally */
#define V4L2_IN_ST_VFLIP       0x00000020 /* Frames are flipped vertically */

/* field 'status' - analog */
#define V4L2_IN_ST_NO_H_LOCK   0x00000100  /* No horizontal sync lock */
#define V4L2_IN_ST_COLOR_KILL  0x00000200  /* Color killer is active */
#define V4L2_IN_ST_NO_V_LOCK   0x00000400  /* No vertical sync lock */
#define V4L2_IN_ST_NO_STD_LOCK 0x00000800  /* No standard format lock */

/* field 'status' - digital */
#define V4L2_IN_ST_NO_SYNC     0x00010000  /* No synchronization lock */
#define V4L2_IN_ST_NO_EQU      0x00020000  /* No equalizer lock */
#define V4L2_IN_ST_NO_CARRIER  0x00040000  /* Carrier recovery failed */

/* field 'status' - VCR and set-top box */
#define V4L2_IN_ST_MACROVISION 0x01000000  /* Macrovision detected */
#define V4L2_IN_ST_NO_ACCESS   0x02000000  /* Conditional access denied */
#define V4L2_IN_ST_VTR         0x04000000  /* VTR time constant */

/* capabilities flags */
#define V4L2_IN_CAP_DV_TIMINGS		0x00000002 /* Supports S_DV_TIMINGS */
#define V4L2_IN_CAP_CUSTOM_TIMINGS	V4L2_IN_CAP_DV_TIMINGS /* For compatibility */
#define V4L2_IN_CAP_STD			0x00000004 /* Supports S_STD */
#define V4L2_IN_CAP_NATIVE_SIZE		0x00000008 /* Supports setting native size */

/*
 *	V I D E O   O U T P U T S
 */
struct v4l2_output {
	u_int32_t	     index;		/*  Which output */
	u_int8_t	     name[32];		/*  Label */
	u_int32_t	     type;		/*  Type of output */
	u_int32_t	     audioset;		/*  Associated audios (bitfield) */
	u_int32_t	     modulator;         /*  Associated modulator */
	v4l2_std_id  std;
	u_int32_t	     capabilities;
	u_int32_t	     reserved[3];
};
/*  Values for the 'type' field */
#define V4L2_OUTPUT_TYPE_MODULATOR		1
#define V4L2_OUTPUT_TYPE_ANALOG			2
#define V4L2_OUTPUT_TYPE_ANALOGVGAOVERLAY	3

/* capabilities flags */
#define V4L2_OUT_CAP_DV_TIMINGS		0x00000002 /* Supports S_DV_TIMINGS */
#define V4L2_OUT_CAP_CUSTOM_TIMINGS	V4L2_OUT_CAP_DV_TIMINGS /* For compatibility */
#define V4L2_OUT_CAP_STD		0x00000004 /* Supports S_STD */
#define V4L2_OUT_CAP_NATIVE_SIZE	0x00000008 /* Supports setting native size */

/*
 *	C O N T R O L S
 */
struct v4l2_control {
	u_int32_t		     id;
	int32_t		     value;
};

struct v4l2_ext_control {
	u_int32_t id;
	u_int32_t size;
	u_int32_t reserved2[1];
	union {
		int32_t value;
		int64_t value64;
		char __user *string;
		u_int8_t __user *p_u8;
		u_int16_t __user *p_u16;
		u_int32_t __user *p_u32;
		int32_t __user *p_s32;
		int64_t __user *p_s64;
		struct v4l2_area __user *p_area;
		struct v4l2_rect __user *p_rect;
		struct v4l2_ctrl_h264_sps __user *p_h264_sps;
		struct v4l2_ctrl_h264_pps __user *p_h264_pps;
		struct v4l2_ctrl_h264_scaling_matrix __user *p_h264_scaling_matrix;
		struct v4l2_ctrl_h264_pred_weights __user *p_h264_pred_weights;
		struct v4l2_ctrl_h264_slice_params __user *p_h264_slice_params;
		struct v4l2_ctrl_h264_decode_params __user *p_h264_decode_params;
		struct v4l2_ctrl_fwht_params __user *p_fwht_params;
		struct v4l2_ctrl_vp8_frame __user *p_vp8_frame;
		struct v4l2_ctrl_mpeg2_sequence __user *p_mpeg2_sequence;
		struct v4l2_ctrl_mpeg2_picture __user *p_mpeg2_picture;
		struct v4l2_ctrl_mpeg2_quantisation __user *p_mpeg2_quantisation;
		struct v4l2_ctrl_vp9_compressed_hdr __user *p_vp9_compressed_hdr_probs;
		struct v4l2_ctrl_vp9_frame __user *p_vp9_frame;
		struct v4l2_ctrl_hevc_sps __user *p_hevc_sps;
		struct v4l2_ctrl_hevc_pps __user *p_hevc_pps;
		struct v4l2_ctrl_hevc_slice_params __user *p_hevc_slice_params;
		struct v4l2_ctrl_hevc_scaling_matrix __user *p_hevc_scaling_matrix;
		struct v4l2_ctrl_hevc_decode_params __user *p_hevc_decode_params;
		struct v4l2_ctrl_av1_sequence __user *p_av1_sequence;
		struct v4l2_ctrl_av1_tile_group_entry __user *p_av1_tile_group_entry;
		struct v4l2_ctrl_av1_frame __user *p_av1_frame;
		struct v4l2_ctrl_av1_film_grain __user *p_av1_film_grain;
		struct v4l2_ctrl_hdr10_cll_info __user *p_hdr10_cll_info;
		struct v4l2_ctrl_hdr10_mastering_display __user *p_hdr10_mastering_display;
		void __user *ptr;
	} __attribute__ ((packed));
} __attribute__ ((packed));

struct v4l2_ext_controls {
	union {
		u_int32_t ctrl_class;
		u_int32_t which;
	};
	u_int32_t count;
	u_int32_t error_idx;
	int32_t request_fd;
	u_int32_t reserved[1];
	struct v4l2_ext_control *controls;
};

#define V4L2_CTRL_ID_MASK	  (0x0fffffff)
#define V4L2_CTRL_ID2CLASS(id)    ((id) & 0x0fff0000UL)
#define V4L2_CTRL_ID2WHICH(id)    ((id) & 0x0fff0000UL)
#define V4L2_CTRL_DRIVER_PRIV(id) (((id) & 0xffff) >= 0x1000)
#define V4L2_CTRL_MAX_DIMS	  (4)
#define V4L2_CTRL_WHICH_CUR_VAL   0
#define V4L2_CTRL_WHICH_DEF_VAL   0x0f000000
#define V4L2_CTRL_WHICH_REQUEST_VAL 0x0f010000
#define V4L2_CTRL_WHICH_MIN_VAL   0x0f020000
#define V4L2_CTRL_WHICH_MAX_VAL   0x0f030000

enum v4l2_ctrl_type {
	V4L2_CTRL_TYPE_INTEGER	     = 1,
	V4L2_CTRL_TYPE_BOOLEAN	     = 2,
	V4L2_CTRL_TYPE_MENU	     = 3,
	V4L2_CTRL_TYPE_BUTTON	     = 4,
	V4L2_CTRL_TYPE_INTEGER64     = 5,
	V4L2_CTRL_TYPE_CTRL_CLASS    = 6,
	V4L2_CTRL_TYPE_STRING        = 7,
	V4L2_CTRL_TYPE_BITMASK       = 8,
	V4L2_CTRL_TYPE_INTEGER_MENU  = 9,

	/* Compound types are >= 0x0100 */
	V4L2_CTRL_COMPOUND_TYPES     = 0x0100,
	V4L2_CTRL_TYPE_U8	     = 0x0100,
	V4L2_CTRL_TYPE_U16	     = 0x0101,
	V4L2_CTRL_TYPE_U32	     = 0x0102,
	V4L2_CTRL_TYPE_AREA          = 0x0106,
	V4L2_CTRL_TYPE_RECT	     = 0x0107,

	V4L2_CTRL_TYPE_HDR10_CLL_INFO		= 0x0110,
	V4L2_CTRL_TYPE_HDR10_MASTERING_DISPLAY	= 0x0111,

	V4L2_CTRL_TYPE_H264_SPS             = 0x0200,
	V4L2_CTRL_TYPE_H264_PPS		    = 0x0201,
	V4L2_CTRL_TYPE_H264_SCALING_MATRIX  = 0x0202,
	V4L2_CTRL_TYPE_H264_SLICE_PARAMS    = 0x0203,
	V4L2_CTRL_TYPE_H264_DECODE_PARAMS   = 0x0204,
	V4L2_CTRL_TYPE_H264_PRED_WEIGHTS    = 0x0205,

	V4L2_CTRL_TYPE_FWHT_PARAMS	    = 0x0220,

	V4L2_CTRL_TYPE_VP8_FRAME            = 0x0240,

	V4L2_CTRL_TYPE_MPEG2_QUANTISATION   = 0x0250,
	V4L2_CTRL_TYPE_MPEG2_SEQUENCE       = 0x0251,
	V4L2_CTRL_TYPE_MPEG2_PICTURE        = 0x0252,

	V4L2_CTRL_TYPE_VP9_COMPRESSED_HDR	= 0x0260,
	V4L2_CTRL_TYPE_VP9_FRAME		= 0x0261,

	V4L2_CTRL_TYPE_HEVC_SPS			= 0x0270,
	V4L2_CTRL_TYPE_HEVC_PPS			= 0x0271,
	V4L2_CTRL_TYPE_HEVC_SLICE_PARAMS	= 0x0272,
	V4L2_CTRL_TYPE_HEVC_SCALING_MATRIX	= 0x0273,
	V4L2_CTRL_TYPE_HEVC_DECODE_PARAMS	= 0x0274,

	V4L2_CTRL_TYPE_AV1_SEQUENCE	    = 0x280,
	V4L2_CTRL_TYPE_AV1_TILE_GROUP_ENTRY = 0x281,
	V4L2_CTRL_TYPE_AV1_FRAME	    = 0x282,
	V4L2_CTRL_TYPE_AV1_FILM_GRAIN	    = 0x283,
};

/*  Used in the VIDIOC_QUERYCTRL ioctl for querying controls */
struct v4l2_queryctrl {
	u_int32_t		     id;
	u_int32_t		     type;	/* enum v4l2_ctrl_type */
	u_int8_t		     name[32];	/* Whatever */
	int32_t		     minimum;	/* Note signedness */
	int32_t		     maximum;
	int32_t		     step;
	int32_t		     default_value;
	u_int32_t                flags;
	u_int32_t		     reserved[2];
};

/*  Used in the VIDIOC_QUERY_EXT_CTRL ioctl for querying extended controls */
struct v4l2_query_ext_ctrl {
	u_int32_t		     id;
	u_int32_t		     type;
	char		     name[32];
	int64_t		     minimum;
	int64_t		     maximum;
	u_int64_t		     step;
	int64_t		     default_value;
	u_int32_t                flags;
	u_int32_t                elem_size;
	u_int32_t                elems;
	u_int32_t                nr_of_dims;
	u_int32_t                dims[V4L2_CTRL_MAX_DIMS];
	u_int32_t		     reserved[32];
};

/*  Used in the VIDIOC_QUERYMENU ioctl for querying menu items */
struct v4l2_querymenu {
	u_int32_t		id;
	u_int32_t		index;
	union {
		u_int8_t	name[32];	/* Whatever */
		int64_t	value;
	};
	u_int32_t		reserved;
} __attribute__ ((packed));

/*  Control flags  */
#define V4L2_CTRL_FLAG_DISABLED		0x0001
#define V4L2_CTRL_FLAG_GRABBED		0x0002
#define V4L2_CTRL_FLAG_READ_ONLY	0x0004
#define V4L2_CTRL_FLAG_UPDATE		0x0008
#define V4L2_CTRL_FLAG_INACTIVE		0x0010
#define V4L2_CTRL_FLAG_SLIDER		0x0020
#define V4L2_CTRL_FLAG_WRITE_ONLY	0x0040
#define V4L2_CTRL_FLAG_VOLATILE		0x0080
#define V4L2_CTRL_FLAG_HAS_PAYLOAD	0x0100
#define V4L2_CTRL_FLAG_EXECUTE_ON_WRITE	0x0200
#define V4L2_CTRL_FLAG_MODIFY_LAYOUT	0x0400
#define V4L2_CTRL_FLAG_DYNAMIC_ARRAY	0x0800
#define V4L2_CTRL_FLAG_HAS_WHICH_MIN_MAX 0x1000

/*  Query flags, to be ORed with the control ID */
#define V4L2_CTRL_FLAG_NEXT_CTRL	0x80000000
#define V4L2_CTRL_FLAG_NEXT_COMPOUND	0x40000000

/*  User-class control IDs defined by V4L2 */
#define V4L2_CID_MAX_CTRLS		1024
/*  IDs reserved for driver specific controls */
#define V4L2_CID_PRIVATE_BASE		0x08000000


/*
 *	T U N I N G
 */
struct v4l2_tuner {
	u_int32_t                   index;
	u_int8_t			name[32];
	u_int32_t			type;	/* enum v4l2_tuner_type */
	u_int32_t			capability;
	u_int32_t			rangelow;
	u_int32_t			rangehigh;
	u_int32_t			rxsubchans;
	u_int32_t			audmode;
	int32_t			signal;
	int32_t			afc;
	u_int32_t			reserved[4];
};

struct v4l2_modulator {
	u_int32_t			index;
	u_int8_t			name[32];
	u_int32_t			capability;
	u_int32_t			rangelow;
	u_int32_t			rangehigh;
	u_int32_t			txsubchans;
	u_int32_t			type;	/* enum v4l2_tuner_type */
	u_int32_t			reserved[3];
};

/*  Flags for the 'capability' field */
#define V4L2_TUNER_CAP_LOW		0x0001
#define V4L2_TUNER_CAP_NORM		0x0002
#define V4L2_TUNER_CAP_HWSEEK_BOUNDED	0x0004
#define V4L2_TUNER_CAP_HWSEEK_WRAP	0x0008
#define V4L2_TUNER_CAP_STEREO		0x0010
#define V4L2_TUNER_CAP_LANG2		0x0020
#define V4L2_TUNER_CAP_SAP		0x0020
#define V4L2_TUNER_CAP_LANG1		0x0040
#define V4L2_TUNER_CAP_RDS		0x0080
#define V4L2_TUNER_CAP_RDS_BLOCK_IO	0x0100
#define V4L2_TUNER_CAP_RDS_CONTROLS	0x0200
#define V4L2_TUNER_CAP_FREQ_BANDS	0x0400
#define V4L2_TUNER_CAP_HWSEEK_PROG_LIM	0x0800
#define V4L2_TUNER_CAP_1HZ		0x1000

/*  Flags for the 'rxsubchans' field */
#define V4L2_TUNER_SUB_MONO		0x0001
#define V4L2_TUNER_SUB_STEREO		0x0002
#define V4L2_TUNER_SUB_LANG2		0x0004
#define V4L2_TUNER_SUB_SAP		0x0004
#define V4L2_TUNER_SUB_LANG1		0x0008
#define V4L2_TUNER_SUB_RDS		0x0010

/*  Values for the 'audmode' field */
#define V4L2_TUNER_MODE_MONO		0x0000
#define V4L2_TUNER_MODE_STEREO		0x0001
#define V4L2_TUNER_MODE_LANG2		0x0002
#define V4L2_TUNER_MODE_SAP		0x0002
#define V4L2_TUNER_MODE_LANG1		0x0003
#define V4L2_TUNER_MODE_LANG1_LANG2	0x0004

struct v4l2_frequency {
	u_int32_t	tuner;
	u_int32_t	type;	/* enum v4l2_tuner_type */
	u_int32_t	frequency;
	u_int32_t	reserved[8];
};

#define V4L2_BAND_MODULATION_VSB	(1 << 1)
#define V4L2_BAND_MODULATION_FM		(1 << 2)
#define V4L2_BAND_MODULATION_AM		(1 << 3)

struct v4l2_frequency_band {
	u_int32_t	tuner;
	u_int32_t	type;	/* enum v4l2_tuner_type */
	u_int32_t	index;
	u_int32_t	capability;
	u_int32_t	rangelow;
	u_int32_t	rangehigh;
	u_int32_t	modulation;
	u_int32_t	reserved[9];
};

struct v4l2_hw_freq_seek {
	u_int32_t	tuner;
	u_int32_t	type;	/* enum v4l2_tuner_type */
	u_int32_t	seek_upward;
	u_int32_t	wrap_around;
	u_int32_t	spacing;
	u_int32_t	rangelow;
	u_int32_t	rangehigh;
	u_int32_t	reserved[5];
};

/*
 *	R D S
 */

struct v4l2_rds_data {
	u_int8_t	lsb;
	u_int8_t	msb;
	u_int8_t	block;
} __attribute__ ((packed));

#define V4L2_RDS_BLOCK_MSK	 0x7
#define V4L2_RDS_BLOCK_A	 0
#define V4L2_RDS_BLOCK_B	 1
#define V4L2_RDS_BLOCK_C	 2
#define V4L2_RDS_BLOCK_D	 3
#define V4L2_RDS_BLOCK_C_ALT	 4
#define V4L2_RDS_BLOCK_INVALID	 7

#define V4L2_RDS_BLOCK_CORRECTED 0x40
#define V4L2_RDS_BLOCK_ERROR	 0x80

/*
 *	A U D I O
 */
struct v4l2_audio {
	u_int32_t	index;
	u_int8_t	name[32];
	u_int32_t	capability;
	u_int32_t	mode;
	u_int32_t	reserved[2];
};

/*  Flags for the 'capability' field */
#define V4L2_AUDCAP_STEREO		0x00001
#define V4L2_AUDCAP_AVL			0x00002

/*  Flags for the 'mode' field */
#define V4L2_AUDMODE_AVL		0x00001

struct v4l2_audioout {
	u_int32_t	index;
	u_int8_t	name[32];
	u_int32_t	capability;
	u_int32_t	mode;
	u_int32_t	reserved[2];
};

/*
 *	M P E G   S E R V I C E S
 */
#if 1
#define V4L2_ENC_IDX_FRAME_I    (0)
#define V4L2_ENC_IDX_FRAME_P    (1)
#define V4L2_ENC_IDX_FRAME_B    (2)
#define V4L2_ENC_IDX_FRAME_MASK (0xf)

struct v4l2_enc_idx_entry {
	u_int64_t offset;
	u_int64_t pts;
	u_int32_t length;
	u_int32_t flags;
	u_int32_t reserved[2];
};

#define V4L2_ENC_IDX_ENTRIES (64)
struct v4l2_enc_idx {
	u_int32_t entries;
	u_int32_t entries_cap;
	u_int32_t reserved[4];
	struct v4l2_enc_idx_entry entry[V4L2_ENC_IDX_ENTRIES];
};


#define V4L2_ENC_CMD_START      (0)
#define V4L2_ENC_CMD_STOP       (1)
#define V4L2_ENC_CMD_PAUSE      (2)
#define V4L2_ENC_CMD_RESUME     (3)

/* Flags for V4L2_ENC_CMD_STOP */
#define V4L2_ENC_CMD_STOP_AT_GOP_END    (1 << 0)

struct v4l2_encoder_cmd {
	u_int32_t cmd;
	u_int32_t flags;
	union {
		struct {
			u_int32_t data[8];
		} raw;
	};
};

/* Decoder commands */
#define V4L2_DEC_CMD_START       (0)
#define V4L2_DEC_CMD_STOP        (1)
#define V4L2_DEC_CMD_PAUSE       (2)
#define V4L2_DEC_CMD_RESUME      (3)
#define V4L2_DEC_CMD_FLUSH       (4)

/* Flags for V4L2_DEC_CMD_START */
#define V4L2_DEC_CMD_START_MUTE_AUDIO	(1 << 0)

/* Flags for V4L2_DEC_CMD_PAUSE */
#define V4L2_DEC_CMD_PAUSE_TO_BLACK	(1 << 0)

/* Flags for V4L2_DEC_CMD_STOP */
#define V4L2_DEC_CMD_STOP_TO_BLACK	(1 << 0)
#define V4L2_DEC_CMD_STOP_IMMEDIATELY	(1 << 1)

/* Play format requirements (returned by the driver): */

/* The decoder has no special format requirements */
#define V4L2_DEC_START_FMT_NONE		(0)
/* The decoder requires full GOPs */
#define V4L2_DEC_START_FMT_GOP		(1)

/* The structure must be zeroed before use by the application
   This ensures it can be extended safely in the future. */
struct v4l2_decoder_cmd {
	u_int32_t cmd;
	u_int32_t flags;
	union {
		struct {
			u_int64_t pts;
		} stop;

		struct {
			/* 0 or 1000 specifies normal speed,
			   1 specifies forward single stepping,
			   -1 specifies backward single stepping,
			   >1: playback at speed/1000 of the normal speed,
			   <-1: reverse playback at (-speed/1000) of the normal speed. */
			int32_t speed;
			u_int32_t format;
		} start;

		struct {
			u_int32_t data[16];
		} raw;
	};
};
#endif


/*
 *	D A T A   S E R V I C E S   ( V B I )
 *
 *	Data services API by Michael Schimek
 */

/* Raw VBI */
struct v4l2_vbi_format {
	u_int32_t	sampling_rate;		/* in 1 Hz */
	u_int32_t	offset;
	u_int32_t	samples_per_line;
	u_int32_t	sample_format;		/* V4L2_PIX_FMT_* */
	int32_t	start[2];
	u_int32_t	count[2];
	u_int32_t	flags;			/* V4L2_VBI_* */
	u_int32_t	reserved[2];		/* must be zero */
};

/*  VBI flags  */
#define V4L2_VBI_UNSYNC		(1 << 0)
#define V4L2_VBI_INTERLACED	(1 << 1)

/* ITU-R start lines for each field */
#define V4L2_VBI_ITU_525_F1_START (1)
#define V4L2_VBI_ITU_525_F2_START (264)
#define V4L2_VBI_ITU_625_F1_START (1)
#define V4L2_VBI_ITU_625_F2_START (314)

/* Sliced VBI
 *
 *    This implements is a proposal V4L2 API to allow SLICED VBI
 * required for some hardware encoders. It should change without
 * notice in the definitive implementation.
 */

struct v4l2_sliced_vbi_format {
	u_int16_t   service_set;
	/* service_lines[0][...] specifies lines 0-23 (1-23 used) of the first field
	   service_lines[1][...] specifies lines 0-23 (1-23 used) of the second field
				 (equals frame lines 313-336 for 625 line video
				  standards, 263-286 for 525 line standards) */
	u_int16_t   service_lines[2][24];
	u_int32_t   io_size;
	u_int32_t   reserved[2];            /* must be zero */
};

/* Teletext World System Teletext
   (WST), defined on ITU-R BT.653-2 */
#define V4L2_SLICED_TELETEXT_B          (0x0001)
/* Video Program System, defined on ETS 300 231*/
#define V4L2_SLICED_VPS                 (0x0400)
/* Closed Caption, defined on EIA-608 */
#define V4L2_SLICED_CAPTION_525         (0x1000)
/* Wide Screen System, defined on ITU-R BT1119.1 */
#define V4L2_SLICED_WSS_625             (0x4000)

#define V4L2_SLICED_VBI_525             (V4L2_SLICED_CAPTION_525)
#define V4L2_SLICED_VBI_625             (V4L2_SLICED_TELETEXT_B | V4L2_SLICED_VPS | V4L2_SLICED_WSS_625)

struct v4l2_sliced_vbi_cap {
	u_int16_t   service_set;
	/* service_lines[0][...] specifies lines 0-23 (1-23 used) of the first field
	   service_lines[1][...] specifies lines 0-23 (1-23 used) of the second field
				 (equals frame lines 313-336 for 625 line video
				  standards, 263-286 for 525 line standards) */
	u_int16_t   service_lines[2][24];
	u_int32_t	type;		/* enum v4l2_buf_type */
	u_int32_t   reserved[3];    /* must be 0 */
};

struct v4l2_sliced_vbi_data {
	u_int32_t   id;
	u_int32_t   field;          /* 0: first field, 1: second field */
	u_int32_t   line;           /* 1-23 */
	u_int32_t   reserved;       /* must be 0 */
	u_int8_t    data[48];
};

/*
 * Sliced VBI data inserted into MPEG Streams
 */

/*
 * V4L2_MPEG_STREAM_VBI_FMT_IVTV:
 *
 * Structure of payload contained in an MPEG 2 Private Stream 1 PES Packet in an
 * MPEG-2 Program Pack that contains V4L2_MPEG_STREAM_VBI_FMT_IVTV Sliced VBI
 * data
 *
 * Note, the MPEG-2 Program Pack and Private Stream 1 PES packet header
 * definitions are not included here.  See the MPEG-2 specifications for details
 * on these headers.
 */

/* Line type IDs */
#define V4L2_MPEG_VBI_IVTV_TELETEXT_B     (1)
#define V4L2_MPEG_VBI_IVTV_CAPTION_525    (4)
#define V4L2_MPEG_VBI_IVTV_WSS_625        (5)
#define V4L2_MPEG_VBI_IVTV_VPS            (7)

struct v4l2_mpeg_vbi_itv0_line {
	u_int8_t id;	/* One of V4L2_MPEG_VBI_IVTV_* above */
	u_int8_t data[42];	/* Sliced VBI data for the line */
} __attribute__ ((packed));

struct v4l2_mpeg_vbi_itv0 {
	u_int32_t linemask[2]; /* Bitmasks of VBI service lines present */
	struct v4l2_mpeg_vbi_itv0_line line[35];
} __attribute__ ((packed));

struct v4l2_mpeg_vbi_ITV0 {
	struct v4l2_mpeg_vbi_itv0_line line[36];
} __attribute__ ((packed));

#define V4L2_MPEG_VBI_IVTV_MAGIC0	"itv0"
#define V4L2_MPEG_VBI_IVTV_MAGIC1	"ITV0"

struct v4l2_mpeg_vbi_fmt_ivtv {
	u_int8_t magic[4];
	union {
		struct v4l2_mpeg_vbi_itv0 itv0;
		struct v4l2_mpeg_vbi_ITV0 ITV0;
	};
} __attribute__ ((packed));

/*
 *	A G G R E G A T E   S T R U C T U R E S
 */

/**
 * struct v4l2_plane_pix_format - additional, per-plane format definition
 * @sizeimage:		maximum size in bytes required for data, for which
 *			this plane will be used
 * @bytesperline:	distance in bytes between the leftmost pixels in two
 *			adjacent lines
 * @reserved:		drivers and applications must zero this array
 */
struct v4l2_plane_pix_format {
	u_int32_t		sizeimage;
	u_int32_t		bytesperline;
	u_int16_t		reserved[6];
} __attribute__ ((packed));

/**
 * struct v4l2_pix_format_mplane - multiplanar format definition
 * @width:		image width in pixels
 * @height:		image height in pixels
 * @pixelformat:	little endian four character code (fourcc)
 * @field:		enum v4l2_field; field order (for interlaced video)
 * @colorspace:		enum v4l2_colorspace; supplemental to pixelformat
 * @plane_fmt:		per-plane information
 * @num_planes:		number of planes for this format
 * @flags:		format flags (V4L2_PIX_FMT_FLAG_*)
 * @ycbcr_enc:		enum v4l2_ycbcr_encoding, Y'CbCr encoding
 * @hsv_enc:		enum v4l2_hsv_encoding, HSV encoding
 * @quantization:	enum v4l2_quantization, colorspace quantization
 * @xfer_func:		enum v4l2_xfer_func, colorspace transfer function
 * @reserved:		drivers and applications must zero this array
 */
struct v4l2_pix_format_mplane {
	u_int32_t				width;
	u_int32_t				height;
	u_int32_t				pixelformat;
	u_int32_t				field;
	u_int32_t				colorspace;

	struct v4l2_plane_pix_format	plane_fmt[VIDEO_MAX_PLANES];
	u_int8_t				num_planes;
	u_int8_t				flags;
	 union {
		u_int8_t				ycbcr_enc;
		u_int8_t				hsv_enc;
	};
	u_int8_t				quantization;
	u_int8_t				xfer_func;
	u_int8_t				reserved[7];
} __attribute__ ((packed));

/**
 * struct v4l2_sdr_format - SDR format definition
 * @pixelformat:	little endian four character code (fourcc)
 * @buffersize:		maximum size in bytes required for data
 * @reserved:		drivers and applications must zero this array
 */
struct v4l2_sdr_format {
	u_int32_t				pixelformat;
	u_int32_t				buffersize;
	u_int8_t				reserved[24];
} __attribute__ ((packed));

/**
 * struct v4l2_meta_format - metadata format definition
 * @dataformat:		little endian four character code (fourcc)
 * @buffersize:		maximum size in bytes required for data
 * @width:		number of data units of data per line (valid for line
 *			based formats only, see format documentation)
 * @height:		number of lines of data per buffer (valid for line based
 *			formats only)
 * @bytesperline:	offset between the beginnings of two adjacent lines in
 *			bytes (valid for line based formats only)
 */
struct v4l2_meta_format {
	u_int32_t				dataformat;
	u_int32_t				buffersize;
	u_int32_t				width;
	u_int32_t				height;
	u_int32_t				bytesperline;
} __attribute__ ((packed));

/**
 * struct v4l2_format - stream data format
 * @type:		enum v4l2_buf_type; type of the data stream
 * @fmt.pix:		definition of an image format
 * @fmt.pix_mp:		definition of a multiplanar image format
 * @fmt.win:		definition of an overlaid image
 * @fmt.vbi:		raw VBI capture or output parameters
 * @fmt.sliced:		sliced VBI capture or output parameters
 * @fmt.raw_data:	placeholder for future extensions and custom formats
 * @fmt:		union of @pix, @pix_mp, @win, @vbi, @sliced, @sdr,
 *			@meta and @raw_data
 */
struct v4l2_format {
	u_int32_t	 type;
	union {
		struct v4l2_pix_format		pix;     /* V4L2_BUF_TYPE_VIDEO_CAPTURE */
		struct v4l2_pix_format_mplane	pix_mp;  /* V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE */
		struct v4l2_window		win;     /* V4L2_BUF_TYPE_VIDEO_OVERLAY */
		struct v4l2_vbi_format		vbi;     /* V4L2_BUF_TYPE_VBI_CAPTURE */
		struct v4l2_sliced_vbi_format	sliced;  /* V4L2_BUF_TYPE_SLICED_VBI_CAPTURE */
		struct v4l2_sdr_format		sdr;     /* V4L2_BUF_TYPE_SDR_CAPTURE */
		struct v4l2_meta_format		meta;    /* V4L2_BUF_TYPE_META_CAPTURE */
		u_int8_t	raw_data[200];                   /* user-defined */
	} fmt;
};

/*	Stream type-dependent parameters
 */
struct v4l2_streamparm {
	u_int32_t	 type;			/* enum v4l2_buf_type */
	union {
		struct v4l2_captureparm	capture;
		struct v4l2_outputparm	output;
		u_int8_t	raw_data[200];  /* user-defined */
	} parm;
};

/*
 *	E V E N T S
 */

#define V4L2_EVENT_ALL				0
#define V4L2_EVENT_VSYNC			1
#define V4L2_EVENT_EOS				2
#define V4L2_EVENT_CTRL				3
#define V4L2_EVENT_FRAME_SYNC			4
#define V4L2_EVENT_SOURCE_CHANGE		5
#define V4L2_EVENT_MOTION_DET			6
#define V4L2_EVENT_PRIVATE_START		0x08000000

/* Payload for V4L2_EVENT_VSYNC */
struct v4l2_event_vsync {
	/* Can be V4L2_FIELD_ANY, _NONE, _TOP or _BOTTOM */
	u_int8_t field;
} __attribute__ ((packed));

/* Payload for V4L2_EVENT_CTRL */
#define V4L2_EVENT_CTRL_CH_VALUE		(1 << 0)
#define V4L2_EVENT_CTRL_CH_FLAGS		(1 << 1)
#define V4L2_EVENT_CTRL_CH_RANGE		(1 << 2)
#define V4L2_EVENT_CTRL_CH_DIMENSIONS		(1 << 3)

struct v4l2_event_ctrl {
	u_int32_t changes;
	u_int32_t type;
	union {
		int32_t value;
		int64_t value64;
	};
	u_int32_t flags;
	int32_t minimum;
	int32_t maximum;
	int32_t step;
	int32_t default_value;
};

struct v4l2_event_frame_sync {
	u_int32_t frame_sequence;
};

#define V4L2_EVENT_SRC_CH_RESOLUTION		(1 << 0)

struct v4l2_event_src_change {
	u_int32_t changes;
};

#define V4L2_EVENT_MD_FL_HAVE_FRAME_SEQ	(1 << 0)

/**
 * struct v4l2_event_motion_det - motion detection event
 * @flags:             if V4L2_EVENT_MD_FL_HAVE_FRAME_SEQ is set, then the
 *                     frame_sequence field is valid.
 * @frame_sequence:    the frame sequence number associated with this event.
 * @region_mask:       which regions detected motion.
 */
struct v4l2_event_motion_det {
	u_int32_t flags;
	u_int32_t frame_sequence;
	u_int32_t region_mask;
};

struct v4l2_event {
	u_int32_t				type;
	union {
		struct v4l2_event_vsync		vsync;
		struct v4l2_event_ctrl		ctrl;
		struct v4l2_event_frame_sync	frame_sync;
		struct v4l2_event_src_change	src_change;
		struct v4l2_event_motion_det	motion_det;
		u_int8_t			data[64];
	} u;
	u_int32_t				pending;
	u_int32_t				sequence;
	struct timespec				timestamp;
	u_int32_t				id;
	u_int32_t				reserved[8];
};

#define V4L2_EVENT_SUB_FL_SEND_INITIAL		(1 << 0)
#define V4L2_EVENT_SUB_FL_ALLOW_FEEDBACK	(1 << 1)

struct v4l2_event_subscription {
	u_int32_t				type;
	u_int32_t				id;
	u_int32_t				flags;
	u_int32_t				reserved[5];
};

/*
 *	A D V A N C E D   D E B U G G I N G
 *
 *	NOTE: EXPERIMENTAL API, NEVER RELY ON THIS IN APPLICATIONS!
 *	FOR DEBUGGING, TESTING AND INTERNAL USE ONLY!
 */

/* VIDIOC_DBG_G_REGISTER and VIDIOC_DBG_S_REGISTER */

#define V4L2_CHIP_MATCH_BRIDGE      0  /* Match against chip ID on the bridge (0 for the bridge) */
#define V4L2_CHIP_MATCH_SUBDEV      4  /* Match against subdev index */

/* The following four defines are no longer in use */
#define V4L2_CHIP_MATCH_HOST V4L2_CHIP_MATCH_BRIDGE
#define V4L2_CHIP_MATCH_I2C_DRIVER  1  /* Match against I2C driver name */
#define V4L2_CHIP_MATCH_I2C_ADDR    2  /* Match against I2C 7-bit address */
#define V4L2_CHIP_MATCH_AC97        3  /* Match against ancillary AC97 chip */

struct v4l2_dbg_match {
	u_int32_t type; /* Match type */
	union {     /* Match this chip, meaning determined by type */
		u_int32_t addr;
		char name[32];
	};
} __attribute__ ((packed));

struct v4l2_dbg_register {
	struct v4l2_dbg_match match;
	u_int32_t size;	/* register size in bytes */
	u_int64_t reg;
	u_int64_t val;
} __attribute__ ((packed));

#define V4L2_CHIP_FL_READABLE (1 << 0)
#define V4L2_CHIP_FL_WRITABLE (1 << 1)

/* VIDIOC_DBG_G_CHIP_INFO */
struct v4l2_dbg_chip_info {
	struct v4l2_dbg_match match;
	char name[32];
	u_int32_t flags;
	u_int32_t reserved[32];
} __attribute__ ((packed));

/**
 * struct v4l2_create_buffers - VIDIOC_CREATE_BUFS argument
 * @index:	on return, index of the first created buffer
 * @count:	entry: number of requested buffers,
 *		return: number of created buffers
 * @memory:	enum v4l2_memory; buffer memory type
 * @format:	frame format, for which buffers are requested
 * @capabilities: capabilities of this buffer type.
 * @flags:	additional buffer management attributes (ignored unless the
 *		queue has V4L2_BUF_CAP_SUPPORTS_MMAP_CACHE_HINTS capability
 *		and configured for MMAP streaming I/O).
 * @max_num_buffers: if V4L2_BUF_CAP_SUPPORTS_MAX_NUM_BUFFERS capability flag is set
 *		this field indicate the maximum possible number of buffers
 *		for this queue.
 * @reserved:	future extensions
 */
struct v4l2_create_buffers {
	u_int32_t			index;
	u_int32_t			count;
	u_int32_t			memory;
	struct v4l2_format		format;
	u_int32_t			capabilities;
	u_int32_t			flags;
	u_int32_t			max_num_buffers;
	u_int32_t			reserved[5];
};

/**
 * struct v4l2_remove_buffers - VIDIOC_REMOVE_BUFS argument
 * @index:	the first buffer to be removed
 * @count:	number of buffers to removed
 * @type:	enum v4l2_buf_type
 * @reserved:	future extensions
 */
struct v4l2_remove_buffers {
	u_int32_t			index;
	u_int32_t			count;
	u_int32_t			type;
	u_int32_t			reserved[13];
};

/*
 *	I O C T L   C O D E S   F O R   V I D E O   D E V I C E S
 *
 */
#define VIDIOC_QUERYCAP		 _IOR('V',  0, struct v4l2_capability)
#define VIDIOC_ENUM_FMT         _IOWR('V',  2, struct v4l2_fmtdesc)
#define VIDIOC_G_FMT		_IOWR('V',  4, struct v4l2_format)
#define VIDIOC_S_FMT		_IOWR('V',  5, struct v4l2_format)
#define VIDIOC_REQBUFS		_IOWR('V',  8, struct v4l2_requestbuffers)
#define VIDIOC_QUERYBUF		_IOWR('V',  9, struct v4l2_buffer)
#define VIDIOC_G_FBUF		 _IOR('V', 10, struct v4l2_framebuffer)
#define VIDIOC_S_FBUF		 _IOW('V', 11, struct v4l2_framebuffer)
#define VIDIOC_OVERLAY		 _IOW('V', 14, int)
#define VIDIOC_QBUF		_IOWR('V', 15, struct v4l2_buffer)
#define VIDIOC_EXPBUF		_IOWR('V', 16, struct v4l2_exportbuffer)
#define VIDIOC_DQBUF		_IOWR('V', 17, struct v4l2_buffer)
#define VIDIOC_STREAMON		 _IOW('V', 18, int)
#define VIDIOC_STREAMOFF	 _IOW('V', 19, int)
#define VIDIOC_G_PARM		_IOWR('V', 21, struct v4l2_streamparm)
#define VIDIOC_S_PARM		_IOWR('V', 22, struct v4l2_streamparm)
#define VIDIOC_G_STD		 _IOR('V', 23, v4l2_std_id)
#define VIDIOC_S_STD		 _IOW('V', 24, v4l2_std_id)
#define VIDIOC_ENUMSTD		_IOWR('V', 25, struct v4l2_standard)
#define VIDIOC_ENUMINPUT	_IOWR('V', 26, struct v4l2_input)
#define VIDIOC_G_CTRL		_IOWR('V', 27, struct v4l2_control)
#define VIDIOC_S_CTRL		_IOWR('V', 28, struct v4l2_control)
#define VIDIOC_G_TUNER		_IOWR('V', 29, struct v4l2_tuner)
#define VIDIOC_S_TUNER		 _IOW('V', 30, struct v4l2_tuner)
#define VIDIOC_G_AUDIO		 _IOR('V', 33, struct v4l2_audio)
#define VIDIOC_S_AUDIO		 _IOW('V', 34, struct v4l2_audio)
#define VIDIOC_QUERYCTRL	_IOWR('V', 36, struct v4l2_queryctrl)
#define VIDIOC_QUERYMENU	_IOWR('V', 37, struct v4l2_querymenu)
#define VIDIOC_G_INPUT		 _IOR('V', 38, int)
#define VIDIOC_S_INPUT		_IOWR('V', 39, int)
#define VIDIOC_G_EDID		_IOWR('V', 40, struct v4l2_edid)
#define VIDIOC_S_EDID		_IOWR('V', 41, struct v4l2_edid)
#define VIDIOC_G_OUTPUT		 _IOR('V', 46, int)
#define VIDIOC_S_OUTPUT		_IOWR('V', 47, int)
#define VIDIOC_ENUMOUTPUT	_IOWR('V', 48, struct v4l2_output)
#define VIDIOC_G_AUDOUT		 _IOR('V', 49, struct v4l2_audioout)
#define VIDIOC_S_AUDOUT		 _IOW('V', 50, struct v4l2_audioout)
#define VIDIOC_G_MODULATOR	_IOWR('V', 54, struct v4l2_modulator)
#define VIDIOC_S_MODULATOR	 _IOW('V', 55, struct v4l2_modulator)
#define VIDIOC_G_FREQUENCY	_IOWR('V', 56, struct v4l2_frequency)
#define VIDIOC_S_FREQUENCY	 _IOW('V', 57, struct v4l2_frequency)
#define VIDIOC_CROPCAP		_IOWR('V', 58, struct v4l2_cropcap)
#define VIDIOC_G_CROP		_IOWR('V', 59, struct v4l2_crop)
#define VIDIOC_S_CROP		 _IOW('V', 60, struct v4l2_crop)
#define VIDIOC_G_JPEGCOMP	 _IOR('V', 61, struct v4l2_jpegcompression)
#define VIDIOC_S_JPEGCOMP	 _IOW('V', 62, struct v4l2_jpegcompression)
#define VIDIOC_QUERYSTD		 _IOR('V', 63, v4l2_std_id)
#define VIDIOC_TRY_FMT		_IOWR('V', 64, struct v4l2_format)
#define VIDIOC_ENUMAUDIO	_IOWR('V', 65, struct v4l2_audio)
#define VIDIOC_ENUMAUDOUT	_IOWR('V', 66, struct v4l2_audioout)
#define VIDIOC_G_PRIORITY	 _IOR('V', 67, u_int32_t) /* enum v4l2_priority */
#define VIDIOC_S_PRIORITY	 _IOW('V', 68, u_int32_t) /* enum v4l2_priority */
#define VIDIOC_G_SLICED_VBI_CAP _IOWR('V', 69, struct v4l2_sliced_vbi_cap)
#define VIDIOC_LOG_STATUS         _IO('V', 70)
#define VIDIOC_G_EXT_CTRLS	_IOWR('V', 71, struct v4l2_ext_controls)
#define VIDIOC_S_EXT_CTRLS	_IOWR('V', 72, struct v4l2_ext_controls)
#define VIDIOC_TRY_EXT_CTRLS	_IOWR('V', 73, struct v4l2_ext_controls)
#define VIDIOC_ENUM_FRAMESIZES	_IOWR('V', 74, struct v4l2_frmsizeenum)
#define VIDIOC_ENUM_FRAMEINTERVALS _IOWR('V', 75, struct v4l2_frmivalenum)
#define VIDIOC_G_ENC_INDEX       _IOR('V', 76, struct v4l2_enc_idx)
#define VIDIOC_ENCODER_CMD      _IOWR('V', 77, struct v4l2_encoder_cmd)
#define VIDIOC_TRY_ENCODER_CMD  _IOWR('V', 78, struct v4l2_encoder_cmd)

/*
 * Experimental, meant for debugging, testing and internal use.
 * Only implemented if CONFIG_VIDEO_ADV_DEBUG is defined.
 * You must be root to use these ioctls. Never use these in applications!
 */
#define	VIDIOC_DBG_S_REGISTER	 _IOW('V', 79, struct v4l2_dbg_register)
#define	VIDIOC_DBG_G_REGISTER	_IOWR('V', 80, struct v4l2_dbg_register)

#define VIDIOC_S_HW_FREQ_SEEK	 _IOW('V', 82, struct v4l2_hw_freq_seek)
#define	VIDIOC_S_DV_TIMINGS	_IOWR('V', 87, struct v4l2_dv_timings)
#define	VIDIOC_G_DV_TIMINGS	_IOWR('V', 88, struct v4l2_dv_timings)
#define	VIDIOC_DQEVENT		 _IOR('V', 89, struct v4l2_event)
#define	VIDIOC_SUBSCRIBE_EVENT	 _IOW('V', 90, struct v4l2_event_subscription)
#define	VIDIOC_UNSUBSCRIBE_EVENT _IOW('V', 91, struct v4l2_event_subscription)
#define VIDIOC_CREATE_BUFS	_IOWR('V', 92, struct v4l2_create_buffers)
#define VIDIOC_PREPARE_BUF	_IOWR('V', 93, struct v4l2_buffer)
#define VIDIOC_G_SELECTION	_IOWR('V', 94, struct v4l2_selection)
#define VIDIOC_S_SELECTION	_IOWR('V', 95, struct v4l2_selection)
#define VIDIOC_DECODER_CMD	_IOWR('V', 96, struct v4l2_decoder_cmd)
#define VIDIOC_TRY_DECODER_CMD	_IOWR('V', 97, struct v4l2_decoder_cmd)
#define VIDIOC_ENUM_DV_TIMINGS  _IOWR('V', 98, struct v4l2_enum_dv_timings)
#define VIDIOC_QUERY_DV_TIMINGS  _IOR('V', 99, struct v4l2_dv_timings)
#define VIDIOC_DV_TIMINGS_CAP   _IOWR('V', 100, struct v4l2_dv_timings_cap)
#define VIDIOC_ENUM_FREQ_BANDS	_IOWR('V', 101, struct v4l2_frequency_band)

/*
 * Experimental, meant for debugging, testing and internal use.
 * Never use this in applications!
 */
#define VIDIOC_DBG_G_CHIP_INFO  _IOWR('V', 102, struct v4l2_dbg_chip_info)

#define VIDIOC_QUERY_EXT_CTRL	_IOWR('V', 103, struct v4l2_query_ext_ctrl)
#define VIDIOC_REMOVE_BUFS	_IOWR('V', 104, struct v4l2_remove_buffers)


/* Reminder: when adding new ioctls please add support for them to
   drivers/media/v4l2-core/v4l2-compat-ioctl32.c as well! */

#define BASE_VIDIOC_PRIVATE	192		/* 192-255 are private */

/* Deprecated definitions kept for backwards compatibility */
#define V4L2_PIX_FMT_HM12 V4L2_PIX_FMT_NV12_16L16
#define V4L2_PIX_FMT_SUNXI_TILED_NV12 V4L2_PIX_FMT_NV12_32L32
/*
 * This capability was never implemented, anyone using this cap should drop it
 * from their code.
 */
#define V4L2_CAP_ASYNCIO 0x02000000

#endif /* _SYS_VIDEOIO_H_ */