//! Autogenerated by GenerateDef from src/aro/Builtins/arm.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) {    _BitScanForward,
    _BitScanForward64,
    _BitScanReverse,
    _BitScanReverse64,
    _InterlockedAnd16_acq,
    _InterlockedAnd16_nf,
    _InterlockedAnd16_rel,
    _InterlockedAnd64,
    _InterlockedAnd64_acq,
    _InterlockedAnd64_nf,
    _InterlockedAnd64_rel,
    _InterlockedAnd8_acq,
    _InterlockedAnd8_nf,
    _InterlockedAnd8_rel,
    _InterlockedAnd_acq,
    _InterlockedAnd_nf,
    _InterlockedAnd_rel,
    _InterlockedCompareExchange16_acq,
    _InterlockedCompareExchange16_nf,
    _InterlockedCompareExchange16_rel,
    _InterlockedCompareExchange64_acq,
    _InterlockedCompareExchange64_nf,
    _InterlockedCompareExchange64_rel,
    _InterlockedCompareExchange8_acq,
    _InterlockedCompareExchange8_nf,
    _InterlockedCompareExchange8_rel,
    _InterlockedCompareExchangePointer_acq,
    _InterlockedCompareExchangePointer_rel,
    _InterlockedCompareExchange_acq,
    _InterlockedCompareExchange_nf,
    _InterlockedCompareExchange_rel,
    _InterlockedDecrement16_acq,
    _InterlockedDecrement16_nf,
    _InterlockedDecrement16_rel,
    _InterlockedDecrement64,
    _InterlockedDecrement64_acq,
    _InterlockedDecrement64_nf,
    _InterlockedDecrement64_rel,
    _InterlockedDecrement_acq,
    _InterlockedDecrement_nf,
    _InterlockedDecrement_rel,
    _InterlockedExchange16_acq,
    _InterlockedExchange16_nf,
    _InterlockedExchange16_rel,
    _InterlockedExchange64,
    _InterlockedExchange64_acq,
    _InterlockedExchange64_nf,
    _InterlockedExchange64_rel,
    _InterlockedExchange8_acq,
    _InterlockedExchange8_nf,
    _InterlockedExchange8_rel,
    _InterlockedExchangeAdd16_acq,
    _InterlockedExchangeAdd16_nf,
    _InterlockedExchangeAdd16_rel,
    _InterlockedExchangeAdd64,
    _InterlockedExchangeAdd64_acq,
    _InterlockedExchangeAdd64_nf,
    _InterlockedExchangeAdd64_rel,
    _InterlockedExchangeAdd8_acq,
    _InterlockedExchangeAdd8_nf,
    _InterlockedExchangeAdd8_rel,
    _InterlockedExchangeAdd_acq,
    _InterlockedExchangeAdd_nf,
    _InterlockedExchangeAdd_rel,
    _InterlockedExchangePointer_acq,
    _InterlockedExchangePointer_nf,
    _InterlockedExchangePointer_rel,
    _InterlockedExchangeSub64,
    _InterlockedExchange_acq,
    _InterlockedExchange_nf,
    _InterlockedExchange_rel,
    _InterlockedIncrement16_acq,
    _InterlockedIncrement16_nf,
    _InterlockedIncrement16_rel,
    _InterlockedIncrement64,
    _InterlockedIncrement64_acq,
    _InterlockedIncrement64_nf,
    _InterlockedIncrement64_rel,
    _InterlockedIncrement_acq,
    _InterlockedIncrement_nf,
    _InterlockedIncrement_rel,
    _InterlockedOr16_acq,
    _InterlockedOr16_nf,
    _InterlockedOr16_rel,
    _InterlockedOr64,
    _InterlockedOr64_acq,
    _InterlockedOr64_nf,
    _InterlockedOr64_rel,
    _InterlockedOr8_acq,
    _InterlockedOr8_nf,
    _InterlockedOr8_rel,
    _InterlockedOr_acq,
    _InterlockedOr_nf,
    _InterlockedOr_rel,
    _InterlockedXor16_acq,
    _InterlockedXor16_nf,
    _InterlockedXor16_rel,
    _InterlockedXor64,
    _InterlockedXor64_acq,
    _InterlockedXor64_nf,
    _InterlockedXor64_rel,
    _InterlockedXor8_acq,
    _InterlockedXor8_nf,
    _InterlockedXor8_rel,
    _InterlockedXor_acq,
    _InterlockedXor_nf,
    _InterlockedXor_rel,
    _MoveFromCoprocessor,
    _MoveFromCoprocessor2,
    _MoveToCoprocessor,
    _MoveToCoprocessor2,
    __builtin_arm_cdp,
    __builtin_arm_cdp2,
    __builtin_arm_clrex,
    __builtin_arm_cls,
    __builtin_arm_cls64,
    __builtin_arm_clz,
    __builtin_arm_clz64,
    __builtin_arm_cmse_TT,
    __builtin_arm_cmse_TTA,
    __builtin_arm_cmse_TTAT,
    __builtin_arm_cmse_TTT,
    __builtin_arm_crc32b,
    __builtin_arm_crc32cb,
    __builtin_arm_crc32cd,
    __builtin_arm_crc32ch,
    __builtin_arm_crc32cw,
    __builtin_arm_crc32d,
    __builtin_arm_crc32h,
    __builtin_arm_crc32w,
    __builtin_arm_dbg,
    __builtin_arm_dmb,
    __builtin_arm_dsb,
    __builtin_arm_get_fpscr,
    __builtin_arm_isb,
    __builtin_arm_ldaex,
    __builtin_arm_ldc,
    __builtin_arm_ldc2,
    __builtin_arm_ldc2l,
    __builtin_arm_ldcl,
    __builtin_arm_ldrex,
    __builtin_arm_ldrexd,
    __builtin_arm_mcr,
    __builtin_arm_mcr2,
    __builtin_arm_mcrr,
    __builtin_arm_mcrr2,
    __builtin_arm_mrc,
    __builtin_arm_mrc2,
    __builtin_arm_mrrc,
    __builtin_arm_mrrc2,
    __builtin_arm_nop,
    __builtin_arm_prefetch,
    __builtin_arm_qadd,
    __builtin_arm_qadd16,
    __builtin_arm_qadd8,
    __builtin_arm_qasx,
    __builtin_arm_qdbl,
    __builtin_arm_qsax,
    __builtin_arm_qsub,
    __builtin_arm_qsub16,
    __builtin_arm_qsub8,
    __builtin_arm_rbit,
    __builtin_arm_rsr,
    __builtin_arm_rsr64,
    __builtin_arm_rsrp,
    __builtin_arm_sadd16,
    __builtin_arm_sadd8,
    __builtin_arm_sasx,
    __builtin_arm_sel,
    __builtin_arm_set_fpscr,
    __builtin_arm_sev,
    __builtin_arm_sevl,
    __builtin_arm_shadd16,
    __builtin_arm_shadd8,
    __builtin_arm_shasx,
    __builtin_arm_shsax,
    __builtin_arm_shsub16,
    __builtin_arm_shsub8,
    __builtin_arm_smlabb,
    __builtin_arm_smlabt,
    __builtin_arm_smlad,
    __builtin_arm_smladx,
    __builtin_arm_smlald,
    __builtin_arm_smlaldx,
    __builtin_arm_smlatb,
    __builtin_arm_smlatt,
    __builtin_arm_smlawb,
    __builtin_arm_smlawt,
    __builtin_arm_smlsd,
    __builtin_arm_smlsdx,
    __builtin_arm_smlsld,
    __builtin_arm_smlsldx,
    __builtin_arm_smuad,
    __builtin_arm_smuadx,
    __builtin_arm_smulbb,
    __builtin_arm_smulbt,
    __builtin_arm_smultb,
    __builtin_arm_smultt,
    __builtin_arm_smulwb,
    __builtin_arm_smulwt,
    __builtin_arm_smusd,
    __builtin_arm_smusdx,
    __builtin_arm_ssat,
    __builtin_arm_ssat16,
    __builtin_arm_ssax,
    __builtin_arm_ssub16,
    __builtin_arm_ssub8,
    __builtin_arm_stc,
    __builtin_arm_stc2,
    __builtin_arm_stc2l,
    __builtin_arm_stcl,
    __builtin_arm_stlex,
    __builtin_arm_strex,
    __builtin_arm_strexd,
    __builtin_arm_sxtab16,
    __builtin_arm_sxtb16,
    __builtin_arm_uadd16,
    __builtin_arm_uadd8,
    __builtin_arm_uasx,
    __builtin_arm_uhadd16,
    __builtin_arm_uhadd8,
    __builtin_arm_uhasx,
    __builtin_arm_uhsax,
    __builtin_arm_uhsub16,
    __builtin_arm_uhsub8,
    __builtin_arm_uqadd16,
    __builtin_arm_uqadd8,
    __builtin_arm_uqasx,
    __builtin_arm_uqsax,
    __builtin_arm_uqsub16,
    __builtin_arm_uqsub8,
    __builtin_arm_usad8,
    __builtin_arm_usada8,
    __builtin_arm_usat,
    __builtin_arm_usat16,
    __builtin_arm_usax,
    __builtin_arm_usub16,
    __builtin_arm_usub8,
    __builtin_arm_uxtab16,
    __builtin_arm_uxtb16,
    __builtin_arm_vcvtr_d,
    __builtin_arm_vcvtr_f,
    __builtin_arm_wfe,
    __builtin_arm_wfi,
    __builtin_arm_wsr,
    __builtin_arm_wsr64,
    __builtin_arm_wsrp,
    __builtin_arm_yield,
    __builtin_sponentry,
    __clear_cache,
    __dmb,
    __dsb,
    __emit,
    __isb,
    __ldrexd,
    __sev,
    __sevl,
    __wfe,
    __wfi,
    __yield,
};

pub fn fromName(name: []const u8) ?Properties {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) Properties {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 5;
pub const longest_name = 38;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    @setEvalBranchQuota(520);
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var w = std.Io.Writer.fixed(buf);

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return w.buffered();
}

const Node = packed struct {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each builtin using a separate array.
    number: std.math.IntFittingRange(0, data.len),
    /// If true, this node is the end of a valid builtin.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u16,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 260, .child_index = 2 },
    .{ .char = 'B', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 6 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = false, .number = 103, .child_index = 7 },
    .{ .char = 'M', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 8 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 149, .child_index = 9 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 18 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 19 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 20 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 138, .child_index = 21 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 22 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 23 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 25 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 26 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 27 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 28 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 29 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 31 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 32 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 33 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 34 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 35 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 36 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 36 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 37 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 36 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 38 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 39 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 40 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 42 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 43 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 44 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 45 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 47 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 48 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 49 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 50 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 51 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'i', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 52 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 53 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 54 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 55 },
    .{ .char = 'T', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 56 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 57 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 58 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 59 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 60 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 61 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 62 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 63 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 64 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 65 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 66 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 60 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 67 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 69 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 70 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 71 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 72 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 73 },
    .{ .char = 'F', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 74 },
    .{ .char = 'R', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 75 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 76 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 64 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 77 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 78 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 79 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 80 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 81 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 82 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 83 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 138, .child_index = 84 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 86 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 87 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 88 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 89 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 90 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 137, .child_index = 91 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 92 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 93 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 94 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 95 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 103, .child_index = 96 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 103 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 137, .child_index = 104 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 105 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 106 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 107 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 108 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 109 },
    .{ .char = 'C', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 110 },
    .{ .char = 'D', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 111 },
    .{ .char = 'E', .end_of_word = false, .end_of_list = false, .number = 30, .child_index = 112 },
    .{ .char = 'I', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 113 },
    .{ .char = 'O', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 114 },
    .{ .char = 'X', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 115 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 116 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 137, .child_index = 117 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 118 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 119 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 120 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 121 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 122 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 123 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 124 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 123 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 125 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 114 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 129 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 137, .child_index = 130 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 145 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 146 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 146 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 125 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 147 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 148 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 149 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 150 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 151 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 152 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 156 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 19, .child_index = 157 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 161 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 164 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 26 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 165 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 166 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 168 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 169 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 170 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 173 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 51, .child_index = 175 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 24, .child_index = 182 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 187 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 188 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 30 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 190 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 191 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 192 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 193 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 194 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 152 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 195 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 196 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 197 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 198 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 199 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 200 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 201 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 204 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 205 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 206 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 36 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 36 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 207 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 7, .child_index = 208 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 211 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 212 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 214 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 216 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 218 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 219 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 37 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 221 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 222 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 224 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 227 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 24, .child_index = 229 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 231 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 233 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 236 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 222 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 227 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 227 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 237 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 236 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 239 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 40 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 221 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 240 },
    .{ .char = '4', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 241 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 242 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 243 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 244 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 245 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 246 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 247 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 248 },
    .{ .char = 's', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 146 },
    .{ .char = 'z', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 146 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 249 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 250 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 251 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 248 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = false, .number = 4, .child_index = 252 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 254 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 255 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 247 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 257 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 258 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 259 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 245 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 260 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 261 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 262 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 264 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 251 },
    .{ .char = 'v', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 51 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 222 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 265 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 14, .child_index = 267 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 269 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 272 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 274 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = false, .number = 4, .child_index = 252 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 248 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 254 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 275 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 277 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 274 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 280 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 281 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 282 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 283 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 284 },
    .{ .char = 'q', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 247 },
    .{ .char = '2', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 285 },
    .{ .char = '3', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 286 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 287 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 51 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 288 },
    .{ .char = '2', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 247 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 247 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 289 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 290 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = true, .number = 3, .child_index = 290 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 191 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 292 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 260 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 274 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 10, .child_index = 294 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 299 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 301 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 302 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 301 },
    .{ .char = 't', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 305 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 292 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 306 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 307 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 308 },
    .{ .char = 't', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 305 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 310 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 312 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 313 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 314 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 315 },
    .{ .char = '2', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 316 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 321 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 322 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 323 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 324 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 324 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 325 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 327 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 301 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 325 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 325 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 327 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 301 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 327 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 325 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 325 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 325 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 324 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 307 },
    .{ .char = '1', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 324 },
    .{ .char = '8', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 329 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'E', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 330 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 331 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 30, .child_index = 332 },
    .{ .char = 'T', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 339 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 340 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = '6', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'x', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '8', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 346 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 348 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 10, .child_index = 349 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 150 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 151 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 152 },
    .{ .char = 'A', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 352 },
    .{ .char = 'P', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 353 },
    .{ .char = 'S', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 354 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 'T', .end_of_word = true, .end_of_list = true, .number = 4, .child_index = 355 },
    .{ .char = 'b', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'w', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 357 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 358 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 359 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 150 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 151 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 13, .child_index = 121 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 360 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 361 },
    .{ .char = 'A', .end_of_word = true, .end_of_list = false, .number = 2, .child_index = 362 },
    .{ .char = 'T', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 363 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 364 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 365 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 366 },
    .{ .char = 'T', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 367 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 368 },
    .{ .char = '6', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 191 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 369 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 370 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 371 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 372 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 14, .child_index = 373 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 152 },
    .{ .char = '1', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 150 },
    .{ .char = '6', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 378 },
    .{ .char = '8', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 152 },
    .{ .char = 'P', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 379 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 153 },
    .{ .char = '4', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 152 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 380 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 381 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 382 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 383 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 384 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 385 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 386 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 196 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 198 },
};
pub const data = blk: {
    @setEvalBranchQuota(2340);
    break :blk [_]Properties{
        .{ .param_str = "UcUNi*UNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*UNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UcUNi*ULLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*ss", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLiLLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*cc", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*NiNi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "v*v*D*v*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ssD*s", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "LLiLLiD*LLi", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "ccD*c", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "NiNiD*Ni", .header = .intrin, .language = .all_ms_languages },
        .{ .param_str = "UiIUiIUiIUiIUiIUi", .language = .all_ms_languages },
        .{ .param_str = "UiIUiIUiIUiIUiIUi", .language = .all_ms_languages },
        .{ .param_str = "vUiIUiIUiIUiIUiIUi", .language = .all_ms_languages },
        .{ .param_str = "vUiIUiIUiIUiIUiIUi", .language = .all_ms_languages },
        .{ .param_str = "vUIiUIiUIiUIiUIiUIi" },
        .{ .param_str = "vUIiUIiUIiUIiUIiUIi" },
        .{ .param_str = "v" },
        .{ .param_str = "UiZUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiZUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiWUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Uiv*" },
        .{ .param_str = "Uiv*" },
        .{ .param_str = "Uiv*" },
        .{ .param_str = "Uiv*" },
        .{ .param_str = "UiUiUc", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUc", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiLLUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUs", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiLLUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUs", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true }, .features = "crc" },
        .{ .param_str = "vUi" },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "vUIiUIivC*" },
        .{ .param_str = "vUIiUIivC*" },
        .{ .param_str = "vUIiUIivC*" },
        .{ .param_str = "vUIiUIivC*" },
        .{ .param_str = "v.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "LLUiv*" },
        .{ .param_str = "vUIiUIiUiUIiUIiUIi" },
        .{ .param_str = "vUIiUIiUiUIiUIiUIi" },
        .{ .param_str = "vUIiUIiLLUiUIi" },
        .{ .param_str = "vUIiUIiLLUiUIi" },
        .{ .param_str = "UiUIiUIiUIiUIiUIi" },
        .{ .param_str = "UiUIiUIiUIiUIiUIi" },
        .{ .param_str = "LLUiUIiUIiUIi" },
        .{ .param_str = "LLUiUIiUIiUIi" },
        .{ .param_str = "v" },
        .{ .param_str = "vvC*UiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UicC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLUicC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v*cC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLiiiLLi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLiiiLLi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLiiiLLi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "LLiiiLLi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUIiUIiv*" },
        .{ .param_str = "vUIiUIiv*" },
        .{ .param_str = "vUIiUIiv*" },
        .{ .param_str = "vUIiUIiv*" },
        .{ .param_str = "i.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "i.", .attributes = .{ .custom_typecheck = true } },
        .{ .param_str = "iLLUiv*" },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "UiUiUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "iii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ii", .attributes = .{ .@"const" = true } },
        .{ .param_str = "fdi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "ffi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v" },
        .{ .param_str = "vcC*Ui", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vcC*LLUi", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vcC*vC*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "v" },
        .{ .param_str = "v*", .attributes = .{ .@"const" = true } },
        .{ .param_str = "vv*v*" },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "vIUiC", .language = .all_ms_languages },
        .{ .param_str = "vUi", .header = .arm_acle, .attributes = .{ .@"const" = true } },
        .{ .param_str = "WiWiCD*", .language = .all_ms_languages },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
        .{ .param_str = "v", .header = .arm_acle },
    };
};
};
}
