//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    @"64bit",
    max_1,
    max_2,
    v1_1,
    v2_0,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.@"64bit")] = .{
        .llvm_name = null,
        .description = "Enable 64-bit PA-RISC 2.0",
        .dependencies = featureSet(&[_]Feature{
            .v2_0,
        }),
    };
    result[@intFromEnum(Feature.max_1)] = .{
        .llvm_name = null,
        .description = "Enable MAX-1 multimedia acceleration extensions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.max_2)] = .{
        .llvm_name = null,
        .description = "Enable MAX-2 multimedia acceleration extensions",
        .dependencies = featureSet(&[_]Feature{
            .max_1,
        }),
    };
    result[@intFromEnum(Feature.v1_1)] = .{
        .llvm_name = null,
        .description = "Enable ISA v1.1",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.v2_0)] = .{
        .llvm_name = null,
        .description = "Enable ISA v2.0",
        .dependencies = featureSet(&[_]Feature{
            .max_2,
            .v1_1,
        }),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const ns_1: CpuModel = .{
        .name = "ns_1",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const ns_2: CpuModel = .{
        .name = "ns_2",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const pa_7000: CpuModel = .{
        .name = "pa_7000",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v1_1,
        }),
    };
    pub const pa_7100: CpuModel = .{
        .name = "pa_7100",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v1_1,
        }),
    };
    pub const pa_7100lc: CpuModel = .{
        .name = "pa_7100lc",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .max_1,
            .v1_1,
        }),
    };
    pub const pa_7150: CpuModel = .{
        .name = "pa_7150",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v1_1,
        }),
    };
    pub const pa_7200: CpuModel = .{
        .name = "pa_7200",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v1_1,
        }),
    };
    pub const pa_7300lc: CpuModel = .{
        .name = "pa_7300lc",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .max_1,
            .v1_1,
        }),
    };
    pub const pa_8000: CpuModel = .{
        .name = "pa_8000",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8200: CpuModel = .{
        .name = "pa_8200",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8500: CpuModel = .{
        .name = "pa_8500",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8600: CpuModel = .{
        .name = "pa_8600",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8700: CpuModel = .{
        .name = "pa_8700",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8800: CpuModel = .{
        .name = "pa_8800",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pa_8900: CpuModel = .{
        .name = "pa_8900",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .@"64bit",
        }),
    };
    pub const pcx: CpuModel = .{
        .name = "pcx",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
    pub const ts_1: CpuModel = .{
        .name = "ts_1",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{}),
    };
};
