//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    v3_1,
    v3_2,
    v4_1,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.v3_1)] = .{
        .llvm_name = null,
        .description = "Enable ISA v3.1",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.v3_2)] = .{
        .llvm_name = null,
        .description = "Enable ISA v3.2",
        .dependencies = featureSet(&[_]Feature{
            .v3_1,
        }),
    };
    result[@intFromEnum(Feature.v4_1)] = .{
        .llvm_name = null,
        .description = "Enable ISA v4.1",
        .dependencies = featureSet(&[_]Feature{
            .v3_2,
        }),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const coolidge_v1: CpuModel = .{
        .name = "coolidge_v1",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v3_1,
        }),
    };
    pub const coolidge_v2: CpuModel = .{
        .name = "coolidge_v2",
        .llvm_name = null,
        .features = featureSet(&[_]Feature{
            .v3_2,
        }),
    };
};
